﻿namespace Nikse.SubtitleEdit.Logic.Config.Language.Tools;

public class LanguageFixCommonErrors
{
    public string Title { get; set; }
    public string Step1 { get; set; }
    public string WhatToFix { get; set; }
    public string Example { get; set; }
    public string SelectAll { get; set; }
    public string InverseSelection { get; set; }
    public string Back { get; set; }
    public string Next { get; set; }
    public string Step2 { get; set; }
    public string Fixes { get; set; }
    public string Log { get; set; }
    public string Function { get; set; }
    public string RemovedEmptyLine { get; set; }
    public string RemovedEmptyLineAtTop { get; set; }
    public string RemovedEmptyLineAtBottom { get; set; }
    public string RemovedEmptyLineInMiddle { get; set; }
    public string RemovedEmptyLinesUnusedLineBreaks { get; set; }
    public string FixOverlappingDisplayTimes { get; set; }
    public string FixShortDisplayTimes { get; set; }
    public string FixLongDisplayTimes { get; set; }
    public string FixShortGaps { get; set; }
    public string FixInvalidItalicTags { get; set; }
    public string RemoveUnneededSpaces { get; set; }
    public string RemoveUnneededPeriods { get; set; }
    public string FixCommas { get; set; }
    public string FixMissingSpaces { get; set; }
    public string BreakLongLines { get; set; }
    public string RemoveLineBreaks { get; set; }
    public string RemoveLineBreaksAll { get; set; }
    public string RemoveLineBreaksPixelWidth { get; set; }
    public string FixUppercaseIInsideLowercaseWords { get; set; }
    public string FixDoubleApostrophes { get; set; }
    public string AddPeriods { get; set; }
    public string StartWithUppercaseLetterAfterParagraph { get; set; }
    public string StartWithUppercaseLetterAfterPeriodInsideParagraph { get; set; }
    public string StartWithUppercaseLetterAfterColon { get; set; }
    public string FixLowercaseIToUppercaseI { get; set; }
    public string FixCommonOcrErrors { get; set; }
    public string CommonOcrErrorsFixed { get; set; }
    public string RemoveSpaceBetweenNumber { get; set; }
    public string BreakDialogsOnOneLine { get; set; }
    public string RemoveDialogFirstInNonDialogs { get; set; }
    public string NormalizeStrings { get; set; }
    public string FixTurkishAnsi { get; set; }
    public string FixDanishLetterI { get; set; }
    public string FixSpanishInvertedQuestionAndExclamationMarks { get; set; }
    public string AddMissingQuote { get; set; }
    public string AddMissingQuotes { get; set; }
    public string RemoveHyphensSingleLine { get; set; }
    public string FixHyphensInDialogs { get; set; }
    public string AddMissingQuotesExample { get; set; }
    public string XMissingQuotesAdded { get; set; }
    public string Fix3PlusLine { get; set; }
    public string Fix3PlusLines { get; set; }
    public string Analysing { get; set; }
    public string NothingToFix { get; set; }
    public string FixesFoundX { get; set; }
    public string XFixesApplied { get; set; }
    public string NothingFixableBut { get; set; }
    public string XFixedBut { get; set; }
    public string XCouldBeFixedBut { get; set; }
    public string FixFirstLetterToUppercaseAfterParagraph { get; set; }
    public string MergeShortLine { get; set; }
    public string MergeShortLineAll { get; set; }
    public string UnbreakShortLinePixelWidth { get; set; }
    public string BreakLongLine { get; set; }
    public string FixLongDisplayTime { get; set; }
    public string FixInvalidItalicTag { get; set; }
    public string FixShortDisplayTime { get; set; }
    public string FixOverlappingDisplayTime { get; set; }
    public string FixShortGap { get; set; }
    public string FixInvalidItalicTagsExample { get; set; }
    public string RemoveUnneededSpacesExample { get; set; }
    public string RemoveUnneededPeriodsExample { get; set; }
    public string FixMissingSpacesExample { get; set; }
    public string FixUppercaseIInsideLowercaseWordsExample { get; set; }
    public string FixLowercaseIToUppercaseIExample { get; set; }
    public string StartTimeLaterThanEndTime { get; set; }
    public string UnableToFixStartTimeLaterThanEndTime { get; set; }
    public string XFixedToYZ { get; set; }
    public string UnableToFixTextXY { get; set; }
    public string UnneededSpace { get; set; }
    public string UnneededPeriod { get; set; }
    public string FixMissingSpace { get; set; }
    public string FixUppercaseIInsideLowercaseWord { get; set; }
    public string FixMissingPeriodAtEndOfLine { get; set; }
    public string RefreshFixes { get; set; }
    public string ApplyFixes { get; set; }
    public string AutoBreak { get; set; }
    public string Unbreak { get; set; }
    public string FixDoubleDash { get; set; }
    public string FixDoubleGreaterThan { get; set; }
    public string FixEllipsesStart { get; set; }
    public string FixMissingOpenBracket { get; set; }
    public string FixMusicNotation { get; set; }
    public string FixDoubleDashExample { get; set; }
    public string FixDoubleGreaterThanExample { get; set; }
    public string FixEllipsesStartExample { get; set; }
    public string FixMissingOpenBracketExample { get; set; }
    public string FixMusicNotationExample { get; set; }
    public string NumberOfImportantLogMessages { get; set; }
    public string FixedOkXY { get; set; }
    public string FixOcrErrorExample { get; set; }
    public string FixSpaceBetweenNumbersExample { get; set; }
    public string FixDialogsOneLineExample { get; set; }
    public string RemoveDialogFirstInNonDialogsExample { get; set; }
    public string SelectDefault { get; set; }
    public string SetDefault { get; set; }
    public string FixContinuationStyleX { get; set; }
    public string FixUnnecessaryLeadingDots { get; set; }
    public string FixCommonErrorsProfiles { get; set; }
    public string FixCommonOcrErrorsStep1 { get; set; }
    public string SearchRulesDotDotDot { get; set; }
    public string GoToApplyFixes { get; set; }
    public string BackToFixList { get; set; }
    public string ApplyFixesAndClose { get; set; }
    public string FixCommonOcrErrorsStep2 { get; set; }
    public string FixCommonOcrErrorsStep2FixesFoundX { get; set; }

    public LanguageFixCommonErrors()
    {
        Title = "Fix common errors";
        Step1 = "Step 1/2 - Choose which errors to fix";
        WhatToFix = "What to fix";
        Example = "Example";
        SelectAll = "Select all";
        InverseSelection = "Invert selection";
        Back = "< &Back";
        Next = "&Next >";
        Step2 = "Step 2/2 - Verify fixes";
        Fixes = "Fixes";
        Log = "Log";
        Function = "Function";
        RemovedEmptyLine = "Remove empty line";
        RemovedEmptyLineAtTop = "Remove empty line at top";
        RemovedEmptyLineAtBottom = "Remove empty line at bottom";
        RemovedEmptyLineInMiddle = "Remove empty line in middle";
        RemovedEmptyLinesUnusedLineBreaks = "Remove empty lines/unused line breaks";
        FixOverlappingDisplayTimes = "Fix overlapping display times";
        FixShortDisplayTimes = "Fix short display times";
        FixLongDisplayTimes = "Fix long display times";
        FixShortGaps = "Fix short gaps";
        FixInvalidItalicTags = "Fix invalid italic tags";
        RemoveUnneededSpaces = "Remove unneeded spaces";
        RemoveUnneededPeriods = "Remove unneeded periods";
        FixCommas = "Fix commas";
        FixMissingSpaces = "Fix missing spaces";
        BreakLongLines = "Break long lines";
        RemoveLineBreaks = "Remove line breaks in short texts with only one sentence";
        RemoveLineBreaksAll = "Remove line breaks in short texts (all except dialogs)";
        RemoveLineBreaksPixelWidth = "Unbreak subtitles that can fit on one line (pixel width)";
        FixUppercaseIInsideLowercaseWords = "Fix uppercase 'i' inside lowercase words (OCR error)";
        FixDoubleApostrophes = "Fix double apostrophe characters ('') to a single quote (\")";
        AddPeriods = "Add period after lines where next line starts with uppercase letter";
        StartWithUppercaseLetterAfterParagraph = "Start with uppercase letter after paragraph";
        StartWithUppercaseLetterAfterPeriodInsideParagraph = "Start with uppercase letter after period inside paragraph";
        StartWithUppercaseLetterAfterColon = "Start with uppercase letter after colon/semicolon";
        CommonOcrErrorsFixed = "Common OCR errors fixed (OcrReplaceList file used): {0}";
        RemoveSpaceBetweenNumber = "Remove space between numbers";
        BreakDialogsOnOneLine = "Split dialogs on one line";
        RemoveDialogFirstInNonDialogs = "Remove start dash in first line for non-dialogs";
        NormalizeStrings = "Normalize strings";
        FixLowercaseIToUppercaseI = "Fix alone lowercase 'i' to 'I' (English)";
        FixTurkishAnsi = "Fix Turkish ANSI (Icelandic) letters to Unicode";
        FixDanishLetterI = "Fix Danish letter 'i'";
        FixSpanishInvertedQuestionAndExclamationMarks = "Fix Spanish inverted question and exclamation marks";
        AddMissingQuote = "Add missing quote (\")";
        AddMissingQuotes = "Add missing quotes (\")";
        RemoveHyphensSingleLine = "Remove dialog dashes in single lines";
        FixHyphensInDialogs = "Fix dash in dialogs via style: {0}";
        AddMissingQuotesExample = "\"How are you? -> \"How are you?\"";
        XMissingQuotesAdded = "Missing quotes added: {0}";
        Fix3PlusLine = "Fix subtitle with more than two lines";
        Fix3PlusLines = "Fix subtitles with more than two lines";
        Analysing = "Analyzing...";
        NothingToFix = "Nothing to fix :)";
        FixesFoundX = "Fixes found: {0}";
        XFixesApplied = "Fixes applied: {0}";
        NothingFixableBut = "Nothing could be fixed automatically. The subtitle contains errors - see log for details";
        XFixedBut = "{0} issue(s) fixed but the subtitle still contains errors - see log for details";
        XCouldBeFixedBut = "{0} issue(s) could be fixed but the subtitle will still contain errors - see log for details";
        FixFirstLetterToUppercaseAfterParagraph = "Fix first letter to uppercase after paragraph";
        MergeShortLine = "Merge short line (single sentence)";
        MergeShortLineAll = "Merge short line (all except dialogs)";
        UnbreakShortLinePixelWidth = "Unbreak short line (pixel width)";
        BreakLongLine = "Break long line";
        FixLongDisplayTime = "Fix long display time";
        FixInvalidItalicTag = "Fix invalid italic tag";
        FixShortDisplayTime = "Fix short display time";
        FixOverlappingDisplayTime = "Fix overlapping display time";
        FixShortGap = "Fix short gap";
        FixInvalidItalicTagsExample = "<i>What do I care.<i> -> <i>What do I care.</i>";
        RemoveUnneededSpacesExample = "Hey   you ; there. -> Hey you; there.";
        RemoveUnneededPeriodsExample = "Hey you!. -> Hey you!";
        FixMissingSpacesExample = "Hey.You. -> Hey. You.";
        FixUppercaseIInsideLowercaseWordsExample = "The earth is fIat. -> The earth is flat.";
        FixLowercaseIToUppercaseIExample = "What do i care. -> What do I care.";
        StartTimeLaterThanEndTime = "Text number {0}: Start time is later than end time: {4}{1} -> {2} {3}";
        UnableToFixStartTimeLaterThanEndTime = "Unable to fix text number {0}: Start time is later than end time: {1}";
        XFixedToYZ = "{0} fixed to: {1}{2}";
        UnableToFixTextXY = "Unable to fix text number {0}: {1}";
        UnneededSpace = "Unneeded space";
        UnneededPeriod = "Unneeded period";
        FixMissingSpace = "Fix missing space";
        FixUppercaseIInsideLowercaseWord = "Fix uppercase 'i' inside lowercase word";
        FixMissingPeriodAtEndOfLine = "Add missing period at end of line";
        ApplyFixes = "A&pply selected fixes";
        RefreshFixes = "Refresh available fixes";
        FixDoubleDash = "Fix '--' -> '...'";
        FixDoubleGreaterThan = "Remove '>>'";
        FixEllipsesStart = "Remove leading '...'";
        FixMissingOpenBracket = "Fix missing [ or ( in line";
        FixMusicNotation = "Replace music symbols (e.g. âTª) with preferred symbol";
        FixDoubleDashExample = "'Whoa-- um yeah!' -> 'Whoa... um yeah!'";
        FixDoubleGreaterThanExample = "'>> Robert: Sup dude!' -> 'Robert: Sup dude!'";
        FixEllipsesStartExample = "'... and then we' -> 'and then we'";
        FixMissingOpenBracketExample = "'clanks] Look out!' -> '[clanks] Look out!'";
        FixMusicNotationExample = "'âTª sweet dreams are' -> '♫ sweet dreams are'";
        AutoBreak = "Auto &br";
        Unbreak = "&Unbreak";
        FixCommonOcrErrors = "Fix common OCR errors (using OCR replace list)";
        NumberOfImportantLogMessages = "{0} important log messages!";
        FixedOkXY = "Fixed and OK - '{0}': {1}";
        FixOcrErrorExample = "D0n't -> Don't";
        FixSpaceBetweenNumbersExample = "1 100 -> 1100";
        FixDialogsOneLineExample = "Hi John! - Hi Ida! -> Hi John!<br />- Hi Ida!";
        RemoveDialogFirstInNonDialogsExample = "- How are you? -> How are you?";
        SelectDefault = "Select default";
        SetDefault = "Set current fixes as default";
        FixContinuationStyleX = "Fix continuation style: {0}";
        FixUnnecessaryLeadingDots = "Remove unnecessary leading dots";
        FixCommonErrorsProfiles = "Fix common errors profiles";
        FixCommonOcrErrorsStep1 = "Fix common errors, step 1 (choose fixes)";
        FixCommonOcrErrorsStep2 = "Fix common errors, step 2 (apply fixes)";
        SearchRulesDotDotDot = "Search rules...";
        GoToApplyFixes = "Go to apply fixes";
        BackToFixList =  "Back to fix list";
        ApplyFixes = "Apply selected fixes & close";
        FixCommonOcrErrorsStep2FixesFoundX =  "Fix common errors, step 2 - Fixes found: {0}";
        ApplyFixesAndClose = "Apply fixes & close";   
    }
}