param (
    [string]$path
)

$fullPath = $(Get-Item $path).FullName

# Check if the path exists
if (-Not (Test-Path -Path $fullPath)) {
    Write-Host "The specified path does not exist."
    exit
}

# Prompt the user for the string to append
$appendString = Read-Host "Enter the string to append to the file/folder name (e.g., '(2013)')"

# Get the name of the current path
$currentName = Split-Path -Path $fullPath -Leaf
$newName = "$currentName $appendString"

# Rename the current path
Rename-Item -Path $fullPath -NewName $newName

# Assign the new name to another variable and get its full path
$newFullPath = $(Get-Item -Path (Join-Path -Path (Split-Path -Path $fullPath -Parent) -ChildPath $newName)).FullName

# Recurse into the new path and rename files with the current name to the new name
Get-ChildItem -Path $newFullPath -Recurse | ForEach-Object {
    if ($_.Name -like "*$currentName*") {
        $newChildName = $_.Name.Replace($currentName, "$currentName $appendString")
        Rename-Item -Path $_.FullName -NewName $newChildName
    }
}