from __future__ import annotations

from typing import Literal, Protocol, overload

from antlr4 import Parser, ParserRuleContext
from antlr4.error.ErrorListener import ErrorListener
from antlr4.error.ErrorStrategy import ErrorStrategy
from antlr4.InputStream import InputStream
from antlr4.tree.Tree import TerminalNode

class _TerminalNodeImpl(Protocol):
    def getText(self) -> str: ...

class wizardParser(Parser):
    # code generic to ANTLR4 poorly typed
    _errHandler: ErrorStrategy
    _ctx: ParserRuleContext
    _input: InputStream
    def addErrorListener(self, listener: ErrorListener) -> None: ...
    def removeErrorListener(self, listener: ErrorListener) -> None: ...
    def removeErrorListeners(self) -> None: ...

    # code specific to wizard

    class ParseWizardContext(ParserRuleContext):
        def body(self) -> wizardParser.BodyContext: ...
        def EOF(self) -> _TerminalNodeImpl: ...

    def parseWizard(self) -> wizardParser.ParseWizardContext: ...

    class BodyContext(ParserRuleContext):
        @overload
        def stmt(self, i: int) -> wizardParser.StmtContext: ...
        @overload
        def stmt(self, i: None = ...) -> list[wizardParser.StmtContext]: ...
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...

    class StmtContext(ParserRuleContext):
        def assignment(self) -> wizardParser.AssignmentContext: ...
        def compoundAssignment(self) -> wizardParser.CompoundAssignmentContext: ...
        def controlFlowStmt(self) -> wizardParser.ControlFlowStmtContext: ...
        def keywordStmt(self) -> wizardParser.KeywordStmtContext: ...

    class AssignmentContext(ParserRuleContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def Assign(self) -> _TerminalNodeImpl: ...
        def expr(self) -> wizardParser.ExprContext: ...

    class CompoundAssignmentContext(ParserRuleContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def expr(self) -> wizardParser.ExprContext: ...
        def CompoundExp(self) -> _TerminalNodeImpl | None: ...
        def CompoundMul(self) -> _TerminalNodeImpl | None: ...
        def CompoundDiv(self) -> _TerminalNodeImpl | None: ...
        def CompoundMod(self) -> _TerminalNodeImpl | None: ...
        def CompoundAdd(self) -> _TerminalNodeImpl | None: ...
        def CompoundSub(self) -> _TerminalNodeImpl | None: ...

    class ConstantContext(ParserRuleContext):
        def getText(self) -> str: ...

    class StringContext(ParserRuleContext):
        def getText(self) -> str: ...
        def DoubleQuotedString(self) -> _TerminalNodeImpl | None: ...
        def SingleQuotedString(self) -> _TerminalNodeImpl | None: ...

    class IntegerContext(ParserRuleContext):
        def getText(self) -> str: ...
        def Number(self) -> _TerminalNodeImpl | None: ...

    class DecimalContext(ParserRuleContext):
        def getText(self) -> str: ...
        @overload
        def Number(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Number(self, i: None = ...) -> list[TerminalNode]: ...
        def Dot(self) -> _TerminalNodeImpl | None: ...

    class ArgListContext(ParserRuleContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        @overload
        def Comma(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Comma(self, i: None = ...) -> list[TerminalNode]: ...

    class ExprContext(ParserRuleContext): ...

    class PreIncrementContext(ExprContext):
        def Increment(self) -> _TerminalNodeImpl | None: ...
        def Identifier(self) -> _TerminalNodeImpl: ...

    class DotFunctionCallContext(ExprContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def Dot(self) -> _TerminalNodeImpl | None: ...
        def Identifier(self) -> _TerminalNodeImpl: ...
        def LeftParenthesis(self) -> _TerminalNodeImpl | None: ...
        def RightParenthesis(self) -> _TerminalNodeImpl | None: ...
        def argList(self) -> wizardParser.ArgListContext: ...

    class OrContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...

    class InContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def In(self) -> _TerminalNodeImpl | None: ...
        def Colon(self) -> _TerminalNodeImpl | None: ...

    class PostDecrementContext(ExprContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def Decrement(self) -> _TerminalNodeImpl: ...

    class TimesDivideModuloContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Times(self) -> _TerminalNodeImpl | None: ...
        def Divide(self) -> _TerminalNodeImpl | None: ...
        def Modulo(self) -> _TerminalNodeImpl | None: ...

    class IndexContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def LeftBracket(self) -> _TerminalNodeImpl: ...
        def RightBracket(self) -> _TerminalNodeImpl: ...

    class ExponentiationContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Raise(self) -> _TerminalNodeImpl: ...

    class PlusMinusContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Plus(self) -> _TerminalNodeImpl | None: ...
        def Minus(self) -> _TerminalNodeImpl | None: ...

    class NotContext(ExprContext):
        def expr(self) -> wizardParser.ExprContext: ...

    class LesserContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Lesser(self) -> _TerminalNodeImpl | None: ...
        def LesserOrEqual(self) -> _TerminalNodeImpl | None: ...
        def Colon(self) -> _TerminalNodeImpl | None: ...

    class NegativeContext(ExprContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def Minus(self) -> _TerminalNodeImpl | None: ...

    class EqualContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Equal(self) -> _TerminalNodeImpl | None: ...
        def NotEqual(self) -> _TerminalNodeImpl | None: ...
        def Colon(self) -> _TerminalNodeImpl | None: ...

    class AndContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...

    class SliceContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def LeftBracket(self) -> _TerminalNodeImpl | None: ...
        @overload
        def Colon(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Colon(self) -> list[TerminalNode]: ...
        def RightBracket(self) -> _TerminalNodeImpl | None: ...

    class ValueContext(ExprContext):
        def getText(self) -> str: ...
        def constant(self) -> wizardParser.ConstantContext: ...
        def decimal(self) -> wizardParser.DecimalContext: ...
        def integer(self) -> wizardParser.IntegerContext: ...
        def string(self) -> wizardParser.StringContext: ...
        def Identifier(self) -> _TerminalNodeImpl: ...

    class GreaterContext(ExprContext):
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        def Greater(self) -> _TerminalNodeImpl | None: ...
        def GreaterOrEqual(self) -> _TerminalNodeImpl | None: ...
        def Colon(self) -> _TerminalNodeImpl | None: ...

    class FunctionCallContext(ExprContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def LeftParenthesis(self) -> _TerminalNodeImpl | None: ...
        def argList(self) -> wizardParser.ArgListContext: ...
        def RightParenthesis(self) -> _TerminalNodeImpl | None: ...

    class PostIncrementContext(ExprContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def Increment(self) -> _TerminalNodeImpl: ...

    class ParenExprContext(ExprContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def LeftParenthesis(self) -> _TerminalNodeImpl: ...
        def RightParenthesis(self) -> _TerminalNodeImpl: ...

    class PreDecrementContext(ExprContext):
        def Decrement(self) -> _TerminalNodeImpl: ...
        def Identifier(self) -> _TerminalNodeImpl: ...

    class ControlFlowStmtContext(ParserRuleContext): ...

    class ReturnContext(ControlFlowStmtContext):
        def Return(self) -> _TerminalNodeImpl: ...

    class CancelContext(ControlFlowStmtContext):
        def cancelStmt(self) -> wizardParser.CancelStmtContext: ...

    class BreakContext(ControlFlowStmtContext):
        def Break(self) -> _TerminalNodeImpl: ...

    class ForContext(ControlFlowStmtContext):
        def forStmt(self) -> wizardParser.ForStmtContext: ...

    class SelectContext(ControlFlowStmtContext):
        def selectStmt(self) -> wizardParser.SelectStmtContext: ...

    class WhileContext(ControlFlowStmtContext):
        def whileStmt(self) -> wizardParser.WhileStmtContext: ...

    class ContinueContext(ControlFlowStmtContext):
        def Continue(self) -> _TerminalNodeImpl: ...

    class IfContext(ControlFlowStmtContext):
        def ifStmt(self) -> wizardParser.IfStmtContext: ...

    class CancelStmtContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...

    class CaseStmtContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def body(self) -> wizardParser.BodyContext: ...

    class DefaultStmtContext(ParserRuleContext):
        def body(self) -> wizardParser.BodyContext: ...

    class ElifStmtContext(ParserRuleContext):
        def Elif(self) -> _TerminalNodeImpl: ...
        def expr(self) -> wizardParser.ExprContext: ...
        def body(self) -> wizardParser.BodyContext: ...

    class ElseStmtContext(ParserRuleContext):
        def Else(self) -> _TerminalNodeImpl: ...
        def body(self) -> wizardParser.BodyContext: ...

    class ForStmtContext(ParserRuleContext):
        def Identifier(self) -> _TerminalNodeImpl: ...
        def body(self) -> wizardParser.BodyContext: ...
        def EndFor(self) -> _TerminalNodeImpl: ...
        def forRangeHeader(self) -> wizardParser.ForRangeHeaderContext: ...
        def forInHeader(self) -> wizardParser.ForInHeaderContext: ...

    class ForRangeHeaderContext(ParserRuleContext):
        @overload
        def expr(self, i: Literal[0, 1]) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext | None: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...

    class ForInHeaderContext(ParserRuleContext):
        def In(self) -> _TerminalNodeImpl: ...
        def expr(self) -> wizardParser.ExprContext: ...

    class IfStmtContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def body(self) -> wizardParser.BodyContext: ...
        def EndIf(self) -> _TerminalNodeImpl: ...
        @overload
        def elifStmt(self, i: int) -> wizardParser.ElifStmtContext | None: ...
        @overload
        def elifStmt(self, i: None = ...) -> list[wizardParser.ElifStmtContext]: ...
        def elseStmt(self) -> wizardParser.ElseStmtContext: ...

    class SelectStmtContext(ParserRuleContext):
        def EndSelect(self) -> _TerminalNodeImpl: ...
        def selectOne(self) -> wizardParser.SelectOneContext: ...
        def selectMany(self) -> wizardParser.SelectManyContext: ...

    class SelectCaseListContext(ParserRuleContext):
        @overload
        def caseStmt(self, i: int) -> wizardParser.CaseStmtContext | None: ...
        @overload
        def caseStmt(self, i: None = ...) -> list[wizardParser.CaseStmtContext]: ...
        def defaultStmt(self) -> wizardParser.DefaultStmtContext: ...

    class OptionTupleContext(ParserRuleContext):
        @overload
        def expr(self, i: Literal[0, 1, 2]) -> wizardParser.ExprContext: ...
        @overload
        def expr(self, i: int) -> wizardParser.ExprContext | None: ...
        @overload
        def expr(self, i: None = ...) -> list[wizardParser.ExprContext]: ...
        @overload
        def Comma(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Comma(self, i: None = ...) -> list[_TerminalNodeImpl]: ...

    class SelectOneContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def selectCaseList(self) -> wizardParser.SelectCaseListContext: ...
        @overload
        def Comma(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Comma(self, i: None = ...) -> list[_TerminalNodeImpl]: ...
        @overload
        def optionTuple(self, i: int) -> wizardParser.OptionTupleContext | None: ...
        @overload
        def optionTuple(
            self, i: None = ...
        ) -> list[wizardParser.OptionTupleContext]: ...

    class SelectManyContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def selectCaseList(self) -> wizardParser.SelectCaseListContext: ...
        @overload
        def Comma(self, i: int) -> _TerminalNodeImpl | None: ...
        @overload
        def Comma(self, i: None = ...) -> list[_TerminalNodeImpl]: ...
        @overload
        def optionTuple(self, i: int) -> wizardParser.OptionTupleContext | None: ...
        @overload
        def optionTuple(
            self, i: None = ...
        ) -> list[wizardParser.OptionTupleContext]: ...

    class WhileStmtContext(ParserRuleContext):
        def expr(self) -> wizardParser.ExprContext: ...
        def body(self) -> wizardParser.BodyContext: ...
        def EndWhile(self) -> _TerminalNodeImpl: ...

    class KeywordStmtContext(ParserRuleContext):
        def Keyword(self) -> _TerminalNodeImpl: ...
        def argList(self) -> wizardParser.ArgListContext: ...
