from enum import IntEnum


class GL_IMAGE_FORMAT(IntEnum):
    GL_BYTE = 0x1400
    GL_UNSIGNED_BYTE = 0x1401
    GL_SHORT = 0x1402
    GL_UNSIGNED_SHORT = 0x1403
    GL_INT = 0x1404
    GL_UNSIGNED_INT = 0x1405
    GL_FLOAT = 0x1406
    GL_HALF_FLOAT = 0x140B
    GL_COLOR_INDEX = 0x1900
    GL_STENCIL_INDEX = 0x1901
    GL_DEPTH_COMPONENT = 0x1902
    GL_RED = 0x1903
    GL_GREEN = 0x1904
    GL_BLUE = 0x1905
    GL_ALPHA = 0x1906
    GL_RGB = 0x1907
    GL_RGBA = 0x1908
    GL_LUMINANCE = 0x1909
    GL_LUMINANCE_ALPHA = 0x190A
    GL_BITMAP = 0x1A00
    GL_R3_G3_B2 = 0x2A10
    GL_UNSIGNED_BYTE_3_3_2 = 0x8032
    GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033
    GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034
    GL_UNSIGNED_INT_8_8_8_8 = 0x8035
    GL_UNSIGNED_INT_10_10_10_2 = 0x8036
    GL_ALPHA4 = 0x803B
    GL_ALPHA8 = 0x803C
    GL_ALPHA12 = 0x803D
    GL_ALPHA16 = 0x803E
    GL_LUMINANCE4 = 0x803F
    GL_LUMINANCE8 = 0x8040
    GL_LUMINANCE12 = 0x8041
    GL_LUMINANCE16 = 0x8042
    GL_LUMINANCE4_ALPHA4 = 0x8043
    GL_LUMINANCE6_ALPHA2 = 0x8044
    GL_LUMINANCE8_ALPHA8 = 0x8045
    GL_LUMINANCE12_ALPHA4 = 0x8046
    GL_LUMINANCE12_ALPHA12 = 0x8047
    GL_LUMINANCE16_ALPHA16 = 0x8048
    GL_INTENSITY = 0x8049
    GL_INTENSITY4 = 0x804A
    GL_INTENSITY8 = 0x804B
    GL_INTENSITY12 = 0x804C
    GL_INTENSITY16 = 0x804D
    GL_RGB4 = 0x804F
    GL_RGB5 = 0x8050
    GL_RGB8 = 0x8051
    GL_RGB10 = 0x8052
    GL_RGB12 = 0x8053
    GL_RGB16 = 0x8054
    GL_RGBA2 = 0x8055
    GL_RGBA4 = 0x8056
    GL_RGB5_A1 = 0x8057
    GL_RGBA8 = 0x8058
    GL_RGB10_A2 = 0x8059
    GL_RGBA12 = 0x805A
    GL_RGBA16 = 0x805B
    GL_BGR = 0x80E0
    GL_BGRA = 0x80E1
    GL_DEPTH_COMPONENT16 = 0x81A5
    GL_DEPTH_COMPONENT24 = 0x81A6
    GL_DEPTH_COMPONENT32 = 0x81A7
    GL_COMPRESSED_RED = 0x8225
    GL_COMPRESSED_RG = 0x8226
    GL_RG = 0x8227
    GL_RG_INTEGER = 0x8228
    GL_R8 = 0x8229
    GL_R16 = 0x822A
    GL_RG8 = 0x822B
    GL_RG16 = 0x822C
    GL_R16F = 0x822D
    GL_R32F = 0x822E
    GL_RG16F = 0x822F
    GL_RG32F = 0x8230
    GL_R8I = 0x8231
    GL_R8UI = 0x8232
    GL_R16I = 0x8233
    GL_R16UI = 0x8234
    GL_R32I = 0x8235
    GL_R32UI = 0x8236
    GL_RG8I = 0x8237
    GL_RG8UI = 0x8238
    GL_RG16I = 0x8239
    GL_RG16UI = 0x823A
    GL_RG32I = 0x823B
    GL_RG32UI = 0x823C
    GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362
    GL_UNSIGNED_SHORT_5_6_5 = 0x8363
    GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364
    GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365
    GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366
    GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367
    GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368
    GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0
    GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1
    GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2
    GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3
    GL_COMPRESSED_ALPHA = 0x84E9
    GL_COMPRESSED_LUMINANCE = 0x84EA
    GL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB
    GL_COMPRESSED_INTENSITY = 0x84EC
    GL_COMPRESSED_RGB = 0x84ED
    GL_COMPRESSED_RGBA = 0x84EE
    GL_DEPTH_STENCIL = 0x84F9
    GL_RGBA32F = 0x8814
    GL_RGB32F = 0x8815
    GL_RGBA16F = 0x881A
    GL_RGB16F = 0x881B
    GL_R11F_G11F_B10F = 0x8C3A
    GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = 0x8C3B  # EXT_packed_float
    GL_RGB9_E5 = 0x8C3D
    GL_UNSIGNED_INT_5_9_9_9_REV_EXT = 0x8C3E  # EXT_texture_shared_exponent
    GL_SRGB = 0x8C40
    GL_SRGB8 = 0x8C41
    GL_SRGB_ALPHA = 0x8C42
    GL_SRGB8_ALPHA8 = 0x8C43
    GL_SLUMINANCE_ALPHA = 0x8C44
    GL_SLUMINANCE8_ALPHA8 = 0x8C45
    GL_SLUMINANCE = 0x8C46
    GL_SLUMINANCE8 = 0x8C47
    GL_COMPRESSED_SRGB = 0x8C48
    GL_COMPRESSED_SRGB_ALPHA = 0x8C49
    GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F
    GL_RGBA32UI = 0x8D70
    GL_RGB32UI = 0x8D71
    GL_RGBA16UI = 0x8D76
    GL_RGB16UI = 0x8D77
    GL_RGBA8UI = 0x8D7C
    GL_RGB8UI = 0x8D7D
    GL_RGBA32I = 0x8D82
    GL_RGB32I = 0x8D83
    GL_RGBA16I = 0x8D88
    GL_RGB16I = 0x8D89
    GL_RGBA8I = 0x8D8E
    GL_RGB8I = 0x8D8F
    GL_RED_INTEGER = 0x8D94
    GL_RGB_INTEGER = 0x8D98
    GL_RGBA_INTEGER = 0x8D99
    GL_BGR_INTEGER = 0x8D9A
    GL_BGRA_INTEGER = 0x8D9B
    GL_COMPRESSED_RED_RGTC1 = 0x8DBB
    GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC
    GL_COMPRESSED_RG_RGTC2 = 0x8DBD
    GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE
    GL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C
    GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D
    GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E
    GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F
    GL_R8_SNORM = 0x8F94
    GL_RG8_SNORM = 0x8F95
    GL_RGB8_SNORM = 0x8F96
    GL_RGBA8_SNORM = 0x8F97
    GL_R16_SNORM = 0x8F98
    GL_RG16_SNORM = 0x8F99
    GL_RGB16_SNORM = 0x8F9A
    GL_RGBA16_SNORM = 0x8F9B
    GL_RGB10_A2UI = 0x906F
    GL_COMPRESSED_R11_EAC = 0x9270
    GL_COMPRESSED_SIGNED_R11_EAC = 0x9271
    GL_COMPRESSED_RG11_EAC = 0x9272
    GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273
    GL_COMPRESSED_RGB8_ETC2 = 0x9274
    GL_COMPRESSED_SRGB8_ETC2 = 0x9275
    GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276
    GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277
    GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278
    GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279


class GLTextureFormat:
    def __init__(self, requirements, internalFormat, compressed):
        self.requirements = requirements
        self.internalFormat = internalFormat
        self.compressed = compressed

        if internalFormat.name.endswith("UI"):
            self.samplerType = "UI"
        elif internalFormat.name.endswith("I"):
            self.samplerType = "I"
        else:
            self.samplerType = "F"


class CompressedGLTextureFormat(GLTextureFormat):
    def __init__(self, requirements, internalFormat):
        super().__init__(requirements, internalFormat, True)


class UncompressedGLTextureFormat(GLTextureFormat):
    def __init__(self, requirements, internalFormat, format, type, converter=None):
        super().__init__(requirements, internalFormat, False)
        self.format = format
        self.type = type
        if converter:
            self.converter = converter
        else:
            self.converter = lambda x: x