#!/bin/bash
# FNA Update Script
# Written by Ethan "flibitijibibo" Lee
#
# Released under public domain.
# No warranty implied; use at your own risk.
#
# Run this script in the game's executable folder.
#
# This script requires the following programs:
# - git
# - msbuild, which should include a C# compiler
#
# You may want to update MonoKickstart as well!
# https://github.com/flibitijibibo/MonoKickstart/tree/master/precompiled

# Be Smart. Be Safe.
set -e

# Move to script's directory
cd "`dirname "$0"`"

# Grab native libraries
curl -O https://fna.flibitijibibo.com/archive/fnalibs.tar.bz2
tar xvfj fnalibs.tar.bz2 lib64
rm fnalibs.tar.bz2 # Wouldn't want to waste disk space, would we...

# Download and build latest FNA
if [ -d "FNA" ]; then
	cd FNA
	git pull
	git submodule update
else
	git clone --recursive https://github.com/FNA-XNA/FNA
	cd FNA
	curl -o FNA.Settings.props https://flibitijibibo.com/Terraria.Settings.props
fi
msbuild /p:Configuration=Release /p:Platform=x86 FNA.sln
cd ..
cp FNA/bin/Release/* .

# We out.
echo Complete!