$(document).ready(function () {
    cecInit();
})

function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

function cecInit() {
    var jsonData;
	var	locale = getParameterByName('locale');
    var isHighDpi = getParameterByName('isHighDpi');
	cecGetLocaleJson(locale);
}

function cecGetLocaleJson(locale)
{
	var jsonLocation = "Dictionary/" + locale + ".json";
	$.getJSON(jsonLocation, function (data) {        
        cecDisplayContent(data);
    })
    .fail(function () {     
      if(locale == "en_US") {
		  return;
	  }
	  cecGetLocaleJson("en_US");
    })
}

function cecDisplayContent(data)
{
	var content =
			"<div class=\"cec-text-center cec-product\">"
			+ data["Name"]
			+ "</div>"
			+ "<div class=\"cec-text-center cec-subText\">"
			+ data["SubTitle"]
			+ "</div>"
			+ "<div class=\"cec-text-center cec-learnMoreBtn\">"
			+ "<a onclick = parent.cecExternalLink(\"https://www.adobe.com/products/framemaker/resources.html\"); href=\"#\" class=\"cec-btn cec-btn-primary\">"+data["Button"]+"</a></div>";

        $(".cec-carousel").append(content);
}