/*
 * COPYRIGHT (c) 1986-1997 Adobe Systems Incorporated.
 *
 * This source code contained herein is proprietary and
 * confidential information of Adobe Systems Incorporated
 * and is covered by the U.S. and other copyright and trade
 * secret protection.  Unauthorized adaptation, distribution,
 * use or display is prohibited and may be subject to civil
 * and criminal penalties.  Disclosure to others is prohibited.
 * For the terms and conditions of source code use refer to
 * your Adobe Systems Incorporated Source Code License Agreement.
 */


#include "fapi.h"
#include "fdetypes.h"

extern VoidT Sgml_ApiEmergency FARGS((VoidT));
extern VoidT Sgml_ApiInitialize FARGS((IntT init));
extern VoidT Sgml_ApiCommand FARGS((IntT command));
extern VoidT Sgml_ApiNotify FARGS((IntT notification, F_ObjHandleT docId, StringT sparm, IntT iparm));
extern VoidT Sgml_ApiDialogEvent FARGS((IntT dlgNum, IntT itemNum, IntT mods));


VoidT F_ApiEmergency()
{
	Sgml_ApiEmergency();
}

VoidT F_ApiInitialize(init)
IntT init;
{
	StringT productName;
    F_FdeInit();/*This is part of FDE so every time the dll is loaded this must be called.*/
    F_ApiEnableUnicode(True);
	F_FdeInitFontEncs("UTF-8");
	productName = F_ApiGetString(0, FV_SessionId, FP_ProductFamily);
	F_InitProduct(productName);
	F_Free(productName);
	Sgml_ApiInitialize(init);
}

VoidT F_ApiCommand(command)
IntT command;
{
    F_FdeInit();/*This is part of FDE so every time the dll is loaded this must be called.*/
	Sgml_ApiCommand(command);
}

VoidT F_ApiNotify(notification, docId, sparm, iparm)
IntT notification;
F_ObjHandleT docId;
StringT sparm;
IntT iparm;
{
    F_FdeInit();/*This is part of FDE so every time the dll is loaded this must be called.*/
	Sgml_ApiNotify(notification, docId, sparm, iparm);
}

VoidT F_ApiDialogEvent(dlgNum, itemNum, mods)
IntT dlgNum;
IntT itemNum; 
IntT mods;
{
    F_FdeInit();/*This is part of FDE so every time the dll is loaded this must be called.*/
	Sgml_ApiDialogEvent(dlgNum, itemNum, mods);
}

