/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright (c) 1986 - 2000 Adobe Systems Incorporated            */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
#include "fm_sgml.h"
#include "fstrings.h"
#include "fstrlist.h"
#include "fmemory.h"
#include "futils.h"
#include "fcharmap.h"
#include "fmetrics.h"
#include "fstrres.h"
#include "fm_maker.h"

/*
 * function prototypes
 */
SrwErrorT InsertMarker(F_ObjHandleT docId, F_ObjHandleT elemId);
VoidT SetWidthOnImport(F_ObjHandleT docId, F_ObjHandleT elemId);
VoidT CenterOnImport(F_ObjHandleT docId, F_ObjHandleT elemId);
StringT getAttrVal(F_ObjHandleT docId, F_ObjHandleT elemId, StringT attrname);
VoidT ApplyCondition(F_ObjHandleT docId, F_ObjHandleT elemId, StringT condition);
VoidT DeleteCols(F_ObjHandleT docId, F_ObjHandleT elemId);
VoidT UpdateTblBorders(F_ObjHandleT docId, F_ObjHandleT elemId, SrConvObjT tblObj);
F_ObjHandleT getHypertextMarkerType(F_ObjHandleT docId);

/* macros */
#define NUM_ELEMENTS(x) (sizeof(x)/sizeof((x)[0]))
#define BUFF 1023

/* FrameMaker metrics */
#define pts (MetricT) 65536
#define in  (MetricT) 65536 * 72

/* nested table counter */
static IntT tablecount = 0;

/* cell counter */
static IntT cellcount = 0;
static IntT totalcells = 0;

/* total number of columns in a table. see rules document to change.*/
static IntT columnTotal = 100;

/* widths of table cells */
static MetricT tblWidths[100];
static BoolT USECELLWIDTHS = True;

static SrInsertLocT lastInsertLoc;
static SrInsertLocT lastCellInsertLoc;
static F_ObjHandleT docId;
static SrConvObjT docObj;

/* defines for align attribute */
#define CENTER  1
#define RIGHT	2
#define LEFT	3

/*
 * XML Reader Sample Event Handler for XHTML
 */
SrwErrorT Sr_EventHandler(eventp, srObj)
SrEventT *eventp;
SrConvObjT srObj;
{
	F_ObjHandleT elemId;
	static BoolT TD = True;
	static BoolT TH = True;
	static IntT widthcellcount = 0;
	static IntT tablerowcount = 0;
	F_AttributeExT cellWidthAtt;

	switch (eventp->evtype)
	{
	case SR_EVT_BEGIN_READER:
	case SR_EVT_BEGIN_BOOK:
	case SR_EVT_BEGIN_DOC:
	case SR_EVT_BEGIN_BOOK_COMP:
		docObj = Sr_GetCurConvObjOfType(SR_OBJ_DOC);
		docId = Sr_GetDocId(docObj);
		break;

	case SR_EVT_CDATA :
		break;

	case SR_EVT_BEGIN_ELEM:
		if (F_StrIEqual(eventp->u.tag.gi, (StringT)"table"))
		{
			tablecount++;
			if (tablecount > 1)
				return (SRW_E_SUCCESS);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tr"))
		{
			if (tablecount == 1)
				tablerowcount++;

			if (tablecount > 1)
				return (SRW_E_SUCCESS);

		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"td"))
		{
			if (tablecount == 1)
			{
				lastInsertLoc = Sr_GetInsertLoc(srObj);
				TD = True;
				lastCellInsertLoc = Sr_GetInsertLoc(srObj);

				/* get width of cell */
				if (tablerowcount == 1)
				{
					cellWidthAtt = Sr_GetAttrVal(srObj, (StringT)"width");
					if (cellWidthAtt.values.len > 0)
					{
						tblWidths[widthcellcount] = F_StrAlphaToInt(
									(StringT)cellWidthAtt.values.val[0]) * pts;
						F_ApiDeallocateAttributeEx(&cellWidthAtt);
						widthcellcount++;
					}
					else
						USECELLWIDTHS = False;
				}
			}
			else if (tablecount > 1)
			{
				Sr_SetInsertLoc(srObj, &lastInsertLoc);
				if (TH == True)
					Sr_SetFmElemTag(srObj, (StringT) "th");
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"th"))
		{
			if (tablecount == 1)
			{
				lastInsertLoc = Sr_GetInsertLoc(srObj);
				TH = True;
				lastCellInsertLoc = Sr_GetInsertLoc(srObj);

				/* get width of cell */
				if (tablerowcount == 1)
				{
					cellWidthAtt = Sr_GetAttrVal(srObj, (StringT)"width");
					if (cellWidthAtt.values.len > 0)
					{
						tblWidths[widthcellcount] = F_StrAlphaToInt(
									(StringT)cellWidthAtt.values.val[0]) * pts;
						F_ApiDeallocateAttributeEx(&cellWidthAtt);
						widthcellcount++;
					}
					else
						USECELLWIDTHS = False;
				}
			}
			else if (tablecount > 1)
			{
				Sr_SetInsertLoc(srObj, &lastInsertLoc);
				if (TD == True)
					Sr_SetFmElemTag(srObj, (StringT) "td");
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tfoot"))
		{
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
				return (SRW_E_SUCCESS);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"thead"))
		{
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
				return (SRW_E_SUCCESS);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"caption"))
		{
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
				return (SRW_E_SUCCESS);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tbody"))
		{
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
				return (SRW_E_SUCCESS);
			}
		}

		/* Insert hypertext marker for "a" element. */
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"a"))
		{	
			Sr_Convert(eventp, srObj);

			docObj = Sr_GetCurConvObjOfType(SR_OBJ_DOC);
			docId = Sr_GetDocId(docObj);
			elemId = Sr_GetFmElemId(srObj);
			return InsertMarker(docId, elemId);

		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"img"))
		{	
			/* For XHTML, the width and height spicified inthe srObj
			 * need to be applied to the import metrics for the inset
			 * rather than the metircs for the anchored frame
			 */
			StringT w, h;
			UCharT strbuf[256];

			/* Get the specified metrics from the import object */
			w = Sr_GetPropVal( srObj, SRW_PROP_WIDTH );
			h = Sr_GetPropVal( srObj, SRW_PROP_HEIGHT );
			
			/* Set the import size for the inset object */
			F_Sprintf(strbuf, "%spt %spt", w, h );
			Sr_SetPropVal( srObj, SRW_PROP_IMPORT_SIZE, strbuf );
			F_ApiDeallocateString( &w );
			F_ApiDeallocateString( &h );
			
			/* Indicate that the anchored frame should conform its
			 * metircs to the inset object
			 */
			Sr_SetPropVal( srObj, SRW_PROP_WIDTH, NULL );
			Sr_SetPropVal( srObj, SRW_PROP_HEIGHT, NULL );
		}
		break;

/*************************************************************************************************
		END ELEMENT EVENT
***************************************************************************************************/
	case SR_EVT_END_ELEM:
		/*
		 *  tablecount needs to be decremented.
		 */
		if (F_StrIEqual(eventp->u.tag.gi, (StringT)"table"))
		{
		 	if (tablecount == 1)
			{
				docObj = Sr_GetCurConvObjOfType(SR_OBJ_DOC);
				docId = Sr_GetDocId(docObj);
				elemId = Sr_GetFmElemId(srObj);
				DeleteCols(docId, elemId);
				Sr_Convert(eventp, srObj);
				SetWidthOnImport(docId, elemId);
				CenterOnImport(docId, elemId);
				UpdateTblBorders(docId, elemId, srObj);
				cellcount = 0;
				totalcells = 0;
				tablecount--;
				if (tablecount == 0)
				{
					USECELLWIDTHS = True;
					tablerowcount = 0;
					widthcellcount = 0;
				}
				return (SRW_E_SUCCESS);
			}
			else
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
				tablecount--; 
				return (SRW_E_SUCCESS);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tr"))
		{
			if(tablecount == 1)
			{
				if (cellcount > totalcells)
					totalcells = cellcount;

				cellcount = 0;
			}
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"td"))
		{
			if (tablecount == 1)
			{
				Sr_Convert(eventp, srObj);
				lastInsertLoc = Sr_GetInsertLoc(srObj);
				cellcount++;
				return (SRW_E_SUCCESS);
			}

			Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"th"))
		{
			if (tablecount == 1)
			{
				Sr_Convert(eventp, srObj);
				lastInsertLoc = Sr_GetInsertLoc(srObj);
				cellcount++;
				return (SRW_E_SUCCESS);
			}
			if (tablecount > 1)
			{
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
			}
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tfoot"))
		{
			if (tablecount > 1)
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"thead"))
		{
			if (tablecount > 1)
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"caption"))
		{
			if (tablecount > 1)
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"tbody"))
		{
			if (tablecount > 1)
				Sr_SetProcessingFlags(srObj, SRW_UNWRAP_ELEMENT);
		}
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"label")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"select")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"optgroup")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"option")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"textarea")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"fieldset")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"button")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"legend")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"isindex")	||
				F_StrIEqual(eventp->u.tag.gi, (StringT)"input"))
		{
			Sr_Convert(eventp, srObj);
			docObj = Sr_GetCurConvObjOfType(SR_OBJ_DOC);
			docId = Sr_GetDocId(docObj);
			elemId = Sr_GetFmElemId(srObj);
			ApplyCondition(docId, elemId, (StringT)"Form");
		} 
		else if (F_StrIEqual(eventp->u.tag.gi, (StringT)"script"))
		{
			Sr_Convert(eventp, srObj);
			docObj = Sr_GetCurConvObjOfType(SR_OBJ_DOC);
			docId = Sr_GetDocId(docObj);
			elemId = Sr_GetFmElemId(srObj);
			ApplyCondition(docId, elemId, (StringT)"Script");
		}
		break;

	case SR_EVT_RE:
		break;

	case SR_EVT_END_READER:
		break;
	
	default:
		break;
	}

	return Sr_Convert(eventp, srObj);
}


/*
 * Returns the attribute value of the attribute specified
 * by 'attrName' in the element specified by 'elemId'
 */
StringT
getAttrVal(docId, elemId, attrName)
F_ObjHandleT docId, elemId;
StringT attrName;
{
	StringT val = NULL;
	F_AttributesExT attr;
	UIntT i;

	if (!docId || !elemId)
		return(NULL);

	attr = F_ApiGetAttributesEx(docId, elemId);

	/* get the value of the atribute in attrName */
	for (i=0; i < attr.len; i++)
	{
		F_AttributeExT *attrValp = &(attr.val[i]);
		if (F_StrIEqual(attrValp->name, attrName))
		{
			if (attrValp->values.len
				&& attrValp->values.val
				&& attrValp->values.val[0])
				val = F_StrCopyString(attrValp->values.val[0]);
			break;
		}
	}

	F_ApiDeallocateAttributesEx(&attr);
	return val;
}

/*
 * DeleteCols()
 * This function deletes extra columns in a table.
 */

VoidT
DeleteCols(F_ObjHandleT docId, F_ObjHandleT elemId)
{
	F_ObjHandleT tableId, rowId; 
	IntT bottomRow = 0;

	if (totalcells <= 0)
		return;

	tableId = F_ApiGetId(docId, elemId, FP_Object);
	if (!tableId)
		return;

	rowId = F_ApiGetId(docId,  tableId, FP_FirstRowInTbl);
	while (rowId)
	{
		rowId = F_ApiGetId(docId, rowId, FP_NextRowInTbl);
		bottomRow++;
	}

	F_ApiMakeTblSelection(docId, tableId, 0, bottomRow - 1, totalcells, columnTotal - 1);
	F_ApiClear(docId, FF_CUT_TBL_CELLS);

	return;
}


/*
 * ApplyCondtion()
 * Applies a condition tag to the element. This allows the user to hide
 * or show Form elements and Script elements since FrameMaker doesn't have
 * a construct to handle them.
 */

VoidT
ApplyCondition(F_ObjHandleT docId, F_ObjHandleT elemId, StringT condition)
{
	IntT			i, size, new_size, *newInts = NULL;
	F_TextRangeT	tr;
	F_ObjHandleT	conditionId = 0;
	F_PropValsT		props;

	tr = F_ApiGetTextRange(docId, elemId, FP_TextRange);
	if (!tr.beg.objId)
		return;

	if (F_StrIEqual(condition, "Script"))
		conditionId = F_ApiGetNamedObject(docId, FO_CondFmt, (StringT)"Script");
	else if (F_StrIEqual(condition, "Form"))
		conditionId = F_ApiGetNamedObject(docId, FO_CondFmt, (StringT)"Form");

	if (!conditionId)
		return;

	props = F_ApiGetTextProps(docId, &tr.beg);
	i = F_ApiGetPropIndex(&props, FP_InCond);
	size = props.val[i].propVal.u.isval.len;
	new_size = size + 1;
	newInts = props.val[i].propVal.u.isval.val;
	newInts = (IntT *)F_Realloc((PtrT)newInts, (new_size) * sizeof(IntT), NO_DSE);
	newInts[size] = conditionId;
	props.val[i].propVal.u.isval.len = new_size;
	props.val[i].propVal.u.isval.val = newInts;
	F_ApiSetTextProps(docId, &tr, &props);
	F_ApiDeallocatePropVals(&props);

	return;
}

/*
 * Add a hypertext marker to an a element.
 */

SrwErrorT
InsertMarker(F_ObjHandleT docId, F_ObjHandleT elemId)
{
	F_TextRangeT	tr;
	F_ObjHandleT	markerId = 0, markerTypeId;
	StringT			attrValue = NULL, mText = NULL, s = NULL;
	IntT			pos, j;

	/* Get marker type Id for Hypertext marker. */
	markerTypeId = getHypertextMarkerType(docId);
	if (!markerTypeId)
		return SRW_E_FAILURE;

	/* Get the Anchor element text range so we can insert the marker in this range. */
	tr = F_ApiGetTextRange(docId, elemId, FP_TextRange);

	/* Get the Anchor element's attributes. */
	attrValue = getAttrVal(docId, elemId, (StringT)"name");
	if (!F_StrIsEmpty(attrValue))
	{
		markerId = F_ApiNewAnchoredObject(docId, FO_Marker, &tr.end);
		if (!markerId) 
			return SRW_E_FAILURE;
		mText = F_StrNew(BUFF);
		s = F_StrCopyString(attrValue);
		for (j=F_StrLen(s)-1; j>=0; j--)
			s[j] = F_CharToLower(s[j]);

		if (F_StrSubString(attrValue, (StringT)"#") != -1)
			F_Sprintf(mText, (StringT)"newlink %s", s+1);
		else
			F_Sprintf(mText, (StringT)"newlink %s", s);

		F_ApiSetString(docId, markerId, FP_MarkerText, mText);
		F_ApiSetId(docId, markerId, FP_MarkerTypeId, markerTypeId);
		F_ApiDeallocateString(&mText);
		F_ApiDeallocateString(&s);
		F_ApiDeallocateString(&attrValue);
	}
		/* If Href attribute is set then add a "gotolink" hypertext marker. */
	else 
	{
		F_ApiDeallocateString(&attrValue);
		attrValue = getAttrVal(docId, elemId, (StringT)"href");
		if (!F_StrIsEmpty(attrValue))
		{
			markerId = F_ApiNewAnchoredObject(docId, FO_Marker, &tr.end);
			if (!markerId) 
				return SRW_E_FAILURE;

			mText = F_StrNew(BUFF);
			pos = F_StrICmpN(attrValue, (StringT)"http://", 7);
			if (pos == 0)
				F_Sprintf(mText, (StringT)"message URL %s", attrValue);
			else
			{
				pos = F_StrICmpN(attrValue, (StringT)"mailto:", 7);
				if (pos == 0)
					F_Sprintf(mText, (StringT)"message URL %s", attrValue);
				else
				{
					pos = F_StrSubString(attrValue, (StringT)"#");

					/* If it's the first char then set marker text to linkname. */
					if (pos == 0)
						F_Sprintf(mText, (StringT)"gotolink %s", attrValue+1);
					/* If it's not in attribute text then set marker to goto firstpage of
					 * external file. */
					else if (pos == -1)
						F_Sprintf(mText, (StringT)"gotolink %s:firstpage", attrValue);
					/* Otherwise, change it to a colon. */
					else 
					{
						attrValue[pos] = ':';
						F_Sprintf(mText, (StringT)"gotolink %s", attrValue);
					}
				}
			}

		F_ApiDeallocateString(&attrValue);
		}

		F_ApiSetId(docId, markerId, FP_MarkerTypeId, markerTypeId);
		F_ApiSetString(docId, markerId, FP_MarkerText, mText);
		F_ApiDeallocateString(&mText);
	}
	return SRW_E_SUCCESS;
}

/* 
 * getHypertextMarkerType(docId)
 * Get the marker type id for hypertext markers.
 *
 * Return NULL if not found.
 *
 * Uses the invariant name so that it works regardless 
 * of what language FM is currently using.
 */
F_ObjHandleT
getHypertextMarkerType(F_ObjHandleT docId)
{
	static StringT hypertextMarkerTypeName = (StringT)"hypertext";

	StringT currentInvariantName = NULL;
	F_ObjHandleT currentTypeId = F_ApiGetId(0, docId, FP_FirstMarkerTypeInDoc);

	while (currentTypeId)
	{
		currentInvariantName = F_ApiGetString(docId, currentTypeId, FP_InvariantName);
		if (F_StrIEqual(currentInvariantName, hypertextMarkerTypeName))
		{
			F_Free(currentInvariantName);
			return currentTypeId;
		}
		F_Free(currentInvariantName);
		currentTypeId = F_ApiGetId(docId, currentTypeId, FP_NextMarkerTypeInDoc);
	}

	/* if we get here, we couldn't find the hypertext marker type */
	return (F_ObjHandleT)NULL;
}

/* 
 * SetWidthOnImport()
 * This function sets the WIDTH attribute for the Table and for each Table Cell in
 * the first row.
 */
VoidT 
SetWidthOnImport(F_ObjHandleT docId, F_ObjHandleT elemId)
{
	StringT			attrValue = NULL;
	F_MetricsT		widths;
	MetricT			textRectWidth; 
	F_ObjHandleT	objectId, textRectId;
	IntT			j, num = 0;
	BoolT			percent = False;
	F_TextLocT		textLoc;


	attrValue = getAttrVal(docId, elemId, (StringT)"width");
	if (F_StrSubString(attrValue, (StringT)"%") != -1)
	{
		percent = True;
		F_StrStrip(attrValue, (StringT)"%");
	}
	num = F_StrAlphaToInt(attrValue);

	if (num <= 0)
	{
		percent = True;
		num = 100;
	}

	switch (F_ApiGetInt(docId, elemId, FP_ElementType)) 
	{
		case FV_FO_TBL :
			objectId = F_ApiGetId(docId, elemId, FP_Object);
			widths = F_ApiGetMetrics(docId, objectId, FP_TblColWidths);
			
			if (USECELLWIDTHS)
			{
				for (j = 0; j < (IntT)widths.len; j++)
					widths.val[j] = tblWidths[j];
				F_ApiSetMetrics(docId, objectId, FP_TblColWidths, &widths);
				F_ApiDeallocateMetrics(&widths);
				return;
			}

			if (percent == True)
			{
				textLoc = F_ApiGetTextLoc(docId, objectId, FP_TextLoc);
				textRectId = F_ApiGetId(docId, textLoc.objId, FP_InTextFrame);
				textRectWidth = F_ApiGetMetric(docId, textRectId, FP_Width);
				for (j = 0; j < (IntT)widths.len; j++)
					widths.val[j] =  (MetricT) F_MetricFractMul(textRectWidth, num, (IntT)100) / widths.len;
			}
			else
			{
				for (j = 0; j < (IntT)widths.len; j++)
					widths.val[j] = (MetricT)F_MetricMul(F_MetricMake(num, widths.len), pts);
			}

			F_ApiSetMetrics(docId, objectId, FP_TblColWidths, &widths);
			F_ApiDeallocateMetrics(&widths);
			break;
		case FV_FO_TBL_ROW :
			break;
		case FV_FO_TBL_CELL :
			break;
	}

	F_ApiDeallocateString(&attrValue);
}


/****************************************
  Center element.
****************************************/
VoidT 
CenterOnImport(F_ObjHandleT docId, F_ObjHandleT elemId)  
{
	StringT			attrValue = NULL;
	F_ObjHandleT	objectId = 0;
	IntT			alignment = CENTER;
	IntT			objectType;

	attrValue = getAttrVal(docId, elemId, (StringT)"align");
	if (F_StrIEqual(attrValue, "center"))
		alignment = CENTER;
	else if (F_StrIEqual(attrValue, "right"))
		alignment = RIGHT;
	else if (F_StrIEqual(attrValue, "left"))
		alignment = LEFT;

	objectType = F_ApiGetInt(docId, elemId, FP_ElementType);
	switch (objectType) 
	{
		case FV_FO_TBL :
			objectId = F_ApiGetId(docId, elemId, FP_Object);
			switch (alignment)
			{
			case CENTER :
				F_ApiSetInt(docId, objectId, FP_TblAlignment, FV_ALIGN_TBL_CENTER);
				break;
			case RIGHT :
				F_ApiSetInt(docId, objectId, FP_TblAlignment, FV_ALIGN_TBL_RIGHT);
				break;
			case LEFT :
				F_ApiSetInt(docId, objectId, FP_TblAlignment, FV_ALIGN_TBL_LEFT);
				break;
			}
			break;
		case FV_FO_TBL_ROW :
			break;
		case FV_FO_TBL_CELL :
			break;
	}
}

VoidT 
UpdateTblBorders(F_ObjHandleT docId, F_ObjHandleT elemId, SrConvObjT tblObj)
{
	StringT			borderValue = NULL, rulesValue = NULL, frameValue = NULL;
	StringT 		rulingString = NULL;
	IntT            borderThickness;
	F_ObjHandleT	tblId;
	F_ObjHandleT 	rulingFmtId, noRulingFmtId, 
					tblBodyRowRulingFmtId = (F_ObjHandleT)NULL,
					tblColRulingFmtId = (F_ObjHandleT)NULL,
					tblHFRowRulingFmtId = (F_ObjHandleT)NULL,
					tblHFSeparatorRulingFmtId = (F_ObjHandleT)NULL,
					tblOtherBodyRulingFmtId = (F_ObjHandleT)NULL,
					tblOtherColRulingFmtId = (F_ObjHandleT)NULL;

	tblId = F_ApiGetId(docId, elemId, FP_Object);

	noRulingFmtId = (F_ObjHandleT)NULL; /* specifies "None." */

	/* Given a border attr value, set the borders.  With no border
	 * attr specified, the xml translate code should have turned on
	 * the right borders, so we need nothing further here.
	 */
	borderValue = getAttrVal(docId, elemId, (StringT)"border");
	if (!F_StrIsEmpty(borderValue))
	{
		/* convert to number then determine thickness */
		borderThickness = F_StrAlphaToInt(borderValue);
		if (borderThickness <= 0)
			rulingFmtId = (F_ObjHandleT)NULL; /* specifies "None." */
		else if (borderThickness == 1)
			rulingString = F_SrCopy(FmVeryThinRulingStyle);
		else if (borderThickness == 2)
			rulingString = F_SrCopy(FmThinRulingStyle);
		else if (borderThickness == 3)
			rulingString = F_SrCopy(FmMediumRulingStyle);
		else
			rulingString = F_SrCopy(FmThickRulingStyle);

		rulingFmtId = F_ApiGetNamedObject(docId, FO_RulingFmt, rulingString);
		F_StrFree(rulingString);

		/* 
		 * If frame attr was not specified, assume all table
		 * borders using the thickness specified by the border attr.
		 *
		 * If both were specified, only turn on the borders specified
		 * by the frame attr (aka table border ruling property).
		 */
		frameValue = Sr_GetPropVal(tblObj, SRW_PROP_TABLE_BORDER);
		if (F_StrIsEmpty(frameValue)) 
		{
			F_ApiSetId(docId, tblId, FP_TblRightRuling, rulingFmtId);
			F_ApiSetId(docId, tblId, FP_TblLeftRuling, rulingFmtId);
			F_ApiSetId(docId, tblId, FP_TblTopRuling, rulingFmtId);
			F_ApiSetId(docId, tblId, FP_TblBottomRuling, rulingFmtId);
		}
		else
		{
			F_ObjHandleT currentId;

			/* Borders should have already been set by the import code,
			 * but not necessarily the correct thickness, so check which
			 * borders are set and set them to the right thickness. */
			currentId = F_ApiGetId(docId, tblId, FP_TblRightRuling);
			if (currentId && currentId != rulingFmtId)
				F_ApiSetId(docId, tblId, FP_TblRightRuling, rulingFmtId);

			currentId = F_ApiGetId(docId, tblId, FP_TblLeftRuling);
			if (currentId && currentId != rulingFmtId)
				F_ApiSetId(docId, tblId, FP_TblLeftRuling, rulingFmtId);

			currentId = F_ApiGetId(docId, tblId, FP_TblTopRuling);
			if (currentId && currentId != rulingFmtId)
				F_ApiSetId(docId, tblId, FP_TblTopRuling, rulingFmtId);

			currentId = F_ApiGetId(docId, tblId, FP_TblBottomRuling);
			if (currentId && currentId != rulingFmtId)
				F_ApiSetId(docId, tblId, FP_TblBottomRuling, rulingFmtId);
		}
	}

	rulingString = F_SrCopy(FmThinRulingStyle);
	rulingFmtId = F_ApiGetNamedObject(docId, FO_RulingFmt, rulingString);
	F_StrFree(rulingString);
	rulesValue = getAttrVal(docId, elemId, (StringT)"rules");
	if (F_StrIsEmpty(rulesValue) || F_StrIEqual(rulesValue, (StringT)"none")) 
	{
		tblBodyRowRulingFmtId = noRulingFmtId;
		tblColRulingFmtId = noRulingFmtId;
		tblHFRowRulingFmtId = noRulingFmtId;
		tblHFSeparatorRulingFmtId = noRulingFmtId;
		tblOtherBodyRulingFmtId = noRulingFmtId;
		tblOtherColRulingFmtId = noRulingFmtId;
	}
	else if (F_StrIEqual(rulesValue, (StringT)"cols"))
	{
		tblBodyRowRulingFmtId = noRulingFmtId;
		tblColRulingFmtId = rulingFmtId;
		tblHFRowRulingFmtId = noRulingFmtId;
		tblHFSeparatorRulingFmtId = noRulingFmtId;
		tblOtherBodyRulingFmtId = noRulingFmtId;
		tblOtherColRulingFmtId = rulingFmtId; 
	}
	else if (F_StrIEqual(rulesValue, (StringT)"rows"))
	{
		tblBodyRowRulingFmtId = rulingFmtId;
		tblColRulingFmtId = noRulingFmtId;
		tblHFRowRulingFmtId = rulingFmtId;
		tblHFSeparatorRulingFmtId = rulingFmtId;
		tblOtherBodyRulingFmtId = rulingFmtId;
		tblOtherColRulingFmtId = noRulingFmtId;
	}
	else if (F_StrIEqual(rulesValue, (StringT)"groups"))
	{
		tblBodyRowRulingFmtId = noRulingFmtId;
		tblColRulingFmtId = noRulingFmtId;
		tblHFRowRulingFmtId = noRulingFmtId;
		tblHFSeparatorRulingFmtId = rulingFmtId;
		tblOtherBodyRulingFmtId = noRulingFmtId;
		tblOtherColRulingFmtId = noRulingFmtId;
	}
	/* if its not specified assume all */
	else if (F_StrIEqual(rulesValue, (StringT)"all"))
	{
		tblBodyRowRulingFmtId = rulingFmtId;
		tblColRulingFmtId = rulingFmtId;
		tblHFRowRulingFmtId = rulingFmtId;
		tblHFSeparatorRulingFmtId = rulingFmtId;
		tblOtherBodyRulingFmtId = rulingFmtId;
		tblOtherColRulingFmtId = rulingFmtId;
	}

	F_ApiSetId(docId, tblId, FP_TblBodyRowRuling, tblBodyRowRulingFmtId);
	F_ApiSetId(docId, tblId, FP_TblColRuling, tblColRulingFmtId);
	F_ApiSetId(docId, tblId, FP_TblHFRowRuling, tblHFRowRulingFmtId);
	F_ApiSetId(docId, tblId, FP_TblHFSeparatorRuling, tblHFSeparatorRulingFmtId);
	F_ApiSetId(docId, tblId, FP_TblOtherBodyRowRuling, tblOtherBodyRulingFmtId);
	F_ApiSetId(docId, tblId, FP_TblOtherColRuling, tblOtherColRulingFmtId);

	F_ApiDeallocateString(&frameValue);
	F_ApiDeallocateString(&borderValue);
	F_ApiDeallocateString(&rulesValue);
}
