/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright (c) 1986 - 2000 Adobe Systems Incorporated            */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#include "fm_sgml.h"
#include "fmemory.h"
#include "fstrings.h"
#include "fstrlist.h"
#include "fmetrics.h"
#include "futils.h"
#include "fm_maker.h"
#include "fstrres.h"

#define pts (MetricT)65536

StringT GetTableWidth(F_ObjHandleT docId, F_ObjHandleT tableId);
StringT GetTableAlignment(F_ObjHandleT docId, F_ObjHandleT tableId);
StringT GetCellWidth(F_ObjHandleT docId, F_ObjHandleT cellId);
StringT GetBorderFromRuling(F_ObjHandleT docId, F_ObjHandleT fmtRulingId);
StringT GetTableBorder(F_ObjHandleT docId, F_ObjHandleT tableId);
StringT GetTableRuling(F_ObjHandleT docId, F_ObjHandleT tblId);
StringT GetTableFrame(F_ObjHandleT docId, F_ObjHandleT tblId);
StringT GetGraphicMetric( F_ObjHandleT docId, F_ObjHandleT afrmId, IntT metric );

static SrwTablePartTypeT XhtmlScanOrder[4] = {SRW_TABLE_TITLE, 
											  SRW_TABLE_HEADING,
											  SRW_TABLE_FOOTING,
											  SRW_TABLE_BODY};
/*
 * XML Writer Sample Event Handler for XHTML
 */
SrwErrorT Sw_EventHandler(eventp, swObj)
SwEventT *eventp;
SwConvObjT swObj;
{
	SgmlAttrValT att;
	SwConvObjT docObj;
	static F_ObjHandleT docId;
	StringT width = NULL, align = NULL, border = NULL, 
			rules = NULL, frame = NULL;

	switch (Sw_GetObjType(swObj))
	{
		case SW_OBJ_TABLE:
			docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
			if (!docObj)
				docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);

			if (docObj)
			{
				docId = Sw_GetDocId(docObj);

				/* set table width in points. */
				width = GetTableWidth(docId, eventp->fm_objid);
				att = Sw_GetAttrVal(swObj, (StringT)"width");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, width);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&width);


				/* set table align attribute */
				align = GetTableAlignment(docId, eventp->fm_objid);

				att = Sw_GetAttrVal(swObj, (StringT)"align");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, align);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&align);

				/* set table borders */
				border = GetTableBorder(docId, eventp->fm_objid);
				att = Sw_GetAttrVal(swObj, (StringT)"border");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, border);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&border);

				/* set table ruling */
				rules = GetTableRuling(docId, eventp->fm_objid);
				att = Sw_GetAttrVal(swObj, (StringT)"rules");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, rules);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&rules);

				/* set table frame */
				/* note this overwrites the attr value set
				 * by FM since it tries to write a CALS table
				 * instead of an XHTML table.
				 */
				frame = GetTableFrame(docId, eventp->fm_objid);
				att = Sw_GetAttrVal(swObj, (StringT)"frame");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, frame);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&frame);

				/* Swap tbody and tfoot order */
				Sw_SetTableScanOrder(swObj, XhtmlScanOrder);
			}
			break;

		case SW_OBJ_TABLE_CELL:
			docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
			if (!docObj)
				docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);

			if (docObj)
			{
				docId = Sw_GetDocId(docObj);

				width = GetCellWidth(docId, eventp->fm_objid);
				att = Sw_GetAttrVal(swObj, (StringT)"width");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, width);
				Sw_SetAttrVal(swObj, &att);

				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&width);
			}
			break;
			
		case SW_OBJ_GRAPHIC:

			/* For XHTML, we need to export the metric of the inset
			 * object rather than theose of the anchored frame
			 */
			docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
			if (!docObj)
				docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);

			if (docObj)
			{
				StringT insetMetric;
				docId = Sw_GetDocId(docObj);

				insetMetric = GetGraphicMetric( docId, eventp->fm_objid, FP_Width );
				att = Sw_GetAttrVal(swObj, (StringT)"width");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, insetMetric);
				Sw_SetAttrVal(swObj, &att);
				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&insetMetric);

				insetMetric = GetGraphicMetric( docId, eventp->fm_objid, FP_Height );
				att = Sw_GetAttrVal(swObj, (StringT)"height");
				att.sgmlAttrVal = (StringListT) F_StrListNew(1,1);
				F_StrListAppend(att.sgmlAttrVal, insetMetric);
				Sw_SetAttrVal(swObj, &att);
				Sgml_DeallocateAttrVal(&att);
				F_ApiDeallocateString(&insetMetric);

			}
			break;

		default:
			break;

	}

	return Sw_Convert(eventp, swObj);
}


StringT GetTableWidth(F_ObjHandleT docId, F_ObjHandleT tableId)
{
	IntT tblWidth;
	StringT width;

	tblWidth = F_ApiGetMetric(docId, tableId, FP_TblWidth);
	tblWidth =  tblWidth / pts;
	width = F_StrNew(50);
	F_Sprintf(width, "%d", tblWidth);

	return (width);
}

StringT GetCellWidth(F_ObjHandleT docId, F_ObjHandleT cellId)
{
	IntT colNum = 0, tblWidth = 0;
	F_ObjHandleT rowId, tableId;
	F_MetricsT tableWidths;
	StringT width;

	rowId = F_ApiGetId(docId, cellId, FP_CellRow);
	tableId = F_ApiGetId(docId, rowId, FP_RowTbl);
	colNum = F_ApiGetInt(docId, cellId, FP_CellColNum);
	tableWidths = F_ApiGetMetrics(docId, tableId, FP_TblColWidths);
	tblWidth =  tableWidths.val[colNum] / pts;
	width = F_StrNew(50);
	F_Sprintf(width, "%d", tblWidth);

	return (width);
}

StringT GetTableAlignment(F_ObjHandleT docId, F_ObjHandleT tableId)
{
	StringT align = NULL;
	IntT alignment;
	
	alignment = F_ApiGetInt(docId, tableId, FP_TblAlignment);
	switch (alignment)
	{
		case FV_ALIGN_TBL_CENTER:
			align = F_StrCopyString((StringT)"center");
			break;
		case FV_ALIGN_TBL_LEFT:
			align = F_StrCopyString((StringT)"left");
			break;
		case FV_ALIGN_TBL_RIGHT:
			align = F_StrCopyString((StringT)"right");
			break;
		default:
			align = F_StrCopyString((StringT)"right");
			break;
	}

	return (align);
}


StringT GetTableRuling(F_ObjHandleT docId, F_ObjHandleT tblId)
{
	F_ObjHandleT rowRuling, colRuling, separatorRuling;
	StringT ruling = NULL;

	rowRuling = F_ApiGetId(docId, tblId, FP_TblBodyRowRuling);
	colRuling = F_ApiGetId(docId, tblId, FP_TblColRuling);
	separatorRuling = F_ApiGetId(docId, tblId, FP_TblHFSeparatorRuling);

	/* check different combinations and set value appropriately */
	if (rowRuling)
	{
		if (colRuling)
			ruling = F_StrCopyString((StringT)"all");
		else 
			ruling = F_StrCopyString((StringT)"rows");
	}
	else if (colRuling)
	{
		if (separatorRuling)
			ruling = F_StrCopyString((StringT)"all");
		else
			ruling = F_StrCopyString((StringT)"cols");
	}
	else if (separatorRuling)
		ruling = F_StrCopyString((StringT)"groups");
	else
		ruling = F_StrCopyString((StringT)"none");

	return (ruling);
}


/*
 * Check the top, left, right, and bottom table borders for a border
 * thickness.
 */
StringT GetTableBorder(F_ObjHandleT docId, F_ObjHandleT tblId)
{
	F_ObjHandleT rulingFmtId;
	
	rulingFmtId = F_ApiGetId(docId, tblId, FP_TblTopRuling);
	if (!rulingFmtId)
		rulingFmtId = F_ApiGetId(docId, tblId, FP_TblLeftRuling);
	if (!rulingFmtId)
		rulingFmtId = F_ApiGetId(docId, tblId, FP_TblRightRuling);
	if (!rulingFmtId)
		rulingFmtId = F_ApiGetId(docId, tblId, FP_TblBottomRuling);

	return GetBorderFromRuling(docId, rulingFmtId);

}


StringT GetBorderFromRuling(F_ObjHandleT docId, F_ObjHandleT fmtRulingId)
{
	StringT border = NULL;
	StringT veryThinRulingStyle = NULL, thinRulingStyle = NULL;
	StringT mediumRulingStyle = NULL, thickRulingStyle = NULL;
	
	veryThinRulingStyle = F_SrCopy(FmVeryThinRulingStyle);
	thinRulingStyle = F_SrCopy(FmThinRulingStyle);
	mediumRulingStyle = F_SrCopy(FmMediumRulingStyle);
	thickRulingStyle = F_SrCopy(FmThickRulingStyle);

	if (!fmtRulingId)
		border = F_StrCopyString((StringT)"0");
	else if (fmtRulingId == F_ApiGetNamedObject(docId, FO_RulingFmt, veryThinRulingStyle))
		border = F_StrCopyString((StringT)"1");
	else if (fmtRulingId == F_ApiGetNamedObject(docId, FO_RulingFmt, thinRulingStyle))
		border = F_StrCopyString((StringT)"2");
	else if (fmtRulingId == F_ApiGetNamedObject(docId, FO_RulingFmt, mediumRulingStyle))
		border = F_StrCopyString((StringT)"3");
	else if (fmtRulingId ==F_ApiGetNamedObject(docId, FO_RulingFmt, thickRulingStyle))
		border = F_StrCopyString((StringT)"4");
	else
		border = F_StrCopyString((StringT)"1");
		
	F_StrFree(veryThinRulingStyle);
	F_StrFree(thinRulingStyle);
	F_StrFree(mediumRulingStyle);
	F_StrFree(thickRulingStyle);

	return (border);
}

/* Check table border to set frame attribute.  
 * Note this does ignore cell overrides.
 */
StringT GetTableFrame(F_ObjHandleT docId, F_ObjHandleT tblId)
{
	StringT frame;
	F_ObjHandleT tRuling, bRuling, lRuling, rRuling;
	
	tRuling = F_ApiGetId(docId, tblId, FP_TblTopRuling);
	lRuling = F_ApiGetId(docId, tblId, FP_TblLeftRuling);
	rRuling = F_ApiGetId(docId, tblId, FP_TblRightRuling);
	bRuling = F_ApiGetId(docId, tblId, FP_TblBottomRuling);

	if ( tRuling &&  bRuling &&  lRuling &&  rRuling)
		frame = F_StrCopyString((StringT)"border");
	else if ( tRuling &&  bRuling && !lRuling && !rRuling)
		frame = F_StrCopyString((StringT)"hsides");
	else if ( tRuling && !bRuling && !lRuling && !rRuling)
		frame = F_StrCopyString((StringT)"above");
	else if (!tRuling &&  bRuling && !lRuling && !rRuling)
		frame = F_StrCopyString((StringT)"below");
	else if (!tRuling && !bRuling &&  lRuling &&  rRuling)
		frame = F_StrCopyString((StringT)"vsides");
	else if (!tRuling && !bRuling && !lRuling &&  rRuling)
		frame = F_StrCopyString((StringT)"rhs");
	else if (!tRuling && !bRuling &&  lRuling && !rRuling)
		frame = F_StrCopyString((StringT)"lhs");
	else 
		frame = F_StrCopyString((StringT)"void");

	return frame;
}

StringT GetGraphicMetric( F_ObjHandleT docId, F_ObjHandleT afrmId, IntT metric )
{
	MetricT metricVal;
	PRealT  metricFlt;
	StringT metricStr = NULL;
	F_ObjHandleT insetId;
	
	insetId = F_ApiGetId( docId, afrmId, FP_FirstGraphicInFrame );
	metricVal = F_ApiGetMetric(docId, insetId, metric);
	
	metricFlt = (F_MetricToFloat(metricVal) + 0.0005) / F_MetricToFloat( FV_METRIC_POINT);
	metricStr = F_StrNew(50);
	F_Sprintf(metricStr, "%.3f%s", metricFlt, (StringT)"" );
	return( metricStr );
}