/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright (c) 1986 - 2000 Adobe Systems Incorporated            */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/


#include "fm_sgml.h"
#include "fstrings.h"
#include "fmemory.h"
#include "futils.h"
#include "fstrlist.h"
#include "fcharmap.h"

/*
 * application specific data
 */

 typedef struct index_entry 
 {
	StringT name;
	StringT text;
	StringT sortas;
	StringT range;
	StringT pagenum;
	struct index_entry *next;
} IndexEntryT;

    /* global variables */
UCharT buffer[256];

    /* function prototypes */
    static IntT exportULink FARGS((SwEventT *eventp));
    static IntT exportIndexTerm FARGS((SwEventT *eventp, SwConvObjT swObj));
    static IntT parseMarkerText FARGS((SwEventT *eventp, SwConvObjT swObj, StringT txt));
    static VoidT nextWord FARGS((StringT *txt));
    static VoidT expandSeeAlsoElements FARGS((IndexEntryT *p));
    static IndexEntryT *newIndexEntry FARGS((VoidT));
    static VoidT writeIndexToSGML FARGS((IndexEntryT *p, StringT level));
    static VoidT releaseIndex FARGS((IndexEntryT *p) );
    static StringT getIdOfStartRangeMarker FARGS((SwConvObjT swObj, StringT val) );
    static F_ObjHandleT getCurDocId FARGS((VoidT));
    static StringT strToLower FARGS((StringT s));
    static VoidT writeContent FARGS((IndexEntryT *p));
    static VoidT sw_writeLogMessage FARGS( (F_ObjHandleT docId, F_ObjHandleT objId, StringT msg) );


#define NO_END_TAG 2  /* no end tag is required, used with <$endrange> */

    /* error messages */
#define ERR_IDXSEE_1 (StringT)"An <IndexSee> must be followed by <Default Para Font>"
#define ERR_IDXSEE_2 (StringT)"An <IndexSee> must be followed by See or See also"

    /*
     * Sample event handler for SGML Writer
     */
    SrwErrorT Sw_EventHandler(eventp, swObj)
    SwEventT *eventp;
    SwConvObjT swObj;
    {
		StringT gi;

    	switch (eventp->evtype)
    	{
    		case SW_EVT_TEXT_INSET:
    			if (!swObj)
    				return exportULink(eventp);
    			break;

    		case SW_EVT_MARKER:
    			/*
    			 * export and IndexTerm marker to SGML
    			 */
				gi = Sw_GetStructuredGi(swObj);
    			if (F_StrIEqual(gi, (StringT)"IndexTerm"))
    			{
    				SrwErrorT err;

					F_StrFree(gi);
    				err = exportIndexTerm(eventp, swObj);
    				return err;
    			}
				F_StrFree(gi);
    			break;


    		default:
    			break;
    	}

    	return Sw_Convert(eventp, swObj);
    }


    /*
     * set the URL attribute to the filename of the text inset
     * in the ULink element
     */
    static SrwErrorT exportULink(eventp)
    SwEventT *eventp;
    {
    	F_ObjHandleT docId;
    	SwConvObjT docObj;
    	StringT s, tiFilePath;

    	docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
    	if (!docObj)
    	{
    		docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);
    		if (!docObj)
    			return(SRW_E_FAILURE);
    	}
    	docId = Sw_GetDocId(docObj);
    	if (!docId)
    		return(SRW_E_FAILURE);

    	tiFilePath = F_ApiGetString(docId, eventp->fm_objid, FP_TiFile);
    	if (!tiFilePath)
    		return(SRW_E_FAILURE);
    	s = F_StrNew(F_StrLen(tiFilePath) + 32);
    	F_Sprintf(s, "<ulink url=\"%s\"></ulink>", tiFilePath);
    	Sw_WriteString(SW_LOC_INSTANCE, s);
    	F_StrFree(s);
		F_StrFree(tiFilePath);
    	return(SRW_E_SUCCESS);
    }

    /*
     * export the index text of the IndexTerm marker element to
     * SGML
     */
    static SrwErrorT exportIndexTerm(eventp, swObj)
    SwEventT *eventp;
    SwConvObjT swObj;
    {
    	F_ObjHandleT docId, indexTermObjId;
    	StringT indexTermText;
 		UCharT s1[256];  /* maximum marker text is 256 */
    	StringT s;
    	IntT err;

    	/* get the Id of current document or book component */
    	docId = getCurDocId();
    	if (!docId)
    		return (SRW_E_FAILURE);

    	/* get the object Id of the Index marker */
    	indexTermObjId = eventp->fm_objid;

    	/* get the marker text */
    	indexTermText = F_ApiGetString(docId, indexTermObjId, FP_MarkerText);

    	/*
 	 * if there is no  text in the marker write the starttag for the indexterm,
 	 * the starttag and endtag for primary. The endtag for indexterm
    	 * will be written later
    	 */
    	F_StrStripLeadingSpaces(indexTermText);
    	F_StrStripTrailingSpaces(indexTermText);

    	if (F_StrIsEmpty(indexTermText)) Sw_WriteString(SW_LOC_INSTANCE, (StringT)"<indexterm><primary></primary>");


    	/*
 	 * check to see if there is a ; in the string
 	 * if there isn't one, we don't need to parse for
 	 * multiple indexes
 	 */
 	 if (F_StrSubString(indexTermText, (StringT)";") == -1)
 	 {

 		s1[0] = '\0';
 	 	F_StrCpy(s1, indexTermText);
 	 	/*
 	     * remove leading and trailing white spaces; they don't affect the
 	     * index entries
 	     */
 		F_StrStripLeadingSpaces(s1);
 		F_StrStripTrailingSpaces(s1);

 		/*
 		 * assume that page numbering information is specified at the
 		 * beginning of the index entry text. Markers starting with these
 		 * building blocks need to be converted separately because their
 		 * attributes have special meaning
 		 */
 		if (!F_StrPrefix(s1, (StringT)"<$startrange>")
 	  			&& !F_StrPrefix(s1, (StringT)"<$endrange>")
 	  			&& !F_StrPrefix(s1, (StringT)"<$nopage>")
 	  			&& !F_StrPrefix(s1, (StringT)"<$pagenum>")
 	  			&& !F_StrPrefix(s1, (StringT)"<$singlepage>") )

 				Sw_Convert(eventp, swObj);

 		/* parse the marker text */
 		err = parseMarkerText(eventp, swObj, s1);

 	 }
 	 else
 	 {
 		/*
    		 * separate multiple indexes in one marker. Each index is separated
    		 * by a semicolon
    		 */
    		s1[0] = '\0';
    		s = F_StrTok(indexTermText,(StringT)";");
    		while (s != NULL)
    		{

 			/* this is really a semicolon and not an index separator */
    			while (s != NULL && s[F_StrLen(s) - 1] == '\\')
    			{
    				F_StrCat(s1, s);
    				F_StrCat(s1, (StringT)";");
    				s = F_StrTok(NULL, (StringT)";");

    			}

    			F_StrCat(s1, s);

    			/*
    		     * remove leading and trailing white spaces; they don't affect the
    		     * index entries
    		     */
    			F_StrStripLeadingSpaces(s1);
    			F_StrStripTrailingSpaces(s1);

    			/*
    			 * assume that page numbering information is specified at the
    			 * beginning of the index entry text. Markers starting with these
    			 * building blocks need to be converted separately because their
    			 * attributes have special meaning
    			 */
    			if (!F_StrPrefix(s1, (StringT)"<$startrange>")
    		  			&& !F_StrPrefix(s1, (StringT)"<$endrange>")
    		  			&& !F_StrPrefix(s1, (StringT)"<$nopage>")
    		  			&& !F_StrPrefix(s1, (StringT)"<$pagenum>")
    		  			&& !F_StrPrefix(s1, (StringT)"<$singlepage>") )
    					Sw_Convert(eventp, swObj);

    			/* parse the marker text */
    			err = parseMarkerText(eventp, swObj, s1);

    			/*
    			 * if there is more than one index and it requires an end tag
    			 * then write one
    			 */
    			s = F_StrTok(NULL, (StringT)";");
    			if (s && err != NO_END_TAG) 
					Sw_WriteString(SW_LOC_INSTANCE, (StringT)"</indexterm>");
    			s1[0] = '\0';

    		}
 	}

    	/*
    	 * if we have just processed a marker containing a <$endrange>,
    	 * we don't need to write an end tag because of its SpanEnd
    	 * attribute declared as #CONREF
    	 */
    	if (err != NO_END_TAG)
    		Sw_WriteString(SW_LOC_INSTANCE, (StringT)"</indexterm>");


    	/* free the string allocated for the marker text */
    	if (indexTermText) F_Free(indexTermText);

    	return (SRW_E_SUCCESS);

    }

    /*
  * parses txt and constructs a link list of
  * IndexEntryT nodes which later are written
  * to sgml
     */
    static IntT parseMarkerText(eventp, swObj, txt)
    SwEventT *eventp;
    SwConvObjT swObj;
    StringT txt;
    {
    	F_ObjHandleT docId, elemId, objId;
    	IndexEntryT *current, *new, *head;
    	UCharT c;
    	IntT i = 0;
    	static const StringT state[] =
    		{ (StringT) "primary",
    		  (StringT) "secondary",
    		  (StringT) "tertiary"
    		} ;

    	IntT istate = 0;

    	/* get the ID of the current doc or book component */
    	docId = getCurDocId();
    	if (!docId)
    		return 0;

    	/* get the ID of the Frame Element for the Index marker */
    	elemId = eventp->fm_elemid;

    	/* get the ID of the Frame Object for the Index marker */
    	objId = eventp->fm_objid;

    	buffer[i] = '\0'; i = 0;
    	head = newIndexEntry();
    	if (!head) return 0;
    	head->next = NULL;
    	current = head;
    	head->name = F_StrCopyString(state[istate]);

    	while ((c = *txt) != '\0')
    	{


    		switch (c)
    		{

    		/* new index level */
    		case ':':

    			/* write the current index level to SGML */
    			writeIndexToSGML(head, state[istate]);

    			/* start a new index level */
    			head = newIndexEntry();
    			head->name = F_StrCopyString(state[++istate]);
    			/*
    			 * The following line caused big memmory problems
    			 * on HP-UX. Why is it here, anyway?
    			 *
    			* current->next = head;
    			*/
    			current = head;
    			txt++;
    			break;

    		/* sortas attribute */
    		case '[':

    			while ((c = *++txt) != '\0' && c != ']')
    			{
    				buffer[i++] = c;
    			}

    			buffer[i] = '\0'; i = 0;


    			head->sortas = F_StrCopyString(buffer);

    			/* remove white spaces */
    			while ((c = *++txt) != '\0' && c == ' ') ;
    			break;

    		/* See/Seealso or Inline element or building block */
    		case '<':

    			/* get the text enclosed in the square brackets */
    			while ((buffer[i++] = *txt++) != '\0' && buffer[i - 1] != '>') ;
    			buffer[i] = '\0'; i = 0;


    			/* we have a See/Seealso */
    			if (F_StrIEqual(buffer, (StringT)"<IndexSee>") )
    			{

    				buffer[0] = '\0'; i = 0;
    				/* get the text after the tag */
    				buffer[i] = *txt;
    				while (buffer[i] != '\0' && buffer[i] != '<')
    				{
    					i++; txt++;
    					buffer[i] = *txt;
    				}
    				buffer[i] = '\0'; i = 0;

    				F_StrStripLeadingSpaces(buffer);
    				F_StrStripTrailingSpaces(buffer);
    				/* we have a See/See also */
    				if (F_StrIEqual(buffer, (StringT)"See") || F_StrIEqual(buffer, (StringT)"See also") )
    				{

    					/* find out if there is a sort order with the text */
    					if (txt[F_StrLen(txt) - 1] == ']')
    					{
    						StringT sort;

    							sort = F_StrChr(txt, '[');
    							if (sort)
    							{
    								IntT len = 0;
    								/* remove open/close brackets */

	F_StrStrip(sort, (StringT)"[]");

	head->sortas = F_StrCopyString(sort);
    								len = F_StrLen(txt) - F_StrLen(sort);

	F_StrTrunc(txt, len);
    							}
    					}
    					/* write the current index level to SGML */
    					writeIndexToSGML(head, (StringT)"");

    					/* start a new level */
    					head = newIndexEntry();
    					if (F_StrIEqual(buffer, (StringT)"See"))
    						head->name = F_StrCopyString((StringT)"see");
    					else
    						head->name = F_StrCopyString((StringT)"seealso");
    					current->next = head;
    					current = head;

    					/* get the <Default Para Font> */
    	   				while ((buffer[i++] = *txt++) != '\0' && buffer[i - 1] != '>') ;
    					buffer[i] = '\0'; i = 0;


    					/*
    					 * make sure that we have a <Default Para Font>.
    					 */

    					if (!F_StrIEqual(buffer, (StringT)"<Default Para Font>"))
    					{
    						sw_writeLogMessage(docId, objId, ERR_IDXSEE_1);
    					}


    				}
    				else
    				{
    				   	sw_writeLogMessage(docId, objId, ERR_IDXSEE_2);
    				}
    			}

    			else if (F_StrIEqual(buffer, (StringT)"<Default Para Font>"))
    			{
    				new = newIndexEntry();
    				new->name = F_StrCopyString(buffer);
    				new->text = F_StrCopyString(buffer);
    				current->next = new;
    				current = new;
    			}

    			else if (F_StrIEqual(buffer, (StringT)"<$nopage>"))
    			{

    				StringT pagenum;
    				SgmlAttrValT attr;
    				UIntT i;
    				F_AttributesExT attrs, fm_attrs;

    				/*
    				 * find out if the ID attribute has a value
    				 * If it doesn't create one for it
    				 */
    				attrs = F_ApiGetAttributesEx(docId, elemId);
    				fm_attrs = F_ApiCopyAttributesEx(&attrs);
    				F_ApiDeallocateAttributesEx(&attrs);
    				for (i=0; i < fm_attrs.len; i++)
    				{
    					F_AttributeExT *fmAttrValp = &(fm_attrs.val[i]);
    					if (F_StrIEqual(fmAttrValp->name, (StringT)"PAGENUM"))
    					{
    						fmAttrValp->values.len = 1;
    						fmAttrValp->values.val[0] = F_StrCopyString((StringT)"0");
    						pagenum = F_StrCopyString((StringT)"0");
    					}
    				}
    				/*
    				 * set the IndexTerm element atributes in the FM+SGML document
    				 * so that the writer will find the correct PageNum when the corresponding
    				 * <$nopage> is encountered
    				 */
    				F_ApiSetAttributesEx(docId, elemId, &fm_attrs);
					F_ApiDeallocateAttributesEx(&fm_attrs);

    				/*
    				 * set the PageNum attribute in the Writer conversion object so that the
    				 * attribute is exported correctly
    				 */
    				attr = Sw_GetAttrVal(swObj, (StringT)"PAGENUM");
    				attr.sgmlAttrVal = (StringListT) F_StrListNew(1, 1);
    				F_StrListAppend(attr.sgmlAttrVal, pagenum);
    				Sw_SetAttrVal(swObj, &attr);

    				/* release memory to avoid any leaks */
    				Structured_DeallocateAttrVal(&attr);
    				if (pagenum) F_Free(pagenum);

    				Sw_Convert(eventp, swObj);
    			}
    			else if (F_StrIEqual(buffer, (StringT)"<$startrange>"))
    			{
    				StringT range;
    				SgmlAttrValT attr;
    				UIntT i;
    				F_AttributesExT attrs, fm_attrs;

    				/*
    				 * find out if the ID attribute has a value
    				 * If it doesn't create one for it
    				 */
    				attrs = F_ApiGetAttributesEx(docId, elemId);
    				fm_attrs = F_ApiCopyAttributesEx(&attrs);
    				F_ApiDeallocateAttributesEx(&attrs);
    				for (i=0; i < fm_attrs.len; i++)
    				{
    					F_AttributeExT *fmAttrValp = &(fm_attrs.val[i]);
    					if (F_StrIEqual(fmAttrValp->name, (StringT)"ID"))
    					{
    						if (fmAttrValp->values.len == 0)
    						{
    							F_ObjHandleT uid;
    							UCharT s[20];

    							uid = F_ApiGetInt(docId, objId, FP_Unique);
    							F_Sprintf(s, "ABC%d", uid);

								fmAttrValp->values.len = 1;

								fmAttrValp->values.val = (StringT *) F_Alloc (sizeof (StringT *), NO_DSE);

								fmAttrValp->values.val[0] = F_StrCopyString(s);
    							range = F_StrCopyString(s);
    						}
    						else
    							range = F_ApiGetString(docId, elemId, FP_IDAttrValue);
    						break;
    					}
    				}

    				/*
    				 * set the IndexTerm element atributes in the FM+SGML document
    				 * so that the writer will find the correct ID when the corresponding
    				 * <$endrange> is encountered
    				 */
    				F_ApiSetAttributesEx(docId, elemId, &fm_attrs);
					F_ApiDeallocateAttributesEx(&fm_attrs);

    				/*
    				 * set the ID attribute in the Writer conversion object so that the
    				 * ID attribute is exported correctly
    				 */
    				attr = Sw_GetAttrVal(swObj, (StringT)"ID");
    				attr.sgmlAttrVal = (StringListT) F_StrListNew(1, 1);
    				F_StrListAppend(attr.sgmlAttrVal, range);
    				Sw_SetAttrVal(swObj, &attr);

    				/* release memory to avoid any leaks */
    				Structured_DeallocateAttrVal(&attr);
    				if (range) F_Free(range);

    				Sw_Convert(eventp, swObj);

    			}
    			else if (F_StrIEqual(buffer, (StringT)"<$endrange>"))
    			{
    				StringT text;
    				StringT idvalue;
    				SgmlAttrValT attr;
					StringT theMarkerText;

    				theMarkerText = F_ApiGetString(docId, objId, FP_MarkerText);
					text = F_StrCopyString(theMarkerText + F_StrLen(buffer));
					F_ApiDeallocateString(&theMarkerText);

    				idvalue = getIdOfStartRangeMarker(swObj, text);

    				/*
    				 * set the value of the SpanEnd attribute
    				 */
    				attr = Sw_GetAttrVal(swObj, (StringT)"SPANEND");
    				attr.sgmlAttrVal = (StringListT) F_StrListNew(1, 1);
    				F_StrListAppend(attr.sgmlAttrVal, idvalue);
    				Sw_SetAttrVal(swObj, &attr);

    				/* release memory to avoid any leaks */
    				Structured_DeallocateAttrVal(&attr);
    				if (text) F_ApiDeallocateString(&text);
    				if (idvalue) F_ApiDeallocateString(&idvalue);

    				Sw_Convert(eventp, swObj);

    				/*
    				 * return NO_END_TAG to indicate that the end tag has to be ommitted
    				 * for this element since its SpanEnd attribute (declared
    				 * as #CONREF has a value
    				 */
    				return NO_END_TAG;

    			}

    			/*
    			 * treat <$pagenum> and <$singlepage> the same as both
    			 * set the page in the index.
    			 */
    			else if (F_StrIEqual(buffer, (StringT)"<$pagenum>")
    						|| F_StrIEqual(buffer, (StringT)"<$singlepage>") )
    			{
    				StringT pagenum;
    				SgmlAttrValT attr;
    				UIntT i;
    				F_AttributesExT attrs, fm_attrs;

    				/*
    				 * find out if the ID attribute has a value
    				 * If it doesn't create one for it
    				 */
    				attrs = F_ApiGetAttributesEx(docId, elemId);
    				fm_attrs = F_ApiCopyAttributesEx(&attrs);
    				F_ApiDeallocateAttributesEx(&attrs);
    				for (i=0; i < fm_attrs.len; i++)
    				{
    					F_AttributeExT *fmAttrValp = &(fm_attrs.val[i]);
    					if (F_StrIEqual(fmAttrValp->name, (StringT)"PAGENUM"))
    					{
    						fmAttrValp->values.len = 1;
    						fmAttrValp->values.val[0] = F_StrCopyString((StringT)"1");
    						pagenum = F_StrCopyString((StringT)"1");
    					}
    				}
    				/*
    				 * set the IndexTerm element atributes in the FM+SGML document
    				 * so that the writer will find the correct PageNum when the corresponding
    				 * <$pagenum> is encountered
    				 */
    				F_ApiSetAttributesEx(docId, elemId, &fm_attrs);

    				/*
    				 * set the PageNum attribute in the Writer conversion object so that the
    				 * attribute is exported correctly
    				 */
    				attr = Sw_GetAttrVal(swObj, (StringT)"PAGENUM");
    				attr.sgmlAttrVal = (StringListT) F_StrListNew(1, 1);
    				F_StrListAppend(attr.sgmlAttrVal, pagenum);
    				Sw_SetAttrVal(swObj, &attr);

    				/* release memory to avoid any leaks */
    				Structured_DeallocateAttrVal(&attr);
    				if (pagenum) F_Free(pagenum);

    				Sw_Convert(eventp, swObj);

    			}
    			/*
    			 * KeyCap is the only character tag supported for now
    			 */
    			else if (F_StrIEqual(buffer, (StringT)"<KeyCap>"))
    			{
    				StringT s;

    				new = newIndexEntry();
    				s = strToLower(buffer);
    				new->name = F_StrCopyString(s);
    				(VoidT) nextWord(&txt);
    				new->text = F_StrCopyString(buffer);
    				current->next = new;
    				current = new;
    				if (s) F_Free(s);
    			}
    			/*
    			 * any other building block will create an error message in the
    			 * log file
    			 */
    			else
    			{
    				UCharT s[100];

    				F_Sprintf(s, "Unknown building block %s", buffer);
    				sw_writeLogMessage(docId, objId, (StringT)s);

    				return 0;
    			}

    			break;

    		default:
    			/* text */
    			(VoidT) nextWord(&txt);
    			F_StrStripTrailingSpaces(buffer);
    			new = newIndexEntry();
    			new->text = F_StrCopyString(buffer);
    			new->name = F_StrCopyString((StringT)"<TEXT>");
    			current->next = new;
    			current = new;
    			break;

    		} /* end switch */

    	} /* end while */

    	writeIndexToSGML(head, state[istate]);
    	return 1;
    }

    /*
     * expands  multiple <seealso> entries separated by semicolons
     * to full sgml
     */

    static VoidT expandSeeAlsoElements(seealso)
    IndexEntryT *seealso;
    {
    IndexEntryT *p;
 	StringT tempStr;
 	IntT i = 0;
 	UCharT  sgmlString[1024];

 	/*
 	 * save the beginning of the list of nodes
 	 * we will need it later
 	 */
 	p = seealso;

 	/*
 	 * if for some reason we don't have a <seealso> element
 	 * don't even bother going further
 	 */
 	if (!F_StrIEqual(p->name, (StringT)"seealso"))
 			return;

 	/*
 	 * text starts on the second node
 	 */
 	p = p->next;

 	/* save the seealso text */
 	tempStr = F_StrCopyString(p->text);

 	/*
 	 * we need to start with a start tag
 	 * remember to write the matching endtag
 	 * at the end
 	 */
 	sgmlString[0] = '\0';
 	F_StrCat(sgmlString, (StringT)"<seealso>");

 	/*
 	 * get the string character by character
 	 */
 	for (i = 0; i < F_StrLen(tempStr); i++)
 	{
 		/*
 		 * if we have a semicolon, the end the current element
 		 * by writing its endtag and start a new one by writing
 		 * the starttag
 		 */
 		if (tempStr[i] == ';')
 		{
 			F_StrCat(sgmlString, (StringT)"</seealso><seealso>");
 		}

 		/*
 		 * otherwise, we have plain text so save it
 		 */
 		else
 		{
 			UCharT c[2];

 			F_Sprintf(c, "%c", tempStr[i]);
 			F_StrCat(sgmlString, c);
 		}
 	}

 	/*
 	 * there must be an element without an endtag
 	 * so write it here
 	 */
 	F_StrCat(sgmlString, (StringT)"</seealso>");

 	/*
 	 * free the memory already allocated for
 	 * the sgml text and allocate some new one
 	 * big enough to hold the new sgmlString
 	 */
 	if (seealso->next->text)
 		F_Free(seealso->next->text);
 	seealso->next->text = F_StrCopyString(sgmlString);

 	/*
 	 * free the temporary string
 	 */
 	if (tempStr) F_Free(tempStr);

 	return;
 }

 /*
  * get the next word from the marker text
  * gets the next word in the marker text
  * a word is any text delimetered by : < [ ;
  * or the end of line characters
  * A word is anything between :, <, [, ; and EOL
  */
    static VoidT nextWord(txt)
    StringT *txt;
    {
    	UCharT c;
    	IntT i = 0;
    	UCharT buf[256];

    	buf[i] = '\0';
    	c = **txt;
    	while (c != '\0' && c != ':' && c != '<'  && c != '[' && c != ';')
    	{
 		/*
 		 * if it is not an escape char
 		 * save it
 		 */
    		if (c != '\\')
    		{
    			buf[i++] = c;
    			c = *++(*txt);
    		}
    		else
    		{
    			(*txt)++;
    			if (**txt != '\0')
    			{
    				c = **txt;
    				buf[i++] = c;
    			}
    			else
    				break;

    			++(*txt);
    			if (**txt != '\0')
    				c = **txt;
    			else
    				break;

    		}

    	}
    	buf[i] = '\0';

    	F_StrCpy(buffer, buf);

    	return;
    }

    /*
     * allocates heap memory for an IndexEntryT. It initalizes
     * the members of the structure
     */

    static IndexEntryT *newIndexEntry()
    {

    	IndexEntryT *new;

    	new = (IndexEntryT *) F_Alloc (sizeof(IndexEntryT), NO_DSE);
    	if (!new)
    	{
    		F_ApiAlert((StringT)"Can not allocate memory", FF_ALERT_CONTINUE_WARN);
    		return NULL;
    	}
    	new->text = NULL;
    	new->name = NULL;
    	new->sortas = NULL;
    	new->range = NULL;
    	new->pagenum = NULL;
    	new->next = NULL;

    	return new;
    }


    /*
     * writes the SGML of the IndexTerm element being processed
     */
    static VoidT writeIndexToSGML(p, level)
    IndexEntryT *p;
    StringT level;
    {
    	UCharT s[200];
    	StringT tag;

    	/*
    	 * if the element is <seealso>, expand any multiple seealso
    	 * elements and write string to SGML
    	 */
    	if (F_StrIEqual(p->name, (StringT)"seealso") )
    	{
 		/*
 		 * if there is not a semicolon in the seealso text
 		 * there is no need to expand; just right the
 		 * starttag, the text and the end tag
 		 */
 		if (F_StrSubString(p->next->text, (StringT)";") == -1)
 		{
 			Sw_WriteString(SW_LOC_INSTANCE, (StringT)"<seealso>");
 			Sw_WriteString(SW_LOC_INSTANCE, p->next->text);
 			Sw_WriteString(SW_LOC_INSTANCE, (StringT)"</seealso>");
 		}

 		/*
 		 * otherwise expand, create a new text that will contain
 		 * all tags and text and write the text to sgml
 		 */
 		else
 		{
    			expandSeeAlsoElements(p);
    			Sw_WriteString(SW_LOC_INSTANCE, p->next->text);
    		}
 	}

    	/*
    	 * if the element is <see> write the start tag, its contents
    	 * and the end tag
    	 */
    	else if (F_StrIEqual(p->name, (StringT)"see") )
    	{
    		tag = F_StrCopyString(p->name);

    		/* write the start tag */
    		F_Sprintf(s, "<%s>", tag);
    		Sw_WriteString(SW_LOC_INSTANCE, s);

    		/* write its content; assume only text for now */
    		p = p->next;
    		while (p)
    		{
    			if (F_StrIEqual(p->name, (StringT)"<TEXT>"))
    				Sw_WriteString(SW_LOC_INSTANCE, p->text);

    			p = p->next;
    		}

    		/* write the end tag */
    		F_Sprintf(s, "</%s>", tag);
    		Sw_WriteString(SW_LOC_INSTANCE, s);

    		if (tag) F_Free(tag);
    	}

    	/* else if the element is <primary>, <secondary> or <tertiary>
    	 * write the start tag with attributes (if any), its contents
    	 * and the end tag
    	 */

    	else if (F_StrIEqual(p->name, (StringT)"primary")
    		|| F_StrIEqual(p->name, (StringT)"secondary")
    		|| F_StrIEqual(p->name, (StringT)"tertiary") )
    	{
    		tag = F_StrCopyString(p->name);
    		if (p->sortas && p->range)
    			F_Sprintf(s, "<%s ID = \"%s\" sortas =\"%s\">", tag, p->range, p->sortas);
    		else if (p->sortas)
    			F_Sprintf(s, "<%s sortas =\"%s\">", tag, p->sortas);
    		else if (p->range)
    			F_Sprintf(s, "<%s ID =\"%s\">", tag, p->range);
    		else
    			F_Sprintf(s, "<%s>", tag);

    		Sw_WriteString(SW_LOC_INSTANCE, s);

    		writeContent(p->next);

    		/* write the end tag for the current index level */
 			s[0] = '\0';
    		F_Sprintf(s, "</%s>", tag);
    		Sw_WriteString(SW_LOC_INSTANCE, s);

    		/* clean up */
    		if (tag) F_Free(tag);
    	} /* end if primary, secondat or tertiary */


      /* free the memory. It's not needed any more */
      releaseIndex(p);

    }
    /*
     * releases the heap memory allocated for the link list of IndexEntryT
     * elements
     */

    static VoidT
    releaseIndex(p)
    IndexEntryT *p;
    {
    	IndexEntryT *temp;

      	while (p != NULL)
    	{
    		temp = p->next;
    		if (p->name) F_Free(p->name);
    		if (p->text) F_Free(p->text);
    		if (p->range) F_Free(p->range);
    		if (p->pagenum) F_Free(p->pagenum);
    		if (p->sortas) F_Free(p->sortas);
    		F_Free(p);
    		p = temp;
    	}
    }

    /*
     * get the value of the ID attribute that corresponds to
     * a marker with <$startrange>
     */
    static StringT getIdOfStartRangeMarker(swObj, val)
    SwConvObjT swObj;
    StringT val;
    {
    	F_ObjHandleT docId;
    	F_ObjHandleT markerId = 0;

    	docId = getCurDocId();
    	if (!docId)
    		return NULL;

    	markerId = F_ApiGetId(0, docId, FP_FirstMarkerInDoc);
    	while (markerId)
    	{
    		StringT mtext, text;

    		mtext = F_ApiGetString(docId, markerId, FP_MarkerText);
    		if (F_StrPrefix(mtext, (StringT)"<$startrange>"))
    		{
    			text = mtext + F_StrLen((StringT)"<$startrange>");

    			if (F_StrIEqual(text, val))
    			{
    				StringT range;
    				F_ObjHandleT elemId;

    				elemId = F_ApiGetId(docId, markerId, FP_Element);
    				range = F_ApiGetString(docId, elemId, FP_IDAttrValue);
					F_ApiDeallocateString(&mtext);
    				return range;
    			}
    		}
			F_ApiDeallocateString(&mtext);
    		markerId = F_ApiGetId(docId, markerId, FP_NextMarkerInDoc);
    	}

    	return NULL;
    }

    /* returns the Id of the current document or book component
       or zero if there is no current document
     */
    static F_ObjHandleT getCurDocId()
    {

    	SwConvObjT docObj;
    	F_ObjHandleT docId;

    	docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
    	if (!docObj)
    	{
    		docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);
    		if (!docObj)
    			return(0);
    	}
    	docId = Sw_GetDocId(docObj);
    	if (!docId)
    		return(0);

    	return docId;
    }


    /*
     * converts a string to lower case
     * return value needs to be freed
     */
    static StringT strToLower(s)
    StringT s;
    {
    	IntT i = 0;
    	IntT n = F_StrLen(s);
    	StringT s1 = F_StrNew(n + 1);

    	for (i = 0; i < n; i++)
    		s1[i] = F_CharToLower(s[i]);

    	return s1;
    }

 /*
  * recursive writes to SGML the content of the specified
  * IndexEntryT node
  */
    static VoidT
    writeContent(p)
    IndexEntryT *p;
    {
    	IntT len;
    	StringT name, text;

    	if (!p) return;

    	name = F_StrCopyString(p->name);
    	text = F_StrCopyString(p->text);
    	len = F_StrLen(name);

    	if (F_StrIEqual(name, (StringT)"<TEXT>"))
    	{
    		Sw_WriteString(SW_LOC_INSTANCE, text);
    		writeContent(p->next);
    	}

    	else if (F_StrIEqual(name, (StringT)"<keycap>") )
    	{
    		Sw_WriteString(SW_LOC_INSTANCE, (StringT)"<keycap>");
    		Sw_WriteString(SW_LOC_INSTANCE, text);
    		writeContent(p->next);
    		Sw_WriteString(SW_LOC_INSTANCE, (StringT)"</keycap>");
    	}

    	else if (F_StrIEqual(name, (StringT)"<Default Para Font>") )
    			writeContent(p->next);

    	else if (name[0] =='<' && name[F_StrLen(p->name) - 1] == '>')
    	{
    		StringT s;
    		F_StrStrip(name, (StringT)"<>");

    		s = F_StrNew(len+1);

    		F_Sprintf(s, "<%s>", name);
    		Sw_WriteString(SW_LOC_INSTANCE, s);

    		writeContent(p->next);

    		F_Sprintf(s, "</%s>", name);
    		Sw_WriteString(SW_LOC_INSTANCE, s);
    	}

    	if (name) F_Free(name); 
    	if (text) F_Free(text);
    }

    /*
     * writes an error message to the log file. The message
     * is a hypertext link to the object id 'objId' in 'docId'
     */
    static VoidT
    sw_writeLogMessage(docId, objId, msg)
    F_ObjHandleT docId, objId;
    StringT msg;
    {
    		SrwLogMessageLocationT loc;

    		loc.docIdentType = SRW_LOGD_ID;
    		loc.doc_u.docId = docId;
    		loc.locType = SRW_LOGL_ID;
    		loc.loc_u.targetId = objId;

    		Srw_LogMessage(&loc, msg);

    		return;
    }

