/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*The client will add a new Menu Book Utilities when the books is in the current focus. 
	This Menu option will have following two sub-menus:
	- Book MIF Wash: MIF Wash the book components. Before continuing the operation the 
		client will prompt the user to make a backup copy of the file set as the files 
		in the book will be overwritten after MIF wash operation. The client will then
		open the files in book one by one, saving them as MIFs and also saving them back 
		to fm file format at the same time.
	- Open all Book Components (Suppress Warnings): Open all components in the book with
		suppressed warnings and alert messages. User would not need to click on missing 
		fonts, missing graphics and other such alerts while opening the documents.

/********************************************************************/
/*
*	---------------------------------------------------------
*	To Register your client with the FrameMaker product.
*	---------------------------------------------------------
*	The FrameMaker product needs to know about your client to initialize it. To let the FrameMaker product know about this client, you must make some changes to the environment under which the client runs.
*	1.	Copy the attached dll to FrameMaker 10\fminit folder in the Program Files installation directory. 
*	2.	Open maker.ini file in the FrameMaker 10 directory. Add the following lines to the [APIClients] section of the maker.ini file:
*	MIFwash=Standard, MIF Wash, fminit\BookComponentMIFWash.dll, all

*	Note: This is the format for the maker.ini client entry.
*	ClientName=ClientType, description, path, mode
*	ClientName is the name that the FrameMaker product and other clients use to reference your client. ClientType specifies your client type: for example, Standard, DocReport, or TextImport. description is a string describing your client. path is the pathname of your clients DLL. mode determines what product interfaces your client supportscan be one of all, maker, or structured.

*	3.	Launch FrameMaker 10. To verify that the client has been registered successfully open a new book. A menu bar with Book MIF Wash name should get added.
*/

#include "fapi.h"
#include "fdetypes.h"
#include "fmemory.h"
#include "futils.h"
#include "fcodes.h"
#include "fmetrics.h"
#include "fstrings.h"


#define OPEN_BOOK 1
#define MIF_WASH_BOOK 2
#define SAVE_LEGACY 3
#define CLASS_MENU_LABEL (StringT) "Book Utilities"
#define CLASS_BOOK_MENU_NAME (StringT) "MIF Wash"


VoidT setViewOnlySettings();
VoidT SaveAsMIF(F_ObjHandleT compId,StringT compName);
StringT ReplaceExtensionWith(StringT basename, StringT newExt);
VoidT openMIFsavebackAsFm(F_ObjHandleT docId,StringT mifname);
VoidT SaveAsLegacy(F_ObjHandleT compId, StringT compName);


VoidT F_ApiInitialize(init)
IntT init;{
	F_ObjHandleT classBookMenuId;
	F_ObjHandleT bookMenuId,bookMenuId2,bookMenuId3;
	
	/* Making it unicode enabled. */
	F_FdeInit();
	F_ApiEnableUnicode(True);
  	F_FdeInitFontEncs("UTF-8");

	switch(init){
	case FA_Init_First:
		bookMenuId = F_ApiGetNamedObject(FV_SessionId, FO_Menu, (StringT) "!BookMainMenu");
		if(bookMenuId){
			classBookMenuId = F_ApiGetNamedObject(FV_SessionId, FO_Menu, CLASS_BOOK_MENU_NAME);
			if(!classBookMenuId)
				classBookMenuId = F_ApiDefineAndAddMenu(bookMenuId, CLASS_BOOK_MENU_NAME, CLASS_MENU_LABEL);
			bookMenuId =F_ApiDefineAndAddCommand(MIF_WASH_BOOK, classBookMenuId, (StringT) "MIF_WASH_BOOKMenu", (StringT) "Book MIF Wash", (StringT) "\\!MW");
			bookMenuId2 =F_ApiDefineAndAddCommand(OPEN_BOOK, classBookMenuId, (StringT) "OPEN_BOOKMenu", (StringT) "Open all Book Components(Suppress Warnings)", (StringT) "\\!OA");
			//bookMenuId3 =F_ApiDefineAndAddCommand(SAVE_LEGACY, classBookMenuId, (StringT) "SaveAsLegacy", (StringT) "Save the entire File set in FM8 version", (StringT) "\\!LS");
		}
		F_ApiBailOut();
		break;
	}
}

VoidT F_ApiCommand(command)
IntT command;{
	IntT i,userCancelled; /* index into property list */
	F_PropValsT script, *returnp = NULL;
	F_ObjHandleT bookId; /* active book ID */
	F_ObjHandleT compId; /* book component ID */
	F_ObjHandleT docId; /*  document ID */
	StringT compName = NULL,bookName; /* name of book component */
	
	switch(command){
	case OPEN_BOOK:
		/* create open script */
		script = F_ApiGetOpenDefaultParams();
		i = F_ApiGetPropIndex(&script, FS_MakeVisible);
		script.val[i].propVal.u.ival = True;
		i = F_ApiGetPropIndex(&script, FS_RefFileNotFound);
		script.val[i].propVal.u.ival = FV_AllowAllRefFilesUnFindable;
		i = F_ApiGetPropIndex(&script, FS_FileIsOldVersion);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontChangedMetric);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInCatalog);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LanguageNotAvailable);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LockCantBeReset);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_UpdateTextReferences);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UpdateXRefs);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseAutoSaveFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseRecoverFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_AlertUserAboutFailure);
		script.val[i].propVal.u.ival = False;
		i = F_ApiGetPropIndex(&script, FS_BeefyDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FileIsInUse);
		script.val[i].propVal.u.ival = FV_OpenViewOnly;
		i = F_ApiGetPropIndex(&script, FS_FileIsStructured);
		script.val[i].propVal.u.ival = FV_OpenViewOnly;
		i = F_ApiGetPropIndex(&script, FS_OpenFileNotWritable);
		script.val[i].propVal.u.ival = FV_DoOK;

		/* get ID of active book */
		bookId = F_ApiGetId(FV_SessionId, FV_SessionId, FP_ActiveBook);
		/* get all components in the active book and open using script */
		compId = F_ApiGetId(FV_SessionId, bookId, FP_FirstComponentInBook);
		while(compId){
			F_ObjHandleT nextId = 0, parentId = 0;
			IntT compType = F_ApiGetInt(bookId, compId, FP_ComponentType);
			StringT compName = NULL;

			if ( FV_BK_FOLDER == compType || FV_BK_GROUP == compType )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_FirstComponentInBookComponent );
			}

			if ( !nextId )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_NextComponentInBook );
			}

			parentId = compId;
			while ( !nextId && (parentId != 0) )
			{
				parentId = F_ApiGetId ( bookId, parentId, FP_BookComponentParent );
				nextId = F_ApiGetId ( bookId, parentId, FP_NextComponentInBook );
			}

			/* get component name */
			compName = F_ApiGetString(bookId, compId, FP_Name);

			/* -------------------------------------------  */
			/* open the document with the component name */
			docId = F_ApiOpen(compName, &script, &returnp);
			/* -------------------------------------------  */
			
			/* check outcome of open for FV_ReferencedFilesWerentFound */
			if(F_ApiCheckStatus(returnp, FV_ReferencedFilesWerentFound)){
				F_Printf(NULL, (StringT) "%s contains graphic files that could not be found.\n", compName);
			}
			/* check status of FV_UnresolvedTextInsets */
			if(F_ApiCheckStatus(returnp, FV_UnresolvedTextInsets)){
				F_Printf(NULL, (StringT) "%s contains imported text files that could not be found.\n", compName);
			}

			/* deallocate propVals */
			F_ApiDeallocatePropVals(returnp);
			if(compName != NULL)
				F_Free(compName);
			/* get next component in book */
			//compId = F_ApiGetId(bookId, compId, FP_NextComponentInBook);
			
			compId = nextId;
		}
		F_ApiDeallocatePropVals(&script);
		/* bail out when finished */
		F_ApiBailOut();
		break;

		
	case MIF_WASH_BOOK:
		
		/*Ensure backup has been taken(Alert)..Book and book components will be overwritten.*/
		userCancelled=F_ApiAlert((StringT) "IMPORTANT: Ensure that a backup for the fileset has been taken.\n Chapter files in the current book will be overwritten with new FM files.", FF_ALERT_CANCEL_DEFAULT);
		if(userCancelled!=0)
		{
		break;
		}
		/* create open script */
		script = F_ApiGetOpenDefaultParams();
		i = F_ApiGetPropIndex(&script, FS_MakeVisible);
		script.val[i].propVal.u.ival = False;
		i = F_ApiGetPropIndex(&script, FS_RefFileNotFound);
		script.val[i].propVal.u.ival = FV_AllowAllRefFilesUnFindable;
		i = F_ApiGetPropIndex(&script, FS_FileIsOldVersion);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontChangedMetric);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInCatalog);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LanguageNotAvailable);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LockCantBeReset);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_UpdateTextReferences);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UpdateXRefs);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseAutoSaveFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseRecoverFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_AlertUserAboutFailure);
		script.val[i].propVal.u.ival = False;
		i = F_ApiGetPropIndex(&script, FS_BeefyDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FileIsInUse);
		script.val[i].propVal.u.ival = FV_ResetLockAndContinue;
		i = F_ApiGetPropIndex(&script, FS_FileIsStructured);
		script.val[i].propVal.u.ival = FV_OpenViewOnly;
		i = F_ApiGetPropIndex(&script, FS_OpenFileNotWritable);
		script.val[i].propVal.u.ival = FV_DoOK;

		/* get ID of active book */
		bookId = F_ApiGetId(FV_SessionId, FV_SessionId, FP_ActiveBook);
		/* get all components in the active book and open using script */
		compId = F_ApiGetId(FV_SessionId, bookId, FP_FirstComponentInBook);
		while(compId){

			F_ObjHandleT nextId = 0, parentId = 0;
			IntT compType = F_ApiGetInt(bookId, compId, FP_ComponentType);
			StringT compName = NULL;

			if ( FV_BK_FOLDER == compType || FV_BK_GROUP == compType )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_FirstComponentInBookComponent );
			}

			if ( !nextId )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_NextComponentInBook );
			}

			parentId = compId;
			while ( !nextId && (parentId != 0) )
			{
				parentId = F_ApiGetId ( bookId, parentId, FP_BookComponentParent );
				nextId = F_ApiGetId ( bookId, parentId, FP_NextComponentInBook );
			}

			/* get component name */
			compName = F_ApiGetString(bookId, compId, FP_Name);
			/* open the document with the component name */
			if ( compName && !F_StrIsEmpty(compName) )
			{
				docId = F_ApiOpen(compName, &script, &returnp);
				F_Printf(NULL, (StringT) "%s gets opened here.\n", compName);
				//F_Printf(NULL, "FA_errno: %s \n", FA_errno);
			}
			//docId = F_ApiOpen(compName, &script, &returnp);
			
			/* check outcome of open for FV_ReferencedFilesWerentFound */
			if(F_ApiCheckStatus(returnp, FV_ReferencedFilesWerentFound)){
				F_Printf(NULL, (StringT) "%s contains graphic files that could not be found.\n", compName);
			}
			/* check status of FV_UnresolvedTextInsets */
			if(F_ApiCheckStatus(returnp, FV_UnresolvedTextInsets)){
				F_Printf(NULL, (StringT) "%s contains imported text files that could not be found.\n", compName);
			}

			/*Save As MIF file here*/
			if (!F_StrIsEmpty(compName) )
			{
				SaveAsMIF(docId,compName);
			}

			/* deallocate propVals */
			F_ApiDeallocatePropVals(returnp);
			if(compName != NULL)
				F_Free(compName);
			/* get next component in book */
			//compId = F_ApiGetId(bookId, compId, FP_NextComponentInBook);
			compId = nextId;
		}
		F_ApiDeallocatePropVals(&script);
		/* bail out when finished */
		F_ApiBailOut();
		break;

	case SAVE_LEGACY:

		/*Ensure backup has been taken(Alert)..Book and book components will be overwritten.*/
		userCancelled=F_ApiAlert((StringT) "IMPORTANT: Ensure that a backup for the fileset has been taken.\n Chapter files in the current book will be overwritten with new version 9 files.", FF_ALERT_CANCEL_DEFAULT);
		if(userCancelled!=0)
		{
		break;
		}
		/* create open script */
		script = F_ApiGetOpenDefaultParams();
		i = F_ApiGetPropIndex(&script, FS_MakeVisible);
		script.val[i].propVal.u.ival = True;
		i = F_ApiGetPropIndex(&script, FS_RefFileNotFound);
		script.val[i].propVal.u.ival = FV_AllowAllRefFilesUnFindable;
		i = F_ApiGetPropIndex(&script, FS_FileIsOldVersion);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontChangedMetric);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInCatalog);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FontNotFoundInDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LanguageNotAvailable);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_LockCantBeReset);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_UpdateTextReferences);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UpdateXRefs);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseAutoSaveFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_UseRecoverFile);
		script.val[i].propVal.u.ival = FV_DoNo;
		i = F_ApiGetPropIndex(&script, FS_AlertUserAboutFailure);
		script.val[i].propVal.u.ival = False;
		i = F_ApiGetPropIndex(&script, FS_BeefyDoc);
		script.val[i].propVal.u.ival = FV_DoOK;
		i = F_ApiGetPropIndex(&script, FS_FileIsInUse);
		script.val[i].propVal.u.ival = FV_OpenViewOnly;
		i = F_ApiGetPropIndex(&script, FS_FileIsStructured);
		script.val[i].propVal.u.ival = FV_OpenViewOnly;
		i = F_ApiGetPropIndex(&script, FS_OpenFileNotWritable);
		script.val[i].propVal.u.ival = FV_DoOK;

		/* get ID of active book */
		bookId = F_ApiGetId(FV_SessionId, FV_SessionId, FP_ActiveBook);
		/* get all components in the active book and open using script */
		compId = F_ApiGetId(FV_SessionId, bookId, FP_FirstComponentInBook);
		while(compId){

			F_ObjHandleT nextId = 0, parentId = 0;
			IntT compType = F_ApiGetInt(bookId, compId, FP_ComponentType);
			StringT compName = NULL;

			if ( FV_BK_FOLDER == compType || FV_BK_GROUP == compType )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_FirstComponentInBookComponent );
			}

			if ( !nextId )
			{
				nextId = F_ApiGetId ( bookId, compId, FP_NextComponentInBook );
			}

			parentId = compId;
			while ( !nextId && (parentId != 0) )
			{
				parentId = F_ApiGetId ( bookId, parentId, FP_BookComponentParent );
				nextId = F_ApiGetId ( bookId, parentId, FP_NextComponentInBook );
			}

				/* get component name */
				/*if ( FV_BK_FOLDER == compType || FV_BK_GROUP == compType )
				{
					compName = F_ApiGetString(bookId, compId, FP_BookComponentTitle);
				}
				else
				{*/
					compName = F_ApiGetString(bookId, compId, FP_Name);
				

			/* open the document with the component name */
			if ( compName && !F_StrIsEmpty(compName) )
			{
				docId = F_ApiOpen(compName, &script, &returnp);
				F_Printf(NULL, (StringT) "%s gets opened here.\n", compName);
				//F_Printf(NULL, "FA_errno: %s \n", FA_errno);
			}

			/* check outcome of open for FV_ReferencedFilesWerentFound */
			if(F_ApiCheckStatus(returnp, FV_ReferencedFilesWerentFound)){
				F_Printf(NULL, (StringT) "%s contains graphic files that could not be found.\n", compName);
			}
			/* check status of FV_UnresolvedTextInsets */
			if(F_ApiCheckStatus(returnp, FV_UnresolvedTextInsets)){
				F_Printf(NULL, (StringT) "%s contains imported text files that could not be found.\n", compName);
			}

			/*Save As Legacy file here*/
			if(!F_StrIsEmpty(compName))
			{
				SaveAsLegacy(docId,compName);
			}

			/* deallocate propVals */
			F_ApiDeallocatePropVals(returnp);
			if(compName != NULL)
				F_Free(compName);
			/* get next component in book */
			//compId = F_ApiGetId(bookId, compId, FP_NextComponentInBook);
			compId = nextId;
		}
		/* get component name */
		//bookName = F_ApiGetString(0,bookId,FP_Name);
		//SaveAsLegacy(bookId,bookName);
		F_ApiDeallocatePropVals(&script);
		/* bail out when finished */
		F_ApiBailOut();
		break;
	}
}

VoidT SaveAsMIF(F_ObjHandleT compId, StringT compName)
{
	F_PropValsT params, *returnParams = NULL;
	F_ObjHandleT saveId;
	IntT i = 0;
	StringT mifname=0;
	
	F_FdeInit();
	
	/* Gets the active book (bookId) */
	//bookId = F_ApiGetId(FV_SessionId, FV_SessionId, FP_ActiveBook);
	
	/* Sets save parameters */
	params = F_ApiGetSaveDefaultParams();
	i = F_ApiGetPropIndex(&params, FS_FileType);
	params.val[i].propVal.u.ival = FV_SaveFmtInterchange;
	/*i = F_ApiGetPropIndex(&params, FS_SaveAsModeName);
	params.val[i].propVal.u.ival = FV_SaveAsNameAskUser;
	i = F_ApiGetPropIndex(&params, FS_SaveMode);
	params.val[i].propVal.u.ival = FV_ModeSaveAs;*/

	//FA_errno=0;
	/* Saves the book chapter as MIF.*/
	mifname = ReplaceExtensionWith(compName, ".mif");
	saveId = F_ApiSave(compId, mifname, &params, &returnParams);

	F_ApiClose(compId, FF_CLOSE_MODIFIED);

	//***************save the mif file back to fm format********** (NB)
	openMIFsavebackAsFm(saveId,mifname);

	//F_Printf(NULL, "\n Unable to save as MIF. FA_errno is : %d", FA_errno);
	F_ApiDeallocatePropVals(&params);
	F_ApiDeallocatePropVals(returnParams);
}

VoidT SaveAsLegacy(F_ObjHandleT compId, StringT legacyName)
{
	F_PropValsT params, *returnParams = NULL;
	F_ObjHandleT saveId;
	IntT i = 0;
	//StringT legacyName1=0;
	
	F_FdeInit();
	
	/* Gets the active book (bookId) */
	//bookId = F_ApiGetId(FV_SessionId, FV_SessionId, FP_ActiveBook);
	
	/* Sets save parameters */
	params = F_ApiGetSaveDefaultParams();
	i = F_ApiGetPropIndex(&params, FS_FileType);
	params.val[i].propVal.u.ival = FV_SaveFmtBinary90;

	/* Saves the book chapter as MIF.*/

	saveId = F_ApiSave(compId, legacyName, &params, &returnParams);

	F_ApiClose(compId, FF_CLOSE_MODIFIED);

	F_ApiDeallocatePropVals(&params);
	F_ApiDeallocatePropVals(returnParams);
}

VoidT openMIFsavebackAsFm(F_ObjHandleT docId,StringT mifname)
{
	IntT i,j; /* index into property list */
	F_PropValsT script, *returnp = NULL;
	//F_ObjHandleT bookId; /* active book ID */
	F_ObjHandleT saveId; /* book component ID */
	//F_ObjHandleT docId; /*  document ID */
	BoolT userCancel = False;
	StringT fmname=NULL,compName = NULL; /* name of book component */
	F_PropValsT params, *returnParams = NULL;
	

	/* create open script */
	script = F_ApiGetOpenDefaultParams();
	i = F_ApiGetPropIndex(&script, FS_MakeVisible);
	script.val[i].propVal.u.ival = False;
	i = F_ApiGetPropIndex(&script, FS_RefFileNotFound);
	script.val[i].propVal.u.ival = FV_AllowAllRefFilesUnFindable;
	i = F_ApiGetPropIndex(&script, FS_FileIsOldVersion);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_FontChangedMetric);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_FontNotFoundInCatalog);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_FontNotFoundInDoc);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_LanguageNotAvailable);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_LockCantBeReset);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_UpdateTextReferences);
	script.val[i].propVal.u.ival = FV_DoNo;
	i = F_ApiGetPropIndex(&script, FS_UpdateXRefs);
	script.val[i].propVal.u.ival = FV_DoNo;
	i = F_ApiGetPropIndex(&script, FS_UseAutoSaveFile);
	script.val[i].propVal.u.ival = FV_DoNo;
	i = F_ApiGetPropIndex(&script, FS_UseRecoverFile);
	script.val[i].propVal.u.ival = FV_DoNo;
	i = F_ApiGetPropIndex(&script, FS_AlertUserAboutFailure);
	script.val[i].propVal.u.ival = False;
	i = F_ApiGetPropIndex(&script, FS_BeefyDoc);
	script.val[i].propVal.u.ival = FV_DoOK;
	i = F_ApiGetPropIndex(&script, FS_FileIsInUse);
	script.val[i].propVal.u.ival = FV_ResetLockAndContinue;
	i = F_ApiGetPropIndex(&script, FS_FileIsStructured);
	script.val[i].propVal.u.ival = FV_OpenViewOnly;
	i = F_ApiGetPropIndex(&script, FS_OpenFileNotWritable);
	script.val[i].propVal.u.ival = FV_DoOK;
				
	/* get component name */
	//compName = F_ApiGetString(0, docId, FP_Name);

	docId = F_ApiOpen(mifname, &script, &returnp);

	/*-------------SAVE AS FM-----------------*/
	/* Sets save parameters */
	params = F_ApiGetSaveDefaultParams();
	j = F_ApiGetPropIndex(&params, FS_FileType);
	params.val[j].propVal.u.ival = FV_SaveFmtBinary;
	//FA_errno=0;
	/* Saves the book chapter as fm.*/
	fmname = ReplaceExtensionWith(mifname, ".fm");
	saveId = F_ApiSave(docId, fmname, &params, &returnParams);

	F_ApiClose(saveId, FF_CLOSE_MODIFIED);

}


StringT ReplaceExtensionWith(StringT basename, StringT newExt)
{
	StringT dotP = 0;
	IntT extLen = 0;
	StringT newStr = 0;

	if(basename==NULL)
		return NULL;


	if(!newExt)
		newExt = (StringT)"";
	
	dotP = F_StrRChrUTF8(basename, (ConStringT)".");

	if(dotP==NULL)
	{
		//Without extension
		dotP = basename + F_StrLen(basename);
	}

	extLen = F_StrLen(newExt);
	newStr = (StringT)F_Calloc(dotP-basename + extLen+1 + 1, sizeof(UCharT),  NO_DSE); //+1 for '.' 
	if(newStr == NULL)
	{
		/*Out of memory*/
		return NULL;
	}

	memcpy(newStr, basename, dotP-basename);
	memcpy(newStr + (dotP-basename), newExt, extLen);
	*(newStr+(dotP-basename)+extLen+1)='\0';

	return newStr;
}