var Max_Files_To_Show = 8;
var Max_Fav_Files_To_Show = 8;
function CSSChangeStyle(selector, property, value) {
    for (var i=0; i<document.styleSheets.length;i++) {
    	//Loop through all styles, try add rule
        try { 
        	document.styleSheets[i].insertRule(selector+ ' {'+property+':'+value+'}', document.styleSheets[i].cssRules.length);
        } 
        catch(err) {
	        try { 
	        	document.styleSheets[i].addRule(selector, property+':'+value);
	        } 
	        catch(err) {}
        }//IE
    }
}

function ClearListEntries(idAttr) {
	var parentNode = document.getElementById(idAttr);
	var childNodes = parentNode.childNodes;
	var index;

	for (index = childNodes.length - 1; index >= 0; index--) {
		parentNode.removeChild(childNodes[index]);
	}
}

function ClearMarketingContent() {
    ClearListEntries("marketing");
}

function AddMarketingContent(source) {
	var item = document.createElement("iframe");
	item.src = source;
	item.className = "iframemarketing";
	document.getElementById("marketing").appendChild(item);
}

function compareStrings (string1, string2, ignoreCase, useLocale) {
    if (ignoreCase) {
        if (useLocale) {
            string1 = string1.toLocaleLowerCase();
            string2 = string2.toLocaleLowerCase();
        }
        else {
            string1 = string1.toLowerCase();
            string2 = string2.toLowerCase();
        }
    }

    return string1 === string2;
}

function subString (string1, string2, ignoreCase, useLocale) {
    if (ignoreCase) {
        if (useLocale) {
            string1 = string1.toLocaleLowerCase();
            string2 = string2.toLocaleLowerCase();
        }
        else {
            string1 = string1.toLowerCase();
            string2 = string2.toLowerCase();
        }
    }

    return (string1.search(string2) >= 0);
}

function getDitaVersion(file, ditaDefaultVersion) {
	if (file.search("DITA_") >= 0) {
		return file.substring(5,8);
	}
	else if (file.search("DITA") >= 0) {
		return file.substring(4,7);
	}
	else if (subString(file, "Topic", true, true) || 
		subString(file, "Concept", true, true) ||
		subString(file, "Reference", true, true) ||
		subString(file, "Task", true, true) ||
		subString(file, "Map", true, true)) {
		return ditaDefaultVersion;
	}
	return "";
}

function getDitaVersionCSS(version) {
	if (version.localeCompare("1.1") == 0)
		return "1_1";
	else if (version.localeCompare("1.2") == 0)
		return "1_2";
	else if (version.localeCompare("1.3") == 0)
		return "1_3";

	return;
}

function getDitaTopicType(file) {
	if (file.search("DITA_") >= 0 && file.length >= 9) {
		// DITA_1.x_ is the string we need to strip before the file name that we show in Welcome Screen.
		return file.substring(9);
	}

	return file;
}

function AddToMRUXmlList(file, id, ditaDefaultVersion) {
	var welcomeScreenXmlCmd = "http://fm-welcomescreen/?cmd=newxml-";
	var welcomeScreenDitaCmd = "http://fm-welcomescreen/?cmd=newxml-dita-";
	var idAttr = "fmNewXmlRecentList";
	var elemId = idAttr.concat(id);
	var item = document.createElement("a");
	var lowecaseFile = file.toLowerCase();

	var badge = document.createElement("span");

	var version = getDitaVersion(file, ditaDefaultVersion);

	item.id = elemId;
	if (lowecaseFile.search("topic") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitaTopic";
		item.innerHTML = "Topic";
	}
	else if (lowecaseFile.search("concept") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitaConcept";
		item.innerHTML = "Concept";
	}
	else if (lowecaseFile.search("reference") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitaReference";
		item.innerHTML = "Reference";
	}
	else if (lowecaseFile.search("task") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitaTask";
		item.innerHTML = "Task";
	}
	else if (lowecaseFile.search("map") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitamap";
		item.innerHTML = "DitaMap";
	}
	else if (lowecaseFile.search("bookmap") >= 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLDitamap";
		item.innerHTML = "BookMap";
	}
	else if (lowecaseFile.localeCompare("xdocbook") == 0) {
		item.href = welcomeScreenDitaCmd.concat(file);
		item.className = "createTile XMLXDocBook";
		item.innerHTML = "XDocBook";
	}
	else {
		item.href = welcomeScreenXmlCmd.concat(file);
		item.className = "createTile XML";
		item.innerHTML = getDitaTopicType(file);
	}

	if (version) {
		badge.className = "badge DITA-".concat( getDitaVersionCSS(version) );
		badge.innerHTML = "DITA ".concat(version);
	}

	item.title = file;

	item.appendChild(badge);
	document.getElementById(idAttr).appendChild(item);
}

function NoRecentItem(id, string)
{
	var item = document.createElement("div");
	var span = document.createElement("span");

	item.innerHTML = string;
	item.className = "NoRecentText";

	document.getElementById(id).appendChild(item);
}

function NoRecentXmlInList() {
	//NoRecentItem("fmNewXmlRecentList", "No Recent XML Templates");
}

function ClearMRUXmlList() {
	ClearListEntries("fmNewXmlRecentList");
}

function AddToRecentFileList(file, isFavFile) {
    var welcomeScreenCmd = "http://fm-welcomescreen/?cmd=opendocument-";
    var addfavclickcmd = "http://fm-welcomescreen/?cmd=addfav-";
    var removerecentclickcmd = "http://fm-welcomescreen/?cmd=removerecent-";
    var removefavclickcmd = "http://fm-welcomescreen/?cmd=removefav-";
    var divItem = document.createElement("div");
    divItem.setAttribute("class", "FavFileItem");

    var item = document.createElement("a");
    item.setAttribute("class", "filename");
    var spanItem = document.createElement("span");
    var leafname = file.split('\\').pop().split('/').pop();
    var txt = document.createTextNode(leafname);
    item.href = welcomeScreenCmd.concat(file);
    item.setAttribute("title", file);
    item.style.cssText = '';
    item.appendChild(txt);
    item.appendChild(spanItem);
    var recentremoveitem;

    if (isFavFile == "0") {
        recentremoveitem = document.createElement("a");
        recentremoveitem.setAttribute("class", "action");
        recentremoveitem.setAttribute("title", "Remove from Recent Files");
        recentremoveitem.href = removerecentclickcmd.concat(file);
        var recentremoveimg = document.createElement("img");
        recentremoveimg.setAttribute("src", "images/remove.svg");
        recentremoveimg.style.cssText = 'padding-top:0.1em;width:16px;height:16px;';
        recentremoveitem.appendChild(recentremoveimg);
    }

    var favadditem = document.createElement("a");
    favadditem.setAttribute("class", "action");

    var favaddimg = document.createElement("img");
    if (isFavFile == "0") {
        favadditem.href = addfavclickcmd.concat(file);
        favadditem.setAttribute("title", "Add to Favorites");
        favaddimg.setAttribute("src", "images/fav.svg");
    }
    else {
        favadditem.setAttribute("class", "favremoveaction");
        favadditem.href = removefavclickcmd.concat(file);
        favadditem.setAttribute("title", "Remove from Favorites");
        favaddimg.setAttribute("src", "images/addedfav.svg");
    }

    favaddimg.style.cssText = 'width:16px;height:16px;';
    favadditem.appendChild(favaddimg);

    divItem.appendChild(item);
    divItem.appendChild(favadditem);
    if (isFavFile == "0")
        divItem.appendChild(recentremoveitem);

    document.getElementById("fmRecentDocList").appendChild(divItem);

    //FM-2763: Check to make show more element visible
    if (document.getElementById("fmRecentDocList").childElementCount > Max_Files_To_Show) {
        document.getElementById("show-more-button").className = "show-more-visible";
    }
}

function AddToRecentProjectList(file) {
	var welcomeScreenCmd = "http://fm-welcomescreen/?cmd=opendocument-";
	var item = document.createElement("a");
	var spanItem = document.createElement("span");
	var leafname = file.split('\\').pop().split('/').pop();
	var txt = document.createTextNode(leafname);
	item.href = welcomeScreenCmd.concat(file);

	item.setAttribute("title",file);
	item.className = "recentItems";

	item.appendChild(txt);
	item.appendChild(spanItem);
	document.getElementById("fmRecentProjectList").appendChild(item);
	//FM-2763: Check to make show more element visible
	if(document.getElementById("fmRecentProjectList").childElementCount>Max_Files_To_Show){
		document.getElementById("show-more-button-project").className = "show-more-visible";
		}
}

function AddToFavoritesList(file) {
   /* var welcomeScreenCmd = "http://fm-welcomescreen/?cmd=opendocument-";
    var removefavclickcmd = "http://fm-welcomescreen/?cmd=removefav-";
    var divItem = document.createElement("div");
    divItem.setAttribute("class", "FavFileItem");

    var item = document.createElement("a");
	item.setAttribute("class", "filename");
    var spanItem = document.createElement("span");
    var leafname = file.split('\\').pop().split('/').pop();
    var txt = document.createTextNode(leafname);
    item.href = welcomeScreenCmd.concat(file);
    item.setAttribute("title", file);
    item.style.cssText = 'float:left;';
    item.appendChild(txt);
    item.appendChild(spanItem);

    var favremoveitem = document.createElement("a");
	favremoveitem.setAttribute("class", "action");
    favremoveitem.href = removefavclickcmd.concat(file);
    var favremoveimg = document.createElement("img");
    favremoveimg.setAttribute("src", "images/remove.svg");
    favremoveimg.style.cssText = 'float:right;width:16px;height:16px;';
	favremoveitem.setAttribute("title", "Remove from Favorites");
    favremoveitem.appendChild(favremoveimg);

    divItem.appendChild(item);
    divItem.appendChild(favremoveitem);

    document.getElementById("fmFavorites").appendChild(divItem);
    //FM-2763: Check to make show more element visible
    if (document.getElementById("fmFavorites").childElementCount > Max_Fav_Files_To_Show) {
        document.getElementById("show-more-button-favorites").className = "show-more-visible";
    }
	*/
}

function ClearRecentFileList() {
	ClearListEntries("fmRecentDocList");
}

function ClearRecentPROJECTList() {
    ClearListEntries("fmRecentProjectList");
}
function ClearFavoritesList() {
   /* ClearListEntries("fmFavorites"); */
}

function AddToRecentCMSList(cmsTitle) {
	var welcomeScreenCmsCmd = "http://fm-welcomescreen/?cmd=opencmsconnection-";
	var item = document.createElement("a");
	var txt = document.createTextNode(cmsTitle);
	item.href = welcomeScreenCmsCmd.concat(cmsTitle);
	item.className = "recentItems";

	item.appendChild(txt);
	document.getElementById("fmRecentCMSList").appendChild(item);
}

function NoRecentCMSInList() {
	NoRecentItem("fmRecentCMSList", "No Recent Repositories");
}

function NoRecentFilesInList() {
	NoRecentItem("fmRecentDocList", "No Recent Files");
}
function NoRecentProjectsInList() {
	NoRecentItem("fmRecentProjectList", "No Recent Projects");
}
function NoFavoritesInList() {
   /* NoRecentItem("fmFavorites", "No Favorites"); */
}

function ClearRecentCMSList() {
	ClearListEntries("fmRecentCMSList");
}

function AddDitaVersion(version) {
	var ditaStr1 = "(DITA-";
	var ditaStr2 = ")";
	document.getElementById("DITA_Standard").innerHTML = ditaStr1.concat(version).concat(ditaStr2);
}

function HideStructuredSecion() {
	var elemId = document.getElementById("fmStructuredSection");
	elemId.style.display = 'none';
	elemId.style.visibility = 'hidden';

	var structTemplId = document.getElementById("fmStructuredTemplate");
	structTemplId.style.display = 'none';
	structTemplId.style.visibility = 'hidden';	
}
