const scrollOnSingleBtnClick = 50;

function CSSChangeStyle(selector, property, value) {
    for (var i=0; i<document.styleSheets.length;i++) {
    	//Loop through all styles, try add rule
        try { 
        	document.styleSheets[i].insertRule(selector+ ' {'+property+':'+value+'}', document.styleSheets[i].cssRules.length);
        } 
        catch(err) {
	        try { 
	        	document.styleSheets[i].addRule(selector, property+':'+value);
	        } 
	        catch(err) {}
        }//IE
    }
}

function UpdateBreadCrumbs(breadCrumbId, breadCrumbTag)
{
	var breadCrumbs = document.getElementById('breadCrumbs');
	var modules = document.getElementById("modules");
	var container = document.getElementById("container");

    breadCrumbs.innerHTML += ('<li class="breadcrumb-item" id = "' + breadCrumbId + '" onClick="OnClickBreadCrumb(' + breadCrumbId + ')">' + '<a href="http://fm-BreadCrumbs/?cmd=breadcrumb-tag-cmd&id=' + breadCrumbId + '">' + breadCrumbTag + '</a></li>');
	
	if (modules.scrollWidth - container.offsetWidth > 1)
	    modules.scrollLeft = modules.scrollWidth;
	
	UpdateScrollButtonsVisibility();
}

function ClearBreadCrumbs()
{
	var breadCrumbs = document.getElementById('breadCrumbs');
	breadCrumbs.innerHTML = ('');
	HideScrollButtons();
}

function OnClickBreadCrumb(elemId)
{
	//do nothing for now
}

function OnClickLeftScrollBtn(elemId)
{
	var modules = document.getElementById("modules");
	modules.scrollLeft -= scrollOnSingleBtnClick;
}

function OnClickRightScrollBtn(elemId)
{
	var modules = document.getElementById("modules");
	modules.scrollLeft += scrollOnSingleBtnClick;
}

function ShowScrollButtons()
{
	var scrollLeft = document.getElementById("scroll-left");
	var scrollRight = document.getElementById("scroll-right");

	scrollLeft.style.visibility = 'visible';
	scrollRight.style.visibility = 'visible';
}

function HideScrollButtons()
{
	var scrollLeft = document.getElementById("scroll-left");
	var scrollRight = document.getElementById("scroll-right");

	scrollLeft.style.visibility = 'hidden';
	scrollRight.style.visibility = 'hidden';
}

function OnBodyResized()
{
	UpdateScrollButtonsVisibility();
}

function UpdateScrollButtonsVisibility()
{
	var modules = document.getElementById("modules");
	var container = document.getElementById("container");
	
	if (modules.scrollWidth - container.offsetWidth > 1)
		ShowScrollButtons();
	else
		HideScrollButtons();
}