/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// An IDisplayAdapter is an adapter interface to a display surface where
// content is displayed to the user.
// An implementation of this interface could represent e.g. a coachmark or
// a panel
//
function IDisplayAdapter()
{
}

//////////////////////////////////////////////////////////////////////////////
//
// Return the type string of this adapter.
// The type string of a WorkflowDisplay object need to match
//
IDisplayAdapter.prototype.getType = function()
{
    // return unique type string
}

//////////////////////////////////////////////////////////////////////////////
//
// Initialize adapter
//
IDisplayAdapter.prototype.initialize = function(/*Object*/ inParams)
{
}

//////////////////////////////////////////////////////////////////////////////
//
// Terminate adapter
//
IDisplayAdapter.prototype.terminate = function()
{
}

//////////////////////////////////////////////////////////////////////////////
//
// Show display surface
//
IDisplayAdapter.prototype.show = function()
{
    // show display surface
}

//////////////////////////////////////////////////////////////////////////////
//
// Hide display surface
//
IDisplayAdapter.prototype.hide = function()
{
    // hide display surface
}

//////////////////////////////////////////////////////////////////////////////
//
// Set or change content and display if visible
//
IDisplayAdapter.prototype.setContent = function(/*WorkflowContent*/ inContent)
{
    // display content on surface
}

//////////////////////////////////////////////////////////////////////////////
//
// Set or change existing parameters
//
IDisplayAdapter.prototype.setParameters = function(/*Object*/ inParams)
{

}
