/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
//
function CoachmarkContinuationHandler()
{
	var continuation = null;
	var callback = null;

	//////////////////////////////////////////////////////////////////////////////
	//
	//
	this.start = function(/*WorkflowStepContinuation*/ inContinuation, /*Function*/ inCallback)
	{
		continuation = inContinuation;
		callback = inCallback;

		if (Utils.isValidProperty(continuation))
		{
			if (continuation.type == WorkflowStepContinuation.TYPE_MANUALLY)
			{
				// user is supposed to click Next button in coachmark
				//
				ScriptedWorkflowSupport.instance.addEventListener('Coachmark.next', callback);
			}
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	//
	this.stop = function()
	{
		if (Utils.isValidProperty(continuation))
		{
			if (continuation.type == WorkflowStepContinuation.TYPE_MANUALLY)
			{
				// user was supposed to click Next button in coachmark
				//
				ScriptedWorkflowSupport.instance.removeEventListener('Coachmark.next', callback);
			}
		}

		continuation = null;
		callback = null;
	}
}

CoachmarkContinuationHandler.NAME = "tourcoachmark";

// init
ContinuationManager.get().addHandler(CoachmarkContinuationHandler.NAME, new CoachmarkContinuationHandler());