/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// A GuidedtourContentProvider object (based on IContentProvider) provides
// content for a guided tour (following specs of Rush First Mile Experience)
//
function GuidedtourContentProvider()
{
	var table = null;
	var requests = [];
	var loading = false;

	//////////////////////////////////////////////////////////////////////////////
	//
	// Retrieve content for WorkflowContentPart
	//
	this.getContent = function (/*WorkflowContentPart*/ inContentPart, /*Function*/ inCallback)
	{
		var thisObj = 	this;
		var part =		Utils.getParamValue(inContentPart, Utils.REQUIRED);
		var callback =	Utils.getParamValue(inCallback, Utils.REQUIRED);

		// only mime type "text/plain" is supported
		//
		if (part.mimeType == 'text/plain')
		{
			var contentID = MonikerMapper.get().getValue(part.contentID);

			if (Utils.isValidProperty(table))
			{
				var str = '';

				if (Utils.isValidProperty(table[contentID]))
				{
					str = table[contentID];
				}
				else
				{
					logWarn('String not available for content ID: "' + contentID + '"');
					str = contentID;
				}

				logInfo('Provide content, content ID: "' + contentID + '", content: "' + str + '"');
				callback(str);
			}
			else
			{

				requests.push({ part : part, callback : callback});

				if (!loading)
				{
					loadTable(inContentPart.getWorkflowID(), function(/*Boolean*/ inSuccess)
					{
						Utils.forEach(requests, function(/*Object*/ inRequest)
						{
							if (Utils.isValidProperty(table))
							{
								thisObj.getContent(inRequest.part, inRequest.callback)
							}
							else
							{
								logInfo('Provide content, content ID: "' + inRequest.part.contentID + '", content: ""');
								inRequest.callback('');
							}
						});

						requests = [];
					});
				}
			}
		}
		else
		{
			logError('Mime type not suppoerted "' + part.mimeType + '"');
			throw new Error("Unknown mime type");
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Load zstring string table file
	//
	function loadTable(/*String*/ inWorkflowID, /*Function*/ inCallback)
	{
		logInfo('Load string table, workflow ID: "' + inWorkflowID + '"');

		loading = true;

		var callback = inCallback;
		var workflowID = inWorkflowID;
		var locale = ScriptedWorkflowSupport.instance.appLocale;
		var root = ScriptedWorkflowSupport.instance.workflowRoot;

		if (root.lastIndexOf('/') == root.length-1)
		{
			root = root.substr(0, root.length-1);
		}

		// request zstring file from locale folder and as fallback from the content
		// root folder
		var path = root + '/' + inWorkflowID + '/' + locale + '/' + 'stringtable.txt';
		var altPath = root + '/' + inWorkflowID + '/' + 'stringtable.txt';

		try
		{
			DataRequestManager.requestDataAlt([path, altPath], function(/*Boolean*/ inSuccess, /*String*/ inData)
			{
				loading = false;

				if (inSuccess)
				{
					logInfo('Loaded string table, workflow ID: "' + workflowID + '"');

					parse(inData);
					callback(true);
				}
				else
				{
					logError('Can not load stringtable file, path "' + path + '", alt.path "' + altPath + '"');
					callback(false);
				}
			});
		}
		catch (exc)
		{
			logExc(exc);

			loading = false;
			callback(false);
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Parse string table content
	//
	function parse(/*[String]*/ inData)
	{
		logInfo('Parse string table');

		if (Utils.isValidProperty(inData))
		{
			var lines = inData.split('\n');

			Utils.forEach(lines, function(str)
			{
				str = removeQuotes(str);
				var entry = str.split('=');

				if (entry.length > 2)
				{
					var concated = '';

					for (var i=1; i<entry.length; i++)
					{
						concated += entry[i];

						if ((i+1) < entry.length)
						{
							concated += "=";
						}
					}

					entry = [entry[0], concated];
				}

				if (entry.length > 1)
				{
					if (!Utils.isValidProperty(table))
					{
						table = {};
					}

					table[entry[0]] = entry[1];
					table[str] = entry[1];
				}
			});
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Remove leading/trailing double quotes
	//
	function removeQuotes(/*[String]*/ inLine)
	{
		var line = inLine.trim();

		if (line.indexOf('"') == 0 && line.lastIndexOf('"') == line.length-1)
		{
			line = line.substring(1, line.length-1);
		}

		return line;
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Register factory
//
ContentProviderFactory.addFactory('guidedtour', function(){return new GuidedtourContentProvider();});