/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
//
function ScriptExecutor()
{
	//////////////////////////////////////////////////////////////////////////////
	//
	// Execute inEvalStr
	//
	this.execute = function(/*String*/ inEvalSrc, /*Boolean*/ inCondition, /*Function*/ inCallback)
	{
		var res = new ExecutionResult();

		var condition = Utils.getParamValue(inCondition, Utils.OPTIONAL, false);
		var script = replaceSymbols(inEvalSrc);
		script = '(function(){' + (condition ? 'return ' : '') + script + '})();';

		try
		{
			res.result = eval(script);
			res.success = true;
			res.message = '';
		}
		catch(exc)
		{
			res.success = false;
			res.message = exc.toString();

			logError('Exception occured while trying to eval the expression: "' + script + '"');
			logExc(exc);
		}

		if (Utils.isValidProperty(inCallback))
		{
			inCallback(res);
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Replace symbols in script with real code
	//
	function replaceSymbols(/*String*/ inScript)
	{
		function insertStr(/*String*/ inStr, /*String*/ inInsert, /*Number*/ inPos)
		{
			var tmp = inStr.substr(0, inPos);
			tmp += inInsert;
			tmp += inStr.substr(inPos);
			return tmp;
		}

		function escapeX(/*String*/ inStr)
		{
			var str = inStr;

			for (var p=0; p<str.length; p++)
			{
				switch(str.charAt(p))
				{
					case '/':
					case '\\':
					case '[':
					case ']':
					case '{':
					case '}':
					case '!':
					case '$':
					case '%':
					case '&':
					case '?':
					{
						if (p >= 0 && str.charAt(p-1) != '\\')
						{
							str = insertStr(str, '\\', p);
						}
					}
						break;
				}
			}

			return str;
		}

		var script = inScript;

		// ${EVOBJ}$
		//
		var kEnvObj = '${ENV}$';
		var exp = new RegExp(escapeX(kEnvObj), 'g');
		script = script.replace(exp, 'WorkflowEnvironment.current');

		return script;
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Register executor
//
ScriptExecutor.TYPE_SCRIPT = 'script';
ExecutorManager.add(ScriptExecutor.TYPE_SCRIPT, new ScriptExecutor());