/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

// The purpose of the TriggerHandlerFactory is to provide support for
// different types of trigger mechanisms, likely events or timer
// Used in: ScriptEventTriggerHandler

function TriggerHandlerFactory()
{
	var factories = {};

	//////////////////////////////////////////////////////////////////////////////
	//
	// Create handler for trigger type
	//
	this.create = function(/*String*/ inTriggerType)
	{
		var type = Utils.getParamValue(inTriggerType, Utils.REQUIRED);

		Utils.throwInvalid(factories[type]);

		logInfo('Created trigger handler, type: "' + inTriggerType + '"');

		return factories[type]();
	}


	//////////////////////////////////////////////////////////////////////////////
	//
	// Add factory function
	//
	this.addFactory = function(/*String*/ inTriggerType, /*Function*/ inFactory)
	{
		logInfo('Register factory, type: "' + inTriggerType + '"');

		var type    = Utils.getParamValue(inTriggerType, Utils.REQUIRED);
		var factory = Utils.getParamValue(inFactory, Utils.REQUIRED);

		Utils.throwInvalid(type, String);
		Utils.throwInvalid(factory, Function);

		if (!Utils.isValidProperty(factories[type]))
		{
			factories[type] = factory;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
//
//
TriggerHandlerFactory.instance = null;
TriggerHandlerFactory.get = function()
{
	if (!Utils.isValidProperty(TriggerHandlerFactory.instance))
	{
		TriggerHandlerFactory.instance = new TriggerHandlerFactory();
	}

	return TriggerHandlerFactory.instance;
}

//////////////////////////////////////////////////////////////////////////////
//
// Create handler for trigger type
//
TriggerHandlerFactory.create = function(/*String*/ inTriggerType)
{
	return TriggerHandlerFactory.get().create(inTriggerType);
}

//////////////////////////////////////////////////////////////////////////////
//
// Add factory function
//
TriggerHandlerFactory.addFactory = function(/*String*/ inTriggerType, /*Function*/ inFactory)
{
	try
	{
		TriggerHandlerFactory.get().addFactory(inTriggerType, inFactory);
	}
	catch(exc)
	{
		logExc(exc);
	}
}
