/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

// The purpose of the ContentProviderFactory is to provide support for
// different types of media, i.e. strings
// but also: GuidedtourContentProvider

function ContentProviderFactory()
{
	var factories = {};

	//////////////////////////////////////////////////////////////////////////////
	//
	// Create content provider for type
	//
	this.create = function(/*String*/ inContentProviderType)
	{
		var type = Utils.getParamValue(inContentProviderType, Utils.REQUIRED);

		Utils.throwInvalid(factories[type]);

		return factories[type]();
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return Array of available content provider type names
	//
	this.getTypes = function()
	{
		var types = [];

		for (var type in factories)
		{
			types.push(type);
		}

		return types;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Add factory function
	//
	this.addFactory = function(/*String*/ inContentProviderType, /*Function*/ inFactory)
	{
		logInfo('Register factory, type: "' + inContentProviderType + '"');

		var type    = Utils.getParamValue(inContentProviderType, Utils.REQUIRED);
		var factory = Utils.getParamValue(inFactory, Utils.REQUIRED);

		Utils.throwInvalid(type, String);
		Utils.throwInvalid(factory, Function);

		if (!Utils.isValidProperty(factories[type]))
		{
			factories[type] = factory;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
//
//
ContentProviderFactory.instance = null;
ContentProviderFactory.get = function()
{
	if (!Utils.isValidProperty(ContentProviderFactory.instance))
	{
		ContentProviderFactory.instance = new ContentProviderFactory();
	}

	return ContentProviderFactory.instance;
}

//////////////////////////////////////////////////////////////////////////////
//
// Create content provider for type
//
ContentProviderFactory.create = function(/*String*/ inContentProviderType)
{
	return ContentProviderFactory.get().create(inContentProviderType);
}

//////////////////////////////////////////////////////////////////////////////
//
// Return Array of available content provider type names
//
ContentProviderFactory.getTypes = function()
{
	return ContentProviderFactory.get().getTypes();
}

//////////////////////////////////////////////////////////////////////////////
//
// Add factory function
//
ContentProviderFactory.addFactory = function(/*String*/ inContentProviderType, /*Function*/ inFactory)
{
	try
	{
		ContentProviderFactory.get().addFactory(inContentProviderType, inFactory);
	}
	catch(exc)
	{
		logExc(exc);
	}
}
