/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2018 Adobe                                               */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE: All information contained herein is, and remains            */
/* the property of Adobe and its suppliers, if any. The intellectual   */
/* and technical concepts contained herein are proprietary to Adobe    */
/* and its suppliers and are protected by all applicable intellectual  */
/* property laws, including trade secret and copyright laws.           */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe.                                                         */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// The StartupController is supposed to take care that everything what's
// required is loaded and initialized before a workflow processing is initiated
//
function StartupController()
{
	var initializedItems = {};
	var tasks = [];

	//////////////////////////////////////////////////////////////////////////////
	//
	// Startup item is supposed to call this as soon as it is initialized
	// and available
	//
	this.setInitialized = function(/*String*/ inItem)
	{
		if (Utils.isValidProperty(initializedItems[inItem]))
		{
			logWarning('Initialized multiple times: ' + inItem);
		}
		else
		{
			logInfo('Item initialized: ' + inItem);
			initializedItems[inItem] = true;
		}

		if (this.isInitialized())
		{
			// all startup items are initialized, call registered
			// callbacks
			//
			Utils.forEach(tasks, function(/*Function*/ inTask)
			{
				inTask();
			});

			tasks = [];
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Returns true as soon as all startup items are initialized
	//
	this.isInitialized = function()
	{
		var ret = true;

		Utils.forEach(StartupController.startupItems, function(/*String*/ inItem)
		{
			ret = ret && Utils.isValidProperty(initializedItems[inItem])
		});

		return ret;
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Register call which is called as soon as all startup items are initialized
	//
	this.registerTask = function(/*Function*/ inCallback)
	{
		tasks.push(inCallback);
	}
}

StartupController.ITEM_EVENTTYPES 			= 'eventtypes';				// load & init of all available script event types
StartupController.ITEM_MONIKER 				= 'moniker';				// load & init of moniker table
StartupController.ITEM_TRIGGER_COMPONENTS	= 'triggercomponents';		// load & init of global trigger components

//////////////////////////////////////////////////////////////////////////////
//
StartupController.startupItems = [];
StartupController.instance = null;

//////////////////////////////////////////////////////////////////////////////
//
//
StartupController.get = function()
{
	if (!Utils.isValidProperty(StartupController.instance))
	{
		StartupController.instance = new StartupController();
	}

	return StartupController.instance;
}

//////////////////////////////////////////////////////////////////////////////
//
// Add a startup item
//
//	Very early on during startup some elements need to be present, so they register from global space.
//	One can verify with isInitialized whether all are ready and/or use registerTask to get notified when done.
//	Each element calls setInitialized(inItem) to make it ready.
//	This is barely debuggable, because we load all scripts sequencially and immediately create globals.
//
StartupController.addItem = function(/*String*/ inItem)
{
	StartupController.startupItems.push(inItem);
}
