(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[0],{

/***/ "hUbq":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(React) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PickerModeClose", function() { return PickerModeClose; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "innerPanelID", function() { return innerPanelID; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "panelID", function() { return panelID; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UAPController; });
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("i8i4");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_parsePickerInfo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("v5Ri");
/* harmony import */ var _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("jsAP");
/* harmony import */ var _CDOWrapper_CDOImsDataBuilder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("K0Sv");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("EcEN");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var src_js_start_stores_MainStore__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("cCFZ");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("3UBC");
/* harmony import */ var _LoggerWrapper_Logger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("43WE");
/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/









const PickerModeClose = 'closePicker';
const innerPanelID = 'ccx-document-picker-inner-panel';
const panelID = 'ccx-document-picker-panel';
class UAPController {
    constructor() {
        this._logger = _LoggerWrapper_Logger__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"].get('UAPController');
        this.uapModeMap = {
            onShowPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].open,
            showPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].open,
            openDocumentPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].open,
            saveAsDocumentPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].saveAs,
            linkAssetsPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].linkAssets,
            relinkAssetsPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].relink,
            placePicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].place,
            placeLinkOrEmbedPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].placeLinkOrEmbed,
            saveAsCopyDocumentPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].saveAsCopy,
            multiInstancelinkAssetsPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].linkAssets,
            multiInstanceSaveAsDocumentPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].saveAs,
            multiInstanceImportDocumentPicker: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].import
        };
        this.closePickerModeMap = {
            hidePicker: PickerModeClose,
            onClosePicker: PickerModeClose,
            closeMultiInstanceDocPicker: PickerModeClose,
            closeSaveAsDocumentPicker: PickerModeClose,
            closeMultiInstanceImportDocumentPicker: PickerModeClose
        };
    }
    showUapModal(commandId, event, CDOProductData, fetchCDOToken, user) {
        let dialogElement;
        let lastPickerState;
        // For XD, onShowPicker is the panel-id for the event node.
        // 'onShowPicker' is basically required by XD to show the Open Picker
        // Dialog (Cmd + O) and was historically handled through Panel.tsx
        // (Panel Commands) in the UAP codebase. The lifecycle of a Panel based
        // picker in UXP is handled using the 'uxpshowpanel' & 'uxphidepanel'
        // events and not 'uxpcommand' which is predominantly used for other
        // modes here. It must be noted that the Open Picker is hosted in its
        // own separate window while the Save-As picker which is shown in the
        // document window as stationary modal is added to the document body.
        if (commandId === 'onShowPicker') {
            dialogElement = document.getElementById(innerPanelID);
            if (!dialogElement) {
                dialogElement = document.createElement('div');
                dialogElement.style.height = '100%';
                dialogElement.style.width = '100%';
                dialogElement.id = innerPanelID;
                event.node.style.height = '100%';
                event.node.style.width = '100%';
                event.node.id = panelID;
            }
            event.node.appendChild(dialogElement);
        }
        else {
            dialogElement = document.createElement('dialog');
            // this is to give it a size.  Clients should define the size
            // in their own CSS.
            dialogElement.id = 'ccx-document-picker';
            dialogElement.className = 'ccx-document-picker-multi-instance';
            document.body.appendChild(dialogElement);
            const onClose = () => {
                dialogElement.remove();
            };
            dialogElement.addEventListener('close', onClose);
        }
        const mode = this.getMode(commandId);
        this.closeUAPDialog = () => {
            if (___WEBPACK_IMPORTED_MODULE_6__[/* default */ "a"].shouldCloseUAPDialog(lastPickerState)) {
                dialogElement.parentNode.removeChild(dialogElement);
            }
        };
        const UXPData = event === null || event === void 0 ? void 0 : event.data;
        const UXPWindowController = UXPData === null || UXPData === void 0 ? void 0 : UXPData.windowController;
        if (UXPData && UXPWindowController) {
            if (commandId === 'onShowPicker') {
                event.node.windowController = UXPWindowController;
            }
            else {
                dialogElement.windowController = UXPWindowController;
                dialogElement.wcId = UXPWindowController.id();
            }
        }
        let pickerInfo;
        if (window.cdoHost.getPickerInfo) {
            pickerInfo = Object(_util_parsePickerInfo__WEBPACK_IMPORTED_MODULE_1__[/* parsePickerInfo */ "b"])(window.cdoHost.getPickerInfo(mode));
            pickerInfo.mode = mode; // in case the host didnt send it back...
        }
        pickerInfo = { ...pickerInfo, ...UXPData };
        if (!pickerInfo.featureFlags) {
            pickerInfo.featureFlags = {};
        }
        pickerInfo.featureFlags = { ...pickerInfo.featureFlags, ..._util_parsePickerInfo__WEBPACK_IMPORTED_MODULE_1__[/* UapFeatureFlags */ "a"] };
        const hostApp = window.cdoHost;
        const callbacks = {
            onFeatureEnabled: (featureFlag) => hostApp === null || hostApp === void 0 ? void 0 : hostApp.featureEnabled(featureFlag),
            onGetLocalRecents: async () => hostApp === null || hostApp === void 0 ? void 0 : hostApp.getLocalRecents(),
            onGetPreviewRendition: async (path) => {
                const renditionData = await (hostApp === null || hostApp === void 0 ? void 0 : hostApp.getUxpPreviewRendition(path));
                return Promise.resolve(renditionData);
            },
            getTheme: async () => {
                if (hostApp === null || hostApp === void 0 ? void 0 : hostApp.getTheme) {
                    return Object(_CDOWrapper_CDOImsDataBuilder__WEBPACK_IMPORTED_MODULE_3__[/* getSupportedCDOTheme */ "b"])(await (hostApp === null || hostApp === void 0 ? void 0 : hostApp.getTheme()));
                }
                else {
                    return Object(_CDOWrapper_CDOImsDataBuilder__WEBPACK_IMPORTED_MODULE_3__[/* getSupportedCDOTheme */ "b"])(CDOProductData.theme);
                }
            }
        };
        callbacks.onPlaceLinkOrEmbedDocuments = (docInfoArray, isLink) => {
            var _a;
            (_a = hostApp === null || hostApp === void 0 ? void 0 : hostApp.placeLinkOrEmbedDocuments) === null || _a === void 0 ? void 0 : _a.call(hostApp, docInfoArray, isLink);
            this.closeUAPDialog();
        };
        callbacks.onImportPlaceDocuments = (docInfoArray) => {
            var _a;
            const { windowController } = pickerInfo;
            if (windowController) {
                (_a = hostApp === null || hostApp === void 0 ? void 0 : hostApp.importDocuments) === null || _a === void 0 ? void 0 : _a.call(hostApp, docInfoArray, windowController);
                this.closeUAPDialog();
            }
        };
        const executePickerAction = (action, windowController) => {
            lastPickerState = action;
            hostApp === null || hostApp === void 0 ? void 0 : hostApp.executePickerAction(action, windowController);
        };
        const openDocuments = (docInfoArray) => {
            hostApp === null || hostApp === void 0 ? void 0 : hostApp.openDocuments(docInfoArray);
        };
        const placeDocuments = (docInfoArray) => {
            hostApp === null || hostApp === void 0 ? void 0 : hostApp.placeDocuments(docInfoArray);
        };
        const addExternalCancelListener = (callback) => {
            dialogElement.addEventListener('cancel', callback);
        };
        const removeExternalCancelListener = (callback) => {
            dialogElement.removeEventListener('cancel', callback);
        };
        // fix for CCXCD-10653
        // Note: this changes the CDOProductData provided by the host. For all apps this object is created again every time,
        // but in XD this is reused. If we ever enable the Place flow in XD, this might cause issues in other picker modes
        if (mode === _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["PickerMode"].placeLinkOrEmbed && pickerInfo.documentFilterOverride) {
            CDOProductData.documentFilter = pickerInfo.documentFilterOverride;
            pickerInfo.documentFilterOverride = undefined;
        }
        // Instantiate the asset picker
        const uap = React.createElement(_ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["UAP"], { openedSessionGuid: uuid__WEBPACK_IMPORTED_MODULE_4___default.a.v1(), pickerInfo: pickerInfo, addExternalCancelListener: addExternalCancelListener, removeExternalCancelListener: removeExternalCancelListener, executePickerAction: executePickerAction, placeDocuments: placeDocuments, openDocuments: openDocuments, closeDialog: this.closeUAPDialog, callbacks: callbacks, cdoHostProductData: CDOProductData, cdoIMSData: Object(_CDOWrapper_CDOImsDataBuilder__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"])(user, fetchCDOToken), theme: src_js_start_stores_MainStore__WEBPACK_IMPORTED_MODULE_5__["mainStore"].colorTheme });
        react_dom__WEBPACK_IMPORTED_MODULE_0___default.a.render(uap, dialogElement);
        const options = {
            resize: 'both',
            minSize: {
                width: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["UXP_MIN_DIALOG_WIDTH"],
                height: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["UXP_MIN_DIALOG_HEIGHT"]
            },
            size: {
                width: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["UXP_INITIAL_DIALOG_WIDTH"],
                height: _ccx_ccx_document_picker__WEBPACK_IMPORTED_MODULE_2__["UXP_INITIAL_DIALOG_HEIGHT"]
            }
        };
        dialogElement.uxpShowModal(options).then(result => {
            this._logger.info("showUapModal : Dialog resolved.");
        })
            .catch(error => {
            this._logger.info("showUapModal: Dialog caught error.", error);
        });
        return true;
    }
    closeUapModal(mode, event) {
        var _a, _b, _c;
        if (mode === 'onClosePicker') {
            const dialogElement = document.getElementById(panelID);
            if (dialogElement) {
                const cancelEvent = document.createEvent("Event");
                cancelEvent.initEvent('cancel', true, true);
                cancelEvent.eventName = 'cancel';
                dialogElement.dispatchEvent(cancelEvent);
            }
            (_a = event.node.firstChild) === null || _a === void 0 ? void 0 : _a.remove();
        }
        else if (mode === 'hidePicker') {
            (_b = this.closeUAPDialog) === null || _b === void 0 ? void 0 : _b.call(this);
        }
        else {
            const UXPData = event === null || event === void 0 ? void 0 : event.data;
            const UXPWindowController = UXPData === null || UXPData === void 0 ? void 0 : UXPData.windowController;
            const dialogElements = document.querySelectorAll('.ccx-document-picker-multi-instance');
            for (let i = 0; i < dialogElements.length; i += 1) {
                const dialogElement = dialogElements[i];
                if (UXPWindowController && (dialogElement.wcId === UXPWindowController.id())) {
                    (_c = dialogElement === null || dialogElement === void 0 ? void 0 : dialogElement.close) === null || _c === void 0 ? void 0 : _c.call(dialogElement);
                }
            }
        }
    }
    getMode(commandId) {
        return this.uapModeMap[commandId] || this.closePickerModeMap[commandId];
    }
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("q1tI")))

/***/ }),

/***/ "v5Ri":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return parsePickerInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UapFeatureFlags; });
/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
// this will be exported some day. https://jira.corp.adobe.com/browse/CCXCD-9198
//import { IPickerInfo } from '@ccx/ccx-document-picker';
/**
 * hostApps using C++ send values in strings so we have
 * to convert some strings to other types.
 * @returns {IPickerInfo}
 */
function parsePickerInfo(input) {
    const toBool = (setting) => (typeof setting === 'string' ? (setting === 'true') : setting);
    const toArray = (setting) => {
        if (typeof setting !== 'string') {
            return setting;
        }
        if (setting.startsWith('[')) {
            /**
             * JSON array
             * ie "[{ \"label\": \"PSDC\", \"extension\": \"psdc\", \"mimeType\": \"PSDC\" }]"
             */
            return JSON.parse(setting);
        }
        /**
         * Comma-delimited string
         * ie "document/vnd.adobe.cpsd+dcx,document/vnd.adobe.illustrator+dcx"
         *
         * Can't include [, if brackets are needed/expected a JSON array can be provided instead
         */
        return setting.split(',');
    };
    const parsed = {
        ...input,
        showInterstitial: toBool(input.showInterstitial),
        disableCancelButton: toBool(input.disableCancelButton),
        hideYourComputerButton: toBool(input.hideYourComputerButton),
        documentFilterOverride: toArray(input.documentFilterOverride),
        enabledTypes: toArray(input.enabledTypes),
        compatibleTypes: toArray(input.compatibleTypes),
        outputFileFormatChoices: toArray(input.outputFileFormatChoices),
        spacesOutputFileFormatChoices: toArray(input.spacesOutputFileFormatChoices)
    };
    return parsed;
}
/*
    Feature flags imported from UAP
*/
const UapFeatureFlags = {
    disableACPL: false,
    disableCloudDocPrefetch: true,
    importDisableCloudDocumentsTab: (_a = window.cdoHost) === null || _a === void 0 ? void 0 : _a.featureEnabled('importDisableCloudDocumentsTab'),
    disableRecentsTab: (_b = window.cdoHost) === null || _b === void 0 ? void 0 : _b.featureEnabled('disableRecentsTab'),
    disableSharedWithYouTab: (_c = window.cdoHost) === null || _c === void 0 ? void 0 : _c.featureEnabled('disableSharedWithYouTab'),
    hideCloudStatusIcon: (_d = window.cdoHost) === null || _d === void 0 ? void 0 : _d.featureEnabled('hideCloudStatusIcon'),
    enableCDPOnboarding: (_e = window.cdoHost) === null || _e === void 0 ? void 0 : _e.featureEnabled('CloudDocCDPOnboarding'),
    enableCloudDocExport: (_f = window.cdoHost) === null || _f === void 0 ? void 0 : _f.featureEnabled('CloudDocExport'),
    enablePlaceEmbedWarningToast: (_g = window.cdoHost) === null || _g === void 0 ? void 0 : _g.featureEnabled('enablePlaceEmbedWarningToast'),
    enablePlaceLinkWarningToast: (_h = window.cdoHost) === null || _h === void 0 ? void 0 : _h.featureEnabled('enablePlaceLinkWarningToast'),
    useCDPDeletedTab: (_j = window.cdoHost) === null || _j === void 0 ? void 0 : _j.featureEnabled('CloudDocUseCDPDeletedTab'),
    useOrganizerMode: (_k = window.cdoHost) === null || _k === void 0 ? void 0 : _k.featureEnabled('CloudDocOrganizerDemo'),
    hideLinkCheckbox: (_l = window.cdoHost) === null || _l === void 0 ? void 0 : _l.featureEnabled('hideLinkCheckbox'),
    enableRenditionUrl: (_m = window.cdoHost) === null || _m === void 0 ? void 0 : _m.featureEnabled('enableRenditionUrl'),
    hideOnboardingInviteToEditRow: (_o = window.cdoHost) === null || _o === void 0 ? void 0 : _o.featureEnabled('hideOnboardingInviteToEditRow'),
};


/***/ })

}]);