/// <reference types="node" />
import { EventEmitter } from "events";
import { RequestInit } from "node-fetch";
import { Response } from "node-fetch";
interface FetchRequestInit extends RequestInit {
    parallel?: {
        minimumPartialSize?: number;
        maxSockets?: number;
        maxLatency?: number;
        maxLatencyRetries?: number;
        exitOnLatency?: boolean;
    };
    timeout?: number;
}
interface FetchResponse extends Response {
    file(path: string): Promise<void>;
    emitter: EventEmitter;
}
export interface PartialMutableRange {
    start: number;
    end: number;
}
export interface PartialRange {
    readonly start: number;
    readonly end: number;
}
export { FetchRequestInit as RequestInit };
export { FetchResponse as Response };
