(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["photos"],{

/***/ "ylat":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__("q1tI");

// EXTERNAL MODULE: ./node_modules/mobx/lib/mobx.module.js
var mobx_module = __webpack_require__("2vnA");

// EXTERNAL MODULE: ./node_modules/mobx-react/index.module.js
var index_module = __webpack_require__("okNM");

// EXTERNAL MODULE: ./src/js/start/stores/MainStore.tsx + 3 modules
var MainStore = __webpack_require__("cCFZ");

// EXTERNAL MODULE: ./src/applications/index.tsx + 7 modules
var applications = __webpack_require__("3UBC");

// EXTERNAL MODULE: ./src/js/iaw/platform.tsx
var platform = __webpack_require__("lKWN");

// EXTERNAL MODULE: ./src/js/iaw/analytics.tsx
var analytics = __webpack_require__("RGcl");

// EXTERNAL MODULE: ./src/js/iaw/imsBridge.tsx + 1 modules
var imsBridge = __webpack_require__("Mqyo");

// EXTERNAL MODULE: ./src/components-start/constants.tsx
var constants = __webpack_require__("/0Ih");

// EXTERNAL MODULE: ./src/js/start/stores/UserStore.tsx
var UserStore = __webpack_require__("VExq");

// EXTERNAL MODULE: ./src/throttle.ts
var throttle = __webpack_require__("QBtN");

// EXTERNAL MODULE: ./src/LoggerWrapper/Logger.tsx
var Logger = __webpack_require__("43WE");

// EXTERNAL MODULE: ./src/js/iaw/VulcanAPI.ts
var VulcanAPI = __webpack_require__("9PyL");

// EXTERNAL MODULE: ./src/components/CCPhotos/LrApp.ts
var LrApp = __webpack_require__("Pstv");

// EXTERNAL MODULE: ./src/components/helpers/DisposerManager.ts
var DisposerManager = __webpack_require__("JdbT");

// CONCATENATED MODULE: ./src/components/CCPhotos/LrImporterPanel.ts
/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};













const pluginManager = window.require('uxp').pluginManager;
class LrImporterPanel_LrImporterPanel {
    constructor() {
        this._disposerManager = new DisposerManager["a" /* default */]();
        this._logger = Logger["a" /* default */].get('LrImporterPanel');
        this.triggerRefresh = Object(throttle["a" /* default */])((forceRefresh = false) => {
            var _a;
            // Refresh if the user is signed in
            if (forceRefresh ||
                (MainStore["mainStore"].user.state !== UserStore["e" /* UserState */].SIGNED_IN && MainStore["mainStore"].user.state !== UserStore["e" /* UserState */].USER_CHANGED)) {
                (_a = this.lrApp) === null || _a === void 0 ? void 0 : _a.globalObject.triggerRefresh();
            }
        }, 100);
        this.handleRequestAccessToken = async () => {
            if (MainStore["mainStore"].user.state === UserStore["e" /* UserState */].SIGNED_OUT || MainStore["mainStore"].user.state === UserStore["e" /* UserState */].NO_USER) {
                return null;
            }
            await Object(mobx_module["I" /* when */])(() => !!MainStore["mainStore"].user.accessToken);
            this._imsData = {
                environment: MainStore["mainStore"].user.isStaging ? 'stage' : 'prod',
                subscriptionType: MainStore["mainStore"].user.subscriptionStatus,
                fetchToken: () => {
                    return MainStore["mainStore"].user.accessToken;
                },
                fetchUserId: () => MainStore["mainStore"].user.UserProfile.userId,
            };
            return this._imsData.fetchToken();
        };
        this.handleOpenLink = url => {
            analytics["a" /* default */].logClickedEvent('lightroom-view', {
                subtype: 'open',
                action: url,
            });
            platform["a" /* default */].openDefaultBrowser(url, Object(imsBridge["d" /* jumpKeyForAdobeAccount */])());
        };
        this.handleReportEvent = (eventName, data) => {
            switch (eventName) {
                case 'initialize-lr-organizer':
                    analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                        eventType: 'initialize',
                    });
                    break;
                case 'initialize-lr-organizer-failed':
                    analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                        eventType: 'error',
                        errorDesc: `Message: ${data.message}, Stack: ${data.stack}`.slice(0, 1024),
                    });
                    break;
                case 'rendered-lr-organizer':
                    analytics["a" /* default */].logRenderedEvent('lightroom-organizer');
                    // this.handleEscapeKey();
                    break;
                case 'clicked-asset':
                    analytics["a" /* default */].logClickedEvent('lightroom-view', {
                        subtype: 'select',
                        content: {
                            id: data.assetId,
                            extension: data.extension,
                            mimetype: data.contentType,
                            category: 'image',
                        },
                    });
                    break;
                case 'clicked-import':
                    analytics["a" /* default */].logClickedEvent('lightroom-view', {
                        subtype: 'import',
                        count: data.count,
                    });
                    break;
                case 'clicked-cancel-download':
                    analytics["a" /* default */].logClickedEvent('lightroom-view', {
                        subtype: 'cancel-download',
                        count: data.count,
                    });
                    break;
                case 'clicked-refresh':
                    analytics["a" /* default */].logClickedEvent('lightroom-view', {
                        subtype: 'refresh',
                    });
                    break;
                case 'download-failed':
                    analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                        eventType: 'error',
                        subtype: 'download',
                        errorDesc: data.error,
                        content: {
                            id: data.assetId,
                            extension: data.extension,
                            mimetype: data.contentType,
                            original_file_size: data.originalFileSize,
                            category: 'image',
                        },
                    });
                    break;
            }
        };
        this.handleImportCompleted = async (files, smartObject) => {
            const paths = files
                .filter(file => !file.xmpString)
                .map(({ assetId, extension, contentType, path }) => {
                analytics["a" /* default */].logClickedEvent('lightroom-view', {
                    subtype: 'open',
                    content: {
                        id: assetId,
                        extension,
                        mimetype: contentType,
                        category: 'image',
                    },
                });
                return {
                    _path: path,
                    _kind: 'local',
                };
            });
            const multiplePromise = new Promise(async (resolve, reject) => {
                try {
                    // IAW-9797 - template: false is needed for opening a photo as smart object
                    // however, this change would break the importer for PS with version below 23.2.0
                    let supportSmartObject = false;
                    try {
                        const splitVersion = applications["a" /* default */].version.split('.').map(Number);
                        supportSmartObject = splitVersion[0] > 23 || (splitVersion[0] === 23 && splitVersion[1] >= 2);
                    }
                    catch (error) {
                        this._logger.error(`Could not check PS ${applications["a" /* default */].version} version: ${error}`);
                    }
                    const results = await applications["a" /* default */].openMultipleLocalDocuments({
                        paths,
                        skipMRU: true,
                        smartObject,
                        runWithPriority: true,
                        template: !supportSmartObject,
                        ...(supportSmartObject && {
                            fileOpenContext: {
                                _enum: 'fileOpenContext',
                                _value: 'fileOpenContextHomeScreenLRImport',
                            },
                        }),
                    });
                    if (!results || !results.length) {
                        throw 'No result from Photoshop';
                    }
                    files
                        .filter(file => !file.xmpString)
                        .forEach(({ assetId, extension, contentType, filename }) => {
                        const resultIndex = results.findIndex(result => result.null._path.includes(filename));
                        if (resultIndex >= 0) {
                            // Remove the file extension from the title as
                            // it is determined after the user save the file.
                            const newTitle = filename.replace(/\.\w+$/, '');
                            const resultID = results[resultIndex].documentID;
                            // Change the default title of a template document from "Untitled-X" to the actual file name.
                            applications["a" /* default */].releaseFileReference(newTitle, resultID);
                            // this log event happens when the files open in app,
                            // so HS is no longer visible - we force `logRenderedEvent` to still log this even if HS is not visible
                            analytics["a" /* default */].logRenderedEvent('lightroom-edit', {
                                id: resultID,
                                extension: extension,
                                mimetype: contentType,
                                category: 'image',
                            }, { forceLogEventIfHomeScreenHidden: true });
                        }
                        else {
                            analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                                eventType: 'error',
                                subtype: 'open',
                                errorDesc: 'Failed to open photo',
                                content: {
                                    id: assetId,
                                    extension: extension,
                                    mimetype: contentType,
                                    category: 'image',
                                    open_with_xmp: false,
                                },
                            });
                            // Malformed file content or user cancelled the action (Camera Raw)
                            this._logger.log('Unable to open photo', {
                                filename: filename,
                                extension: extension,
                                mimetype: contentType,
                            });
                        }
                    });
                    resolve();
                }
                catch (err) {
                    this._logger.error(`Unable to open photos: ${err}`, {
                        files,
                    });
                    analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                        eventType: 'error',
                        subtype: 'open',
                        errorDesc: 'Failed to open photos',
                        content: {
                            category: 'image',
                            open_with_xmp: false,
                        },
                    });
                    reject();
                }
            });
            const multiplePromiseWithXMP = new Promise(async (resolve, reject) => {
                try {
                    files
                        .filter(file => file.xmpString)
                        .map(async ({ path, filename, xmpString, adobeUserOrientation, assetId, extension, contentType, localXMP, }) => {
                        try {
                            analytics["a" /* default */].logClickedEvent('lightroom-view', {
                                subtype: 'open',
                                content: {
                                    id: assetId,
                                    extension,
                                    mimetype: contentType,
                                    category: 'image',
                                },
                            });
                            let status = null;
                            this._logger.log('Open file with ACR settings');
                            status = await applications["a" /* default */].openPathWithXMP(path, filename, xmpString, adobeUserOrientation, smartObject, true, localXMP);
                            if (!status) {
                                analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                                    eventType: 'error',
                                    subtype: 'open',
                                    errorDesc: 'Failed to open photo',
                                    content: {
                                        id: assetId,
                                        extension,
                                        mimetype: contentType,
                                        category: 'image',
                                        open_with_xmp: Boolean(xmpString),
                                    },
                                });
                                // Malformed file content or user cancelled the action (Camera Raw)
                                this._logger.log('Unable to open photo', {
                                    path,
                                    xmpString,
                                    adobeUserOrientation,
                                });
                            }
                            else {
                                // Remove the file extension from the title as
                                // it is determined after the user save the file.
                                const newTitle = filename.replace(/\.\w+$/, '');
                                // Change the default title of a template document from "Untitled-X" to the actual file name.
                                applications["a" /* default */].releaseFileReference(newTitle, status.documentID);
                                analytics["a" /* default */].logRenderedEvent('lightroom-edit', {
                                    id: assetId,
                                    extension,
                                    mimetype: contentType,
                                    category: 'image',
                                });
                            }
                        }
                        catch (err) {
                            this._logger.error(`Unable to open photo: ${err}`, {
                                path,
                                xmpString,
                                adobeUserOrientation,
                            });
                        }
                    });
                    resolve();
                }
                catch (err) {
                    this._logger.error(`Unable to open XMP photos: ${err}`, {
                        files,
                    });
                    analytics["a" /* default */].logMiscellaneousEvent('lightroom', {
                        eventType: 'error',
                        subtype: 'open',
                        errorDesc: 'Failed to open XMP photos',
                        content: {
                            category: 'image',
                            open_with_xmp: true,
                        },
                    });
                    reject();
                }
            });
            await Promise.all([multiplePromise, multiplePromiseWithXMP]);
        };
        this._globalProps = {
            colorStop: this.colorStop,
            clientId: 'CCXInAppWelcomeUXP3',
            lrSDKConfig: {
                get token() {
                    return MainStore["mainStore"].user.accessToken;
                },
                clientId: constants["k" /* default */].LIGHTROOM_CLIENT_ID,
                environment: MainStore["mainStore"].user.isStaging ? 'stage' : 'prod',
                ozHost: MainStore["mainStore"].user.isStaging ? 'https://photos-stage.adobe.io/' : 'https://photos.adobe.io',
                hostOverride: MainStore["mainStore"].user.isStaging ? 'https://photos-stage.adobe.io/' : 'https://photos.adobe.io',
                disableAnalytics: true,
            },
            requestAccessToken: this.handleRequestAccessToken,
            locale: applications["a" /* default */].language,
            onImportCompleted: this.handleImportCompleted,
            onOpenLink: this.handleOpenLink,
            onReportEvent: this.handleReportEvent,
            onSDKLoad: LrSDK => {
                if (!window.LrSDK) {
                    window.LrSDK = LrSDK;
                }
            },
            vulcan: Object(VulcanAPI["a" /* vulcanAPI */])(),
            console: window.console,
            isDebugMode: applications["a" /* default */].debugMode,
        };
        this._disposerManager.register(Object(mobx_module["A" /* observe */])(MainStore["mainStore"], 'colorTheme', () => {
            var _a, _b;
            if ((_a = this.lrApp) === null || _a === void 0 ? void 0 : _a.globalObject.onThemeUpdate) {
                (_b = this.lrApp) === null || _b === void 0 ? void 0 : _b.globalObject.onThemeUpdate(this.colorStop);
            }
        }));
        this._disposerManager.register(Object(mobx_module["A" /* observe */])(MainStore["mainStore"].user, 'state', () => {
            this.triggerRefresh();
        }));
        this._disposerManager.register(Object(mobx_module["A" /* observe */])(MainStore["mainStore"].user, 'accessToken', () => {
            this.triggerRefresh(true);
        }));
    }
    get colorStop() {
        return MainStore["mainStore"].colorTheme === 'dark' ? 'darkest' : 'light';
    }
    updateImporterProps() {
        if (this._currentView) {
            if (this.lrApp) {
                this.lrApp.globalObject.importerProps = Object.assign(this._currentView.importerProps || {}, this._globalProps);
            }
        }
        else {
            if (!window.LrSDK) {
                window.LrSDK = this.lrApp && this.lrApp.globalObject && this.lrApp.globalObject.LrSDK;
            }
        }
    }
    loadView(view) {
        // Lr Importer uses this in its code and defaults to en-US
        // We override it with the host language if not previously set
        if (!window.navigator ||
            (!window.navigator.language && !window.navigator.languages && !window.navigator.userLanguage)) {
            window.navigator = window.navigator || {};
            window.navigator.language = applications["a" /* default */].language;
        }
        // Leaving this code here we should improve the current behaviour after the separation of frontend/backend functionality
        // on CC Photos. Currently they always attach the UI. In this case we would want to do that, but in the case of LrSDKHelper
        // we want to use CCPhotos without UI. The isCached will be removed and we should just attach the UI here based on mustReloadUI.
        // const mustReloadUI = this.isLoadedHeadless && !!view; // loaded externally, e.g from Search
        this._currentView = view;
        if (this.lrApp) {
            return;
        }
        const initCallback = lrApp => {
            this.lrApp = lrApp;
            this.updateImporterProps();
        };
        const { lrApp, isCached } = Object(LrApp["a" /* getLrApp */])(initCallback);
        if (lrApp == null) {
            // checks for both null and undefined
            return;
        }
        if (isCached) {
            initCallback(lrApp);
            const { attachImporter, importerProps, document } = this.lrApp.globalObject;
            const lrImporterNode = document.getElementById('lr-importer-uxp');
            attachImporter(lrImporterNode, importerProps);
        }
        this.panel = this.lrApp.createPanelFactory({ panelId: 'importer' });
        this.container = pluginManager.createContainer(this.panel);
    }
    attachToContainer(parentNode) {
        var _a;
        if (parentNode) {
            (_a = this.container) === null || _a === void 0 ? void 0 : _a.attachToNode(parentNode);
            this._renderEventGUID = analytics["a" /* default */].subscribeLogRenderedEvent(() => ['lightroom-organizer']);
        }
    }
    detachFromContainer() {
        var _a;
        (_a = this.container) === null || _a === void 0 ? void 0 : _a.detach();
        analytics["a" /* default */].unsubscribeLogRenderedEvent(this._renderEventGUID);
    }
    destroy() {
        this._disposerManager.disposeAll();
    }
}
__decorate([
    mobx_module["l" /* computed */],
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [])
], LrImporterPanel_LrImporterPanel.prototype, "colorStop", null);
/* harmony default export */ var CCPhotos_LrImporterPanel = (new LrImporterPanel_LrImporterPanel());

// CONCATENATED MODULE: ./src/components/CCPhotos/LRImporter.tsx
/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2018 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
var LRImporter_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var LRImporter_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





let LRImporter_LRImporter = class LRImporter extends react["Component"] {
    constructor(props) {
        super(props);
        this._panelVisible = false;
        this.updatePanelHeight = () => {
            const topHeight = 114, 
            // the footer element is not available when the panel is rendered, so we use a fixed value instead.
            footerHeight = 74, marginBottom = 10;
            this.panelHeight =
                (window.innerHeight || document.getElementById('main').offsetHeight) -
                    topHeight -
                    footerHeight -
                    marginBottom;
            CCPhotos_LrImporterPanel.updateImporterProps();
        };
        this.container = react["createRef"]();
    }
    get colorStop() {
        return MainStore["mainStore"].colorTheme === 'dark' ? 'darkest' : 'light';
    }
    componentDidMount() {
        var _a, _b, _c, _d, _e, _f;
        window.addEventListener('resize', this.updatePanelHeight);
        this.updatePanelHeight();
        this.showImporter();
        // if an element inside the CC-Photos plugin was focused, it will
        // still appear focused when returning to the Lr Tab
        // even if the element isn't actually focused
        // here we check if any element is focused inside the plugin and we blur it out
        const activeElementInsideCCImporter = (_f = (_e = (_d = (_c = (_b = (_a = window.LrSDK) === null || _a === void 0 ? void 0 : _a.importer) === null || _b === void 0 ? void 0 : _b._importerInstances) === null || _c === void 0 ? void 0 : _c._1) === null || _d === void 0 ? void 0 : _d.factory) === null || _e === void 0 ? void 0 : _e.getDocument()) === null || _f === void 0 ? void 0 : _f.activeElement;
        activeElementInsideCCImporter &&
            requestAnimationFrame(() => {
                // there's an issue where we first need to re-focus on the element for the blur to work
                activeElementInsideCCImporter.focus();
                requestAnimationFrame(() => {
                    activeElementInsideCCImporter.blur();
                });
            });
    }
    componentWillUnmount() {
        window.removeEventListener('resize', this.updatePanelHeight);
        this.hideImporter();
    }
    loadImporter() {
        CCPhotos_LrImporterPanel.loadView(this);
    }
    showImporter() {
        this.loadImporter();
        if (this._panelVisible) {
            return;
        }
        this._panelVisible = true;
        CCPhotos_LrImporterPanel.attachToContainer(this.container.current);
    }
    get importerProps() {
        return {
            style: {
                height: this.panelHeight,
                position: 'relative',
                display: this.props.hidden ? 'none' : undefined,
            },
        };
    }
    hideImporter() {
        if (!this._panelVisible) {
            return;
        }
        CCPhotos_LrImporterPanel.detachFromContainer();
        this._panelVisible = false;
    }
    render() {
        return react["createElement"]("div", { style: { height: '100%' }, ref: this.container });
    }
};
LRImporter_decorate([
    mobx_module["z" /* observable */],
    LRImporter_metadata("design:type", Object)
], LRImporter_LRImporter.prototype, "panelHeight", void 0);
LRImporter_decorate([
    mobx_module["l" /* computed */],
    LRImporter_metadata("design:type", Object),
    LRImporter_metadata("design:paramtypes", [])
], LRImporter_LRImporter.prototype, "colorStop", null);
LRImporter_LRImporter = LRImporter_decorate([
    index_module["e" /* observer */],
    LRImporter_metadata("design:paramtypes", [Object])
], LRImporter_LRImporter);
/* harmony default export */ var CCPhotos_LRImporter = __webpack_exports__["default"] = (LRImporter_LRImporter);


/***/ })

}]);