/// <reference types="node" />
import { EventEmitter } from "events";
import { Response } from "node-fetch";
import { PartialRange, RequestInit } from "./types";
export declare class Partial extends EventEmitter {
    /**
     * The range of bytes, the current thread is downloading
     **/
    get range(): PartialRange;
    /**
     * The range header that was sent to the server.
     * We can request a smaller subset of this requested
     * range but not higher.
     **/
    get requestRange(): PartialRange;
    get pendingRange(): PartialRange;
    /**
     * Trim this request to only download to the
     * provided range.
     * Trims automatically to the maximum request
     * range if a higher range is provided.
     **/
    trim(end: number): void;
    get response(): Response;
    private _requestRange;
    private _range;
    private aborted;
    private _response;
    private controller;
    private offset;
    fetch(url: string, options?: RequestInit, range?: {
        start: number;
        end: number;
    }): Promise<Response>;
    abort(): void;
    private _fetchPromise;
    get fetchPromise(): Promise<Response>;
    private _updatedAt;
    private _options;
    get updatedAt(): Date;
    latencyTimeout: ReturnType<typeof setTimeout> | undefined;
    private clearLatencyTimeout;
    download(): Promise<Partial>;
}
