/// <reference types="node" />
import { EventEmitter } from "events";
import { RequestInit, PartialRange } from "./types";
import { Partial } from "./partial";
export interface Metadata {
    init?: RequestInit;
    partials?: Array<PartialRange>;
    url?: string;
    acceptRanges?: string;
    pendingLatencyRetries?: number;
}
export default class Download extends EventEmitter {
    private contentLength;
    private partials;
    private _metadata;
    get metadata(): Metadata & {
        partials: PartialRange[];
    };
    /**
     * Is compression used to get the response. If yes, parallel downloads are disabled
     * as the compress option is passed at fetch call and node-fetch starts decompression.
     * Decompression can only happen in series or when the download is complete but that ship
     * has sailed already.
     * See https://github.com/node-fetch/node-fetch/issues/384
     **/
    isCompressed: Boolean;
    /**
     * Gets the length of the content currently under download
     */
    get size(): number;
    download(url: string, init: RequestInit, partial: Partial): Download;
    resume(metadata: Metadata, contentLength: number, urlOverride?: string, optionsOverride?: RequestInit): this;
    get done(): number;
    private _done;
    private abort;
    private _headers;
    headers(): Headers | undefined;
    /**
     * Parallel requests are not supported or the server stopped responding
     * parallel requests properly. So we need to switch to the single request
     * mode.
     */
    private switchToSingleMode;
    private downloadPartial;
    private downloadMetadata;
    private downloadInternal;
}
