/// <reference types="node" />
import { Headers, AbortError } from "node-fetch";
import { RequestInit, Response } from "./types";
import { EventEmitter } from "events";
export default function parallelFetch(url: string, init?: RequestInit): Promise<Response>;
declare type LoadResponse = {
    size: number;
    url: string;
    init: RequestInit;
    emitter: EventEmitter;
    headers: Headers;
    resume: (url?: string, options?: RequestInit) => Promise<string>;
};
export declare function load(path: string): Promise<LoadResponse>;
declare type Progress = {
    total?: number;
    done: number;
};
export { RequestInit, Response, Progress, LoadResponse, AbortError };
