/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

const path = require('path');

class VulcanJS {
    static createControlAdapter() {
        // Initialize lazily - it's important not to initialize this before NGL
        // Vulcan control lib requires you to specify the location of the adobe_caps library
        require('../build/Release/VulcanControlLib.node')._setLibraryPath(path.resolve(__dirname, '../build/release'));
        const ControlAdapter = require('./VulcanControlAdapter');
        return new ControlAdapter();
    }

    static createMessageAdapter(...args) {
        const MessageAdapter = require('../build/Release/VulcanMessageLib.node').VulcanAdapter;
        return new MessageAdapter(...args);
    }
}

module.exports = VulcanJS;
