#ifndef _MM_JSAPI_H_
#define _MM_JSAPI_H_


#include <stddef.h>

/*****************************************************************************
 * Public data types
 ****************************************************************************/

typedef struct JSContext JSContext;
typedef struct JSObject JSObject;
typedef ptrdiff_t jsval; //DW_64BIT Fix JavaScript Spider Monkey Crash on start with 64 bit.
						 //There was a difference in data type used in Spider Monkey Code and DW interface.
						 //Hence changing from long to ptrdiff_t

#ifndef CORE_INT_TYPES
#define CORE_INT_TYPES
#if __GNUC__
#include <stdint.h>
#endif

//These usigned versions are also declared in some apple headers so make sure our types match
#ifndef _UINT64
#ifdef _UINT64_T
typedef uint64_t			uint64;
#else
typedef unsigned long long	uint64;
#endif
#endif


#ifdef _INT64_T
typedef int64_t				int64;
#else
typedef long long			int64;
#endif


#ifndef _UINT32
#ifdef _UINT32_T
typedef uint32_t			uint32;
#else
typedef unsigned long		uint32;
#endif
#endif


#ifdef _INT32_T
typedef int32_t				int32;
#else
typedef signed   long		int32;
#endif


#ifndef _UINT16
#ifdef _UINT16_T
typedef uint16_t			uint16;
#else
typedef unsigned short		uint16;
#endif
#endif

#ifdef _INT16_T
typedef int16_t				int16;
#else
typedef signed   short		int16;
#endif


#ifndef _UINT8
#ifdef _UINT8_T
typedef uint8_t				uint8;
#else
typedef unsigned char		uint8;
#endif
#endif


#ifdef _INT8_T
typedef int8_t				int8;
#else
typedef signed   char		int8;
#endif

#endif

typedef int32     jsint;
#ifndef JSBool
typedef int JSBool;
#endif

#ifndef jschar
typedef unsigned short jschar;
#endif

#ifndef NULL
#define NULL 0
#endif

typedef JSBool (*JSNative)(JSContext *cx, JSObject *obj, unsigned int argc, 
    jsval *argv, jsval *rval); 

#ifndef jsapi_h___
/* Possible values for JSBool */
#define JS_TRUE 1
#define JS_FALSE 0

/*
 * Type tags stored in the low bits of a jsval.
 */
#define JSVAL_OBJECT            0x0     /* untagged reference to object */
#define JSVAL_INT               0x1     /* tagged 31-bit integer value */
#define JSVAL_DOUBLE            0x2     /* tagged reference to double */
#define JSVAL_STRING            0x4     /* tagged reference to string */
#define JSVAL_BOOLEAN           0x6     /* tagged boolean value */

#define JSVAL_INT_POW2(n)       ((jsval)1 << (n))
#define JSVAL_VOID              INT_TO_JSVAL(0 - JSVAL_INT_POW2(30))

#define JSVAL_TO_INT(v)         ((jsint)(v) >> 1)
#define INT_TO_JSVAL(i)         (((jsval)(i) << 1) | JSVAL_INT)
#define JSVAL_IS_INT(v)         (((v) & JSVAL_INT) && (v) != JSVAL_VOID)

#endif

// Attribute values Get/SetConfigFileAttributes
//
#define MM_FILEATTR_NORMAL	0x00	/* Normal file - No read/write restrictions */
#define MM_FILEATTR_RDONLY	0x01	/* Read only file */
#define MM_FILEATTR_HIDDEN	0x02	/* Hidden file */
#define MM_FILEATTR_SYSTEM	0x04	/* System file */
#define MM_FILEATTR_SUBDIR	0x10	/* Subdirectory */


/*****************************************************************************
 * Public functions
 ****************************************************************************/

/* JSBool JS_DefineFunction(char *name, JSNative call, unsigned int nargs) */
#define JS_DefineFunction(n, c, a) \
    (mmEnv.defineFunction ? (*(mmEnv.defineFunction))(mmEnv.libObj, n, c, a) \
                          : JS_FALSE)

/* char *JS_ValueToString(JSContext *cx, jsval v, unsigned int *pLength) */
#define JS_ValueToString(c, v, l) \
    (mmEnv.valueToString  ? (*(mmEnv.valueToString))(c, v, l) : (char *)0)

/* char *JS_ValueToUCString(JSContext *cx, jsval v, unsigned int *pLength) */
#define JS_ValueToUCString(c, v, l) \
    (mmEnv.valueToUCString  ? (*(mmEnv.valueToUCString))(c, v, l) : (jschar *)0)

/* JSBool JS_ValueToInteger(JSContext *cx, jsval v, long *lp); */
#define JS_ValueToInteger(c, v, l) \
    (mmEnv.valueToInteger ? (*(mmEnv.valueToInteger))(c, v, l) : JS_FALSE)

/* JSBool JS_ValueToDouble(JSContext *cx, jsval v, double *dp); */
#define JS_ValueToDouble(c, v, d) \
    (mmEnv.valueToDouble  ? (*(mmEnv.valueToDouble))(c, v, d) : JS_FALSE)

/* JSBool JS_ValueToBoolean(JSContext *cx, jsval v, JSBool *bp); */
#define JS_ValueToBoolean(c, v, b) \
    (mmEnv.valueToBoolean ? (*(mmEnv.valueToBoolean))(c, v, b) : JS_FALSE)

/* JSBool JS_ValueToObject(JSContext *cx, jsval v, JSObject **op); */
#define JS_ValueToObject(c, v, o) \
    (mmEnv.valueToObject  ? (*(mmEnv.valueToObject))(c, v, o) : JS_FALSE)

/* JSBool JS_StringToValue(JSContext *cx, char *bytes, uint sz, jsval *vp); */
#define JS_StringToValue(c, b, s, v) \
    (mmEnv.stringToValue  ? (*(mmEnv.stringToValue))(c, b, s, v) : JS_FALSE)

/* JSBool JS_UCStringToValue(JSContext *cx, char *bytes, uint sz, jsval *vp); */
#define JS_UCStringToValue(c, b, s, v) \
    (mmEnv.ucstringToValue  ? (*(mmEnv.ucstringToValue))(c, b, s, v) : JS_FALSE)

/* JSBool JS_DoubleToValue(JSContext *cx, double dv, jsval *vp); */
#define JS_DoubleToValue(c, d, v) \
    (mmEnv.doubleToValue  ? (*(mmEnv.doubleToValue))(c, d, v) : JS_FALSE)

/* jsval JS_IntegerToValue(long lv); */
#define JS_IntegerToValue(lv)       (((jsval)(lv) << 1) | 0x1)

/* jsval JS_BooleanToValue(JSBool bv); */
#define JS_BooleanToValue(bv)       (((jsval)(bv) << 3) | 0x6)

/* jsval JS_ObjectToValue(JSObject *obj); */
#define JS_ObjectToValue(ov)		((jsval)(ov))

/* char *JS_ObjectType(JSObject *obj); */
#define JS_ObjectType(o) \
    (mmEnv.objectType     ? (*(mmEnv.objectType))(o) : (char *)0)

/* JSObject *JS_NewArrayObject(JSContext *cx, unsigned int length, jsval *v) */
#define JS_NewArrayObject(c, l, v) \
	(mmEnv.newArrayObject ? (*(mmEnv.newArrayObject))(c, l, v) : (JSObject *)0)

/* long JS_GetArrayLength(JSContext *cx, JSObject *obj) */
#define JS_GetArrayLength(c, o) \
	(mmEnv.getArrayLength ? (*(mmEnv.getArrayLength))(c, o) : -1)

/* JSBool JS_GetElement(JSContext *cx, JSObject *obj, jsint idx, jsval *vp) */
#define JS_GetElement(c, o, i, v) \
    (mmEnv.getElement     ? (*(mmEnv.getElement))(c, o, i, v) : JS_FALSE)

/* JSBool JS_SetElement(JSContext *cx, JSObject *obj, jsint idx, jsval *vp) */
#define JS_SetElement(c, o, i, v) \
    (mmEnv.setElement     ? (*(mmEnv.setElement))(c, o, i, v) : JS_FALSE)

/* JSBool JS_ExecuteScript(JSContext *cx, JSObject *obj, char *script,
 *     unsigned int sz, jsval *rval) */
#define JS_ExecuteScript(c, o, s, z, r) \
    (mmEnv.executeScript  ? (*(mmEnv.executeScript))(c, o, s, z, __FILE__, \
        __LINE__, r) : JS_FALSE)

/* JSBool JS_ExecuteUCScript(JSContext *cx, JSObject *obj, char *script,
 *     unsigned int sz, jsval *rval) */
#define JS_ExecuteUCScript(c, o, s, z, r) \
    (mmEnv.executeUCScript  ? (*(mmEnv.executeUCScript))(c, o, s, z, __FILE__, \
        __LINE__, r) : JS_FALSE)

/* JSBool JS_ReportError(JSContext *cx, char *error, unsigned int sz) */
#define JS_ReportError(c, e, s) \
    (mmEnv.reportError    ? (*(mmEnv.reportError))(c, e, s) : JS_FALSE)

/* JSBool JS_ReportErrorByStringID(JSContext *cx, const jschar *errorId, unsigned int sz) 
 * This will load the appropiate localized string and report the error 
 */
#define JS_ReportErrorByStringID(c, e, s) \
    (mmEnv.reportErrorByStringID    ? (*(mmEnv.reportErrorByStringID))(c, e, s) : JS_FALSE)

/*****************************************************************************
 * ConfigFile functions
 * Use the following file functions in place of system calls if any of 
 * the file operations may act on files in the Dreamweaver configuration 
 * folder. On multiple user systems, such as Windows XP and Mac OSX, 
 * these functions will always work even if the user does not have write 
 * permission in the configuration folder. See Extending Dreamweaver for 
 * more info.
 *
 * Note: you can use these functions for non-configuration files as well. 
 ****************************************************************************/

/* JSObject * MM_GetConfigFolderList (JSContext *cx, char *fileUrl, char *constraints = NULL) */
#define MM_GetConfigFolderList(c, f, cn) \
    (mmEnv.getConfigFolderList    ? (*(mmEnv.getConfigFolderList))(c, f, cn) : (JSObject *)0)

/* JSObject * MM_GetUCConfigFolderList (JSContext *cx, char *fileUrl, char *constraints = NULL) */
#define MM_GetUCConfigFolderList(c, f, cn) \
    (mmEnv.getUCConfigFolderList    ? (*(mmEnv.getUCConfigFolderList))(c, f, cn) : (JSObject *)0)

/* JSBool MM_ConfigFileExists (char *fileURL) */
#define MM_ConfigFileExists(f) \
    (mmEnv.configFileExists    ? (*(mmEnv.configFileExists))(f) : JS_FALSE)

/* JSBool MM_UCConfigFileExists (char *fileURL) */
#define MM_UCConfigFileExists(f) \
    (mmEnv.ucconfigFileExists    ? (*(mmEnv.ucconfigFileExists))(f) : JS_FALSE)

/* int MM_OpenConfigFile (char *fileURL, char *mode)
	- note: mode can be "read" or "write", "write" implies create 
	- note: on windows, the handle you get back is a MS C Runtime file
			handle opened from msvcrt.dll. This is for backwards 
			compatibility, as Dreamweaver no longer links against this
			dll. The function MM_OpenUCConfigFile() is preferred to 
			get a file handle.
	- note: on mac, the handle is the forkRefNum result from FSOpenFork() 
			with the data fork of the file*/
#define MM_OpenConfigFile(f, m) \
    (mmEnv.openConfigFile    ? (*(mmEnv.openConfigFile))(f, m) : JS_FALSE)

/* long MM_OpenUCConfigFile (char *fileURL, char *mode)
	- note: mode can be "read" or "write", "write" implies create
	- note: on windows, the handle you get back is an osfhandle 
			in order to use it with the MS Runtime Library use _open_osfhandle()
	- note: on mac, the handle is the forkRefNum result from FSOpenFork() 
			with the data fork of the file*/
#define MM_OpenUCConfigFile(f, m) \
    (mmEnv.openUCConfigFile    ? (*(mmEnv.openUCConfigFile))(f, m) : JS_FALSE)

/* JSObject * MM_GetConfigFileAttributes (char *fileUrl, unsigned long* attrs, unsigned long* filesize, unsigned long* modtime, unsigned long* createtime) 
	- return string with some or all characters "DRHS", or NULL if error */
#define MM_GetConfigFileAttributes(f, a, s, m, c) \
    (mmEnv.getConfigFileAttributes    ? (*(mmEnv.getConfigFileAttributes))(f, a, s, m, c) : JS_FALSE)

/* JSObject * MM_GetUCConfigFileAttributes (char *fileUrl, unsigned long* attrs, unsigned long* filesize, unsigned long* modtime, unsigned long* createtime) 
	- return string with some or all characters "DRHS", or NULL if error */
#define MM_GetUCConfigFileAttributes(f, a, s, m, c) \
    (mmEnv.getUCConfigFileAttributes    ? (*(mmEnv.getUCConfigFileAttributes))(f, a, s, m, c) : JS_FALSE)

/* JSBool MM_SetConfigFileAttributes (char *fileURL, unsigned long attrs) */
#define MM_SetConfigFileAttributes(f, a) \
    (mmEnv.setConfigFileAttributes    ? (*(mmEnv.setConfigFileAttributes))(f, a) : JS_FALSE)

/* JSBool MM_SetUCConfigFileAttributes (char *fileURL, unsigned long attrs) */
#define MM_SetUCConfigFileAttributes(f, a) \
    (mmEnv.setUCConfigFileAttributes    ? (*(mmEnv.setUCConfigFileAttributes))(f, a) : JS_FALSE)

/* JSBool MM_CreateConfigFolder (char *fileURL) */
#define MM_CreateConfigFolder(f) \
    (mmEnv.createConfigFolder    ? (*(mmEnv.createConfigFolder))(f) : JS_FALSE)

/* JSBool MM_CreateUCConfigFolder (char *fileURL) */
#define MM_CreateUCConfigFolder(f) \
    (mmEnv.createUCConfigFolder    ? (*(mmEnv.createUCConfigFolder))(f) : JS_FALSE)

/* JSBool MM_RemoveConfigFolder (char *fileURL) */
#define MM_RemoveConfigFolder(f) \
    (mmEnv.removeConfigFolder    ? (*(mmEnv.removeConfigFolder))(f) : JS_FALSE)

/* JSBool MM_RemoveUCConfigFolder (char *fileURL) */
#define MM_RemoveUCConfigFolder(f) \
    (mmEnv.removeUCConfigFolder    ? (*(mmEnv.removeUCConfigFolder))(f) : JS_FALSE)

/* JSBool MM_DeleteConfigFile (char *fileURL) */
#define MM_DeleteConfigFile(f) \
    (mmEnv.deleteConfigFile    ? (*(mmEnv.deleteConfigFile))(f) : JS_FALSE)

/* JSBool MM_DeleteUCConfigFile (char *fileURL) */
#define MM_DeleteUCConfigFile(f) \
    (mmEnv.deleteUCConfigFile    ? (*(mmEnv.deleteUCConfigFile))(f) : JS_FALSE)

/* JSBool MM_ReadUCConfigFile (JSContext *cx, char *fileURL, char* charset, jsval *rval) */
#define MM_ReadUCConfigFile(cx, f, c, v) \
    (mmEnv.readUCConfigFile    ? (*(mmEnv.readUCConfigFile))(cx, f, c, v) : JS_FALSE)

/* JSBool MM_WriteUCConfigFile (char *fileURL, char *mode, char *text, char* charset, jsval *rval) */
#define MM_WriteUCConfigFile(f, m, t, c, v) \
    (mmEnv.writeUCConfigFile    ? (*(mmEnv.writeUCConfigFile))(f, m, t, c, v) : JS_FALSE)
    
    /* JSBool MM_ResolveUCConfigFileURL (const jschar * inFileUrl, jschar* outFileUrl, unsigned int outFileLength) */
#define MM_ResolveUCConfigFilePath(ip, op, l) \
    (mmEnv.resolveUCConfigFilePath    ? (*(mmEnv.resolveUCConfigFilePath))(ip, op, l) : JS_FALSE)

	 /* JSObject * JS_RegisterClass (JSContext *cx, JSObject *obj, JSObject *parent_proto, MM_ClassSpec * class_spec) */
#define JS_RegisterClass(cx, obj, parent_proto, class_spec) \
	(mmEnv.registerClass    ? (*(mmEnv.registerClass))(cx, obj, parent_proto, class_spec) : NULL)

    /* JSBool JS_SetClassData (JSContext *cx, JSObject *obj, void *data) */
#define JS_SetClassData(cx, obj, data) \
    (mmEnv.setClassData    ? (*(mmEnv.setClassData))(cx, obj, data) : JS_FALSE)

    /* void * JS_GetClassData (JSContext *cx, JSObject *obj) */
#define JS_GetClassData(cx, obj) \
    (mmEnv.getClassData    ? (*(mmEnv.getClassData))(cx, obj) : NULL)




/*****************************************************************************
 * Public interfaces for defining your own classes. Normally a JSExtension is
 * it's own static global object so there's no instance or state information 
 * associated with it. These let you define your own classes that can have
 * multiple instances of and a little more object oriented for the js scrippter.
 ****************************************************************************/

/* You need to implement this function to get your classes register. This function
 * will get called during application lauch so it shouldn't do more work than just
 * defining the apis you are exposing. If you aren't defining a class you can 
 * comment this prototype out. 
 */
// Declare the external entry point and linkage
#ifdef _WIN32
    __declspec( dllexport ) void MM_RegisterClasses(JSContext *cx, JSObject *obj, JSObject *parent_proto);
#else
    // Codewarrior
#   pragma export on    
    extern void MM_RegisterClasses(JSContext *cx, JSObject *obj, JSObject *parent_proto);
#   pragma export off
#endif

#ifndef jsapi_h___

/*
 * Add, delete, get or set a property named by iD in obj.  Note the jsval iD
 * type -- iD may be a string (Unicode property identifier) or an int (element
 * index).  The *vp out parameter, on success, is the new property value after
 * an add, get, or set.  After a successful delete, *vp is JSVAL_FALSE iff
 * obj[iD] can't be deleted (because it's permanent).
 */
typedef JSBool(*JSPropertyOp)(JSContext *cx, JSObject *obj, jsval iD, jsval *vp);
typedef void(*JSFinalizeOp)(JSContext *cx, JSObject *obj);

/* Stub function for default implementation */
JSBool JS_PropertyStub(JSContext *cx, JSObject *obj, jsval iD, jsval *vp);
void JS_FinalizeStub(JSContext *cx, JSObject *obj);

/* Property attributes, set in JSPropertySpec and passed to API functions. */
#define JSPROP_ENUMERATE        0x01    /* property is visible to for/in loop */
#define JSPROP_READONLY         0x02    /* not settable: assignment is no-op */
#define JSPROP_PERMANENT        0x04    /* property cannot be deleted */
#define JSPROP_EXPORTED         0x08    /* property is exported from object */
#define JSPROP_GETTER           0x10    /* property holds getter function */
#define JSPROP_SETTER           0x20    /* property holds setter function */
#define JSPROP_SHARED           0x40    /* don't allocate a value slot for this
                                           property; don't copy the property on
                                           set of the same-named property in an
                                           object that delegates to a prototype
                                           containing this property */
#define JSPROP_INDEX            0x80    /* name is actually (jsint) index */

/* Function flags, set in JSFunctionSpec and passed to JS_NewFunction etc. */
#define JSFUN_LAMBDA            0x08    /* expressed, not declared, function */
#define JSFUN_GETTER            JSPROP_GETTER
#define JSFUN_SETTER            JSPROP_SETTER
#define JSFUN_BOUND_METHOD      0x40    /* bind this to fun->object's parent */
#define JSFUN_HEAVYWEIGHT       0x80    /* activation requires a Call object */
#define JSFUN_FLAGS_MASK        0xf8    /* overlay JSFUN_* attributes */

/* describe a property in your class */
typedef struct {
    const char      *name;
    int8            tinyid;
    uint8           flags;
    JSPropertyOp    getter;
    JSPropertyOp    setter;
}JSPropertySpec;

/* describe a function in your class */
typedef struct {
    const char      *name;
    JSNative        call;
    uint8           nargs;
    uint8           flags;
    uint16          extra;      /* number of arg slots for local GC roots */
}JSFunctionSpec;

#endif

// all the information you to to fill out to define your class is in this file
#include "mm_jsclassapi.h"


/*****************************************************************************
 * Private data types, macros, and globals
 ****************************************************************************/

#include "mm_jsapi_environment.h"

extern MM_Environment mmEnv;

// Declare the external entry point and linkage
#ifdef _WIN32
#   ifndef _MAC  
    // Windows
    __declspec( dllexport ) void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   else
    // Mac with MSVC++ Win32 portability lib
    extern void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   endif
#else
    // Codewarrior
#   pragma export on    
    extern void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   pragma export off
#endif


#define MM_STATE                                                             	\
    /* Definitions of global variables */                                    	\
    MM_Environment mmEnv;                                                    	\
																			 	\
	 void																	 	\
  	 MM_InitWrapper(MM_Environment *env, unsigned int envSize)                	\
    {																		 	\
		extern void MM_Init();												 	\
																			 	\
		char **envPtr = (char **)env;										 	\
		char **mmPtr =  (char **)(&mmEnv);									 	\
		char **envEnd = (char **)((char *)envPtr + envSize);				 	\
		char **mmEnd =  (char **)((char *)mmPtr  + sizeof(MM_Environment));  	\
																			 	\
		/* Copy fields from env to mmEnv, one pointer at a time */			 	\
		while (mmPtr < mmEnd && envPtr < envEnd)							 	\
			*mmPtr++ = *envPtr++;											 	\
																			 	\
      /* If env doesn't define all of mmEnv's fields, set extras to NULL */		\
		while (mmPtr < mmEnd)												 	\
			*mmPtr++ = (char *)0;											 	\
                                                                             	\
      /* Call user's MM_Init function */                                   		\
      MM_Init();                                                           		\
    }                                                                        	\
																				\
																				\
	/* Defined our stub functions */											\
	JSBool JS_PropertyStub(JSContext *cx, JSObject *obj, jsval iD, jsval *vp){	\
		return JS_TRUE;															\
	}																			\
																				\
	void JS_FinalizeStub(JSContext *cx, JSObject *obj){}						\

                                                                             
#endif /* _MM_JSAPI_H_ */
