/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR": "(ошибка {0})",
    "NOT_FOUND_ERR": "Файл не найден",
    "NOT_READABLE_ERR": "Файл не может быть прочитан",
    "EXCEEDS_MAX_FILE_SIZE": "Файлы с размером, превышающим {0} МБ, невозможно открыть в {APP_NAME}.",
    "NO_MODIFICATION_ALLOWED_ERR": "Целевая директория не может быть изменена.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE": "Ограничение прав не позволяет сделать изменения.",
    "CONTENTS_MODIFIED_ERR": "Файл был изменен вне {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR": "Неизвестный формат кодирования",
    "ENCODE_FILE_FAILED_ERR": "{APP_NAME} не удалось выполнить кодирование содержимого файла.",
    "DECODE_FILE_FAILED_ERR": "{APP_NAME} не удалось выполнить декодирование содержимого файла.",
    "UNSUPPORTED_UTF16_ENCODING_ERR": "{APP_NAME} в данный момент не поддерживает текстовые файлы в кодировке UTF-16.",
    "FILE_EXISTS_ERR": "Файл уже существует.",
    "FILE": "файл",
    "FILE_TITLE": "Файл",
    "DIRECTORY": "директория",
    "DIRECTORY_TITLE": "Каталог",
    "DIRECTORY_NAMES_LEDE": "Имена директорий",
    "FILENAMES_LEDE": "Имена файлов",
    "FILENAME": "Имя файла",
    "DIRECTORY_NAME": "имя директории",

    // Project error strings
    "ERROR_LOADING_PROJECT": "Ошибка при загрузке проекта",
    "OPEN_DIALOG_ERROR": "Произошла ошибка при показе диалога открытия файлов. (ошибка {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR": "Произошла ошибка при попытке загрузить директорию <span class='dialog-filename'>{0}</span>. (ошибка {1})",
    "READ_DIRECTORY_ENTRIES_ERROR": "Произошла ошибка при чтении содержимого директории <span class='dialog-filename'>{0}</span>. (ошибка {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE": "Ошибка открытия файла",
    "ERROR_OPENING_FILE": "Произошла ошибка при попытке открыть файл <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES": "Произошла ошибка при попытке открыть файлы: ",
    "ERROR_RELOADING_FILE_TITLE": "Ошибка перезагрузки изменений с диска",
    "ERROR_RELOADING_FILE": "Произошла ошибка при попытке перезагрузить файл <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE": "Ошибка сохранения файла",
    "ERROR_SAVING_FILE": "Произошла ошибка при попытке сохранить файл <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE": "Ошибка переименования файла",
    "ERROR_RENAMING_FILE": "Произошла ошибка при попытке переименовать файл <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT": "Файл или каталог не является частью открытого в настоящий момент проекта. К сожалению, сейчас можно переименовывать только файлы, входящие в состав проекта.",
    "ERROR_DELETING_FILE_TITLE": "Ошибка удаления файла",
    "ERROR_DELETING_FILE": "Произошла ошибка при попытке удалить файл <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE": "Неверное имя файла {0}",
    "INVALID_FILENAME_MESSAGE": "{0} не может содержать зарезервированные слова, заканчиваться точкой (.) или содержать следующие символы: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS": "Файл или директория с именем <span class='dialog-filename'>{0}</span> уже существует.",
    "ERROR_CREATING_FILE_TITLE": "Ошибка создания файла",
    "ERROR_CREATING_FILE": "Произошла ошибка при попытке создать файл <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_MIXED_DRAGDROP": "Не удается открыть папку одновременно с открытием других файлов.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE": "Ошибка чтения списка сопоставлений клавиш для пользователя",
    "ERROR_KEYMAP_CORRUPT": "Файл со списком сопоставлений клавиш в формате JSON имеет некорректное содержимое. Данный файл будет открыт, чтобы вы могли исправить его формат.",
    "ERROR_LOADING_KEYMAP": "Файл сопоставления клавиш не является допустимым текстовым файлом в кодировке UTF-8 и не может быть загружен",
    "ERROR_RESTRICTED_COMMANDS": "Невозможно переназначить сочетания клавиш для следующих команд: {0}",
    "ERROR_RESTRICTED_SHORTCUTS": "Невозможно переназначить следующие сочетания клавиш: {0}",
    "ERROR_MULTIPLE_SHORTCUTS": "Вы переназначаете несколько сочетаний клавиш для следующих команд: {0}",
    "ERROR_DUPLICATE_SHORTCUTS": "У вас есть несколько привязок для этих клавиш: {0}",
    "ERROR_INVALID_SHORTCUTS": "Эти сочетания клавиш не действуют: {0}",
    "ERROR_NONEXISTENT_COMMANDS": "Вы назначаете сочетания клавиш для несуществующих команд: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE": "Ошибка чтения настроек",
    "ERROR_PREFS_CORRUPT": "Обнаружена ошибка формата JSON в файле настроек. Он будет открыт для того, чтобы исправить ошибку вручную. Вам будет необходимо перезагрузить {APP_NAME}, чтобы исправления вступили в силу.",
    "ERROR_PROJ_PREFS_CORRUPT": "Файл с настройками проекта в формате JSON имеет некорректное содержимое. Данный файл будет открыт, чтобы вы могли исправить его формат. Чтобы изменения вступили в силу, необходимо загрузить проект повторно.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE": "К сожалению, запуск {APP_NAME} в браузере пока что не поддерживается.",
    "ERROR_IN_BROWSER": "{APP_NAME} разработан на HTML, но пока что может работать только как настольное приложение, чтобы вы могли редактировать локальные файлы. Пожалуйста, используйте специальную оболочку (проект <b>github.com/adobe/brackets-shell</b>) для запуска {APP_NAME}.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE": "Ошибка индексирования файлов",
    "ERROR_MAX_FILES": "Количество файлов превышает предельно допустимое. Команды использующие индекс файлов могут работать некорректно.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE": "Ошибка запуска браузера.",
    "ERROR_CANT_FIND_CHROME": "Браузер Google Chrome не найден. Пожалуйста, убедитесь, что он установлен.",
    "ERROR_LAUNCHING_BROWSER": "Произошла ошибка при запуске браузера. (ошибка {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE": "Ошибка функции Live Preview",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE": "Соединение с браузером",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE": "Функция Live Preview требует перезапуска Chrome с включенной функцией удаленной отладки. <br /><br />Перезапустить Chrome с удаленной отладкой?",
    "LIVE_DEV_LOADING_ERROR_MESSAGE": "Невозможно загрузить страницу Live Preview",
    "LIVE_DEV_NEED_HTML_MESSAGE": "Откройте HTML файл или убедитесь в наличии index.html в проекте для того чтобы запустить интерактивную разработку.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE": "Для запуска Live Preview с серверным файлом, вы должны указать базовый URL проекта.",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE": "Ошибка запуска HTTP сервера для Live Preview. Попытайтесь снова.",
    "LIVE_DEVELOPMENT_INFO_TITLE": "Добро пожаловать в Live Preview!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE": "Live Preview, функция синхронного предпросмотра, подключает браузер к среде разработки {APP_NAME}. Эта функция загружает HTML файл для предварительного просмотра в браузере и мгновенно отображает все изменения при редактировании кода.<br /><br />В данной версии {APP_NAME}, функция Live Preview пока что работает только с <strong>Google Chrome</strong> и обновления в реальном времени отображаются только при редактировании <strong>CSS или HTML файлов</strong>. Изменения в JavaScript файлах автоматически перезагружают страницу при сохранении.<br /><br />(Это сообщение будет показано только один раз.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING": "Для дополнительной информации, смотрите <a href='{0}' title='{0}'>Поиск и устранение неисправностей ошибок подключения Live Preview</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED": "Функция интерактивного просмотра",
    "LIVE_DEV_STATUS_TIP_PROGRESS1": "Live Preview: Подключение\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2": "Live Preview: Инициализация\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED": "Отсоединить Live Preview",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC": "Live Preview (Для отображения изменений сохраните их)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR": "Live Preview (Не обновляется из-за синтаксической ошибки)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS": "Функция Live Preview была отключена при открытии инструментов разработки в браузере",
    "LIVE_DEV_DETACHED_TARGET_CLOSED": "Функция Live Preview была отключена при закрытии страницы в браузере",
    "LIVE_DEV_NAVIGATED_AWAY": "Функция Live Preview была отключена при переходе на страницу не принадлежащую проекту",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON": "Функция Live Preview была отменена по неизвестной причине ({0})",

    "SAVE_CLOSE_TITLE": "Сохранить изменения",
    "SAVE_CLOSE_MESSAGE": "Вы хотите сохранить изменения, которые вы сделали в документе <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE": "Вы хотите сохранить изменения для следующих файлов?",
    "EXT_MODIFIED_TITLE": "Внешние изменения",
    "CONFIRM_DELETE_TITLE": "Подтвердить удаление",
    "CONFIRM_FILE_DELETE": "Действительно удалить файл <span class='dialog-filename'>{0}</span>?",
    "CONFIRM_FOLDER_DELETE": "Вы уверены, что хотите удалить директорию <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE": "Файл удален",
    "EXT_MODIFIED_WARNING": "<span class='dialog-filename'>{0}</span> был изменен на диске.<br /><br />Вы хотите сохранить ваши изменения и перезаписать внешние?",
    "EXT_MODIFIED_MESSAGE": "<span class='dialog-filename'>{0}</span> был изменен на диске, но также имеются несохраненные изменения в {APP_NAME}.<br /><br />Какую версию вы хотите оставить?",
    "EXT_DELETED_MESSAGE": "<span class='dialog-filename'>{0}</span> был удален на диске, но имеются несохраненные изменения в {APP_NAME}.<br /><br />Вы хотите оставить ваши изменения?",
    
    // Window unload warning messages
    "WINDOW_UNLOAD_WARNING": "Перейти к другому URL-адресу и оставить Brackets?",
    "WINDOW_UNLOAD_WARNING_WITH_UNSAVED_CHANGES": "Изменения не сохранены. Перейти к другому URL-адресу и оставить Brackets?",

    // Generic dialog/button labels
    "DONE": "Готово",
    "OK": "ОК",
    "CANCEL": "Отмена",
    "DONT_SAVE": "Не сохранять",
    "SAVE": "Сохранить",
    "SAVE_AS": "Сохранить как\u2026",
    "SAVE_AND_OVERWRITE": "Заменить",
    "DELETE": "Удалить",
    "BUTTON_YES": "Да",
    "BUTTON_NO": "Нет",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX": "{0} из {1}",
    "FIND_NO_RESULTS": "Не найдено",
    "FIND_QUERY_PLACEHOLDER": "Найти\u2026",
    "FIND_HISTORY_MAX_COUNT": "Максимальное число элементов поиска в истории поиска",
    "REPLACE_PLACEHOLDER": "Заменить на\u2026",
    "BUTTON_REPLACE_ALL": "Заменить все",
    "BUTTON_REPLACE_BATCH": "Все\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES": "Заменить\u2026",
    "BUTTON_REPLACE": "Заменить",
    "BUTTON_NEXT": "\u25B6",
    "BUTTON_PREV": "\u25C0",
    "BUTTON_NEXT_HINT": "Следующее совпадение",
    "BUTTON_PREV_HINT": "Предыдущее совпадение",
    "BUTTON_CASESENSITIVE_HINT": "С учетом регистра",
    "BUTTON_REGEXP_HINT": "Регулярное выражение",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Заменить без отмены",
    "REPLACE_WITHOUT_UNDO_WARNING": "Т.к. необходимо изменить более чем {0} файла(ов), {APP_NAME} выполнит замену непосредственно на диске.<br />Вы не сможете отменить изменения в этих файлах.",
    "BUTTON_REPLACE_WITHOUT_UNDO": "Заменить без отмены",

    "OPEN_FILE": "Открыть файл",
    "SAVE_FILE_AS": "Сохранить файл",
    "CHOOSE_FOLDER": "Выберите папку",

    "RELEASE_NOTES": "Примечания к выпуску",
    "NO_UPDATE_TITLE": "Обновления отсутствуют",
    "NO_UPDATE_MESSAGE": "Вы используете последнюю версию {APP_NAME}.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL": "Заменить",
    "FIND_REPLACE_TITLE_WITH": "с",
    "FIND_TITLE_LABEL": "Найдено",
    "FIND_TITLE_SUMMARY": "&mdash; {0} {1} {2} в {3}",

    // Find in Files
    "FIND_NUM_FILES": "{0} {1}",
    "FIND_IN_FILES_SCOPED": "в <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE": "в проекте",
    "FIND_IN_FILES_ZERO_FILES": "Фильтр исключает все файлы {0}",
    "FIND_IN_FILES_FILE": "файл",
    "FIND_IN_FILES_FILES": "файлы",
    "FIND_IN_FILES_MATCH": "совпадение",
    "FIND_IN_FILES_MATCHES": "совпадений",
    "FIND_IN_FILES_MORE_THAN": "Более ",
    "FIND_IN_FILES_PAGING": "{0}&mdash;{1}",
    "FIND_IN_FILES_FILE_PATH": "<span class='dialog-filename'>{0}</span> {2} <span class='dialog-path'>{1}</span>",
    "FIND_IN_FILES_EXPAND_COLLAPSE": "Ctrl/Cmd-клик чтобы развернуть/свернуть все",
    "FIND_IN_FILES_INDEXING": "Индексирование для мгновенного поиска\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE": "Ошибка замены",
    "REPLACE_IN_FILES_ERRORS": "Данные файлы не были изменены, т.к. они изменились после поиска или не могут быть записаны.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE": "Ошибка при получении информации об обновлениях",
    "ERROR_FETCHING_UPDATE_INFO_MSG": "Ошибка при получении информации о последних обновлениях с сервера. Пожалуйста, убедитесь, что вы подключены к интернету и попробуйте снова. ",

    // File exclusion filters
    "NEW_FILE_FILTER": "Новый фильтр\u2026",
    "CLEAR_FILE_FILTER": "Не исключать файлы",
    "NO_FILE_FILTER": "Нет исключенных файлов",
    "EXCLUDE_FILE_FILTER": "Исключить {0}",
    "EDIT_FILE_FILTER": "Редактировать\u2026",
    "FILE_FILTER_DIALOG": "Редактировать фильтр",
    "FILE_FILTER_INSTRUCTIONS": "Исключить файлы и директории содержащие любую из перечисленных строк, возможно использование <a href='{0}' title='{0}'>групповых символов</a>. Указывайте по одной строке на линию.",
    "FILTER_NAME_PLACEHOLDER": "Назвать этот фильтр (опционально)",
    "FILTER_NAME_REMAINING": "Осталось символов: {0}",
    "FILE_FILTER_CLIPPED_SUFFIX": "и еще {0}",
    "FILTER_COUNTING_FILES": "Подсчет количества файлов\u2026",
    "FILTER_FILE_COUNT": "Фильтр оставляет {0} из {1} файлов/а {2}",
    "FILTER_FILE_COUNT_ALL": "Фильтр оставляет все {0} файлов/а {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND": "Быстрое редактирование недоступно для данной позиции курсора",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES": "Быстрое редактирование CSS: установите курсор на одном из имен класса",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND": "Быстрое редактирование CSS: отсутствует имя класса",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND": "Быстрое редактирование CSS: отсутствует имя идентификатора",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR": "Быстрое редактирование CSS: установите курсор на теге, классе или идентификаторе",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX": "Быстрое редактирование временной функции CSS: некорректный синтаксис",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND": "Быстрое редактирование JS: установите курсор на имени функции",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND": "Быстрая документация для текущей позиции курсора отсутствет",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING": "Загрузка\u2026",
    "UNTITLED": "Без названия",
    "WORKING_FILES": "Рабочие файлы",

    /**
     * MainViewManager
     */
    "TOP": "Сверху",
    "BOTTOM": "Снизу",
    "LEFT": "По левому краю",
    "RIGHT": "По правому краю",

    "CMD_SPLITVIEW_NONE": "Без разделения",
    "CMD_SPLITVIEW_VERTICAL": "Вертикальное разделение",
    "CMD_SPLITVIEW_HORIZONTAL": "Горизонтальное разделение",
    "SPLITVIEW_MENU_TOOLTIP": "Разделить редактор по вертикали или горизонтали",
    "GEAR_MENU_TOOLTIP": "Настроить рабочий набор",

    "SPLITVIEW_INFO_TITLE": "Уже открыт",
    "SPLITVIEW_MULTIPANE_WARNING": "Файл уже открыт на другой панели. В {APP_NAME} скоро будет добавлена поддержка открытия одного и того же файла более чем на одной панели. До этого момента файл будет отображаться на панели, на которой он уже открыт.<br /><br />(Это сообщение будет отображено однократно.)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL": "Ctrl",
    "KEYBOARD_SHIFT": "Shift",
    "KEYBOARD_SPACE": "Пробел",
    "KEYBOARD_PAGE_UP": "Page Up",
    "KEYBOARD_PAGE_DOWN": "Page Down",
    "KEYBOARD_HOME": "Home",
    "KEYBOARD_END": "End",
    "KEYBOARD_INSERT": "Insert",
    "KEYBOARD_DELETE": "Удалить",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION": "Строка {0}, Столбец {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR": " \u2014 Выделен {0} столбец",
    "STATUSBAR_SELECTION_CH_PLURAL": " \u2014 Выделено {0} столбцов",
    "STATUSBAR_SELECTION_LINE_SINGULAR": " \u2014 Выделена {0} строка",
    "STATUSBAR_SELECTION_LINE_PLURAL": " \u2014 Выделено {0} строк",
    "STATUSBAR_SELECTION_MULTIPLE": " \u2014 {0} выбранных элементов",
    "STATUSBAR_INDENT_TOOLTIP_SPACES": "Нажмите чтобы использовать пробелы для отступа",
    "STATUSBAR_INDENT_TOOLTIP_TABS": "Нажмите чтобы использовать табуляцию для отступа",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES": "Нажмите чтобы изменить количества пробелов для отступа",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS": "Нажмите чтобы изменить ширину табуляции в столбцах",
    "STATUSBAR_SPACES": "Пробелы:",
    "STATUSBAR_TAB_SIZE": "Табуляция:",
    "STATUSBAR_LINE_COUNT_SINGULAR": "\u2014 {0} строка",
    "STATUSBAR_LINE_COUNT_PLURAL": "\u2014 {0} строк",
    "STATUSBAR_USER_EXTENSIONS_DISABLED": "Расширения отключены",
    "STATUSBAR_INSERT": "ВСТ",
    "STATUSBAR_OVERWRITE": "ЗАМ",
    "STATUSBAR_INSOVR_TOOLTIP": "Щелкните, чтобы переключить курсор между режимами вставки (ВСТ) и замены (ЗАМ)",
    "STATUSBAR_LANG_TOOLTIP": "Щелкните, чтобы изменить тип файла",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP": "{0}. Щелкните, чтобы переключить панель отчетов.",
    "STATUSBAR_DEFAULT_LANG": "(по умолчанию)",
    "STATUSBAR_SET_DEFAULT_LANG": "Использовать по умолчанию для файлов .{0}",
    "STATUSBAR_ENCODING_TOOLTIP": "Выберите кодировку",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE": "{0} ошибок",
    "SINGLE_ERROR": "1 ошибка {0}",
    "MULTIPLE_ERRORS": "{1} ошибок {0}",
    "NO_ERRORS": "{0} не нашел ошибок &mdash; отлично!",
    "NO_ERRORS_MULTIPLE_PROVIDER": "Ошибок не найдено &mdash; отлично!",
    "LINT_DISABLED": "Статический анализ отключен",
    "NO_LINT_AVAILABLE": "Нет статического анализатора для {0}",
    "NOTHING_TO_LINT": "Не подлежит статическому анализу",
    "LINTER_TIMED_OUT": "{0} превысил время ожидания {1} мс",
    "LINTER_FAILED": "{0} завершил исполнение с ошибкой: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU": "Файл",
    "CMD_FILE_NEW_UNTITLED": "Новый",
    "CMD_FILE_NEW": "Создать файл",
    "CMD_FILE_NEW_FOLDER": "Создать папку",
    "CMD_FILE_OPEN": "Открыть\u2026",
    "CMD_RECENT_FILES_OPEN": "Открыть последний\u2026",
    "CMD_ADD_TO_WORKING_SET": "Добавить в рабочий набор",
    "CMD_OPEN_DROPPED_FILES": "Открыть перетащенные файлы",
    "CMD_OPEN_FOLDER": "Открыть директорию\u2026",
    "CMD_FILE_CLOSE": "Закрыть",
    "CMD_FILE_CLOSE_ALL": "Закрыть все",
    "CMD_FILE_CLOSE_LIST": "Закрыть список",
    "CMD_FILE_CLOSE_OTHERS": "Закрыть остальные",
    "CMD_FILE_CLOSE_ABOVE": "Закрыть остальные сверху",
    "CMD_FILE_CLOSE_BELOW": "Закрыть остальные снизу",
    "CMD_FILE_SAVE": "Сохранить",
    "CMD_FILE_SAVE_ALL": "Сохранить все",
    "CMD_FILE_SAVE_AS": "Сохранить как\u2026",
    "CMD_LIVE_FILE_PREVIEW": "Функция интерактивного просмотра",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE": "Включить экспериментальную функцию интерактивного просмотра",
    "CMD_RELOAD_LIVE_PREVIEW": "Принудительно перезагружать функцию интерактивного просмотра",
    "CMD_PROJECT_SETTINGS": "Настройки проекта\u2026",
    "CMD_FILE_RENAME": "Переименовать",
    "CMD_FILE_DELETE": "Удалить",
    "CMD_INSTALL_EXTENSION": "Установить расширение\u2026",
    "CMD_EXTENSION_MANAGER": "Менеджер расширений\u2026",
    "CMD_FILE_REFRESH": "Обновить дерево проекта",
    "CMD_QUIT": "Выход",
    // Used in native File menu on Windows
    "CMD_EXIT": "Выход",

    // Edit menu commands
    "EDIT_MENU": "Правка",
    "CMD_UNDO": "Отменить",
    "CMD_REDO": "Вернуть",
    "CMD_CUT": "Вырезать",
    "CMD_COPY": "Копировать",
    "CMD_PASTE": "Вставить",
    "CMD_SELECT_ALL": "Выделить все",
    "CMD_SELECT_LINE": "Выделить строку",
    "CMD_SPLIT_SEL_INTO_LINES": "Разбить выделенное на линии",
    "CMD_ADD_CUR_TO_NEXT_LINE": "Добавить курсор к следующей линии",
    "CMD_ADD_CUR_TO_PREV_LINE": "Добавить курсор к предыдущей линии",
    "CMD_INDENT": "Отступ",
    "CMD_UNINDENT": "Убрать отступ",
    "CMD_DUPLICATE": "Дублировать",
    "CMD_DELETE_LINES": "Удалить строку",
    "CMD_COMMENT": "Переключить комментарий строки",
    "CMD_BLOCK_COMMENT": "Переключить комментарий блока",
    "CMD_LINE_UP": "Переместить строку вверх",
    "CMD_LINE_DOWN": "Переместить строку вниз",
    "CMD_OPEN_LINE_ABOVE": "Открыть строку сверху",
    "CMD_OPEN_LINE_BELOW": "Открыть строку снизу",
    "CMD_TOGGLE_CLOSE_BRACKETS": "Автоматически закрывать скобки",
    "CMD_SHOW_CODE_HINTS": "Показывать подсказки в коде",

    // Search menu commands
    "FIND_MENU": "Найти",
    "CMD_FIND": "Найти",
    "CMD_FIND_NEXT": "Найти далее",
    "CMD_SETUP_FIND": "Настройка поиска",
    "CMD_FIND_PREVIOUS": "Найти предыдущие",
    "CMD_FIND_ALL_AND_SELECT": "Найти все и выделить",
    "CMD_ADD_NEXT_MATCH": "Добавить следущее найденное к выделению",
    "CMD_SKIP_CURRENT_MATCH": "Пропустить и добавить следующее найденное",
    "CMD_FIND_IN_FILES": "Найти в файлах",
    "CMD_FIND_IN_SUBTREE": "Найти в\u2026",
    "CMD_REPLACE": "Заменить",
    "CMD_REPLACE_IN_FILES": "Заменить в файлах",
    "CMD_REPLACE_IN_SUBTREE": "Заменить в\u2026",

    // View menu commands
    "VIEW_MENU": "Вид",
    "CMD_HIDE_SIDEBAR": "Скрыть боковую панель",
    "CMD_SHOW_SIDEBAR": "Показать боковую панель",
    "CMD_TOGGLE_SIDEBAR": "Переключить боковую панель",
    "CMD_TOGGLE_PANELS": "Переключить панели",
    "CMD_TOGGLE_PURE_CODE": "Не отвлекать",
    "CMD_INCREASE_FONT_SIZE": "Увеличить размер шрифта",
    "CMD_DECREASE_FONT_SIZE": "Уменьшить размер шрифта",
    "CMD_RESTORE_FONT_SIZE": "Восстановить размер шрифта",
    "CMD_SCROLL_LINE_UP": "Прокрутить на строку вверх",
    "CMD_SCROLL_LINE_DOWN": "Прокрутить на строку вниз",
    "CMD_TOGGLE_LINE_NUMBERS": "Номера строк",
    "CMD_TOGGLE_ACTIVE_LINE": "Подсвечивать активную строку",
    "CMD_TOGGLE_WORD_WRAP": "Переносить по словам",
    "CMD_LIVE_HIGHLIGHT": "Подсвечивать в Live Preview",
    "CMD_VIEW_TOGGLE_INSPECTION": "Анализировать при сохранении",
    "CMD_WORKINGSET_SORT_BY_ADDED": "Сортировать по порядку добавления",
    "CMD_WORKINGSET_SORT_BY_NAME": "Сортировать по имени",
    "CMD_WORKINGSET_SORT_BY_TYPE": "Сортировать по типу",
    "CMD_WORKING_SORT_TOGGLE_AUTO": "Автоматическая сортировка",
    "CMD_THEMES": "Темы\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU": "Навигация",
    "CMD_QUICK_OPEN": "Быстрое открытие",
    "CMD_GOTO_LINE": "Переход на строку",
    "CMD_GOTO_DEFINITION": "Быстрый поиск определения",
    "CMD_GOTO_FIRST_PROBLEM": "Перейти к первой ошибке/предупреждению",
    "CMD_TOGGLE_QUICK_EDIT": "Быстрое редактирование",
    "CMD_TOGGLE_QUICK_DOCS": "Быстрые документы",
    "CMD_QUICK_EDIT_PREV_MATCH": "Предыдущее совпадение",
    "CMD_QUICK_EDIT_NEXT_MATCH": "Следующее совпадение",
    "CMD_CSS_QUICK_EDIT_NEW_RULE": "Создать правило",
    "CMD_NEXT_DOC": "Следующий документ",
    "CMD_PREV_DOC": "Предыдущий документ",
    "CMD_NAVIGATE_BACKWARD": "Перемещение назад",
    "CMD_NAVIGATE_FORWARD": "Перемещение вперед",
    "CMD_NEXT_DOC_LIST_ORDER": "Следующий документ в списке",
    "CMD_PREV_DOC_LIST_ORDER": "Предыдущий документ в списке",
    "CMD_SHOW_IN_TREE": "Показать в дереве проекта",
    "CMD_SHOW_IN_EXPLORER": "Показать в Проводнике",
    "CMD_SHOW_IN_FINDER": "Показать в Finder",
    "CMD_SHOW_IN_OS": "Показать в операционной системе",
    "CMD_SWITCH_PANE_FOCUS": "Переключение области фокусировки",

    // Help menu commands
    "HELP_MENU": "Справка",
    "CMD_CHECK_FOR_UPDATE": "Проверить наличие обновлений",
    "CMD_HOW_TO_USE_BRACKETS": "Как использовать {APP_NAME}",
    "CMD_SUPPORT": "Поддержка {APP_NAME}",
    "CMD_SUGGEST": "Предложить улучшение",
    "CMD_RELEASE_NOTES": "Примечания к выпуску",
    "CMD_GET_INVOLVED": "Принять участие в проекте",
    "CMD_SHOW_EXTENSIONS_FOLDER": "Показать директорию расширений",
    "CMD_HEALTH_DATA_STATISTICS": "Отчет о работоспособности",
    "CMD_HOMEPAGE": "Домашняя страница {APP_TITLE}",
    "CMD_TWITTER": "{TWITTER_NAME} в Twitter",
    "CMD_ABOUT": "О {APP_TITLE}",
    "CMD_OPEN_PREFERENCES": "Открыть файл настроек",
    "CMD_OPEN_KEYMAP": "Открыть список сопоставлений клавиш для пользователя",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD": "Экспериментальная сборка",
    "RELEASE_BUILD": "создание",
    "DEVELOPMENT_BUILD": "Сборка для разработчиков",
    "RELOAD_FROM_DISK": "Перезагрузить с диска",
    "KEEP_CHANGES_IN_EDITOR": "Оставить изменения в редакторе",
    "CLOSE_DONT_SAVE": "Закрыть (Не сохранять)",
    "RELAUNCH_CHROME": "Перезапустить Chrome",
    "ABOUT": "Инфо",
    "CLOSE": "Закрыть",
    "ABOUT_TEXT_LINE1": "sprint {VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP": "создать временную метку: ",
    "ABOUT_TEXT_LINE3": "Внимание, правила и условия, относящиеся к стороннему программному обеспечению находятся на <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> и включены здесь в качестве ссылки.",
    "ABOUT_TEXT_LINE4": "Документация и исходный код находятся на <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>",
    "ABOUT_TEXT_LINE5": "Сделано с \u2764 и на JavaScript:",
    "ABOUT_TEXT_LINE6": "Длинный список инженеров, но, к сожалению, в данный момент мы не можем его показать.",
    "ABOUT_TEXT_MDN_DOCS": "Веб-сайт MDN Docs и графический логотип MDN лицензируются в соответствии с условиями лицензии Creative Commons c указанием авторства, <a href='{MDN_DOCS_LICENSE}'>CC-BY-SA 2.5 Непортированная</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP": "Новая сборка {APP_NAME} доступна! Нажмите здесь для подробностей.",
    "UPDATE_AVAILABLE_TITLE": "Доступно обновление",
    "UPDATE_MESSAGE": "Эй, новая версия {APP_NAME} доступна. Вот некоторые из новых функций:",
    "GET_IT_NOW": "Установить немедленно!",
    "PROJECT_SETTINGS_TITLE": "Настройки проекта для: {0}",
    "PROJECT_SETTING_BASE_URL": "Базовый URL для Live Preview",
    "PROJECT_SETTING_BASE_URL_HINT": "(оставьте пустым для просмотра локальных файлов)",
    "BASEURL_ERROR_INVALID_PROTOCOL": "Протокол {0} не поддерживается Live Preview &mdash; пожалуйста, используйте http: или https: .",
    "BASEURL_ERROR_SEARCH_DISALLOWED": "Базовый URL не может содержать такие параметры поиска как \"{0}\".",
    "BASEURL_ERROR_HASH_DISALLOWED": "Базовый URL не может содержать такие хеши как \"{0}\".",
    "BASEURL_ERROR_INVALID_CHAR": "Специальные символы как '{0}' должны быть %-экранированы.",
    "BASEURL_ERROR_UNKNOWN_ERROR": "Неизвестная ошибка при синтаксическом разборе основного URL",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER": "<em>Открывать файл, когда панель находится в фокусе</em>",
    "FLIPVIEW_BTN_TOOLTIP": "Отразить это отображение на панель {0}",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME": "Текущая тема",
    "USE_THEME_SCROLLBARS": "Использовать полосы прокрутки темы",
    "FONT_SIZE": "Размер шрифта",
    "FONT_FAMILY": "Гарнитура",
    "THEMES_SETTINGS": "Настройки тем",

    // CSS Quick Edit
    "BUTTON_NEW_RULE": "Создать правило",

    // Extension Management strings
    "INSTALL": "Установить",
    "UPDATE": "Обновить",
    "REMOVE": "Удалить",
    "DISABLE": "Отключить",
    "ENABLE": "Включить",
    "OVERWRITE": "Заменить",
    "CANT_REMOVE_DEV": "Расширения, установленные в директории \"dev\", должны удаляться вручную.",
    "CANT_UPDATE": "Это обновление не совместимо с данной версией {APP_NAME}.",
    "CANT_UPDATE_DEV": "Расширения, установленные в директории \"dev\", не могут быть автоматически обновлены.",
    "INSTALL_EXTENSION_TITLE": "Установка расширения",
    "UPDATE_EXTENSION_TITLE": "Обновить расширение",
    "INSTALL_EXTENSION_LABEL": "URL расширения",
    "INSTALL_EXTENSION_HINT": "URL zip-файла расширения или репозитория GitHub",
    "INSTALLING_FROM": "Установка расширения с {0}\u2026",
    "INSTALL_SUCCEEDED": "Установка завершена успешно!",
    "INSTALL_FAILED": "Не удалось установить.",
    "CANCELING_INSTALL": "Отмена\u2026",
    "CANCELING_HUNG": "Отмена установки занимает продолжительное время. Возможно по причине внутренней ошибки.",
    "INSTALL_CANCELED": "Установка отменена.",
    "VIEW_COMPLETE_DESCRIPTION": "Просмотреть готовое описание",
    "VIEW_TRUNCATED_DESCRIPTION": "Просмотреть сокращенное описание",
    "SORT_EXTENSION_METHOD": "Сортировка расширений с помощью downloadCount или publishedDate",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE": "Скачанный файл не является zip-файлом.",
    "MISSING_PACKAGE_JSON": "Пакет не содержит файла package.json.",
    "INVALID_PACKAGE_JSON": "Файл package.json некорректен (ошибка: {0}).",
    "MISSING_PACKAGE_NAME": "Файл package.json не содержит имени пакета.",
    "BAD_PACKAGE_NAME": "{0} не является корректным именем пакета.",
    "MISSING_PACKAGE_VERSION": "Файл package.json не содержит версии пакета.",
    "INVALID_VERSION_NUMBER": "Версия пакета ({0}) некорректна.",
    "INVALID_BRACKETS_VERSION": "Строка совместимости с {APP_NAME} ({0}) некорректна.",
    "DISALLOWED_WORDS": "Слова ({1}) недопустимы в поле {0}.",
    "NPM_INSTALL_FAILED": "не удалось выполнить команду установки npm: {0}",
    "API_NOT_COMPATIBLE": "Расширение несовместимо с данной версией {APP_NAME}. Расширение установлено в директории disabled.",
    "MISSING_MAIN": "Пакет не содержит файл main.js.",
    "EXTENSION_ALREADY_INSTALLED": "Установка данного пакета перезапишет установленное расширение. Перезаписать существующее расширение?",
    "EXTENSION_SAME_VERSION": "Версия данного пакета совпадает с версией установленного расширения. Перезаписать существующее расширение?",
    "EXTENSION_OLDER_VERSION": "Версия данного пакета ({0}) старее версии уставновленного расширения ({1}). Перезаписать существующее расширение?",
    "DOWNLOAD_ID_IN_USE": "Внутренняя ошибка: идентификатор закачки уже используется.",
    "NO_SERVER_RESPONSE": "Невозможно присоединиться к серверу.",
    "BAD_HTTP_STATUS": "Файл не найден на сервере (HTTP {0}).",
    "CANNOT_WRITE_TEMP": "Невозможно сохранить закачку во временный файл.",
    "ERROR_LOADING": "Ошибка при запуске расширения.",
    "MALFORMED_URL": "Некорректный URL. Пожалуйста, убедитесь в его правильности.",
    "UNSUPPORTED_PROTOCOL": "URL должен использовать протокол http or https.",
    "UNKNOWN_ERROR": "Неизвестная внутренняя ошибка.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE": "Extension Manager",
    "EXTENSION_MANAGER_ERROR_LOAD": "Невозможно подсоединиться к каталогу расширений. Пожалуйста, попытайтесь еще раз.",
    "INSTALL_EXTENSION_DRAG": "Перетащите ZIP-файл сюда или",
    "INSTALL_EXTENSION_DROP": "Отпустите ZIP-файл для установки",
    "INSTALL_EXTENSION_DROP_ERROR": "Установка или обновление прекращены из-за следующих ошибок:",
    "INSTALL_FROM_URL": "Установить с URL\u2026",
    "INSTALL_EXTENSION_VALIDATING": "Проверка\u2026",
    "EXTENSION_AUTHOR": "Автор",
    "EXTENSION_DATE": "Дата",
    "EXTENSION_INCOMPATIBLE_NEWER": "Это расширение требует новой версии {APP_NAME}.",
    "EXTENSION_INCOMPATIBLE_OLDER": "Это расширение работает только с предыдущими версиями {APP_NAME}.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER": "Версия {0} данного расширения требует новой версии {APP_NAME}. Вы можете установить предыдущую версию расширения{1}.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER": "Версия {0} данного расширения требует предыдущей версии {APP_NAME}. Вы можете установить предыдущую версию {1}.",
    "EXTENSION_NO_DESCRIPTION": "Описание отсутвует",
    "EXTENSION_MORE_INFO": "Подробнее\u2026",
    "EXTENSION_ERROR": "Ошибка расширения",
    "EXTENSION_KEYWORDS": "Ключевые слова",
    "EXTENSION_TRANSLATED_USER_LANG": "Переведено на {0} языков, в том числе ваш",
    "EXTENSION_TRANSLATED_GENERAL": "Переведено на {0} языков",
    "EXTENSION_TRANSLATED_LANGS": "Это расширение было переведено на следующие языки: {0}",
    "EXTENSION_INSTALLED": "Установлено",
    "EXTENSION_UPDATE_INSTALLED": "Данное расширение было скачано и будет установлено после перегрузки {APP_NAME}.",
    "EXTENSION_SEARCH_PLACEHOLDER": "Поиск",
    "EXTENSION_MORE_INFO_LINK": "Еще",
    "BROWSE_EXTENSIONS": "Просмотреть расширения",
    "EXTENSION_MANAGER_REMOVE": "Удалить расширение",
    "EXTENSION_MANAGER_REMOVE_ERROR": "Невозможно удалить одно или более расширений: {0}. {APP_NAME} продолжит перезагрузку.",
    "EXTENSION_MANAGER_UPDATE": "Обновить расширение",
    "EXTENSION_MANAGER_UPDATE_ERROR": "Невозможно обновить одно или более расширений: {0}. {APP_NAME} продолжит перезагрузку.",
    "EXTENSION_MANAGER_DISABLE": "Отключить расширение",
    "EXTENSION_MANAGER_DISABLE_ERROR": "Не удается отключить одно или несколько расширений: {0}. {APP_NAME} все равно будет перезагружено.",
    "MARKED_FOR_REMOVAL": "Отмечено для удаления",
    "UNDO_REMOVE": "Отменить",
    "MARKED_FOR_UPDATE": "Отмечено для обновления",
    "UNDO_UPDATE": "Отменить",
    "MARKED_FOR_DISABLING": "Отметить для отключения",
    "UNDO_DISABLE": "Отменить",
    "CHANGE_AND_RELOAD_TITLE": "Изменить расширения",
    "CHANGE_AND_RELOAD_MESSAGE": "Для обновления или удаления расширений, {APP_NAME} будет перезагружен. Вам будет предложено сохранить несохраненные изменения.",
    "REMOVE_AND_RELOAD": "Удалить расширения и перегрузиться",
    "CHANGE_AND_RELOAD": "Изменить расширения и перегрузиться",
    "UPDATE_AND_RELOAD": "Обновить расширения и перегрузиться",
    "DISABLE_AND_RELOAD": "Отключить расширения и перезагрузить",
    "PROCESSING_EXTENSIONS": "Обработка изменений в расширениях\u2026",
    "EXTENSION_NOT_INSTALLED": "Невозможно удалить расширение {0}, оно не было установлено.",
    "NO_EXTENSIONS": "Нет установленных расширений.<br>Перейдите на закладку Доступные чтобы начать работу с расширениями.",
    "NO_EXTENSION_MATCHES": "Не найдено расширений по критерию поиска.",
    "REGISTRY_SANITY_CHECK_WARNING": "Будьте осторожны при установке расширений из неизвестных источников.",
    "EXTENSIONS_INSTALLED_TITLE": "Установлено",
    "EXTENSIONS_DEFAULT_TITLE": "По умолч.",
    "EXTENSIONS_AVAILABLE_TITLE": "Доступные",
    "EXTENSIONS_THEMES_TITLE": "Темы",
    "EXTENSIONS_UPDATES_TITLE": "Обновления",
    "EXTENSIONS_LAST_UPDATED": "Последнее обновление",
    "EXTENSIONS_DOWNLOADS": "Загрузки",

    "INLINE_EDITOR_NO_MATCHES": "Совпадений не найдено.",
    "INLINE_EDITOR_HIDDEN_MATCHES": "Все соответствия свернуты. Разверните файлы, перечисленные cправа, для просмотра соответствий.",
    "CSS_QUICK_EDIT_NO_MATCHES": "Существующих правил CSS соответвующих выделенному тексту не определено. <br> Выберите \"Новое правило\" чтобы создать новое.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS": "Ваш проект не содержит таблиц стилей (stylesheets).<br>Создайте его чтобы добавить правила CSS.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON": "наибольший размер",

    /**
     * Unit names
     */
    "UNIT_PIXELS": "Пиксели",

    // extensions/default/DebugCommands
    "DEBUG_MENU": "Отладка",
    "ERRORS": "Ошибки",
    "CMD_SHOW_DEV_TOOLS": "Показать инструменты разработчика",
    "CMD_REFRESH_WINDOW": "Перезагрузить с расширениями",
    "CMD_RELOAD_WITHOUT_USER_EXTS": "Перезагрузить без расширений",
    "CMD_NEW_BRACKETS_WINDOW": "Новое окно {APP_NAME}",
    "CMD_LAUNCH_SCRIPT_MAC": "Установить сочетание клавиш для командной строки",
    "CMD_SWITCH_LANGUAGE": "Переключить язык",
    "CMD_RUN_UNIT_TESTS": "Запустить тесты",
    "CMD_SHOW_PERF_DATA": "Показать данные о производительности",
    "CMD_ENABLE_NODE_DEBUGGER": "Включить отладчик node",
    "CMD_LOG_NODE_STATE": "Отображать состояние node в консоли",
    "CMD_RESTART_NODE": "Перезапустить node",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR": "Показывать ошибки в строке состояния",
    "CMD_OPEN_BRACKETS_SOURCE": "Открыть исходный файл {APP_NAME}",

    "CREATING_LAUNCH_SCRIPT_TITLE": "Сочетание клавиш для командной строки {APP_NAME}",
    "ERROR_CREATING_LAUNCH_SCRIPT": "Произошла ошибка при установке сочетания клавиш для командной строки. Попробуйте использовать <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>данные варианты решения проблемы</a>.<br/><br/>Причина: {0}",
    "ERROR_CLTOOLS_RMFAILED": "Невозможно удалить существующую символическую ссылку <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_MKDIRFAILED": "Невозможно создать каталог <code>/usr/local/bin</code>.",
    "ERROR_CLTOOLS_LNFAILED": "Невозможно создать символическую ссылку <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_SERVFAILED": "Внутренняя ошибка.",
    "ERROR_CLTOOLS_NOTSUPPORTED": "Сочетание клавиш для командной строки не поддерживается данной версией операционной системы.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS": "Успешное завершение! Теперь вы можете легко запускать {APP_NAME} из командной строки: используйте <code>brackets myFile.txt</code> для открытия файла или <code>brackets myFolder</code> для переключения между проектами. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Подробнее</a> об использовании {APP_NAME} из командной строки.",

    "LANGUAGE_TITLE": "Переключить язык",
    "LANGUAGE_MESSAGE": "Язык:",
    "LANGUAGE_SUBMIT": "Перезагрузить {APP_NAME}",
    "LANGUAGE_CANCEL": "Отмена",
    "LANGUAGE_SYSTEM_DEFAULT": "По умолчанию",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION": "Настройки отчета о работоспособности",
    "HEALTH_FIRST_POPUP_TITLE": "Отчет о работоспособности {APP_NAME}",
    "HEALTH_DATA_DO_TRACK": "Отправлять анонимную информацию об использовании {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE": "Чтобы улучшить {APP_NAME}, мы периодически отправляем в Adobe ограниченную, <strong>анонимную</strong> статистику использования {APP_NAME}. Эта информация позволяет нам определить приоритет используемых функций, обнаружить ошибки и недостатки при использовании приложения.<br><br>Вы можете ознакомиться со своими данными или отказаться от их отправки, выбрав пункт <strong>Справка > Отчет о работоспособности</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Подробнее об отчете о работоспособности {APP_NAME}</a>",
    "HEALTH_DATA_PREVIEW": "Отчет о работоспособности {APP_NAME}",
    "HEALTH_DATA_PREVIEW_INTRO": "<p>Чтобы улучшить {APP_NAME}, мы периодически отправляем в Adobe ограниченную, <strong>анонимную</strong> статистику использования {APP_NAME}. Эта информация позволяет нам определить приоритет используемых функций, обнаружить ошибки и недостатки при использовании приложения. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Подробнее об отчете о работоспособности {APP_NAME}</a> и о том, как его использование приносит пользу сообществу {APP_NAME}, защищая при этом вашу конфиденциальность.</p><p>Ниже приведен список данных, которые будут отправлены в вашем следующем отчете о работоспособности, <em>если</em> такая возможность будет включена.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME": "Время",
    "INLINE_TIMING_EDITOR_PROGRESSION": "Прогресс",
    "BEZIER_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Передвинуть выделенную точку<br><kbd class='text'>Shift</kbd> Передвинуться на десять единиц<br><kbd class='text'>Tab</kbd> Переключиться между точками",
    "STEPS_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd> Увеличить или уменьшить шаги<br><kbd>←</kbd><kbd>→</kbd> 'Начало' или 'Конец'",
    "INLINE_TIMING_EDITOR_INVALID": "Старое значение <code>{0}</code> некорректно, отображаемая функция была заменена на <code>{1}</code>. Документ будет обновлен с первой правкой.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP": "Текущий цвет",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP": "Оригинальный цвет",
    "COLOR_EDITOR_RGBA_BUTTON_TIP": "RGBa формат",
    "COLOR_EDITOR_HEX_BUTTON_TIP": "Hex формат",
    "COLOR_EDITOR_HSLA_BUTTON_TIP": "HSLa формат",
    "COLOR_EDITOR_0X_BUTTON_TIP": "Формат Hex (0x)",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR": "{0} (Использовано {1} раз)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL": "{0} (Использовано {1} раза)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION": "Перейти к определению",
    "CMD_SHOW_PARAMETER_HINT": "Показывать подсказки по аргументам функции",
    "NO_ARGUMENTS": "<нет аргументов>",
    "DETECTED_EXCLUSION_TITLE": "Проблема вывода файла JavaScript",
    "DETECTED_EXCLUSION_INFO": "Приложение {APP_NAME} столкнулось с ошибками при обработке файла <span class='dialog-filename'>{0}</span>.<br><br>Данный файл больше не будет обрабатываться для отображения подсказок по коду и использования функций перехода к определению и быстрого редактирования. Чтобы обеспечить возможность повторной обработки этого файла, откройте в проекте файл <code>.brackets.json</code> и измените значение атрибута <code>jscodehints.detectedExclusions</code>.<br><br>Скорее всего, это связано с ошибкой в {APP_NAME}. Если вы можете предоставить копию этого файла, отправьте <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>нам письмо с описанием ошибки</a>, содержащее ссылку на упомянутый файл.",

    // extensions/default/JavascriptRefactoring
    "CMD_REFACTOR": "Рефакторинг",
    "CMD_EXTRACTTO_VARIABLE": "Извлечь в переменную",
    "CMD_EXTRACTTO_FUNCTION": "Извлечь в функцию",
    "ERROR_TERN_FAILED": "Не удалось получить данные от Tern",
    "ERROR_EXTRACTTO_VARIABLE_NOT_VALID": "Выделенный фрагмент не образует выражения",
    "ERROR_EXTRACTTO_FUNCTION_NOT_VALID": "Выбранный блок должен представлять собой набор операторов или выражение",
    "ERROR_EXTRACTTO_VARIABLE_MULTICURSORS": "Извлечение в переменную не работает для мультикурсоров",
    "ERROR_EXTRACTTO_FUNCTION_MULTICURSORS": "Извлечение в функцию не работает для мультикурсоров",
    "EXTRACTTO_FUNCTION_SELECT_SCOPE": "Выберите выходной диапазон",
    "EXTRACTTO_VARIABLE_SELECT_EXPRESSION": "Выберите выражение",
    "CMD_REFACTORING_RENAME": "Переименовать",
    "CMD_REFACTORING_TRY_CATCH": "Перенести в Try Catch",
    "CMD_REFACTORING_CONDITION": "Перенести в Condition",
    "CMD_REFACTORING_GETTERS_SETTERS": "Создать Getters Setters",
    "CMD_REFACTORING_ARROW_FUNCTION": "Преобразовать в функцию стрелки",
    "DESCRIPTION_CODE_REFACTORING": "Включить/отключить рефакторинг по коду JavaScript",
    "ERROR_TRY_CATCH": "Выберите допустимый код для переноса в блок Try-catch",
    "ERROR_WRAP_IN_CONDITION": "Выберите допустимый код для переноса в блок Condition",
    "ERROR_ARROW_FUNCTION": "Поместите курсор внутри функционального выражения",
    "ERROR_GETTERS_SETTERS": "Поместите курсор в элемент member выражения объекта",
    "ERROR_RENAME_MULTICURSOR": "Не удалось переименовать при использовании мультикурсоров",
    "ERROR_RENAME_QUICKEDIT": "Не удалось переименовать этот идентификатор, поскольку на него есть ссылка в другом месте вне этой функции",
    "ERROR_RENAME_GENERAL": "Не удалось переименовать выделенный текст",

    // extensions/default/JSLint
    "JSLINT_NAME": "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW": "Быстрый просмотр при наведении",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS": "Предыдущие проекты",

    // extensions/default/MDNDocs
    "DOCS_MORE_LINK": "Подробнее",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL": "Свернуть все",
    "EXPAND_ALL": "Развернуть все",
    "COLLAPSE_CURRENT": "Свернуть текущий",
    "EXPAND_CURRENT": "Развернуть текущий",

    // extensions/default/NavigationAndHistory
    "RECENT_FILES_DLG_HEADER": "Последние файлы",
    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL": "Очистить",
    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE": "Снимите флажки с файлов, которые не находятся в рабочем наборе",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS": "true для автоматического закрытия фигурных, квадратных и круглых скобок",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE": "false для удаления пункта «Закрыть другие выше» из контекстного меню «Рабочие файлы»",
    "DESCRIPTION_CLOSE_OTHERS_BELOW": "false для удаления пункта «Закрыть другие ниже» из контекстного меню «Рабочие файлы»",
    "DESCRIPTION_CLOSE_OTHERS": "false для удаления пункта «Закрыть другие» из контекстного меню «Рабочие файлы»",
    "DESCRIPTION_CLOSE_TAGS": "Задает параметры закрытия тегов",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS": "Набор тегов, которые не должны закрываться автоматически",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING": "Закрывать при вводе символа > открывающего тега",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING": "Закрывать при вводе символа / закрывающего тега",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS": "Набор тегов, которые при открытии содержат пустую строку",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD": "true, чтобы всегда генерировать маркеры сворачиваемого раздела при изменении уровня отступа",
    "DESCRIPTION_CODE_FOLDING_ENABLED": "true, чтобы включить свертывание кода",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER": "true, чтобы сделать маркеры сворачиваемого раздела видимыми только при перемещении курсора мыши над средником",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL": "Ограничивает количество уровней, на которое применяется функция «Свернуть все»",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE": "Минимальное количество строк, при котором появляется значок сворачиваемого раздела",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES": "true, чтобы запоминать свернутые разделы при закрытии и повторном открытии файла или проекта",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "true, чтобы включить свертывание кода для выделенного текста в редакторе",
    "DESCRIPTION_DISABLED_DEFAULT_EXTENSIONS": "Отключенные расширения, заданные по умолчанию",
    "DESCRIPTION_ATTR_HINTS": "Включить/отключить подсказки атрибутов HTML",
    "DESCRIPTION_CSS_PROP_HINTS": "Включить/отключить подсказки свойств CSS/LESS/SCSS",
    "DESCRIPTION_JS_HINTS": "Включить/отключить подсказки по коду JavaScript",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS": "Включить/отключить информацию о типе данных в подсказках по коду JavaScript",
    "DESCRIPTION_PREF_HINTS": "Включить/отключить подсказки по коду настроек",
    "DESCRIPTION_SPECIAL_CHAR_HINTS": "Включить/отключить подсказки в сущностях HTML",
    "DESCRIPTION_SVG_HINTS": "Включить/отключить подсказки по коду SVG",
    "DESCRIPTION_HTML_TAG_HINTS": "Включить/отключить подсказки в тегах HTML",
    "DESCRIPTION_URL_CODE_HINTS": "Включить/отключить подсказки в URL-адресах в HTML и CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT": "Включить/отключить функциональность перетаскивания",
    "DESCRIPTION_HEALTH_DATA_TRACKING": "Включить отслеживание данных о работоспособности",
    "DESCRIPTION_HIGHLIGHT_MATCHES": "Включить автоматическое выделение соответствующих строк по всему документу",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN": "Выделить все строки, соответствующие маркеру, в котором находится курсор (выделение не требуется)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY": "Выделять только в том случае, когда выделенная область является полным маркером",
    "DESCRIPTION_INSERT_HINT_ON_TAB": "true, чтобы вставлять подсказку по выбранному коду на вкладку",
    "DESCRIPTION_NO_HINTS_ON_DOT": "true, чтобы не показывать автоматически подсказки по коду JS при вводе символа .",
    "DESCRIPTION_JSLINT_OPTIONS": "Объект с параметрами по умолчанию для JSLint",
    "DESCRIPTION_JSLINT_OPTIONS_ASS": "true, чтобы разрешить выражения присваивания",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE": "true, чтобы разрешить побитовые операторы",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER": "true, если необходимо предварительно задать стандартные глобальные настройки поиска",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE": "true, чтобы разрешить использование выражений Google Closure",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE": "true, чтобы разрешить оператор continue",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH": "true, если необходимо предварительно задать глобальные настройки CouchDB",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG": "true, чтобы разрешить использование операторов отладчика",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL": "true, если необходимо предварительно задать глобальные настройки поиска, используемые при разработке",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ": "true, чтобы разрешить операторы == и !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6": "true, если необходимо предварительно задать глобальные настройки ES6",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL": "true, чтобы разрешить оператор eval",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN": "true, чтобы разрешить использование for... in без фильтра",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT": "Выбор произвольной ширины вкладки",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR": "Максимальное число отображаемых предупреждений",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN": "Максимальное число символов на строку текста",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP": "true, чтобы разрешить использование строчных букв в начале имен конструкторов",
    "DESCRIPTION_JSLINT_OPTIONS_NODE": "true, если необходимо предварительно задать глобальные настройки Node.js",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN": "true, чтобы разрешить использование символа подчеркивания в начале идентификаторов",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL": "true, чтобы останавливать программу при первой ошибке",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS": "true, чтобы разрешить операторы ++ и --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP": "true, чтобы разрешить использование конструкций . and [^...]. в регулярных выражениях RegExp",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO": "true, если необходимо предварительно задать глобальные настройки Rhino",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY": "true, чтобы разрешить отсутствие директивы use strict",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID": "true, если могут использоваться блокирующие методы ('...Sync').",
    "DESCRIPTION_JSLINT_OPTIONS_SUB": "true, чтобы разрешить менее эффективную индексацию при обращении к членам объекта",
    "DESCRIPTION_JSLINT_OPTIONS_TODO": "true, чтобы разрешить использование комментариев TODO",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM": "true, чтобы разрешить неиспользуемые параметры",
    "DESCRIPTION_JSLINT_OPTIONS_VARS": "true, чтобы разрешить использование более одной переменной в функции",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE": "true, чтобы игнорировать правила использования пробельных символов",
    "DESCRIPTION_LANGUAGE": "Языковые параметры",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS": "Дополнительные сопоставления расширений файлов и названий языков",
    "DESCRIPTION_LANGUAGE_FILE_NAMES": "Дополнительные сопоставления имен файлов и названий языков",
    "DESCRIPTION_LINEWISE_COPY_CUT": "При выполнении операций копирования/вырезания и отсутствии выделенной области будут целиком скопированы/вырезаны строки, содержащие курсоры",
    "DESCRIPTION_INPUT_STYLE": "Выбирает способ, которым CodeMirror обрабатывает входящие данные и фокус. Варианты: textarea (установлено по умолчанию) или contenteditable, что предпочтительно для чтения с экрана (нестабильно).",
    "DESCRIPTION_LINTING_ENABLED": "true, чтобы включить функцию инспекции кода",
    "DESCRIPTION_ASYNC_TIMEOUT": "Тайм-аут ожидания асинхронного средства lint в миллисекундах",
    "DESCRIPTION_LINTING_PREFER": "Набор проверок инструмента lint для первоначального запуска",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER": "true, чтобы включить экспериментальную функцию интерактивного просмотра",
    "DESCRIPTION_USE_PREFERED_ONLY": "true, чтобы запускать только поставщиков, указанных в файле linting.prefer",
    "DESCRIPTION_MAX_CODE_HINTS": "Максимальное число подсказок по коду для одновременного отображения",
    "DESCRIPTION_PATH": "Параметры пути",
    "DESCRIPTION_PROXY": "URL-адрес прокси-сервера, используемого для установки расширения",
    "DESCRIPTION_SCROLL_PAST_END": "true, чтобы включить прокрутку после окончания документа",
    "DESCRIPTION_SHOW_CODE_HINTS": "false, чтобы отключить все подсказки по коду",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING": "Делает постоянно мигающий курсор видимым при выделении текстовой области",
    "DESCRIPTION_SHOW_LINE_NUMBERS": "true, чтобы показывать номера строк в «среднике» слева от кода",
    "DESCRIPTION_SMART_INDENT": "Автоматически формировать отступ при создании нового блока",
    "DESCRIPTION_SOFT_TABS": "false, чтобы использовать символы табуляции вместо пробелов",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST": "true, чтобы сначала сортировать каталоги в дереве проекта",
    "DESCRIPTION_SPACE_UNITS": "Количество пробелов, используемых для отступов",
    "DESCRIPTION_STATIC_SERVER_PORT": "Номер порта, который будет использоваться встроенным сервером для функции интерактивного просмотра",
    "DESCRIPTION_STYLE_ACTIVE_LINE": "true, чтобы выделять цвет фона строки, на которой находится курсор",
    "DESCRIPTION_TAB_SIZE": "Количество пробелов для отображения вместо символов табуляции",
    "DESCRIPTION_USE_TAB_CHAR": "true, чтобы использовать символы табуляции вместо пробелов",
    "DESCRIPTION_UPPERCASE_COLORS": "true, чтобы генерировать шестнадцатеричные значения цвета в верхнем регистре во встроенном редакторе цветов",
    "DESCRIPTION_WORD_WRAP": "Выполняет перенос по словам строк, ширина которых превышает ширину области просмотра",
    "DESCRIPTION_DETECTED_EXCLUSIONS": "Список обнаруженных файлов, которые приводят к некорректной работе инструмента Tern",
    "DESCRIPTION_INFERENCE_TIMEOUT": "Период времени, после которого инструмент Tern прекращает попытку обработки файлов",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR": "true, чтобы отображать ошибки в строке состояния",
    "DESCRIPTION_QUICK_VIEW_ENABLED": "true, чтобы включить функцию быстрого просмотра",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW": "true, чтобы показывать изображения предварительного просмотра для URL-адресов с отсутствующими расширениями",
    "DESCRIPTION_THEME": "Выберите тему {APP_NAME}",
    "DESCRIPTION_USE_THEME_SCROLLBARS": "true, чтобы разрешить использование пользовательских полос прокрутки",
    "DESCRIPTION_LINTING_COLLAPSED": "true, чтобы сворачивать панель инструмента lint",
    "DESCRIPTION_FONT_FAMILY": "Изменить гарнитуру шрифта",
    "DESCRIPTION_FONT_SIZE": "Изменить размер шрифта, например 13px",
    "DESCRIPTION_FIND_IN_FILES_NODE": "true, чтобы включить поиск на основе узлов",
    "DESCRIPTION_FIND_IN_FILES_INSTANT": "true, чтобы включить мгновенный поиск",
    "DESCRIPTION_FONT_SMOOTHING": "Только для Mac OS: значение subpixel-antialiased, чтобы включить сглаживание субпикселей, или значение antialiased для сглаживания на основе серой шкалы",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW": "false, чтобы отключить открытие файла с настройками в разделенном представлении",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE": "false, чтобы открывать файл с настройками пользователя на левой верхней панели",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED": "true, чтобы сворачивать панели после закрытия последнего файла на них посредством кнопки закрытия в заголовке панели",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS": "Переключать режим отображения кнопок закрытия и отражения отображения в заголовке.",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT": "/*\n * Этот файл только для чтения и содержит\n * поддерживаемые {APP_NAME} настройки.\n * Используйте данный файл как образец для изменения своего файла\n * brackets.json с настройками, открытого на другой панели.\n * Для получения дополнительных сведений по использованию настроек внутри\n * {APP_NAME} ознакомьтесь с веб-страницей по адресу https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT": "По умолч.",
    "DESCRIPTION_PURE_CODING_SURFACE": "true, чтобы включить режим «только код» и скрыть все другие элементы пользовательского интерфейса в {APP_NAME}",
    "DESCRIPTION_INDENT_LINE_COMMENT": "true, чтобы включить отступ для строчных комментариев",
    "DESCRIPTION_RECENT_FILES_NAV": "Включить/отключить навигацию в последних файлах",
    "DESCRIPTION_LIVEDEV_WEBSOCKET_PORT": "Порт, на котором работает сервер WebSocket для интерактивного просмотра.",
    "DESCRIPTION_LIVE_DEV_HIGHLIGHT_SETTINGS": "Настройки подсветки функции интерактивного просмотра",
    "DESCRIPTION_LIVEDEV_ENABLE_REVERSE_INSPECT": "Ошибка отключения предварительного интерактивного просмотра",
    "DESCRIPTION_PHP_HINTS": "Включить/отключить подсказки по коду php",
    "BROWSE_COMMAND_STRING": " Обзор...",

    "COLOR_PICKER_CMD_STRING": " Палитра цветов...",
    "CHOOSE_ANOTHER_CC_LIBARAY": "Изменить библиотеку",
    "EXTRACT_INSERT_SELECTED": " Вставить выбранное",
    "DESCRIPTION_EMMET_PREFS": "Включить/отключить emmet",
    "IMAGE_NOT_FOUND_ERR": "Изображение не найдено",
    "REFRESH_STYLE_STRING": "Обновить список стилей..."
});
