define(function (require, exports) {
    "use strict";

    /**
     * List of Events used in communicating between DW and extension
     */

    // Events from extension to DW
    exports.DW_GIT_INIT = "dw.gitInit";
    exports.DW_GIT_DIALOG_INIT = "dw.gitDialogInit";
    exports.DW_GIT_STATUS = "dw.gitStatus";
    exports.DW_GIT_REFRESH = "dw.gitRefresh";
    exports.DW_GIT_FILE_OPEN = "dw.gitFileOpen";
    exports.DW_GIT_FILE_STATUS = "dw.gitFileStatus";
    exports.DW_GIT_DIALOG_SHOWN = "dw.gitDialogShown";
    exports.DW_GIT_DIFF_FILE = "dw.gitDiffFile";
    exports.DW_GIT_DIALOG_CLOSED = "dw.gitDialogClosed";
    exports.DW_GIT_COMMIT = "dw.gitCommit";
    exports.DW_GIT_UPDATE_DW = "dw.gitUpdateDW";
    exports.DW_GIT_SHOW_ERROR = "dw.gitShowError";
    exports.DW_GIT_TERMINAL_ERROR = "dw.gitTerminalError";
    exports.DW_GIT_REVERT_FILE = "dw.gitRevertFile";
    exports.DW_GIT_DELETE_FILE = "dw.gitDeleteFile";
    exports.DW_GIT_FETCH = "dw.gitFetch";
    exports.DW_GIT_SHOW_PROGRESS = "dw.gitShowProgress";
    exports.DW_GIT_PULL = "dw.gitPull";
    exports.DW_GIT_PUSH = "dw.gitPush";
    exports.DW_GIT_HISTORY = "dw.gitHistory";
    exports.DW_GIT_RESET_LOCAL_REPO = "dw.gitResetLocalRepo";
    exports.DW_GIT_CREATE_TAG = "dw.gitCreateTag";
    exports.DW_GIT_MANAGE_REMOTES = "dw.gitManageRemotes";
    exports.DW_GIT_ADD_REMOTE = "dw.gitAddRemote";
    exports.DW_GIT_REMOTES_UPDATE = "dw.gitRemotesUpdate";
    exports.DW_GIT_CLONE_ERROR = "dw.gitCloneError";
    exports.DW_GIT_STORE_REMOTE_CREDENTIALS = "dw.gitStoreCredentials";
    exports.DW_GIT_REMOVE_REMOTE_CREDENTAILS = "dw.gitRemoveCredentials";
    exports.DW_GIT_CREATE_GITIGNORE = "dw.gitCreateGitignore";
    exports.DW_GIT_CONFIG_PATH = "dw.getGitPath";
    exports.DW_GIT_USER_DETAILS_MISSING = "dw.gitDetailsMissing";
    exports.DW_GIT_REMOVE_SITE_REMOTES_CREDENTIALS = "dw.gitRemoveSiteCredentials";
    exports.DW_GIT_PREFERENCE_TERMINAL = "dw.gitPreferenceTerminal";
    exports.DW_GIT_REFRESH_GUTTERMARKS = "dw.gitRefreshGutterMarks";
    exports.DW_GIT_OPERATION_DONE = "dw.gitOperationDone";
    exports.DW_GIT_OPERATION_ERROR = "dw.gitOperationError";
    exports.DW_GIT_REPO_CREATED = "dw.gitRepoCreated";
    exports.DW_GIT_CONNECTED_TO_REMOTE = "dw.gitConnectedToRemote";

    //Events from DW to Extension
    exports.ADD_TO_GIT_IGNORE = "dwgit.addToIgnore";
    exports.REMOVE_FROM_GIT_IGNORE = "dwgit.removeFromIgnore";
    exports.SET_GIT_ROOT = "dwgit.setRoot";
    exports.REFRESH_PANEL = "dwgit.refreshPanel";
    exports.STAGE = "dwgit.stage";
    exports.UNSTAGE = "dwgit.unstage";
    exports.DIFF = "dwgit.diff";
    exports.FILE_HISTORY = "dwgit.fileHistory";
    exports.REPO_HISTORY = "dwgit.repoHistory";
    exports.COMMIT = "dwgit.commit";
    exports.COMMIT_MERGE = "dwgit.commitMerge";
    exports.UPDATE_FILE_STATUS = "dwgit.updateFileStatus";
    exports.CHANGE_BRANCH = "dwgit.changeBranch";
    exports.OPEN_TERMINAL = "dwgit.openGitTerminal";
    exports.CREATE_NEW_BRANCH = "dwgit.createNewBranch";
    exports.MERGE_BRANCH = "dwgit.mergeBranch";
    exports.DELETE_BRANCH = "dwgit.deleteBranch";
    exports.CANCEL_DIALOG = "dwgit.cancelDialog";
    exports.STAGE_ALL = "dwgit.stageAll";
    exports.UNSTAGE_ALL = "dwgit.unstageAll";
    exports.INITIALIZE_GIT = "dwgit.initializeGit";
    exports.SHOW_ERROR = "dwgit.showError";
    exports.RELOAD_PREFERENCES = "dwgit.reloadPreferences";
    exports.REVERT_FILE = "dwgit.revertFile";
    exports.SET_GIT_PATH = "dwgit.setGitPath";
    exports.FETCH_REMOTE = "dwgit.fetchRemote";
    exports.PULL_FROM_REMOTE = "dwgit.pullFromRemote";
    exports.PUSH_TO_REMOTE = "dwgit.pushToRemote";
    exports.RESET_LOCAL_REPO = "dwgit.resetLocalRepo";
    exports.CLONE_REPO = "dwgit.cloneRepo";
    exports.CREATE_TAG = "dwgit.createTag";
    exports.ADD_REMOTE = "dwgit.addRemote";
    exports.DELETE_REMOTE = "dwgit.deleteRemote";
    exports.SET_USER_DETAILS = "dwgit.setUserDetails";
    exports.SITE_DELETED = "dwgit.siteDeleted";
    exports.UPDATE_THEME = "dwgit.updateTheme";
    exports.SET_APP_FONT = "dwgit.setAppFont";
    exports.TEST_REMOTE = "dwgit.testRemote";
});
