$rubydir = split-path $MyInvocation.MyCommand.Definition -parent

# Execute 'enable' and 'disable' in the context of the current powershell session, so that env vars are effective for subsequent commands.
if ($args[0] -eq "enable" -or $args[0] -eq "disable") {
  $rubyfile = $rubydir + "/ruby"
  $op = $args[0] + "ps1"
  $vars = & $rubyfile --disable-gems -x $MyInvocation.MyCommand.Definition $op
  Invoke-Expression $vars
  exit $LastExitCode
}

# Forward 'use' to the script in ridk_use 
if ($args[0] -eq "use") {
  $ridkfile = $rubydir + "/../ridk_use/ridk.ps1"
  . $ridkfile @args
  exit $LastExitCode
}

# Pass all other commands through to ridk.cmd, so that a separate context for env vars is used.
$cmdfile = $rubydir + "/ridk.cmd"
& $cmdfile @args
exit $LastExitCode

#!/mingw64/bin/ruby
require "ruby_installer/runtime"
RubyInstaller::Runtime::Ridk.run!(ARGV)

# SIG # Begin signature block
# MIIeSwYJKoZIhvcNAQcCoIIePDCCHjgCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDd/mmNIsMayoO3
# vAOzdwy9c/4nz5MrgrHIeU/F+aY4aKCCDIQwggXAMIIEqKADAgECAhAJrV4a8TpO
# SmkLZrmo7iF1MA0GCSqGSIb3DQEBCwUAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xKzApBgNV
# BAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmluZyBDQSAoU0hBMikwHhcNMTkwMTMx
# MDAwMDAwWhcNMjEwMjA0MTIwMDAwWjCB1jETMBEGCysGAQQBgjc8AgEDEwJVUzEZ
# MBcGCysGAQQBgjc8AgECEwhEZWxhd2FyZTEdMBsGA1UEDwwUUHJpdmF0ZSBPcmdh
# bml6YXRpb24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVTMQswCQYDVQQI
# EwJjYTERMA8GA1UEBxMIU2FuIEpvc2UxEzARBgNVBAoTCkFkb2JlIEluYy4xHDAa
# BgNVBAsME0VkZ2UsIMKgRHJlYW13ZWF2ZXIxEzARBgNVBAMTCkFkb2JlIEluYy4w
# ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDCBmy6qRxqZYcXwi4COqwj
# iK2XmpZtqaGMAb5OHuVviJgvrUyp3YlscA07rQFia857d7trjcYT7RbTrPhqoGYM
# 7Z4XEM/k377NnD8NBpNOtojM6NbWyvWHa49VLvgT2kbowoB1A8d8HlnMak9k5E1T
# WmBS6tjUONogEPjSU1aimYAgL/CyRTr5viXY7uaIdIiU+Wh1QFGmw0EUP1S2uqWO
# itmiV+wA0mAYwM5oJF3GwC34ntxDQ+wmOAsgse8DK+xjKos3wxzTB5c6gMlnWz4A
# SOWYC2DZGpmkSeybpcKkFsyZtk0yesswJvUVrTOgNiBNZJ6EEr9yc5m7E9FMHE0Z
# AgMBAAGjggHxMIIB7TAfBgNVHSMEGDAWgBSP6H7wbTJqAAUjx3CXajqQ/2vq1DAd
# BgNVHQ4EFgQUzCFUKJoVlP1lAIHxZ5UphbGHns8wLgYDVR0RBCcwJaAjBggrBgEF
# BQcIA6AXMBUME1VTLURFTEFXQVJFLTI3NDgxMjkwDgYDVR0PAQH/BAQDAgeAMBMG
# A1UdJQQMMAoGCCsGAQUFBwMDMHsGA1UdHwR0MHIwN6A1oDOGMWh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9FVkNvZGVTaWduaW5nU0hBMi1nMS5jcmwwN6A1oDOGMWh0
# dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9FVkNvZGVTaWduaW5nU0hBMi1nMS5jcmww
# SwYDVR0gBEQwQjA3BglghkgBhv1sAwIwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAHBgVngQwBAzB+BggrBgEFBQcBAQRyMHAwJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBIBggrBgEFBQcwAoY8
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0RVZDb2RlU2lnbmlu
# Z0NBLVNIQTIuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggEBAAB7
# 5Bgah3TSfexnlimC1IXftPRup0FnE/RGBts9G9uLwOYSPhAYDuUFmgkWiUFqsTMz
# HQwjHitReOuH5O/2zVi14pnfKNH8CC3f8EdZYKuqji5F6fV2vUM+gwv3DJMiHhZb
# 7bmEFxOJJeFuNipGThUvRRJlMMXnaGOzbLVVHUHRnUUoJrPqaO3cjfhsklcRID2x
# BpsXyud7qbycmNaCnbYZ+SSBVeZXfFuVchrSQYgmWfC4gx+dnsbY3kyG8HY/kfJR
# TqoMOW28Qq5VN/qWk3N+Lsi0lCDZ9oeGd8PNphD2AoPI6k4rGxHNKmFWPOYQ2R3/
# PAezXPFbm8DShOxlM98wgga8MIIFpKADAgECAhAD8bThXzqC8RSWeLPX2EdcMA0G
# CSqGSIb3DQEBCwUAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xKzApBgNVBAMTIkRpZ2lDZXJ0
# IEhpZ2ggQXNzdXJhbmNlIEVWIFJvb3QgQ0EwHhcNMTIwNDE4MTIwMDAwWhcNMjcw
# NDE4MTIwMDAwWjBsMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
# MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2VydCBF
# ViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
# MIIBCgKCAQEAp1P6D7K1E/Fkz4SA/K6ANdG218ejLKwaLKzxhKw6NRI6kpG6V+TE
# yfMvqEg8t9Zu3JciulF5Ya9DLw23m7RJMa5EWD6koZanh08jfsNsZSSQVT6hyiN8
# xULpxHpiRZt93mN0y55jJfiEmpqtRU+ufR/IE8t1m8nh4Yr4CwyY9Mo+0EWqeh6l
# WJM2NL4rLisxWGa0MhCfnfBSoe/oPtN28kBa3PpqPRtLrXawjFzuNrqD6jCoTN7x
# CypYQYiuAImrA9EWgiAiduteVDgSYuHScCTb7R9w0mQJgC3itp3OH/K7IfNs29iz
# GXuKUJ/v7DYKXJq3StMIoDl5/d2/PToJJQIDAQABo4IDWDCCA1QwEgYDVR0TAQH/
# BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
# fwYIKwYBBQUHAQEEczBxMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2Vy
# dC5jb20wSQYIKwYBBQUHMAKGPWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9E
# aWdpQ2VydEhpZ2hBc3N1cmFuY2VFVlJvb3RDQS5jcnQwgY8GA1UdHwSBhzCBhDBA
# oD6gPIY6aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0SGlnaEFzc3Vy
# YW5jZUVWUm9vdENBLmNybDBAoD6gPIY6aHR0cDovL2NybDQuZGlnaWNlcnQuY29t
# L0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENBLmNybDCCAcQGA1UdIASCAbsw
# ggG3MIIBswYJYIZIAYb9bAMCMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3dy5k
# aWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUFBwIC
# MIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUAcgB0
# AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMAYwBl
# AHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQAIABD
# AFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAAUABh
# AHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkAbQBp
# AHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4AYwBv
# AHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYAZQBy
# AGUAbgBjAGUALjAdBgNVHQ4EFgQUj+h+8G0yagAFI8dwl2o6kP9r6tQwHwYDVR0j
# BBgwFoAUsT7DaQP4v0cB1JgmGggC72NkK8MwDQYJKoZIhvcNAQELBQADggEBABkz
# SgyBMzfbrTbJ5Mk6u7UbLnqi4vRDQheev06hTeGx2+mB3Z8B8uSI1en+Cf0hwexd
# gNLw1sFDwv53K9v515EzzmzVshk75i7WyZNPiECOzeH1fvEPxllWcujrakG9HNVG
# 1XxJymY4FcG/4JFwd4fcyY0xyQwpojPtjeKHzYmNPxv/1eAal4t82m37qMayOmZr
# ewGzzdimNOwSAauVWKXEU1eoYObnAhKguSNkok27fIElZCG+z+5CGEOXu6U3Bq9N
# /yalTWFL7EZBuGXOuHmeCJYLgYyKO4/HmYyjKm6YbV5hxpa3irlhLZO46w4EQ9f1
# /qbwYtSZaqXBwfBklIAxghEdMIIRGQIBATCBgDBsMQswCQYDVQQGEwJVUzEVMBMG
# A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSsw
# KQYDVQQDEyJEaWdpQ2VydCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpAhAJrV4a
# 8TpOSmkLZrmo7iF1MA0GCWCGSAFlAwQCAQUAoIGiMBkGCSqGSIb3DQEJAzEMBgor
# BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3
# DQEJBDEiBCCppWMFhawwRdn6AWdIGguNIwQgbsSsyCO9dNySM4I1sTA2BgorBgEE
# AYI3AgEMMSgwJqAkgCIAQQBkAG8AYgBlACAARAByAGUAYQBtAHcAZQBhAHYAZQBy
# MA0GCSqGSIb3DQEBAQUABIIBAE4fkbe4sU3J0AmRJwVVIagWWIX/cQx9CySeTT/V
# E+moTvyZaYaJU1KhB8Nejqx8cxXQNzgdKRUQRugQC+0TWVCy+KDm55N9DNSgXt/x
# GSB9hcWU+q5iJj8EcnnVx3tFV77DdArndCCk2OB15sPAIl03ME3sjVBDZeueizx6
# PcWlIr3IXe0r7dwcspZ4pnsu32TnyemSkAQNs5Sym7bgiIpLe5UOALYRB9gujGDI
# 6N5FJIur5YAjDPQXRenVP355kVWkYKcqpGIFskPBOk+1gch1vvt0nqASxr8wXyZK
# lVmVkpjdr8VhzsJ4LKDhX38+UWgZUgkqr06tL1JlXDH9ssyhgg7IMIIOxAYKKwYB
# BAGCNwMDATGCDrQwgg6wBgkqhkiG9w0BBwKggg6hMIIOnQIBAzEPMA0GCWCGSAFl
# AwQCAQUAMHcGCyqGSIb3DQEJEAEEoGgEZjBkAgEBBglghkgBhv1sBwEwMTANBglg
# hkgBZQMEAgEFAAQgPfRtHUeR7I52pt1oAlHsEWMMNWWvpxfM79a9XToSBwwCEDqZ
# SfQTe2qNikMqEFNl3YQYDzIwMjAwOTE3MjA1NTAwWqCCC7swggaCMIIFaqADAgEC
# AhAEzT+FaK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVT
# MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
# b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1lc3RhbXBp
# bmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAxMDE3MDAwMDAwWjBMMQswCQYDVQQG
# EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVTVEFN
# UC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
# ggEBAOlkNZz6qZhlZBvkF9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
# CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xFfpRtrAMBmTxiPn56/UWX
# MbT6t9lCPqdVm99aT1gCqDJpIhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKh
# FKX4+uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxOzcbVsmVZIeB8LBKN
# cA6Pisrg09ezOXdQ0EIsLnrOnGd6OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8f
# cMbuQhZTNkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1UdDwEB/wQEAwIH
# gDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0g
# BIIBtjCCAbIwggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxodHRwczov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYIKwYBBQUHAgIwggFWHoIBUgBBAG4A
# eQAgAHUAcwBlACAAbwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBhAHQA
# ZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEAbgBjAGUA
# IABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
# YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABBAGcA
# cgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIA
# aQBsAGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
# ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsG
# CWCGSAGG/WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWyyBc1bjAdBgNV
# HQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTsnsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmwwMqAwoC6G
# LGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtdHMuY3JsMIGF
# BggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
# AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3YkqHmRhxKL256PGNuNxej
# Gr9YI7JDnJSDTjkJsCzox+HizO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/B
# jdEhjOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iCgy1tE0Kug8EQTqQk
# 9Eec3g8icndcf0/pOZgrV5JE1+9uk9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X
# /AqfI1579JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18zMGBV9fxrMKyh
# 7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm09zCCBTEwggQZoAMCAQICEAqhJdbWMht+
# QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
# DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIGA1UE
# AxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAwMFoX
# DTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
# IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
# cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB9
# 0Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+X2U/
# 4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXcia
# C1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z98OpH
# 2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQhBly
# F/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4wggHK
# MB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF66Kv
# 9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQE
# AwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYIKwYB
# BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
# cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENB
# LmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29t
# L0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2NybDMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAE
# STBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGln
# aWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEBAHGV
# EulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFaKrcF
# NB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUMEaLLb
# dQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN11ZOF
# k362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEmtmyl
# 7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
# Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQswCQYDVQQGEwJVUzEVMBMG
# A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEw
# LwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
# AhAEzT+FaK52xhuw/nFgzKdtMA0GCWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJ
# AzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAwOTE3MjA1NTAwWjAr
# BgsqhkiG9w0BCRACDDEcMBowGDAWBBQDJb1QXtqWMC3CL0+gHkwovig0xTAvBgkq
# hkiG9w0BCQQxIgQgy6Kj/sKRGb9soXfrr32RKvZ9L6Q1oJI+vxtzg5+KII4wDQYJ
# KoZIhvcNAQEBBQAEggEAIJLkWz1UpEB5wb8sQirgvuDNVczSKuaG/UtKvXn5ZNaK
# ZC/guf0zJ0oXEBpezGulwDxAlIDbPqcrFgYk+vavm+QG55Dau/jc3Hlyd4yYQHVk
# rzRE1ZpegoH5dJlADqCKqMddjAPN96m9Pp3AfBkWUTFisG8dD41+ZvKnxsg+G4y1
# eQ7auJqfyPMJ8whb8NTXhEpOa1I/JCyhqyVO1uX4g6Lz9eW7ZJhhzzQV9be25lNh
# lfGGJbrxLmyE8wexK+4TPgzf7pQD/eZFfVTVEsOCcgzJyTBhz7yk/oHBPXZzBy/1
# xtQyWVBXHEM7lgQn4/glLnk78o30HJncEzXCqhN6Lg==
# SIG # End signature block
