/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, console */

var serverCoreSettings = require('../server-core').coreSettings;

function UpdateProxyUrlCommand(socket, data) {
    "use strict";
    this.socket = socket;
    this.data = data;
}

UpdateProxyUrlCommand.prototype.execute = function () {
    "use strict";
    if (this.socket.authorized === true) {
        if (this.data) {
            serverCoreSettings.PROXY_HOSTNAME = this.data.hostname;
            serverCoreSettings.PROXY_PORT = this.data.port;
        } else {
            serverCoreSettings.PROXY_HOSTNAME = '';
            serverCoreSettings.PROXY_PORT = '';
        }
    }
};

function UpdatePreviewServiceUrlCommand(socket, data) {
    "use strict";
    this.socket = socket;
    this.data = data;
}

UpdatePreviewServiceUrlCommand.prototype.execute = function () {
    "use strict";
    if (this.socket.authorized === true) {
        if (this.data) {
            serverCoreSettings.PREVIEW_SERVICE_URL = this.data;
        } else {
            serverCoreSettings.PREVIEW_SERVICE_URL = '';
        }
    }
};

module.exports.UpdateProxyUrlCommand = UpdateProxyUrlCommand;
module.exports.UpdatePreviewServiceUrlCommand = UpdatePreviewServiceUrlCommand;