/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

// DW-4152622: [PSIRT-13075] Vulnerability in Dreamweawer 2020 version 15211
// By default, node will search for a module starting at the current node_modules folder - if not found,
// it'll work backwards up the directory tree, looking for any parent node_modules folder, all the way
// to the root of the file system. Some libraries have optional dependencies, so they have a try-catch
// around require - but this means that if somebody places a JS file further up the filesystem (e.g.
// under /node_modules/xxx) then the process can be tricked into calling and executing this code.
// We can fix this by overriding the node module paths to exclude any that are above Dreamweaver's directories.
// Dreamweaver's directories are passed as a commandline argument 'dwroots'.

const rootsArg = process.argv.find(element => element.startsWith("dwroots=")) || "";
const rootsVal = rootsArg.split("dwroots=")[1];
const roots = (rootsVal || __dirname).split(";");

const Module = require('module').Module;
const nodeModulePaths = Module._nodeModulePaths.bind(Module);

const pathFilter = (path) => { return (roots.find(root => path.startsWith(root)) ? true : false) }
Module._nodeModulePaths = from => nodeModulePaths(from).filter(pathFilter);

/*global require*/
require('../server-core').createServer([{name: '../server-main', loaded: require('./index')}]);
