/*	
 Copyright 2014 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
  File which has the logic to create the horizontal ruler.
*/

/*jslint vars: true*/
/*global jQuery, $, DW_RULER_CONSTANTS, window, document */


var redrawRuler = function (width) {
        
    "use strict";
    var vmqhRule = DW_RULER_CONSTANTS.rulerDivString;

    var $vmqhRule = $('.vmqhRule');
  
    if (window.visualMediaQueryViewObj.zoomFactor <= 0) {
        window.visualMediaQueryViewObj.zoomFactor = 1.0;
    }
    width /= window.visualMediaQueryViewObj.zoomFactor;
    $vmqhRule.empty();

    // Horizontal ruler ticks
    var tickStringPos = 0;
    var newStringLabel = "";
    var tickStringOffSet = 50;
    var tickLargeOffset = 25;
    var tickSmallOffset = 5;
    
    if (window.visualMediaQueryViewObj.zoomFactor < 0.25) {
        tickStringOffSet = 200;
        tickLargeOffset = 100;
        tickSmallOffset = 20;
    } else if (window.visualMediaQueryViewObj.zoomFactor < 0.5) {
        tickStringOffSet = 100;
        tickLargeOffset = 50;
        tickSmallOffset = 10;
    }
        
    while (tickStringPos <= width) {

        var actualTickStringPos = tickStringPos * window.visualMediaQueryViewObj.zoomFactor;

        if (((tickStringPos) % tickStringOffSet) === 0) {
            newStringLabel = DW_RULER_CONSTANTS.tickString + (tickStringPos) + "</div>";
            $(newStringLabel).css("left", actualTickStringPos + "px").appendTo($vmqhRule);
        } else if (((tickStringPos) % tickLargeOffset) === 0) {
            newStringLabel = DW_RULER_CONSTANTS.tickLarge;
            $(newStringLabel).css("left", actualTickStringPos + "px").appendTo($vmqhRule);
        } else if (((tickStringPos) % tickSmallOffset) === 0) {
            newStringLabel = DW_RULER_CONSTANTS.tickSmall;
            $(newStringLabel).css("left", actualTickStringPos + "px").appendTo($vmqhRule);
        }

        tickStringPos = (tickStringPos + 5);
    }


};

(function () {
    "use strict";
      
	jQuery.fn.vmqRuler = function () {
	
		var vmqhRule = DW_RULER_CONSTANTS.rulerDivString;
		
        /*
         * Handle Window resize
         */
		$(window).resize(function (e) {
            
            if (window.visualMediaQueryViewObj) {
                window.visualMediaQueryViewObj.setNoMqTextMargin();
            }
            
            var $vmqhRule = $('.vmqhRule');
			
            var zoomfactor = 1.0;
            if (window.visualMediaQueryViewObj && window.visualMediaQueryViewObj.zoomFactor > 0) {
                zoomfactor = window.visualMediaQueryViewObj.zoomFactor;
            }
            
            redrawRuler($vmqhRule.width());
			
		});
       
        /*
         * Construct Horizontal Ruler.
         */
        return this.each(function () {
            
            var $this = $(this);
            $(vmqhRule).height(DW_RULER_CONSTANTS.vmqhRuleSize).prependTo($this);
            var $vmqhRule = $this.children('.vmqhRule');
                
            var tickStringPos = 0;
            var newStringLabel = "";
            while (tickStringPos <= $vmqhRule.width()) {
                if (((tickStringPos) % 50) === 0) {
                    newStringLabel = DW_RULER_CONSTANTS.tickString + (tickStringPos) + "</div>";
                    $(newStringLabel).css("left", tickStringPos + "px").appendTo($vmqhRule);
                } else if (((tickStringPos) % 25) === 0) {
                    newStringLabel = DW_RULER_CONSTANTS.tickLarge;
                    $(newStringLabel).css("left", tickStringPos + "px").appendTo($vmqhRule);
                } else if (((tickStringPos) % 5) === 0) {
                    newStringLabel = DW_RULER_CONSTANTS.tickSmall;
                    $(newStringLabel).css("left", tickStringPos + "px").appendTo($vmqhRule);
                }
                tickStringPos = (tickStringPos + 5);
                
            }
        });
        
	};
}());
