/*
 Copyright 2019 Adobe Systems Incorporated.  All rights reserved.
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */

class PasteHandler extends BaseEventHandler {

    constructor() {
		'use strict';
        super();
    }

    onStart(event) {
        'use strict';
        if (event) {
            event.preventDefault();
            event.stopPropagation();
        }
    }

    onEnd(event) {
        'use strict';
        if (event) {
            this.pasteAsPlainText(event);
        }
    }

    // Intended for private use
    pasteAsPlainText(event) {
        'use strict';
        try {
            // Get text representation of clipboard
            var text = event.clipboardData.getData("text/plain");
    
            // \s is equivalent to [ \f\n\r\t\v\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]
            // \n and \r are covered
            text = text.replace(/\s+/g, " ");
    
            // If < and > are part of the content, insertHTML tries handle them differently. It tries to add close tag
            // when <tagname> is pasted. Hence we are encoding them here.
            text = text.replace(/</g, parent.DW_LIVEEDIT_CONSTANTS.MarkupForLessThan);
            text = text.replace(/>/g, parent.DW_LIVEEDIT_CONSTANTS.MarkupForGreatorThan);
    
            // Insert text manually
            parent.document.execCommand("insertHTML", false, text);
        } catch (e) {
            window.parent.writeDWLog("TextHUD Paste handler - exception caught while pasting :" + e.message);
        }
    }
}

