//Copyright 2005-2007 Adobe Systems Incorporated.  All rights reserved.

var helpDoc = MM.HELP_jQueryTabs;

var TABBEDPANELS_ID;
var MESSAGE;
var MESSAGETEXT;
var LIST_PANEL;
var DEFAULT_INPUT;
var COLLAPSIBLE_CHECK;
var EVENT_LIST;
var OPTIONS_DIV;
var UP_BTN;
var DOWN_BTN;
var ADD_BTN;
var DEL_BTN;
var HEIGHTSTYLE_LIST;
var DISABLED_CHECK;
var HIDE_SELECT;
var SHOW_SELECT;
var HIDE_INPUT;
var SHOW_INPUT;
var ORIENTATION_SELECT;

// ********************* API FUNCTIONS ***************************

//--------------------------------------------------------------------
// FUNCTION:
//   canInspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document changes to decide whether
//   or not this property inspector should be displayed.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   true if the currently selected node is a TabbedPanels element,
//   false if it is not.
//--------------------------------------------------------------------

function canInspectSelection() 
{
  var bCanInspectSelection = false;
  var dom = dw.getDocumentDOM();
  
  if (!dom)
	return false;
  
  var selectedNode = dom.getSelectedNode();
  
  if ( !selectedNode || !selectedNode.getTranslatedAttribute )
    return false;
  
	
  var attr = selectedNode.getTranslatedAttribute('tabs');
  
  if( attr && attr.length > 0 )
  {
    bCanInspectSelection = true;
    
    // If the widget manager is out of sync, run the translator.
    var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
    if( !widgetMgr.getWidget('tabs', selectedNode.id ) )
    {
      dom.runTranslator("jQuery Widget");

      if( !widgetMgr.getWidget('tabs', selectedNode.id ) )
      {
        // Running the translator failed to create a design time object
        // for this widget. Either caInspectSelection() was called in the
        // middle of an edit operation, which prevents the translator from
        // running right now, or an error occurred during the translation.

        bCanInspectSelection = false;
      }
    }  
  }

  return bCanInspectSelection;
}

//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This is an internal utility function that searches through the
//   Property Inspector document to find all of the UI controls we
//   will programatically manipulate, and stores handles to them in
//   global variables which are used in some of the other functions
//   for this Property Inspector.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function initializeUI() 
{
  TABBEDPANELS_ID = dwscripts.findDOMObject("idEditBox");
  TABBEDPANELS_ID.value = "";  
  MESSAGE = dwscripts.findDOMObject("message");
  MESSAGETEXT = dwscripts.findDOMObject("messageText");
  MESSAGETEXT.innerHTML = "";
  LIST_PANEL = new ListControl("panelList");
  DEFAULT_INPUT = document.getElementById("activeInput");
  COLLAPSIBLE_CHECK = document.getElementById("collapsibleCheck");
  EVENT_LIST = new ListControl("eventList");
  OPTIONS_DIV = dwscripts.findDOMObject("collapsibleDiv");
  ADD_BTN = dwscripts.findDOMObject("elemAdd");
  DEL_BTN = dwscripts.findDOMObject("elemDel");
  UP_BTN = dwscripts.findDOMObject("elemUp");
  DOWN_BTN = dwscripts.findDOMObject("elemDown");
	HEIGHTSTYLE_LIST = new ListControl("heightStyleList");
	DISABLED_CHECK = document.getElementById("disabledCheck");
	HIDE_SELECT = new ListControl("hideSelect");
	SHOW_SELECT = new ListControl("showSelect");
	HIDE_INPUT = document.getElementById("hideInput");	
	SHOW_INPUT = document.getElementById("showInput");	
	ORIENTATION_SELECT = new ListControl("orientationSelect");
}

//--------------------------------------------------------------------
// FUNCTION:
//   inspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document has changed and it has
//   been decided that this Property Inspector should be displayed.
//   This function syncs up the Property Inspector UI with the
//   widget's design-time object so that it accurately reflects
//   what is in the widget HTML markup and its JS constructor.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function inspectSelection() 
{
	dw.logEvent(UT_JQUERY_TABS, UT_JQUERY_TABS_INSPECT);
  // Call initializeUI() here; it's how the global variables get
  // initialized. The onLoad event on the body tag is never triggered
  // in inspectors.
  initializeUI();
	
  var dom = dw.getDocumentDOM();
  var selectedNode = dom.getSelectedNode();
  if (!canInspectSelection())
    return;
  
  var divId = selectedNode.id;
  // Update the ID field in the PI.
  TABBEDPANELS_ID.value = divId;
  
  var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  var tp = widgetMgr.getWidget('tabs', divId );
  
  if( !tp )
  {
    displayTopLayerErrorMessage(dw.loadString("jquery/widget/alert/broken structure"));
    return;
  }
  
	if (tp && tp.recalculateOpts)
		tp.recalculateOpts();
	
  clearTopLayerErrorMessage()
  tp.refresh();

  // Sync the controls to the design-time object, pass -1 for both
  // the selectedIndex and defaultIndex argument so that syncControls()
  // gets them from the design-time object.

  var errorDetected = syncControls(tp, -1, -1);
	enableControls(tp, errorDetected);
}

//--------------------------------------------------------------------
// FUNCTION:
//   syncControls
//
// DESCRIPTION:
//   This internal utility function syncs up the Property Inspector UI
//   controls with the widget's design-time object so that they
//   accurately reflect what is in the widget HTML markup and JS
//   constructor in the design view document.
//
// ARGUMENTS:
//  tp - object - The widget design-time object.
//  selectedIndex - integer - The index of the panel that is currently
//                            showing. An index value of -1 tells this
//                            function to get the selectedIndex value
//                            from the widget design-time object.
//  defaultIndex - integer - The index of the panel to show when the
//                           widget is initially loaded into a browser.
//                           An index value of -1 tells this function
//                           to get the defaultIndex value from the
//                           widget design-time object.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function syncControls(tp, selectedIndex, defaultIndex)
{
  var panelLabels = new Array();
  var tabs = [];
  var panels = [];
  var errorDetected = false;

  if( tp )
  {
    tabs = tp.getTabs();
    panels = tp.getContentPanels();
  }

  var curPanelIndex = tp.getCurrentPanelIndex();
  var numPanels = Math.max(tabs.length, panels.length);

  for (var i=0; i < numPanels; i++)
  {
    var label = "";
    var validStructure = false;
    
    if( tabs[i] && panels[i] )
    {
      label = dwscripts.collectTextInNode(tabs[i]);
      label = dwscripts.entityNameDecode(label); 
      label = dwscripts.trim(label);
      validStructure = true;
    }
    
    if( !validStructure )
    {  
      if (!tabs[i])
      {
        label = dw.loadString("jquery/widgets/tabbedpanels/missing tab");
        errorDetected = true;
      }
      else
      {
        label = dw.loadString("jquery/widgets/tabbedpanels/missing content");
        errorDetected = true;
      }

    }

    if( label.length == 0 )
      label = dw.loadString("jquery/widget/unlabeled panel");
      
    panelLabels.push(label);
  }

  // Update the PI controls to reflect the collapsible panel's renderstate.
  var errMsg = "";
  var curPanel = (selectedIndex < 0) ? tp.getCurrentPanelIndex() : selectedIndex;
  
  LIST_PANEL.setAll(panelLabels, panelLabels);

  if( panelLabels.length )
  {
    LIST_PANEL.setIndex(curPanel);
    if (!tabs[curPanel])
    {
      errMsg = dw.loadString("jquery/widgets/tabbedpanels/error/missing tab");
    }
    else if (!panels[curPanel])
    {
      errMsg = dw.loadString("jquery/widgets/tabbedpanels/error/missing content");
    }
  }
  else
  {
    errMsg = dw.loadString("jquery/widget/alert/broken structure");
  }

	COLLAPSIBLE_CHECK.checked = tp.getCollapsibleValue();
	DEFAULT_INPUT.value = tp.getDefaultTab();
	
	var eventArray = tp.getEventOptions();
	EVENT_LIST.setAll(eventArray, eventArray);
	if (eventArray && eventArray.length )
		EVENT_LIST.setIndex(tp.getEventIndex());
		
	var heightStyleArray = tp.getHeightStyleOptions();
	HEIGHTSTYLE_LIST.setAll(heightStyleArray, heightStyleArray);
	if (heightStyleArray && heightStyleArray.length)
		HEIGHTSTYLE_LIST.setIndex(tp.getHeightStyleIndex());
		
	DISABLED_CHECK.checked = tp.getDisabledValue();	
	
	var animationArray = tp.getAnimationArray();
	HIDE_SELECT.setAll(animationArray, animationArray);
	var hideIndex = tp.getHideEffectIndex();
	if (animationArray && animationArray.length)
		HIDE_SELECT.setIndex(hideIndex);
	
	if(hideIndex)
		HIDE_INPUT.value = tp.getHideDurationValue();
	else
		HIDE_INPUT.value = "";
	
	SHOW_SELECT.setAll(animationArray, animationArray);
	var showIndex = tp.getShowEffectIndex();
	if (animationArray && animationArray.length)
		SHOW_SELECT.setIndex(showIndex);
	
	if(showIndex)
		SHOW_INPUT.value = tp.getShowDurationValue();
	else
		SHOW_INPUT.value = "";
		
	var orientationArray = tp.getOrientationOptions();
	ORIENTATION_SELECT.setAll(orientationArray, orientationArray);
	if (orientationArray && orientationArray.length)
		ORIENTATION_SELECT.setIndex(tp.getOrientationIndex());

  setErrorMsg(errMsg);

  return errorDetected;
}

//--------------------------------------------------------------------
// FUNCTION:
//   enableControls
//
// DESCRIPTION:
//   This internal utility function enables/disables the controls
//   in the Property Inspector based on the state of the widget
//   design-time object.
//
// ARGUMENTS:
//  tp - object - The widget design-time object.
//  errorOnPage - boolean - true if the widget markup is invalid,
//                          false if the markup is valid.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function enableControls(tp, errorOnPage)
{
  // Start off with everything disabled by default.

  var enableList = false;
  var enableAdd = false;
  var enableDel = false;
  var enableUp = false;
  var enableDown = false;

  if (LIST_PANEL.getLen() < 1)
  {
    // If there's nothing in the list panel, the user must have
    // removed all of the tabs and content panels, or completely
    // removed one of the group containers. Enable the add button
    // so the user can add a panel to fix things.

    enableAdd = true;
  }
  else
  {
    // The list panel has something in it, so get its current
    // selection and enable the add, delete and move buttons
    // if necessary.

    enableList = true;

    var selectedIndex = LIST_PANEL.getIndex();
    if (selectedIndex >= 0)
    {
      // The currently selected panel is only valid if it
      // has both a tab and content panel.

      var tabs = tp.getTabs();
      var panels = tp.getContentPanels();
      var validPanelSelected = tabs[selectedIndex] && panels[selectedIndex];

      if (validPanelSelected)
      {
        var lastIndex = Math.max(tabs.length, panels.length) - 1;

        enableAdd = true;

        // Only enable the delete button if the selected panel
        // isn't the last valid panel in the list.

        enableDel = (selectedIndex > 0 || (selectedIndex < lastIndex && tabs[selectedIndex+1] && panels[selectedIndex+1]));

        // Only enable the up button if the selected item
        // isn't the first thing in the list.

        enableUp = selectedIndex != 0;

        // Only enable the down button if the selected item isn't
        // the last valid item in the list.

        enableDown = (selectedIndex < lastIndex && tabs[selectedIndex+1] && panels[selectedIndex+1]);
      }
      else
      {
        // The currently selected item is an invalid panel, so
        // only enable the delete button so the user can get rid
        // of it.

        enableDel = true;
      }
    }
  }

  if (enableList)
    LIST_PANEL.enable();
  else
    LIST_PANEL.disable();

	EVENT_LIST.enable();
	
	if( HIDE_SELECT.getIndex() > 0 )
		HIDE_INPUT.disabled = false;
	else
		HIDE_INPUT.disabled = true;
		
	if( SHOW_SELECT.getIndex() > 0 )
		SHOW_INPUT.disabled = false;
	else
		SHOW_INPUT.disabled = true;	

  if (enableAdd && !errorOnPage)
  {
    ADD_BTN.removeAttribute("disabled");
    ADD_BTN.src = "../Shared/MM/Images/btnAddSmall.png";
  }
  else
  {
    ADD_BTN.setAttribute("disabled", true);
    ADD_BTN.src = "../Shared/MM/Images/btnAddSmall_dis.png";
  }
  
  if (enableDel && !errorOnPage)
  {
    DEL_BTN.removeAttribute("disabled");
    DEL_BTN.src = "../Shared/MM/Images/btnDelSmall.png";
  }
  else
  {
    DEL_BTN.setAttribute("disabled", true);
    DEL_BTN.src = "../Shared/MM/Images/btnDelSmall_dis.png";
  }

  if (enableUp && !errorOnPage)
  {
    UP_BTN.removeAttribute("disabled");
    UP_BTN.src = "../Shared/MM/Images/btnUpSmall.png";

  }
  else
  {
    UP_BTN.setAttribute("disabled", true);
    UP_BTN.src = "../Shared/MM/Images/btnUpSmall_dis.png";
  }

  if (enableDown && !errorOnPage)
  {
    DOWN_BTN.removeAttribute("disabled");
    DOWN_BTN.src = "../Shared/MM/Images/btnDownSmall.png";
  }
  else
  {
    DOWN_BTN.setAttribute("disabled", true);
    DOWN_BTN.src = "../Shared/MM/Images/btnDownSmall_dis.png";
  }
}

//--------------------------------------------------------------------
// FUNCTION:
//   updateTag
//
// DESCRIPTION:
//   This function handles all of the user actions triggered by the
//   user from the Propery Inspector controls.
//
// ARGUMENTS:
//  action - string - The name of the action to perform.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function updateTag(action)
{
  var dom = dw.getDocumentDOM();
  var selectedNode = dom.getSelectedNode();
  if (!canInspectSelection())
    return;
  
  var divId = selectedNode.id;
  
  var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  var tp = widgetMgr.getWidget('tabs', divId );
  if( !tp )
    return;
  
  var tabs = tp.getTabs();
  var panels = tp.getContentPanels();
  var numPanels = Math.max(tabs.length, panels.length);
  var numValidPanels = Math.min(tabs.length, panels.length);

  var selectedIndex = LIST_PANEL.getIndex();
  var defaultIndex = tp.getDefaultTab();
  
  if (action) 
  {
    switch (action)
    {
      case "setDefault":
      {
        tp.setDefaultValue(DEFAULT_INPUT.value);
      }
      break;
			
			case "setCollapsible":
      {
        tp.setCollapsibleValue(COLLAPSIBLE_CHECK.checked);
      }
      break;
			
			case "setEvent":
      {
        tp.setEvent(EVENT_LIST.getIndex());
      }
      break;
			
			case 'setHeightStyle'	:
			{
				tp.setHeightStyleIndex(HEIGHTSTYLE_LIST.getIndex());
			}
			break;
			
			case 'setDisabled':
			{
				tp.setDisabledValue(DISABLED_CHECK.checked);
			}
			break;	
			
			case 'setHideSelect':
			{
				tp.setHideEffectIndex(HIDE_SELECT.getIndex());
			}
			break;
			
			case 'setShowSelect':
			{
				tp.setShowEffectIndex(SHOW_SELECT.getIndex());
			}
			break;
			
			case 'setHideInput':
			{
				tp.setHideDurationValue(HIDE_INPUT.value);
			}
			break;
			
			case 'setShowInput':
			{
				tp.setShowDurationValue(SHOW_INPUT.value);
			}
			break;
			
			case 'setOrientation':
			{
				tp.setOrientationIndex(ORIENTATION_SELECT.getIndex());
			}
			break;
			
      case "addPanel":
      {
        // Create any missing tab group container if necessary.
	    if (numValidPanels == 0)
          tp.repairTabGroupIfNeeded();

        // Verify bounds.
        if (numValidPanels > 0 && selectedIndex >= numValidPanels)
          selectedIndex = numValidPanels - 1;

        // Add new panel after the current selection.
        tp.addPanel(selectedIndex);
        if (!numValidPanels)
        {
          defaultIndex = 0;
          selectedIndex = 0;
          tp.defaultTabId = 0;
        }
        else {
          if (defaultIndex > selectedIndex)
            tp.defaultTabId = defaultIndex + 1;
          ++selectedIndex;
        }
      }
      break;
      
      case "deletePanel":
      {
        // Verify bounds.
        if((numValidPanels == 1 && selectedIndex == 0) || selectedIndex < 0 || selectedIndex >= numPanels )
          return;
          
        // Delete the currently selected panel.
        tp.removePanel(selectedIndex);
        if (defaultIndex > 0 && defaultIndex >= selectedIndex)
          tp.defaulTabId = defaultIndex - 1;
        if (selectedIndex > 0)
          --selectedIndex;
      }
      break;
      
      case "movePanelUp":
      {
        // Verify bounds.
        if(numValidPanels < 2 || selectedIndex < 1 || selectedIndex >= numValidPanels)
          return;

        if (defaultIndex == selectedIndex)
          tp.defaulTabId = defaultIndex - 1;
        else if (defaultIndex == (selectedIndex - 1))
          tp.defaulTabId = defaultIndex + 1;

        tp.movePanelUp(selectedIndex);
        --selectedIndex;
      }
      break;
      
      case "movePanelDown":
      {
        // Verify bounds.
        if(numValidPanels < 2 || selectedIndex < 0 || (selectedIndex+1) >= numValidPanels)
          return;

        if (defaultIndex == selectedIndex)
          tp.defaulTabId = defaultIndex + 1;
        else if (defaultIndex == (selectedIndex + 1))
          tp.defaulTabId = defaultIndex - 1;

        tp.movePanelDown(selectedIndex);
        ++selectedIndex;
      }
      break;
      
      case "panelSelected":
      {
        // Don't need to do anything here, the refresh() or showPanel()
        // call below will show the correct panel based on selectedIndex.
      }
      break;
      
      case "id":
      {
        // Validate the new id.
        var newId = TABBEDPANELS_ID.value;
        if( newId == divId )
          return; // Nothing to change.
        
        if( newId.length == 0 )
        {
          alert(dw.loadString("jquery/widget/alert/need unique id"));
          return;
        }
        
        if( dom.getElementById(newId) )
        {
          alert(dw.loadString("jquery/widget/alert/id already exists"));
          return;
        }
        
        if( !dwscripts.isValidID(newId) )
        {
          alert(dw.loadString("jquery/widget/alert/id is invalid"));
          return;
        }
        
        // Update the constructor.
        tp.updateWidgetId(newId);

        // Update the WidgetManager for the new ID.
        widgetMgr.setWidget('tabs', newId, tp );
      }
      break;
      
      case "guide":
      {
        dwscripts.displayDWHelp(widgetGuide);
      }
      break;
    }
   }
  
  // All these edits modify the tabbedpanels. We need to recreate the JS Object to reflect those changes.
  tp.refresh();
  tabs = tp.getTabs(); // Re-get the tabs since they've changed.

  if(tabs.length > 0 && selectedIndex >= 0 && selectedIndex < tabs.length )
  {
    // Only show the panel if it's valid.
    if( tp.isValidPanelStructure(selectedIndex) )
      tp.showPanel(selectedIndex);
  }
  
  // Make sure selection stays on the div.
  dom.setSelectedNode(selectedNode);
   
  var error = syncControls(tp, selectedIndex, -1);
  enableControls(tp, error);
  //we need to refresh live view after doing this, as partial refresh will not be suffiecient to show the changes!
  dw.reloadLiveView();
}

//--------------------------------------------------------------------
// FUNCTION:
//   setErrorMsg
//
// DESCRIPTION:
//   This internal utility function that shows/hides the error message
//   panel in the Property Inspector. If the msg passed in is not an
//   empty string, the panel is shown, otherwise it is hidden.
//
// ARGUMENTS:
//  msg - string - Error message to display.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function setErrorMsg(msg)
{
  if (msg)
  {
    MESSAGETEXT.innerHTML = msg;
    OPTIONS_DIV.style.display = "none";
    MESSAGE.style.display = "";
  }
  else
  {
    MESSAGETEXT.innerHTML = "";
    OPTIONS_DIV.style.display = "";
    MESSAGE.style.display = "none";
  }
}
