/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2017 Adobe Systems Incorporated                  */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		initializeUI
//
// PURPOSE
//		Initializes all UI elements in the command dialog. We're using an
//    mm:browsercontrol to contain the html we will load to play the video
/////////////////////////////////////////////////////////////////////////////
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global document, dw, File, handleSpaceKeyPressed, handleEscapeKeyPressed, dwscripts*/
var workspaceName = "";
var invoker = "";
var isInitDone = false;
var CONSTANTS = {
    UT_NFW : "NFW Contextual Hints",
    WORKSPACESTR: "workspace",
    DISPLAYEDSTR: "displayed",
    SEPARATOR: "_",
    EXITSTR: "exit-Q",
	VIDEO : "Video",
	VIDEOS : "/InAppWalkThrough/OnBoarding/VideoTutorial/Videos/",
    VIDEOFILEEXT : ".mp4",
    VTTEXT : ".vtt",
    MAXVIDEOWIDTH: 1920,    //Developer.mp4 and Standard.mp4 have size of 1920*1080(16:9 aspect ratio) and this will be the max video size we show
    MAXVIDEOWIDTH_HIRESOLUTION_WINDOWS: 1000,   //this will be the max video width for windows high resolution monitors greater than 2000px as screen resolution width,
    MAXWINSCREENWIDTH: 2000,
    MINVIDEOWIDTH: 900, //minimum width is where the video is played with good resolution and height is calculated as round((width/16)*9)
    TITLE: "Dreamweaver - ",
    DEVELOPERWORKSPACETITLE: "Tutorial/DeveloperWorkspace",
    STANDARDWORKSPACETITLE: "Tutorial/StandardWorkspace",
    HOSTEDPATH: "https://download.macromedia.com/pub/edgetools/dreamweaver/Videos/18.0.0/"
};

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		receiveArguments
//
// PURPOSE
//		receive the arguments and store their values
/////////////////////////////////////////////////////////////////////////////
function receiveArguments() {
    "use strict";
    
    if (arguments.length !== 2) {
        return;
    }
    //get the workspace name and invoker name
    //workspace name - needed to load the right video which is in format workspacename.mp4
    //invoker name - needed for headlights logging
    workspaceName = arguments[0];
    invoker = arguments[1];
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		canAcceptCommand
//
// PURPOSE
//		return a true if we are connect to the internet
/////////////////////////////////////////////////////////////////////////////
function canAcceptCommand() {
    "use strict";
    return dw.isConnectedToInternet();
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		isCloseButtonRequired
//
// PURPOSE
//		return a bool if Close Button is needed in title bar
//      we need this since on mac, there are no default buttons shown in
//      titlebar unlike windows, where close button atleast is shown
/////////////////////////////////////////////////////////////////////////////
function isCloseButtonRequired() {
    "use strict";
    
    return true;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		getCustomTitle
//
// PURPOSE
//		return the custom title which will be shown in the title bar
/////////////////////////////////////////////////////////////////////////////
function getCustomTitle() {
    "use strict";
    var localeStr = CONSTANTS.TITLE;
    if (workspaceName === 'Developer') {
        localeStr += dw.loadString(CONSTANTS.DEVELOPERWORKSPACETITLE);
    } else if (workspaceName === 'Standard') {
        localeStr += dw.loadString(CONSTANTS.STANDARDWORKSPACETITLE);
    }
    return localeStr;
}


/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		getContainerWidth
//
// PURPOSE
//		return the frame width. Limit the width between the max and min
//      for a clear resolution video. Screen width/1.5 will be the width
//      for better video viewing experience
/////////////////////////////////////////////////////////////////////////////
function getContainerWidth() {
    "use strict";
    var screenWidth = dw.getScreenWidth();
    var containerWidth = Math.round(screenWidth / 1.5);
    if (dwscripts.IS_MAC) {
        if (containerWidth > CONSTANTS.MAXVIDEOWIDTH) {
            containerWidth = CONSTANTS.MAXVIDEOWIDTH;
        }
    } else {
        if (screenWidth >= CONSTANTS.MAXWINSCREENWIDTH) {
            containerWidth = CONSTANTS.MAXVIDEOWIDTH_HIRESOLUTION_WINDOWS;
        } else if (containerWidth > CONSTANTS.MAXVIDEOWIDTH) {
            containerWidth = CONSTANTS.MAXVIDEOWIDTH;
        }
    }
    if (containerWidth < CONSTANTS.MINVIDEOWIDTH) {
        containerWidth = CONSTANTS.MINVIDEOWIDTH;
    }
        
    return containerWidth;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		getContainerHeight
//
// PURPOSE
//		return frame height. The height will be width/16 * 9 to maintain
//      the aspect ratio
/////////////////////////////////////////////////////////////////////////////
function getContainerHeight() {
    "use strict";
    var width = getContainerWidth();
    var containerHeight = Math.round((width / 16) * 9);
    return containerHeight;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		getTrackCode
//
// PURPOSE
//		compose the <track...> html code for loading locale specific subtitle
/////////////////////////////////////////////////////////////////////////////
function getTrackCode() {
    "use strict";
    //build the map of the iso lang code with the code and label
	var languagesSet = {
        en_US : {code : "en", label : "English"},
        ja_JP : {code : "ja", label : "日本語"},
		fr_FR : {code : "fr", label : "Français"},
        fr_MA : {code : "fr", label : "Français"},
		cs_CZ : {code : "cs", label : "Čeština"},
        de_DE : {code : "de", label : "Deutsch"},
		es_ES : {code : "es", label : "Español"},
		it_IT : {code : "it", label : "Italiano"},
		nl_NL : {code : "nl", label : "Nederlands"},
		sv_SE : {code : "sv", label : "svenska"},
		pt_BR : {code : "pt", label : "Português"},
		pl_PL : {code : "pl", label : "Polski"},
		ru_RU : {code : "ru", label : "Русский"},
		tr_TR : {code : "tr", label : "Türkçe"},
		zh_CN : {code : "zh-Hans", label : "简体中文"},
		zh_TW : {code : "zh-Hant", label : "繁體中文"},
		ko_KR : {code : "ko", label : "한국어"},
		en_AE : {code : "ar", label : "العربية"},
		en_IL : {code : "he", label : "עברית"}
    };
	var appLanguage = dw.getLicensedLanguage();
    var retVal = languagesSet[appLanguage];
    var srcLang = languagesSet.en_US.code;
    var label = languagesSet.en_US.label;
    var videoCaptionFile = workspaceName + '-';
    if (retVal !== undefined) {
        srcLang = retVal.code;
        label = retVal.label;
    }

    //the path for the caption file, .vtt
	var captionTrack = CONSTANTS.HOSTEDPATH + videoCaptionFile + srcLang + CONSTANTS.VTTEXT;

    var trackHTML = '<track kind="subtitles" src="' + captionTrack + '" srclang="' + srcLang + '" label="' + label + '" default>';

    //add the english caption file as a second option if the locale file exists
    if (srcLang !== languagesSet.en_US.code) {
        captionTrack = CONSTANTS.HOSTEDPATH + videoCaptionFile + languagesSet.en_US.code + CONSTANTS.VTTEXT;
        trackHTML += '<track kind="subtitles" src="' + captionTrack + '" srclang="' + languagesSet.en_US.code + '" label="' + languagesSet.en_US.label + '">';
    }

    return trackHTML;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		browserControlLoaded
//
// PURPOSE
//		handler when the browser control is loaded
/////////////////////////////////////////////////////////////////////////////
function browserControlLoaded() {
    "use strict";
    var objBrowserCtrl = document.getElementById("videoContainer");
    if (objBrowserCtrl !== undefined) {
        objBrowserCtrl.focus();
        var browserWin = objBrowserCtrl.getWindow();
	    if (browserWin) {
            browserWin.spaceKeyPressed = handleSpaceKeyPressed;
            browserWin.escapeKeyPressed = handleEscapeKeyPressed;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		initializeUI
//
// PURPOSE
//		load the html in browser control
/////////////////////////////////////////////////////////////////////////////
function initializeUI() {
    "use strict";

	//compose the video filepath
	var videoFilepath = CONSTANTS.HOSTEDPATH + workspaceName + CONSTANTS.VIDEOFILEEXT;
    

	//get the track html code
    var trackHtmlCode = getTrackCode();

	//load the video file in the browser control
	var objBrowserCtrl = document.getElementById("videoContainer");

	if (objBrowserCtrl !== undefined) {
        objBrowserCtrl.enablePageNavigationHistory(false);//needed so that the back/forward buttons don't work
        objBrowserCtrl.setScrollbarMode("off", "h");
        objBrowserCtrl.setScrollbarMode("off", "v");
        objBrowserCtrl.style.width = window.innerWidth + "px";
        objBrowserCtrl.style.height = window.innnerHeight + "px";
		var toLoadHtmlStr = '<!doctype html><html><head><meta charset="utf-8"><title></title></head><style>video::-webkit-media-controls-fullscreen-button { display:none; }body {  margin: 0; }video { position: absolute;top: 0;  bottom: 0;  left: 0;  width: 100%;  height: 100% !important;  border: 0;}  </style><script>function HandleKeyPress(event) { if (event.keyCode === 32) { window.spaceKeyPressed();  } else if (event.keyCode === 27) { window.escapeKeyPressed();} }</script><body onkeydown="HandleKeyPress(event);"><video id="videocontrol" width="100%" height="100% !important" controls autoplay><source src="' + videoFilepath + '" type="video/mp4">your browser does not support video tag' + trackHtmlCode + '</video></body></html>';
		
        objBrowserCtrl.addEventListener("BrowserControlLoad", browserControlLoaded, true);
		objBrowserCtrl.loadHTML(toLoadHtmlStr);
        
        isInitDone = true;
        
        
	}
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		unloadUI
//
// PURPOSE
//		While unloading the page, get the % of the video played and log
//      headlights for the invoker and % of video played
/////////////////////////////////////////////////////////////////////////////
function unloadUI() {
    "use strict";
    //headlights
		
	var headlightStr = invoker + CONSTANTS.SEPARATOR + workspaceName + CONSTANTS.SEPARATOR + CONSTANTS.WORKSPACESTR + CONSTANTS.SEPARATOR + CONSTANTS.VIDEO + CONSTANTS.SEPARATOR;
    var invokerHeadlightStr = headlightStr + CONSTANTS.DISPLAYEDSTR;
    dw.logEvent(CONSTANTS.UT_NFW, invokerHeadlightStr);
    
	var objBrowserCtrl = document.getElementById("videoContainer");

	if (objBrowserCtrl !== undefined) {
        var browserWin = objBrowserCtrl.getWindow();
		if (browserWin) {
            var videoElem = browserWin.document.getElementById("videocontrol");
			if (videoElem) {
				var totalduration = videoElem.duration;
				var curTime = videoElem.currentTime;
				var durationWatched = (curTime / totalduration) * 100;
				
				var videoStr = CONSTANTS.EXITSTR;
				if (durationWatched <= 25) {
				    videoStr += "1";
                } else if (durationWatched <= 50) {
				    videoStr += "2";
                } else if (durationWatched <= 75) {
				    videoStr += "3";
                } else {
				    videoStr += "4";
                }
				
				headlightStr += videoStr;
                dw.logEvent(CONSTANTS.UT_NFW, headlightStr);
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		onResize
//
// PURPOSE
//		DW calls OnResize when there is some size change
/////////////////////////////////////////////////////////////////////////////
function onResize() {
    "use strict";
    
    if (isInitDone) {
        var objBrowserCtrl = document.getElementById("videoContainer");
        if (objBrowserCtrl) {
            objBrowserCtrl.style.height = window.innerHeight + "px";
		    objBrowserCtrl.style.width = window.innerWidth + "px";
        }
    } else {
        initializeUI();
    }
    
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		windowDimensions
//
// PURPOSE
//		return the custom window dimensions to DW
//		add padding to width and height for no scrollbar
/////////////////////////////////////////////////////////////////////////////
function windowDimensions(platform) {
    "use strict";
    var width = getContainerWidth();
    var height = getContainerHeight();
    var windowSize =  width + ',' + height;
    return windowSize;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		handleSpaceKeyPressed
//
// PURPOSE
//		handle when space key is pressed to play or pause the video
/////////////////////////////////////////////////////////////////////////////
function handleSpaceKeyPressed() {
    "use strict";
    var objBrowserCtrl = document.getElementById("videoContainer");

	if (objBrowserCtrl !== undefined) {
        var browserWin = objBrowserCtrl.getWindow();
		if (browserWin) {
            var videoElem = browserWin.document.getElementById("videocontrol");
			if (videoElem) {
                if (videoElem.paused === true) {
                    videoElem.play();
                } else {
                    videoElem.pause();
                }
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		handleEscapeKeyPressed
//
// PURPOSE
//		handle escape key
/////////////////////////////////////////////////////////////////////////////
function handleEscapeKeyPressed() {
    "use strict";
    window.close();
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION
//		needsCustomPositionFix
//
// PURPOSE
//		the function presence is checked for 10.11 multi monitor issue for
//      origin fix
/////////////////////////////////////////////////////////////////////////////
function needsCustomPositionFix() {
    "use strict";
}