/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2010 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
*
**************************************************************************/

var gSearchFieldHasFocus = false;
var gSearchFieldTimerPeriod = 300;
var gBrowser = null;
var gCurrentImageClick = null;
//strings needed to create the image source
var srcDir = "images/";
var normalImg = "_normal.png";
var hoverImg = "_hover.png";
var activeImg = "_active.png";
//variable holding the state of the filter parameters
var gActiveFilter = null;
var gActiveRecommendation = null;
var gMouseOverButton = null;
var gShowSelectedFonts = null;
// path to the FreeFontsImport.html
var gFontsDisplayHTML = "/FreeFontsUtility/FreeFontsImport.html";
//////////////////////////////////////////////////////////////////////////////////////////////

//--------------------------------------------------------------------
// FUNCTION:
//   onClickOkButton
//
// DESCRIPTION:
//	called when the OK button is clicked, it queries dwBrowser for selected fonts and iteratively adds
//  it to the webfontmanager's list of fonts
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function onClickOkButton()
{
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().getSelectedFonts)
	{
		dw.clearFreeFontList();
		var selectedFonts = gBrowser.getWindow().getSelectedFonts();
		
		if(selectedFonts)
		{
			for(var k = 0; k < selectedFonts.length; k++)	
			{
				var family = selectedFonts[k];
				var fontVariationArray = new Array(family.variations.length);
				for (var j = 0; j < family.variations.length; j++)
				{
					var fontVariation = new Object();
					fontVariation.id = family.variations[j].fvd;
					fontVariation.name = family.variations[j].name;
					fontVariationArray[j] = fontVariation;
				}
				dw.addFreeFont(family.id, family.name, family.slug, fontVariationArray, family.css_stack);
			}
		}
	}
	window.close();
}


//--------------------------------------------------------------------
// FUNCTION:
//   initUI
//
// DESCRIPTION:
//	Initialize the browser control and load the FreeFontImport.html which contains the UI code
//  The rendering of the dialog is different in Windows and Mac, hence the correction styles
//  for Mac are applied here
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function initUI() 
{
	gBrowser = document.getElementById('browser');						
	
	gBrowser.setScrollbarMode("off","h");
	gBrowser.addEventListener("BrowserControlLoad", initUIBrowser , true); 
	var configPath = dw.getConfigurationPath();
	var htmlPath = configPath + gFontsDisplayHTML;
	gBrowser.openURL(htmlPath);

	if(dw.isOSX())
	{
        var searchTable = document.getElementById('searchTable');
		searchTable.cellpadding = "0";
        
		var searchText = document.getElementById('searchText');
		searchText.size = "22";
		searchText.parentNode.style.width="150px";
			
		var textDiv = document.getElementById('textFilters');	
		textDiv.firstChild.border = "0";
			
		var searchImage = document.getElementById('searchImage');
		searchImage.style.paddingLeft = "5px";
			
		var filterLabel = document.getElementById('filterLabel');	
		filterLabel.style.top = "10px";
			
		var bottomBar = document.getElementById('bottomBar');	
		bottomBar.style.height = "60px";
	}
    else
    {
        gBrowser.style.width = "807px";
    }
	
	var okButton = document.getElementById('ok');	
	okButton.focus();
}

//--------------------------------------------------------------------
// FUNCTION:
//   initUIBrowser
//
// DESCRIPTION:
//	Called when BrowserControlLoad event is triggered, triggers the start of UI setup of Browser control
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------


function initUIBrowser()
{
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().initUI)
	{
		gBrowser.getWindow().initUI(dw.getUserConfigurationPath(), dw.getSelectedFreeFonts(), window);
	}
}

//--------------------------------------------------------------------
// FUNCTION:
//   handleCorruptFile
//
// DESCRIPTION:
//	Called when Browser cannot parse the json file or retrive the json file, this function deletes the corrupt json file
//  and prompts user to restart, as the backup json file can be loaded
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function handleCorruptFile()
{
	var	pathTojson = dw.getUserConfigurationPath() + "FreeFonts/FreeFonts.json";
	DWfile.remove(pathTojson);
	alert("The Font Data is found to be corrupt, Please restart Dreamweaver to use this feature");
	window.close();
}


//--------------------------------------------------------------------
// FUNCTION:
//   startCapture
//
// DESCRIPTION:
//	Called when searchtext text field gets Focus, it starts a timer that polls for change in text
//
// ARGUMENTS:
//   HTMLElement textfield
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------


function startTextCapture(textField)
{
	if(textField.value == "Filter by name")
		textField.value = "";
	
	gSearchFieldHasFocus = true;
	window.setTimeout(getTextFocus,gSearchFieldTimerPeriod); 
}

//--------------------------------------------------------------------
// FUNCTION:
//   getFocus
//
// DESCRIPTION:
//	Called when timer goes off, find the text in the search Field and apply the search
//  Also check if the search field still has focus, if yes apply next round of timer
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function getTextFocus()
{
	var textField = document.getElementById('searchText');
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().applySearch)
	{
		gBrowser.getWindow().applySearch(textField.value);
		gBrowser.refreshPageStyles();
		if(gSearchFieldHasFocus == true)
		{	
			window.setTimeout(getTextFocus,gSearchFieldTimerPeriod); 
		}
		//placing this code here as it ensures that "Filter by name" never gets searched
		else if(textField.value == "")
		{
			textField.value = "Filter by name";
		}
	}
}

//--------------------------------------------------------------------
// FUNCTION:
//   stopCapture
//
// DESCRIPTION:
//	Called when the search Field loses focus, it stops the timer
//
// ARGUMENTS:
//   HTMLElement textfield
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------


function stopTextCapture(textField)
{
	gSearchFieldHasFocus = false;	
}

//--------------------------------------------------------------------
// FUNCTION:
//   captureMouseDown
//
// DESCRIPTION:
//	Since we dont onClick for image, we capture mousedown and mouseup to validate a click
//
// ARGUMENTS:
//   HTMLElement image
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function captureMouseDown(id)
{
	gCurrentImageClick = id;
}

//--------------------------------------------------------------------
// FUNCTION:
//   handleFilterClick
//
// DESCRIPTION:
//	Handles the selection / deselection of filter either from button or image
//
// ARGUMENTS:
//   filter - imageObject , filterType - 0 for regular filter, 1 for recommendation, 2 for selected font filter
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function handleFilterClick(filter, filterType)
{
	switch(filterType)
		{
			//one of sans, serif, slab etc
			case 0:	
					if(gActiveFilter == filter)
					{	
						if(gMouseOverButton == filter)
							filter.src = srcDir + filter.id + hoverImg;
						else
							filter.src = srcDir + filter.id + normalImg;
						gActiveFilter = null;
						applyFilter("none");
					}
					else
					{
						if(gActiveFilter != null)
							gActiveFilter.src = srcDir + gActiveFilter.id + normalImg;
							
						filter.src = srcDir + filter.id + activeImg;
						gActiveFilter = filter;
						applyFilter(filter.id);
					}
					break;
					
			case 1:
					if(gActiveRecommendation == filter)
					{
						if(gMouseOverButton == filter)
							filter.src = srcDir + filter.id + hoverImg;
						else
							filter.src = srcDir + filter.id + normalImg;
						gActiveRecommendation = null;
						applyRecommendation("none");
					}
					else 
					{
						if(gActiveRecommendation != null)
							gActiveRecommendation.src = srcDir + gActiveRecommendation.id + normalImg;
							
						filter.src = srcDir + filter.id + activeImg;
						gActiveRecommendation = filter;
						applyRecommendation(filter.id);
					}
					break;
					
			case 2:
					if(gShowSelectedFonts != null)
					{
						filter.src = srcDir + filter.id + hoverImg;
						gShowSelectedFonts = null;
						showSelectedFonts(false);
					}
					else
					{
						filter.src = srcDir + filter.id + activeImg;
						gShowSelectedFonts = filter;
						showSelectedFonts(true);
					}
					break;
			
		}
		var focusItem = document.getElementById( filter.id + "Button");
		focusItem.focus();
}

//--------------------------------------------------------------------
// FUNCTIONS:
//   applyFilter, applyRecommendation, showSelectedFonts
//
// DESCRIPTION:
//	Passes the filter information to DWBrowser
//
// ARGUMENTS:
//  string representing the type of filter
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function applyFilter(str)
{
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().changeFilter)
	{
		gBrowser.getWindow().changeFilter(str);
	}
}

function applyRecommendation(str)
{
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().changeRecommendation)
	{
		gBrowser.getWindow().changeRecommendation(str);
	}
}

function showSelectedFonts(bool)
{
	if(gBrowser && gBrowser.getWindow()&& gBrowser.getWindow().showSelectedFonts)
	{
		gBrowser.getWindow().showSelectedFonts(bool);
	}
}
//--------------------------------------------------------------------
// FUNCTION:
//   captureMouseUp
//
// DESCRIPTION:
//	Since we dont have onClick for image, we capture mousedown and mouseup to validate a click
//
// ARGUMENTS:
//   filter - imageObject , filterType - 0 for regular filter, 1 for recommendation, 2 for selected font filter
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function captureMouseUp(filter, filterType)
{
	if(gCurrentImageClick == filter)
	{
		handleFilterClick(filter, filterType);		
	}
}

//--------------------------------------------------------------------
// FUNCTION:
//   captureMouseOver
//
// DESCRIPTION:
//	Called when the images get a mouseover event
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function captureMouseOver(filter)
{
	gMouseOverButton = filter;
	if( gActiveFilter != filter && gActiveRecommendation != filter && gShowSelectedFonts != filter)
	{
		filter.src=srcDir + filter.id + hoverImg;
        filter.alt=filter.altText;
        //altText is the dummy attribute used to refresh the tooltip, as it hides on image change in mac
	}
}

//--------------------------------------------------------------------
// FUNCTION:
//   captureButtonClick
//
// DESCRIPTION:
//	Called when the filter Button gets click / hit Enter
//
// ARGUMENTS:
//   filter - id of equivalent imageobject , filterType - 0 for regular filter, 1 for recommendation, 2 for selected font filter
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function captureButtonClick(filterId, filterType)
{
	var img = document.getElementById(filterId);
	handleFilterClick(img, filterType);
}

//--------------------------------------------------------------------
// FUNCTION:
//   captureMouseOver
//
// DESCRIPTION:
//	Called when the images get a mouseout message 
//
// ARGUMENTS:
//   none
//
// RETURNS:
//  nothing 
//--------------------------------------------------------------------

function captureMouseOut(filter)
{
	if(gMouseOverButton == filter && gActiveFilter != filter && gActiveRecommendation != filter && gShowSelectedFonts != filter)
	{
		filter.src = srcDir + filter.id + normalImg;
        filter.alt="";
	}
	gMouseOverButton = null;
}
