/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true*/

define([
    'underscore',
    'backbone',
    'Constants'
], function (_, Backbone, Constants) {
    "use strict";
    var LandingPageModel = Backbone.Model.extend({

        defaults: {
        },

        currentConfiguration: null,

        configurations: [
            {
                segment     : 'get-measurements-extract-cta',  // We use this to segment our metrics. Each one should be unique
                directory   : 'marketing/marketing_psd',
                guid        : 'marketing-psd-cta',
                behavior    : function () {
                    graphite.events.off('show-extract-asset-popup');
                    graphite.events.on('show-extract-asset-popup', function () {
                        graphite.events.trigger('load-call-to-action');
                    });
                }
            },
            {
                segment     : 'inspire-styles-cta',  // We use this to segment our metrics. Each one should be unique
                directory   : 'marketing/inspire_styles',
                guid        : 'inspire-styles-cta',
                behavior    : function () {
                    graphite.events.off('show-extract-asset-popup');
                    graphite.events.on('show-extract-asset-popup', function () {
                        graphite.events.trigger('load-call-to-action');
                    });
                }
            },
            {
                segment     : 'inspire-measurements-cta',  // We use this to segment our metrics. Each one should be unique
                directory   : 'marketing/inspire_measurements',
                guid        : 'inspire-measurements-cta',
                behavior    : function () {
                    graphite.events.off('show-extract-asset-popup');
                    graphite.events.on('show-extract-asset-popup', function () {
                        graphite.events.trigger('load-call-to-action');
                    });
                }
            }
        ],

        configurationLookup : {},

        initialize: function () {
            var i;
            for (i in this.configurations) {
                if (this.configurations.hasOwnProperty(i)) {
                    this.configurationLookup[this.configurations[i].segment] = this.configurations[i];
                }
            }
        },

        getLandingPage: function (segment) {
            if (segment && this.configurationLookup[segment]) {
                this.currentConfiguration = this.configurationLookup[segment];
            } else {
                this.currentConfiguration = this.configurations[Math.floor(Math.random() * this.configurations.length)];
            }
            return this.currentConfiguration;
        }

    });

    return new LandingPageModel();
});
