/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, require: true*/

require.config({
    paths: {
        dwconfig: '../../../../dwconfig/dwconfig',
        jquery: 'libs/jquery/jquery.min',
        mpAjax: 'libs/jquery/dwMultipartParser',
        breadcrumb: 'libs/jquery/jquery.rcrumbs',
        jqueryTranslate: 'libs/jquery/jquery.i18n.properties-1.0.9',
        underscore: 'libs/underscore/underscore-min',
        backbone: 'libs/backbone/backbone-min',
        parfait: '../lib/graphite-api/public/js',
        override: '../../../../js',
        dreamweaver: '../../../../js',
        images: 'lib/graphite-api/public/images',


        // storage has built in support for requirejs
        // hence, it doesn't need to configured in 'shim'
        //storage: 'libs/backbone/backbone.localStorage',
        text: 'libs/require/text',

        'plugin-dependencies': 'libs/pluginshim/plugin-dependencies',
        'plugin-components': 'libs/pluginshim/'
    },

    shim: {
        underscore: {
            exports: '_'
        },

        backbone: {
            deps: [ 'underscore', 'jquery' ],
            exports: 'Backbone'
        },
        
        mpAjax: {
            deps: [ 'jquery' ],
            exports: 'mpAjax'
        },
        
        breadcrumb: {
            deps: [ 'jquery' ],
            exports: 'breadcrumb'
		},

        jqueryTranslate: {
            deps: [ 'jquery' ],
            exports: 'jqueryTranslate'
        }
        
    },

    map: {
        '*': {
            css: 'libs/require/css/css',
            "routes/appRouter": "override/routes/DwAppRouter",
            "serverAPI": "override/DwServerAPI",
            "DWPSDExtractManager": "override/DWPSDExtractManager",
            "DWPSDExtractSelectionHandler": "override/DWPSDExtractSelectionHandler",
            "DWPopUpManager": "override/DWPopUpManager",

            "parfait/UserPlacardView": "views/UserPlacardView",
            "parfait/PSDAssetsView": "ccweb.files.extract/views/assets/PSDAssetsView",
            "parfait/PSDPreviewView": "ccweb.files.extract/views/preview/PSDPreviewView",
            "parfait/AlertView": "views/AlertView",
            "parfait/SelectionBarView": "ccweb.files.extract/views/detail/SelectionBarView",
            "parfait/PSDDetailsView": "ccweb.files.extract/views/detail/PSDDetailsView",
            "parfait/DetailsController": "ccweb.files.extract/controllers/DetailsController",
            "parfait/DetailPanelView": "ccweb.files.extract/views/detail/DetailPanelView",
            "parfait/AssetListView": "views/landing/AssetListView",
            "parfait/AssetView": "views/landing/AssetView",
            "parfait/LayerItemView": "ccweb.files.extract/views/layers/LayerItemView",
            "parfait/LayerGroupItemView": "ccweb.files.extract/views/layers/LayerGroupItemView",
            "parfait/UserSettingsPopupView": "views/popup/UserSettingsPopupView",
            "parfait/ExtractAssetView": "ccweb.files.extract/views/popup/ExtractAssetView",
            "parfait/Constants": "ccweb.files.extract/Constants",
            "parfait/AssetController": "ccweb.files.extract/controllers/AssetController",
            "parfait/DerivedAssetController": "ccweb.files.extract/controllers/DerivedAssetController",
            "parfait/FlattenedAssetController": "ccweb.files.extract/controllers/FlattenedAssetController",
            "parfait/KeyboardController": "ccweb.files.extract/controllers/KeyboardController",
            "parfait/SelectionController": "ccweb.files.extract/controllers/SelectionController",
            "parfait/ZoomController": "ccweb.files.extract/controllers/ZoomController",
            "parfait/LayerModel": "ccweb.files.extract/models/LayerModel",
            "parfait/LayerPropertiesModel": "ccweb.files.extract/models/LayerPropertiesModel",
            "parfait/MetricsProxyModel": "ccweb.files.extract/models/MetricsProxyModel",
            "parfait/PSDModel": "ccweb.files.extract/models/PSDModel",
            "parfait/ImageUtil": "ccweb.files.extract/utils/ImageUtil",
            "parfait/SpriteSheetUtils": "ccweb.files.extract/utils/SpriteSheetUtils",
            "parfait/LayerCompView": "ccweb.files.extract/views/detail/LayerCompView",
            "parfait/ZoomView": "ccweb.files.extract/views/detail/ZoomView",
            "parfait/ContextMenuView": "ccweb.files.extract/views/inspect/ContextMenuView",
            "parfait/InspectCSSView": "ccweb.files.extract/views/inspect/InspectCSSView",
            "parfait/InspectFontFamilyView": "ccweb.files.extract/views/inspect/InspectFontFamilyView",
            "parfait/PSDInspectView": "ccweb.files.extract/views/inspect/PSDInspectView",
            "parfait/LayersListItemView": "ccweb.files.extract/views/layers/LayersListItemView",
            "parfait/LayersListView": "ccweb.files.extract/views/layers/LayersListView",
            "parfait/BasePopupView": "ccweb.files.extract/views/popup/BasePopupView",
            "parfait/BasePreviewPopupView": "ccweb.files.extract/views/popup/BasePreviewPopupView",
            "parfait/ColorChipPopupView": "ccweb.files.extract/views/popup/ColorChipPopupView",
            "parfait/InterceptPopupView": "ccweb.files.extract/views/popup/InterceptPopupView",
            "parfait/LayerThumbPopupView": "ccweb.files.extract/views/popup/LayerThumbPopupView",
            "parfait/MeasurementOffsetPopupView": "ccweb.files.extract/views/popup/MeasurementOffsetPopupView",
            "parfait/MeasurementPopupView": "ccweb.files.extract/views/popup/MeasurementPopupView",
            "parfait/InspectStyleOverlayView": "ccweb.files.extract/views/preview/InspectStyleOverlayView",
            "parfait/MouseListenerOverlayView": "ccweb.files.extract/views/preview/MouseListenerOverlayView",
            "parfait/PopupOverlayView": "ccweb.files.extract/views/preview/PopupOverlayView",
            "parfait/SelectionOverlayView": "ccweb.files.extract/views/preview/SelectionOverlayView",
            
            "views/UserPlacardView": "override/views/DwUserPlacardView",
            "ccweb.files.extract/views/assets/PSDAssetsView": "override/views/DwPSDAssetsView",
            "ccweb.files.extract/views/preview/PSDPreviewView": "override/views/DwPSDPreviewView",
            "views/AlertView": "override/views/DwAlertView",
            "ccweb.files.extract/views/detail/SelectionBarView": "override/views/DwSelectionBarView",
            "ccweb.files.extract/views/detail/PSDDetailsView": "override/views/DwPSDDetailsView",
            "ccweb.files.extract/controllers/DetailsController": "override/controllers/DwDetailsController",
            "ccweb.files.extract/views/detail/DetailPanelView": "override/views/DwDetailPanelView",
            "views/landing/AssetListView": "override/views/DwAssetListView",
            "views/landing/AssetView": "override/views/DwAssetView",
            "ccweb.files.extract/views/layers/LayerItemView": "override/views/DwLayerItemView",
            "ccweb.files.extract/views/layers/LayerGroupItemView": "override/views/DwLayerGroupItemView",
            "ccweb.files.extract/views/popup/ExtractAssetView": "override/views/DwExtractAssetView",
            "ccweb.files.extract/Constants": "override/Constants",
            "ccweb.files.extract/controllers/AssetController": "override/controllers/DwAssetController",
            "ccweb.files.extract/controllers/DerivedAssetController": "override/controllers/DwDerivedAssetController",
            "ccweb.files.extract/controllers/FlattenedAssetController": "override/controllers/DwFlattenedAssetController",
            "ccweb.files.extract/controllers/KeyboardController": "override/controllers/DwKeyboardController",
            "ccweb.files.extract/controllers/SelectionController": "override/controllers/DwSelectionController",
            "ccweb.files.extract/controllers/ZoomController": "override/controllers/DwZoomController",
            "ccweb.files.extract/models/LayerModel": "override/models/DwLayerModel",
            "ccweb.files.extract/models/LayerPropertiesModel": "override/models/DwLayerPropertiesModel",
            "ccweb.files.extract/models/MetricsProxyModel": "override/models/DwMetricsProxyModel",
            "ccweb.files.extract/models/PSDModel": "override/models/DwPSDModel",
            "ccweb.files.extract/utils/ImageUtil": "override/utils/DwImageUtil",
            "ccweb.files.extract/utils/SpriteSheetUtils": "override/utils/DwSpriteSheetUtils",
            "ccweb.files.extract/views/detail/LayerCompView": "override/views/detail/DwLayerCompView",
            "ccweb.files.extract/views/detail/ZoomView": "override/views/detail/DwZoomView",
            "ccweb.files.extract/views/inspect/ContextMenuView": "override/views/inspect/DwContextMenuView",
            "ccweb.files.extract/views/inspect/InspectCSSView": "override/views/inspect/DwInspectCSSView",
            "ccweb.files.extract/views/inspect/InspectFontFamilyView": "override/views/inspect/DwInspectFontFamilyView",
            "ccweb.files.extract/views/inspect/PSDInspectView": "override/views/inspect/DwPSDInspectView",
            "ccweb.files.extract/views/layers/LayersListItemView": "override/views/layers/DwLayersListItemView",
            "ccweb.files.extract/views/layers/LayersListView": "override/views/layers/DwLayersListView",
            "ccweb.files.extract/views/popup/BasePopupView": "override/views/popup/DwBasePopupView",
            "ccweb.files.extract/views/popup/BasePreviewPopupView": "override/views/popup/DwBasePreviewPopupView",
            "ccweb.files.extract/views/popup/ColorChipPopupView": "override/views/popup/DwColorChipPopupView",
            "ccweb.files.extract/views/popup/InterceptPopupView": "override/views/popup/DwInterceptPopupView",
            "ccweb.files.extract/views/popup/LayerThumbPopupView": "override/views/popup/DwLayerThumbPopupView",
            "ccweb.files.extract/views/popup/MeasurementOffsetPopupView": "override/views/popup/DwMeasurementOffsetPopupView",
            "ccweb.files.extract/views/popup/MeasurementPopupView": "override/views/popup/DwMeasurementPopupView",
            "ccweb.files.extract/views/preview/InspectStyleOverlayView": "override/views/preview/DwInspectStyleOverlayView",
            "ccweb.files.extract/views/preview/MouseListenerOverlayView": "override/views/preview/DwMouseListenerOverlayView",
            "ccweb.files.extract/views/preview/PopupOverlayView": "override/views/preview/DwPopupOverlayView",
            "ccweb.files.extract/views/preview/SelectionOverlayView": "override/views/preview/DwSelectionOverlayView",
            
            "ccweb.files.extract/views/popup/ExtractCodeView": "override/views/StylesPopupView",
            
            "ccweb.files.extract/views/templates": "override/views/templates"
        }
    },

    urlArgs: 'sha=***gitSHA***' // ***gitSHA*** is the SHA from git, inserted as part of the post-deploy grunt task

});

require([ 'override/dwApp' ], function () {
    "use strict";
});
