/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, Image:true */

define([
    'underscore',
    'backbone',
    'ccweb.files.extract/views/popup/BasePopupView',
    'plugin-dependencies',
    'ccweb.files.extract/utils/ImageUtil',
    'ccweb.files.extract/utils/TemplateUtil',
    'ccweb.files.extract/utils/SpriteSheetUtils',
    'text!ccweb.files.extract/views/templates/assetThumbPopupTemplate.html'
], function (_, Backbone, BasePopupView, deps, ImageUtil, TemplateUtil, SpriteSheetUtils, AssetThumbPopupTemplate) {
    'use strict';
    var AssetThumbPopupView = BasePopupView.extend({

        className: 'asset-thumb-popup popup',

        initialize: function () {
            BasePopupView.prototype.initialize.apply(this, arguments);

            // events
            graphite.events.on('load-asset-thumb-popup', this.handleLoadAssetThumb, this);
            graphite.events.on('show-asset-thumb-popup', this.handleShow, this);
            graphite.events.on('hide-asset-thumb-popup', this.closePopup, this);
        },

        render: function () {
            BasePopupView.prototype.render.apply(this, arguments);
            this.$el.find('.popup-contents').html(
                TemplateUtil.createTemplate(AssetThumbPopupTemplate)
            );

            return this;
        },

        removeEventListeners: function () {
            graphite.events.off(null, null, this);
        },

        //------------------------------------------------
        // Handlers
        //------------------------------------------------

        handleLoadAssetThumb: function (model) {
            var url = (model.get('mimeType') === 'image/svg+xml') ?
                        graphite.serverAPI.getDerivedDownloadURL(model.get('guid'), model.get('name')) :
                        graphite.serverAPI.getDerivedRenditionURL(model.get('guid')),
                image = new Image(),
                $preview = this.$el.find('.sprite_preview');

            image.addEventListener('load', function () {
                $preview[0].width = image.width;
                $preview[0].height = image.height;
                var context = $preview[0].getContext('2d');
                context.drawImage(image, 0, 0);
                image.removeEventListener('load');
            });
            graphite.serverAPI.loadCrossDomainImage(image, url);
        },

        closePopup: function () {
            BasePopupView.prototype.closePopup.apply(this, arguments);
            this.$el.find('.preview').attr('src', '');
        },

        remove: function () {
            this.removeEventListeners();
            BasePopupView.prototype.remove.call(this);
        }

    });

    return AssetThumbPopupView;
});
