
/*jslint vars: true, node: true */
"use strict";

var fs = require('fs');
var path = require('path');
var cache = require('../cache');
var imsServiceTokenUtils = require('../utils').imsServiceTokenUtils;

var Step = require('step');
var handlerUtils = require('../utils').handlerUtils;
var stepUtils = require('../utils').stepUtils;
var userFeatureUtils = require('../utils').userFeatureUtils;

var mimeMap = {
    '.txt': 'text/plain',
    '.html': 'text/html',
    '.htm': 'text/html',
    '.css': 'text/css',
    '.xml': 'application/xml',
    '.json': 'application/json',
    '.js': 'application/javascript',
    '.jpg': 'image/jpeg',
    '.jpeg': 'image/jpeg',
    '.gif': 'image/gif',
    '.png': 'image/png',
    '.woff': 'application/font-woff'
};

var WEB_APP_PATH = "/public";
var WELCOME_PAGE = "admin.html";

function serveAdminContent(req, res, next) {
//    console.log('@staticHandler: serving ' + req.url);

    var filePath = '.' + WEB_APP_PATH + req.url;
    if (filePath == '.' + WEB_APP_PATH + "/") {
        filePath = '.' + WEB_APP_PATH + '/' + WELCOME_PAGE; // Default page (welcome page)
    }

    // Get rid of request paramaters if any
    filePath = filePath.split("?")[0];
    var extname = path.extname(filePath);
    var contentType = mimeMap[extname] ? mimeMap[extname] : 'text/html';
//   console.log("static serving: " + filePath);

    path.exists(filePath, function (exists) {
        if (exists) {
            var content = cache.get(filePath, {'type': 'file'});
            res.cache("no-Cache");
            res.writeHead(200, {'Content-Type': contentType});
            res.end(content, 'utf-8');
        } else {//Redirect to root
//            console.log("redirect: file doesn't exist:" +filePath);
            res.header('Location', '/');
            res.send(302);
        }
    });
}

function putUserFeatureFlag(req, res, next) {
    var featureFlag;
    var userID;
    var newData;
    res.cache("no-Cache");
    
    if (handlerUtils.userNotAllowed(req, res))
        return;
    
    try {
        Step(
            function processFormPost() {
                stepUtils.processFormInRequest(null, req, null, this);
            },
            function getUserData(err, files, fields, localServiceToken) {
                if (err) {
                    throw err;
                }
                
                userID = fields["userID"];
                featureFlag = fields["featureFlag"];
            
                userFeatureUtils.getUserData(userID, featureFlag === 'accountEnabled', this);
            },
            function updateUserData(err, data) {
                if (err) {
                    throw err;
                }
                if (!data)
                    throw "User is not registered";
                
                data[featureFlag] = true;
                newData = data;
                userFeatureUtils.putUserData(userID, data, this);
            },
            function returnResult(err, data) {
                if (err) {
                    newData = {error: err}
                }
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(newData));
            });
    } catch (err) {
        res.send(500, "Could not set feature flag: " + err);
    }
}
    
function delUserFeatureFlag(req, res, next) {
    var featureFlag;
    var userID;
    var newData;
    res.cache("no-Cache");
    
    if (handlerUtils.userNotAllowed(req, res))
        return;
    
    try {
        Step(
            function processFormPost() {
                stepUtils.processFormInRequest(null, req, null, this);
            },
            function getUserData(err, files, fields, localServiceToken) {
                if (err) {
                    throw err;
                }
                
                userID = fields["userID"];
                featureFlag = fields["featureFlag"];
            
                userFeatureUtils.getUserData(userID, false, this);
            },
            function updateUserData(err, data) {
                if (err) {
                    throw err;
                }
                if (!data)
                    throw "User is not registered"; 
                
                if (featureFlag === 'accountEnabled') {
                    data[featureFlag] = false;
                } else {
                    delete data[featureFlag];
                }
                newData = data;
                userFeatureUtils.putUserData(userID, data, this);
            },
            function returnResult(err, data) {
                if (err) {
                    newData = {error: err}
                }
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(newData));
            });
    } catch (err) {
        res.send(500, "Could not remove feature flag: " + err);
    }
}

function getWaitListedUsers(req, res, next) {
    var newData;
    res.cache("no-Cache");
    
    if (handlerUtils.userNotAllowed(req, res))
        return;    
    
    try {
        Step(
            function getWaitListedUsers() {                     
                userFeatureUtils.getWaitListedUsers(this);
            },
            function returnResult(err, data) {
                if (err) {
                    newData = {error: err};
                }
                newData = data;
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(newData));
            });
    } catch (err) {
        res.send(500, "Could not get wait listed users: " + err);
    }
}


function getAllUsers(req, res, next) {
    var newData;
    res.cache("no-Cache");
    
    if (handlerUtils.userNotAllowed(req, res))
        return;    
    
    try {
        Step(
            function getAllUsers() {                     
                userFeatureUtils.getAllUsers(this);
            },
            function returnResult(err, data) {
                if (err) {
                    newData = {error: err};
                }
                newData = data;
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(newData));
            });
    } catch (err) {
        res.send(500, "Could not get all users: " + err);
    }
}


function installHandlers(server) {
    server.put('/api/v1/user/flag', putUserFeatureFlag);
    server.del('/api/v1/user/flag', delUserFeatureFlag);    
    server.get('/api/v1/waitListedUsers', getWaitListedUsers);    
    server.get('/api/v1/allUsers', getAllUsers);    
}

module.exports = {
    handleAdminContent : serveAdminContent,
    installHandlers : installHandlers
};
