/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/views/layers/LayerItemView',
    'ccweb.files.extract/views/layers/LayerGroupItemView',
    'ccweb.files.extract/Constants',
    'plugin-dependencies',
    'parfait/LayersListView'
], function ($, _, Backbone, LayerItemView, LayerGroupItemView, Constants, deps, LayersListView) {
    'use strict';
    
    function isDefaultVisibility(items) {
        for (var i = 0, ii = items.length; i < ii; i++) {
            var layer = items[i];
            if (layer.model.get('visible') !== layer.model.get('psdVisible')) {
                return false;
            }
            if (layer.subItems && !isDefaultVisibility(layer.subItems)) {
                return false;
            }
        }
        return true;
    }
    
    var DwLayersListView = LayersListView.extend({
        template: '<div class="section-wrapper"><button id="resetLayers">' + deps.translate("RESET") + '</button></div><div class="layers-list">' +
                    '</div>',
        render: function () {
            var tmpl = _.template(this.template),
                view = this;
            view.$el.html(tmpl);
            view.$layersList = $(view.el).find('.layers-list');
            var $resetButton = $(view.el).find('#resetLayers');

            graphite.events.on('layerVisiblityChanged', function () {
                $resetButton.attr({
                    disabled: isDefaultVisibility(view.layerItems)
                });
            }, this);
            graphite.events.on('reset-layers-visibility', function () {
                $resetButton.attr({
                    disabled: true
                });
            }, this);

            return this;
        },
        
        handleResetLayers: function () {
            graphite.events.trigger('reset-layers-visibility', {});
            graphite.events.trigger("layers-usage" , {formatSubEvent : ["Reset"]});
        },
        
        handleModelLayerCollectionChanged: function () {
            var self,
                layerCollection,
                i,
                layerModel,
                type,
                listItem;

            this.layerItems.length = 0;
            this.$layersList.empty();
            if (this.model.get('layerCollection') !== null) {
                self = this;
                layerCollection = this.model.get('layerCollection');
                for (i = layerCollection.length - 1; i > -1; i--) {
                    layerModel = layerCollection.at(i);
                    type = layerModel.get('type');
                    if ((type === Constants.Type.LAYER_GROUP) || (type === Constants.Type.LAYER_ARTBOARD)) {
                        listItem = new LayerGroupItemView({model: layerModel,
                                                           psdGuid: self.model.get('id'),
                                                           toplevel: true});
                        this.layerItems.push(listItem);
                    } else {
                        listItem = new LayerItemView({model: layerModel,
                                                      psdGuid: self.model.get('id'),
                                                      toplevel: true});
                        this.layerItems.push(listItem);
                    }
                    this.$layersList.append(listItem.el);
                }

            }
            
            if (this.model.get('dataType') !== 'complete') {
                this.$layersList.find('.visible-button').css('opacity', '.2').off('click');
                this.$layersList.find('.image-wrapper').hide();
                this.$layersList.find('.layer-group-label').css('margin-left', '0px');
                this.$layersList.find('.layer-label').css('margin-left', '0px');
            }
        }
    });
    
    return DwLayersListView;
});