/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, window: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/views/inspect/InspectCSSView',
    'ccweb.files.extract/views/inspect/InspectFontFamilyView',
    'ccweb.files.extract/views/inspect/InspectSolidColorView',
    'ccweb.files.extract/views/inspect/DropperColorView',
    'ccweb.files.extract/views/inspect/InspectGradientView',
    'ccweb.files.extract/views/inspect/ContextMenuView',
    'ccweb.files.extract/models/FontFamilyModel',
    'ccweb.files.extract/controllers/DetailsController',
    'ccweb.files.extract/controllers/ClipboardController',
    'ccweb.files.extract/controllers/SelectionController',
    'ccweb.files.extract/models/ColorModel',
    'ccweb.files.extract/models/ColorUsageModel',
    'ccweb.files.extract/models/PSDSettingsModel',
    'ccweb.files.extract/models/UserSettingsModel',
    'plugin-dependencies',
    'ccweb.files.extract/utils/TemplateUtil',
    'ccweb.files.extract/Constants',
    'ccweb.files.extract/utils/CSSUtil',
    'text!ccweb.files.extract/views/templates/autoExtractedItemsTemplate.html',
    'parfait/PSDInspectView'
], function ($, _, Backbone, InspectCSSView, InspectFontFamilyView, InspectSolidColorView, DropperColorView,
             InspectGradientView, ContextMenuView, FontFamilyModel, DetailsController, ClipboardController,
             SelectionController, ColorModel, ColorUsageModel, PSDSettingsModel, UserSettingsModel,
             deps, TemplateUtil, Constants, CSSUtil, AutoExtractedItemsTemplate, PSDInspectView) {
    'use strict';

    var DwPSDInspectView = PSDInspectView.extend({
        events: function () {
            return _.extend({}, PSDInspectView.prototype.events, {
                "change #unitTypeDropdown": "handlePreferredUnitTypeChanged"
            });
        },
        
        initialize: function () {
            this.render();
            this.model.on('change:extractedStyles', this.handleModelExtractedStylesChange, this);
            DetailsController.on('change:selectedInspectItem', this.handleSelectedInspectItemChange, this);

            if (this.model.get('extractedStyles')) {
                this.handleModelExtractedStylesChange();
            }

            graphite.events.on('commitDropperColor', this.handleNewDropperColor, this);
            graphite.events.on('psdSettingsChanged', this.handlePSDSettingsChanged, this);
        },
        
        remove: function () {
            this.cssView.remove();
            this.cssView = null;

            this.removeEventListeners();

            // Remove color chip views
            _.each(this.colorChips, function (colorChip) {
                colorChip.remove();
            });
            this.colorChips.length = 0;
            // Remove gradient chip views
            _.each(this.gradientChips, function (gradientChip) {
                gradientChip.remove();
            });
            this.gradientChips.length = 0;
            // Remove font family views
            _.each(this.fontFamilyViews, function (fontFamily) {
                fontFamily.remove();
            });
            this.fontFamilyViews.length = 0;
			this.$el.empty();
            Backbone.View.prototype.remove.call(this);
        },
        
        createCSSView: function () {
            var cssList = this.$el.find('.css-properties'),
                baseFontSizeValue = PSDSettingsModel.get('baseFontSizeValue'),
                baseFontSizeUnits = PSDSettingsModel.get('baseFontSizeUnits'),
                preferredFontUnits = UserSettingsModel.get('preferredFontUnits');

            if (!preferredFontUnits) {
                preferredFontUnits = Constants.FontUnitType.PX;
            }
            this.$el.find("#unitTypeDropdown").val(preferredFontUnits);
            this.$el.find('.fontUnit').text(preferredFontUnits);
            this.handlePreferredUnitTypeChanged(preferredFontUnits);

            this.cssView = new InspectCSSView({parentView: this});
            this.cssView.el = cssList;

            this.$el.find("#unitTypeDropdown").val(preferredFontUnits);
        },
        
        handlePreprocessorMenuShow: function ($menu) {
            var currentPreprocessor = UserSettingsModel.get('preprocessor');
            $menu.find('a').removeClass('active');
            $menu.find('a').each(function () {
                if ($(this).attr('data') === currentPreprocessor) {
                    $(this).addClass('active');
                }
            });
        }
    });
    return DwPSDInspectView;
});