/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/controllers/SelectionController',
    'ccweb.files.extract/views/inspect/InspectFontFaceView',
    'ccweb.files.extract/utils/TemplateUtil',
    'ccweb.files.extract/utils/FontUtil',
    'text!ccweb.files.extract/views/templates/fontFamilyListItemTemplate.html',
	'DWPSDExtractManager',
    'plugin-dependencies',
    'parfait/InspectFontFamilyView'
], function ($, _, Backbone, SelectionController, InspectFontFaceView, TemplateUtil, FontUtil,
             FontFamilyListItemTemplate, DWPSDExtractManager, deps, InspectFontFamilyView) {
    'use strict';

    var DwInspectFontFamilyView = InspectFontFamilyView.extend({
        render: function () {
            var self = this,
                faces = this.model.get('faces'),
                fontFace,
                fontFaceObj,
                isInteger,
                $typekitAnchor,
                $familyName,
                count = 0;

            this.setElement(TemplateUtil.createTemplate(FontFamilyListItemTemplate, this.model));
            this.$el.addClass('closed');
            this.$el.find('.font-face-list').hide();
            $typekitAnchor = this.$el.find('.typekit-anchor');
            $familyName = this.$el.find('.font-family-name');

            // Configure TypeKit URL
            var typekitURL = FontUtil.getTypeKitURL(this.model.get('friendlyName'), function (result) {
                $typekitAnchor.attr('href', result);
            }, this);
            $typekitAnchor.attr('href', typekitURL);

            var keys = _.keys(faces);
            if (keys) {
                keys.sort(this.sortFaces);
            }

            _.each(keys, function (faceName) {
                var styles = faces[faceName];
                styles.sort(self.sortTextSizeFunction);
                isInteger = faceName >>> 0 === parseFloat(faceName);
                faceName = isInteger ? 'font-weight ' + faceName : faceName;
                fontFaceObj = {fontFace: faceName, styles: styles};
                fontFace = new InspectFontFaceView({model: fontFaceObj, ppi: self.ppi});
                self.fontFaceViews.push(fontFace);

                $(self.el).find('.font-face-list').append(fontFace.el);
                $(self.el).find('.font-face-list').append('<div style="clear:both;"></div>');
                count++;
            });

            this.$el.find('.font-face-list').append('<div class="list-bottom-padding"></div>');
            this.$el.find('.font-face-count p').text(count);

        },
        
        handleSelectionChange: function () {
            var self = this,
                textStylesInSelection = SelectionController.get('extractedStylesInSelection').textStyles,
                selectedLayers = SelectionController.getSelectedLayers();

            $.each(textStylesInSelection, function (textStyleIndex, textStyle) {
                if (textStyle.get('style').get('fontName') === self.model.get('name')) {
                    // Only open font-family sections if we have something selected, otherwise with nothing selected, all styles will open
                    if (selectedLayers.length > 0) {
                        $(self.el).removeClass('closed');
                        self.updateClosedStatus();
                    }
                }
            });
        },
        
        handleTypeKitLink: function () {
            DWPSDExtractManager.openInBrowser(this.$el.find(".typekit-anchor").attr("href"));
            graphite.events.trigger('typekitSearch');
        }
    });
    
    return DwInspectFontFamilyView;
});
