/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true, window: true*/

define([
    'jquery',
    'underscore',
    'backbone'
], function ($, _, Backbone) {
    "use strict";
    var MetricsProxyModel = Backbone.Model.extend({

        defaults: {
            authModel: null,
            configModel: null,
            welcomeExpLaunched: null
        },

        // The Auth model and Config model are necessarily different betwixt Parfait and Extract, so we pass them in during initialization. Weak Typing is your friend
        setAuthModel: function (model) {
            this.authModel = model;
        },

        setConfigModel: function (model) {
            this.configModel = model;
            this.setDefaultParam('parfaitBuild', this.configModel.getBuildNumber());
        },
        
        setWelcomeExperienceEvent: function () {
            this.welcomeExpLaunched = "";
            if (window.dwData.isWelcomeExpDismissed === "false") {
                this.welcomeExpLaunched = "Tutorial";
            }
        },

        initialize: function () {
            window.graphite = window.graphite || {};
            window.graphite.events = window.graphite.events || _.extend({}, Backbone.Events);

            window.graphite.events.on("uploaded", this.uploaded, this);
            window.graphite.events.on("upload-failed", this.uploadFailed, this);
            window.graphite.events.on("drawPreviewFinish", this.drawPreviewFinish, this);//Confusing, because unlike other event listeners, this fires a "rendered" event
            window.graphite.events.on("selectedTab", this.selectedTab, this);
            window.graphite.events.on("help-dialog", this.helpDialog, this);
            window.graphite.events.on("help-dialog-shortcut", this.helpDialogShortCut, this);
            window.graphite.events.on("show-measurement-offsets", this.showMeasurementOffsets, this);
            window.graphite.events.on("color-format", this.colorFormat, this);
            window.graphite.events.on("report-fidelity-error", this.reportFidelityError, this);
            window.graphite.events.on("extract-asset-download-init", this.extraAssetDownload, this);
            window.graphite.events.on("asset-extracted-scaled", this.scaledAssetExtracted, this);
            window.graphite.events.on("asset-extracted-optimized", this.optimizedAssetExtracted, this);
            window.graphite.events.on("psdThumbnailClick", this.psdThumbnailClicked, this);
            window.graphite.events.on("sharedPsdThumbnailClick", this.sharedPsdThumbnailClicked, this);
            window.graphite.events.on("psdThumbnailRightClick", this.psdThumbnailRightClicked, this);
            window.graphite.events.on("canvasClickDrag", this.canvasClickDrag, this);
            window.graphite.events.on("register-defaults", this.registerDefaults, this);
            window.graphite.events.on('bad-file-type-dragdrop', this.badFileTypeDragDrop, this);
            window.graphite.events.on("featureFlagSet", this.featureFlagSet, this);
            window.graphite.events.on("layerCompShown", this.layerCompShown, this);
            window.graphite.events.on("layerComp-dropdown-used", this.layerCompDropdownUsed, this);
            window.graphite.events.on("css-copy-gradients", this.cssCopiedForGradients, this);
            window.graphite.events.on("css-copy-fonts", this.cssCopiedForFonts, this);
            window.graphite.events.on("dimensions-multiSelect-used", this.dimensionsInMultiSelectUsed, this);
            window.graphite.events.on("use-extract-offline", this.useExtractOffline, this);
            window.graphite.events.on("asset-download-css-hud", this.assetDownloadFromCSSHud, this);
            window.graphite.events.on("asset-download-layers-panel", this.assetDownloadFromLayersPanel, this);
            window.graphite.events.on("upload-psd", this.handlePSDUpload, this);
            window.graphite.events.on("copy-css", this.copyCSS, this);
            window.graphite.events.on("copy-text", this.copyText, this);
            window.graphite.events.on("copy-selected-text-css-hud", this.copySelectedTextCSSHud, this);
            window.graphite.events.on("copy-selected-text-fonts-style", this.copySelectedTextFontsStyle, this);
            window.graphite.events.on("copy-selected-text-gradients-style", this.copySelectedTextGradientsStyle, this);
            window.graphite.events.on("copy-colors-style", this.copyColorsStyle, this);
            window.graphite.events.on("get-started-clicked", this.getStartedButtonClicked, this);
            window.graphite.events.on("zoom-to-fit", this.zoomToFit, this);
            window.graphite.events.on("zoom-changed", this.zoomChanged, this);
            window.graphite.events.on("layers-usage", this.layersUsage, this);
            window.graphite.events.on("show-settings-clicked", this.showSettingsButtonClicked, this);
            window.graphite.events.on("save-multiple-initiated", this.saveMultipleInitiated, this);
            window.graphite.events.on("batch-extract-scale", this.batchExtractScale, this);
            window.graphite.events.on("psd-upload-initiated", this.psdUploadInitiated, this);
            window.graphite.events.on("artboardpsd-shown", this.handleArtboardShown, this);
            window.graphite.events.on("artboard-zoomToFit", this.handleArtboardZoomToFit, this);

            this.defaultParams = {
            };
        },

        registerDefaults: function () {
            graphite.serverAPI.registerPersistentParameters(this.defaultParams);
            window.graphite.events.off("register-defaults");
        },

        mergeParams: function (params) {
            var thisParam,
                returnParams = {};
            for (thisParam in this.defaultParams) {
                if (this.defaultParams.hasOwnProperty(thisParam)) {
                    returnParams[thisParam] = this.defaultParams[thisParam];
                }
            }
            for (thisParam in params) {
                if (params.hasOwnProperty(thisParam)) {
                    returnParams[thisParam] = params[thisParam];
                }
            }
            return returnParams;
        },

        setDefaultParam: function (key, value) {
            this.defaultParams[key] = value;
        },

        layersUsage: function (params) {
            this.trackEvent("layers-usage", params);
        },
        
        zoomChanged: function (params) {
            this.trackEvent("zoom-changed", params);
        },
        
        zoomToFit: function (params) {
            this.trackEvent("zoom-to-fit", params);
        },
        
        uploaded: function (params) {
            this.trackEvent("uploaded", params);
        },

        uploadFailed: function (params) {
            this.trackEvent("upload-failed", params);
        },

        drawPreviewFinish: function (psdModel) {
            var currTime = Date.now();
            var renditionDuration = currTime - psdModel.get("previewStarted");
            var eventParams = { renditionDuration : renditionDuration };

            this.setDefaultParam('assetID', psdModel.get("id"));
            this.trackEvent("rendered", eventParams);
        },

        selectedTab: function (params) {
            this.trackEvent("selected-tab", params);
        },

        helpDialog: function () {
            this.trackEvent("help-dialog");
        },

        helpDialogShortCut: function () {
            this.trackEvent("help-dialog-shortcut");
        },

        showMeasurementOffsets: function () {
            this.trackEvent("show-measurement-offsets");
        },

        copyCSS: function () {
            this.trackEvent("copy-css");
        },

        copyText: function () {
            this.trackEvent("copy-text");
        },
        
        copySelectedTextCSSHud: function () {
            this.trackEvent("copy-selected-text-css-hud");
        },
        
        copySelectedTextFontsStyle: function () {
            this.trackEvent("copy-selected-text-fonts-style");
        },
        
        copySelectedTextGradientsStyle: function () {
            this.trackEvent("copy-selected-text-gradients-style");
        },

        copyColorsStyle: function () {
            this.trackEvent("copy-colors-style");
        },

        colorFormat: function (params) {
            this.trackEvent("color-format", params);
        },

        reportFidelityError: function () {
            this.trackEvent("report-fidelity-error");
        },

        extraAssetDownload: function (params) {
            this.trackEvent("extract-asset-download-init", params);
        },

        scaledAssetExtracted: function (params) {
            this.trackEvent("asset-extracted-scaled", params);
        },
        
        optimizedAssetExtracted: function (params) {
            this.trackEvent("asset-extracted-optimized", params);
        },

        psdThumbnailClicked: function () {
            this.trackEvent("psd-preview-canvas-clicked");
        },

        sharedPsdThumbnailClicked: function () {
            this.trackEvent("shared-psd-preview-canvas-clicked");
        },
        
        psdThumbnailRightClicked: function () {
            this.trackEvent("psd-preview-canvas-right-clicked");
        },

        canvasClickDrag: function (params) {
            this.trackEvent("psd-preview-canvas-clickdrag", params);
        },

        badFileTypeDragDrop: function (params) {
            this.trackEvent("bad-file-type-dragdrop", params);
        },

        layerCompShown: function () {
            this.trackEvent("layer-comp-shown");
        },

        layerCompChanged: function () {
            this.trackEvent("layer-comp-changed");
        },

        layerCompDropdownUsed: function (params) {
            this.trackEvent("layerComp-dropdown-used", params);
        },

        cssCopiedForGradients: function (params) {
            this.trackEvent("css-copy-gradients", params);
        },

        cssCopiedForFonts: function (params) {
            this.trackEvent("css-copy-fonts", params);
        },

        dimensionsInMultiSelectUsed: function (params) {
            this.trackEvent("dimensions-multiSelect-used", params);
        },

        useExtractOffline: function (params) {
            this.trackEvent("use-extract-offline", params);
        },

        assetDownloadFromCSSHud: function (params) {
            this.trackEvent("asset-download-css-hud", params);
        },
        
        assetDownloadFromLayersPanel: function (params) {
            this.trackEvent("asset-download-layers-panel", params);
        },

        handlePSDUpload: function (params) {
            this.trackEvent("upload-psd", params);
        },

        getStartedButtonClicked: function () {
            this.trackEvent("get-started-clicked");
        },
        
        psdUploadInitiated: function () {
            this.trackEvent("psd-upload-initiated");
        },
        
        showSettingsButtonClicked: function () {
            this.trackEvent("show-settings-clicked");
        },
        
        saveMultipleInitiated: function () {
            this.trackEvent("save-multiple-initiated");
        },
        
        batchExtractScale: function (params) {
            this.trackEvent("batch-extract-scale", params);
        },
        
        handleArtboardShown: function (params) {
            this.trackEvent("artboardpsd-shown", params);
        },
        
        handleArtboardZoomToFit: function (params) {
            this.trackEvent("artboard-zoomToFit", params);
        },

        getIndicesOf: function (searchStr, str, caseSensitive) {
            var startIndex = 0, searchStrLen = searchStr.length;
            var index, indices = [];
            if (!caseSensitive) {
                str = str.toLowerCase();
                searchStr = searchStr.toLowerCase();
            }
            while ((index = str.indexOf(searchStr, startIndex)) > -1) {
                indices.push(index);
                startIndex = index + searchStrLen;
            }
            return indices;
        },
       
        formatSubEvent: function (formatString, formatArray) {
            // Basic implementation of sprintf to work for only %s. Will not handle any other format specifier - not even %%.
            var formattersLocation = this.getIndicesOf("%s", formatString, false),
                formatLength = formattersLocation.length;
            if (formatLength !== formatArray.length) {
                throw new SyntaxError("[sprintf] format specifers does not match with parameters passed ");
            }
            while (formatLength > 0) {
                formatString = formatString.replace("%s", formatArray[formatArray.length - formatLength].toString());
                formatLength = formatLength - 1;
            }
            return formatString;
        },
       
        trackEvent: function (eventName, eventParams) {
            var baseEvent =  "ExtractPanel",
                otherEvent = "OTH ExtractPanel",
                eventMap,
                eventInfo,
                badFileTypeExt = '',
                params = eventParams || {};

            if (eventName === "bad-file-type-dragdrop") {
                if (eventParams && eventParams.extension && eventParams.extension !== '') {
                    badFileTypeExt = " " + eventParams.extension;
                } else {
                    badFileTypeExt = " NoExt";
                }
            }
            
            eventMap = {
                "layers-usage"                  : {event : baseEvent, subevent: "ExtractPanel Layers %s" + this.welcomeExpLaunched},
                "zoom-changed"                  : {event : baseEvent, subevent: "ExtractPanel ZoomChanged %s" + this.welcomeExpLaunched},
                "zoom-to-fit"                   : {event : baseEvent, subevent: "ExtractPanel FitClicked %s" + this.welcomeExpLaunched},
                "selected-tab"                  : {event : otherEvent, subevent : "ExtractPanel Show%sPanel" + this.welcomeExpLaunched},
                "show-measurement-offsets"      : {event : otherEvent, subevent : "ExtractPanel ShowMeasurementOffsets" + this.welcomeExpLaunched},
                "copy-css"                      : {event : baseEvent, subevent : "ExtractPanel CSSHud CopyCSS" + this.welcomeExpLaunched},
                "copy-text"                     : {event : baseEvent, subevent : "ExtractPanel CSSHud CopyText" + this.welcomeExpLaunched},
                "color-format"                  : {event : baseEvent, subevent : "ExtractPanel Style ColorFormat%s" + this.welcomeExpLaunched},
                "report-fidelity-error"         : {event : otherEvent, subevent : "ExtractPanel FidelityError"},
                "extract-asset-download-init"   : {event : otherEvent, subevent : "ExtractPanel AssetDownloadInitiated %s" + this.welcomeExpLaunched},
                "asset-extracted-scaled"        : {event : baseEvent, subevent : "ExtractPanel AssetExtractedScaled" + this.welcomeExpLaunched},
                "asset-extracted-optimized"     : {event : baseEvent, subevent : "ExtractPanel AssetExtractedOptimized" + this.welcomeExpLaunched},
                "psd-preview-canvas-clicked"    : {event : otherEvent, subevent : "ExtractPanel PsdPreviewClicked"},
                "shared-psd-preview-canvas-clicked"    : {event : otherEvent, subevent : "ExtractPanel SharedPsdPreviewClicked"},
                "psd-preview-canvas-right-clicked"    : {event : otherEvent, subevent : "ExtractPanel PsdPreviewRightClicked"},
                "psd-preview-canvas-clickdrag"  : {event : otherEvent, subevent : "ExtractPanel PsdCanvasClickDrag" + this.welcomeExpLaunched},
                "rendered"                      : {event : baseEvent, subevent : "ExtractPanel PSDRenderComplete" + this.welcomeExpLaunched},
                "layer-comp-shown"              : {event : otherEvent, subevent : "ExtractPanel LayerCompShown" + this.welcomeExpLaunched},
                "layer-comp-changed"            : {event : baseEvent, subevent : "ExtractPanel LayercompsChange" + this.welcomeExpLaunched},
                "uploaded"                      : {event : baseEvent, subevent : "ExtractPanel UploadComplete"},
                "upload-failed"                 : {event : otherEvent, subevent : "ExtractPanel UploadFailed"},
                "bad-file-type-dragdrop"        : {event : otherEvent, subevent : "ExtractPanel BadFileTypeUpload" + badFileTypeExt},
                "help-dialog"                   : {event : baseEvent, subevent : "ExtractPanel HelpDialog" + this.welcomeExpLaunched},
                "help-dialog-shortcut"          : {event : baseEvent, subevent : "ExtractPanel HelpDialogShortcut" + this.welcomeExpLaunched},
                "layerComp-dropdown-used"          : {event : baseEvent, subevent : "ExtractPanel LayercompsChange" + this.welcomeExpLaunched},
                "css-copy-gradients"               : {event : baseEvent, subevent : "ExtractPanel Style GradientsCopy" + this.welcomeExpLaunched},
                "css-copy-fonts"                   : {event : baseEvent, subevent : "ExtractPanel Style FontsCopy" + this.welcomeExpLaunched},
                "dimensions-multiSelect-used"      : {event : baseEvent, subevent : "ExtractPanel MultiSelectDimensionsClicked" + this.welcomeExpLaunched},
                "use-extract-offline"              : {event : otherEvent, subevent : "ExtractPanel OfflineExtract" + this.welcomeExpLaunched},
                "asset-download-css-hud"           : {event : baseEvent, subevent : "ExtractPanel CSSHud DownloadImg" + this.welcomeExpLaunched},
                "asset-download-layers-panel"      : {event : baseEvent, subevent : "ExtractPanel Layers DownloadImg" + this.welcomeExpLaunched},
                "upload-psd"                       : {event : otherEvent, subevent : "ExtractPanel PSDUpload"},
                "copy-selected-text-css-hud"       : {event : baseEvent, subevent : "ExtractPanel CSSHud CopySelectedText" + this.welcomeExpLaunched},
                "copy-selected-text-fonts-style"   : {event : baseEvent, subevent : "ExtractPanel Style FontsCopySelectedText" + this.welcomeExpLaunched},
                "copy-selected-text-gradients-style" : {event : baseEvent, subevent : "ExtractPanel Style GradientsCopySelectedText" + this.welcomeExpLaunched},
                "copy-colors-style"                : {event : baseEvent, subevent : "ExtractPanel Style ColorsCopy" + this.welcomeExpLaunched},
                "get-started-clicked"              : {event: baseEvent, subevent: "ExtractPanel GetStartedClicked"},
                "show-settings-clicked"            : {event: otherEvent, subevent: "ExtractPanel EditSettings" + this.welcomeExpLaunched},
                "save-multiple-initiated"          : {event: baseEvent, subevent: "Success:ExtractPanel SaveMultipleAssetsInitiated"},
                "batch-extract-scale"              : {event: otherEvent, subevent: "ExtractPanel BatchExtractScale"},
                "psd-upload-initiated"             : {event: baseEvent, subevent: "ExtractPanel PsdUploadInitiated"},
                "artboardpsd-shown"                : {event : otherEvent, subevent : "ExtractPanel ArtboardPSD Opened"},
                "artboard-zoomToFit"               : {event : baseEvent, subevent : "ExtractPanel Artboard Zoomed"}
            };

            eventInfo = eventMap[eventName];

            if (eventInfo) {

                var mergedParams = this.mergeParams(params);

                // subevent formatting
                
                var subEvent = eventInfo.subevent;
                if (mergedParams.formatSubEvent) {
                    if (mergedParams.formatSubEvent.length) {
                        try {
                            subEvent = this.formatSubEvent(subEvent, mergedParams.formatSubEvent);
                        } catch (e) {
                            console.error("Format specifer error in metrics proxy model for Event: " + eventInfo.event + " SubEvent: " + eventInfo.subevent);
                        }
                    }
                    delete mergedParams.formatSubEvent;
                }
 
                mergedParams.subevent = subEvent;

                // eventname (subevent has already been embedded)
                mergedParams.eventname = eventInfo.event;

                // Now post our event
                graphite.serverAPI.trackExtractEvent(mergedParams);
            }

        }
    });

    return MetricsProxyModel;
});
