
/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, document: true, olark: true*/

define([
    "jquery",
    "underscore",
    "backbone",
    "plugin-dependencies"
], function ($, _, Backbone, deps) {
    "use strict";

    var DwNetworkStatusController = Backbone.Model.extend({

        startListening: function () {
            _.bindAll(this, "updateOnlineStatus", "logOfflineStatus");
            window.addEventListener('online',  this.updateOnlineStatus);
            window.addEventListener('offline', this.updateOnlineStatus);
        },

        updateOnlineStatus: function (event) {
            var self = this;
            if (navigator.onLine) {
                window.graphite.events.trigger("netstatus-change", "reconnected");
                window.removeEventListener('click', this.logOfflineStatus, true);
            } else {
                window.graphite.events.trigger("netstatus-change", "disconnected");
                window.addEventListener('click', this.logOfflineStatus, true);
            }
        },

        logOfflineStatus: function (event) {
            if (!navigator.onLine) {
                window.graphite.events.trigger("use-extract-offline");
            }
        }

    });

    return DwNetworkStatusController;
});