/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, regexp: true */
/*global define: true, graphite: true, Image: true, setTimeout: true, mixpanel: true, window:true, Backbone: true */

define(["jquery",
        'serverAPI',
        'controllers/AuthController',
        'ccweb.files.extract/Constants',
        'ccweb.files.extract/controllers/SelectionController',
        'dreamweaver/controllers/PreferenceController',
        'dwconfig',
        'DWPopUpManager',
        'ccweb.files.extract/models/LayerModelMap'
       ], function ($, serverAPI, AuthController, Constants, SelectionController, PreferenceController, dwconfig, DWPopUpManager, LayerModelMap) {
    "use strict";
    
    var FILE_EXT_TO_FORMAT_MAP = {
        "png": "png-32",
        "png8": "png-8",
        "png32": "png-32",
        "png24": "png-24",
        "svg": "svg",
        "jpg": "jpeg",
        "jpeg": "jpeg"
    };

    var FILE_EXT_TO_CANVAS_MAP = {
        "png": "png",
        "jpg": "jpeg",
        "jpeg": "jpeg",
        "webp": "webp"
    };
    
    var isInitialized = false,
		pendingEventQueue = [];
           
    var DWPSDExtractManager = {
        XReqIdRoot: 'DwExtract-',
        isImageDataAvail : true,
        initialize: function (accessToken, isEnvProd) {
            this.setAccessToken(accessToken, isEnvProd);
            var self = this;
            if (isInitialized === false) {
                if (AuthController.getAuthModel()) {
                    AuthController.getAuthModel().user_data = { accountEnabled: true };
                    var fetchVersionSuccessCb = function (versionData) {
                        if (versionData.api && versionData.api.toLowerCase() === 'introspect') {
                            window.graphite.introspectJsonVersion = versionData.version;
                            if (window.graphite.spritesheetJsonVersion) {
                                self.getExtractPreferences();
                                window.graphite.routers.main.defaultRoute();
                                isInitialized = true;
                                self.logPendingExtractEvents();
                            }
                        } else if (versionData.api && versionData.api.toLowerCase() === 'spritesheet') {
                            window.graphite.spritesheetJsonVersion = versionData.version;
                            if (window.graphite.introspectJsonVersion) {
                                self.getExtractPreferences();
                                window.graphite.routers.main.defaultRoute();
                                isInitialized = true;
                                self.logPendingExtractEvents();
                            }
                        }
                    };
                    this.fetchImageServiceAPIVersion('introspect',  fetchVersionSuccessCb, null);
                    this.fetchImageServiceAPIVersion('spritesheet', fetchVersionSuccessCb, null);
                }
                window.graphite.events.on("netstatus-change", this.notifyNetStatusChange, this);
                window.graphite.events.on("layerCompsLoaded", this.onPSDAvailable, this);
            }
        },
                
        shouldHandleLangSpecificCSS: function () {
            if (window.dwData.appLanguage === "ja_JP" ||
				    window.dwData.appLanguage === "ru_RU" ||
				    window.dwData.appLanguage === "de_DE" ||
				    window.dwData.appLanguage === "fr_FR" ||
				    window.dwData.appLanguage === "pt_BR" ||
				    window.dwData.appLanguage === "sv_SE" ||
				    window.dwData.appLanguage === "nl_NL" ||
				    window.dwData.appLanguage === "pl_PL" ||
				    window.dwData.appLanguage === "it_IT" ||
				    window.dwData.appLanguage === "es_ES" ||
				    window.dwData.appLanguage === "tr_TR" ||
                    window.dwData.appLanguage === "ko_KR" ||
                    window.dwData.appLanguage === "cs_CZ") {
                return true;
            } else {
                return false;
            }
        },
        
        setAccessToken: function (accessToken, isEnvProd) {
            if (isEnvProd === true) {
                window.graphite.environment = dwconfig.PRODUCTION;
            } else {
                window.graphite.environment = dwconfig.STAGEENDPOINT;
            }
            serverAPI.setAccessToken(accessToken);
        },
        
        notifyNetStatusChange: function (notification) {
            
            if (notification === "reconnected" || notification === "connected") {
                this.isImageDataAvail = true;
            } else if (notification === "disconnected") {
                this.isImageDataAvail = false;
            }
            
            if (window.DWPSDExtractCallJsBridgingFunction) {
                var argsObj = {};
                argsObj.isImgAvailable = this.isImageDataAvail;
                window.DWPSDExtractCallJsBridgingFunction('setImageAvailable', argsObj);
            }
        },
        
        onPSDAvailable: function () {
            this.setPSDAvailable(true);
        },
        
        refreshContextMenu: function (argsObj) {
            var osType = 'MAC';
            if (window.dwData && window.dwData.OsType) {
                osType = window.dwData.OsType;
            }
            if (window.DWPSDExtractCallJsBridgingFunction && osType === 'MAC') {
                window.DWPSDExtractCallJsBridgingFunction('refreshContextMenu', {
                    callback: function () {
                        // Do nothing. We have to add callback because bridging calls don't seem to work without it
                    }
                });
            }
        },
        
        setPSDAvailable: function (isPSDAvailable) {
            
            if (window.DWPSDExtractCallJsBridgingFunction) {
                var argsObj = {};
                argsObj.isPSDAvailable = isPSDAvailable;
                window.DWPSDExtractCallJsBridgingFunction('setPSDAvailable', argsObj);
            }
        },
        
        setSelectionBounds: function (left, top, right, bottom) {
            
            if (window.DWPSDExtractCallJsBridgingFunction) {
                var argsObj = {};
                argsObj.left = left;
                argsObj.top = top;
                argsObj.right = right;
                argsObj.bottom = bottom;
                window.DWPSDExtractCallJsBridgingFunction('setSelectionBounds', argsObj);
            }
        },
        
        isDWPSDExtractManagerInitialized: function () {
            return isInitialized;
        },
        
        getExtractPreferences: function () {
            var argsObj = {
                callback: function (result) {
                    PreferenceController.updatePreferences(result);
                }
            };
            window.DWPSDExtractCallJsBridgingFunction('getExtractPreferences', argsObj);
        },
        
        isImageDataAvailable: function () {
            return this.isImageDataAvail;
        },
        
        isAssetExtractAvailable: function (optionalLayerIds) {
            
            var isAvailable = false;
            if (!window.graphite.routers.main.isWelcomeExpDismissed()) {
                
                if (optionalLayerIds) {
                    
                    var layersIdList = JSON.parse(optionalLayerIds);
                    
                    // If we are not successful in parsing give a 
                    // chance to the selection controller
                    
                    if (layersIdList && layersIdList.length > 0) {
                        
                        if (layersIdList.length === 1) {
                            
                            var curLayerModel = LayerModelMap.getModel(layersIdList[0]);
                            if (curLayerModel) {
                                
                                if ((curLayerModel.attributes.properties.layerType !== Constants.Type.LAYER_GROUP) && (curLayerModel.attributes.properties.layerType !== Constants.Type.LAYER_ARTBOARD)) {
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        } else {
                            return false;
                        }
                    }
                }
                
                var layerModels = SelectionController.getSelectedLayers();
            
                if (layerModels.length === 1 && (layerModels[0].attributes.properties.layerType !== Constants.Type.LAYER_GROUP) && (layerModels[0].attributes.properties.layerType !== Constants.Type.LAYER_ARTBOARD)) {
                    isAvailable = true;
                } else {
                    isAvailable = false;
                }
            } else {
                isAvailable = true;
            }
            
            return isAvailable;
        },
        
        isAssetBatchExtractAvailable: function () {
            return window.graphite.routers.main.isWelcomeExpDismissed();
        },
        
        canEnableDownloadAssets: function (optionalLayerIds) {
            
            var canEnable = false;
            
            if (!window.graphite.routers.main.isWelcomeExpDismissed() && this.isAssetExtractAvailable(optionalLayerIds)) {
                // This is first launch experience and the asset extraction is enabled in this case.
                canEnable = true;
            } else if (window.graphite.routers.main.isWelcomeExpDismissed() && this.isImageDataAvailable()) {
                canEnable = true;
            } else {
                canEnable = false;
            }
            
            return canEnable;
        },
        
        updateCSSForSelection: function (codeHintInfo, imageData) {
            var argsObj = {};
            argsObj.codeHintInfo = codeHintInfo;
            argsObj.imageData = imageData;
            
            argsObj.imageData.isImgAvailable = this.canEnableDownloadAssets();
            
            if (window.DWPSDExtractCallJsBridgingFunction) {
                window.DWPSDExtractCallJsBridgingFunction('updateCSSForSelection', argsObj);
            }
        },
        
        logExtractEvent: function (argsObj) {
            if (this.isDWPSDExtractManagerInitialized()) {
                if (window.DWPSDExtractCallJsBridgingFunction) {
                    window.DWPSDExtractCallJsBridgingFunction('logExtractEvent', argsObj);
                }
            } else {
                pendingEventQueue.push(argsObj);
            }
		},

        logPendingExtractEvents: function () {
            var i;
            if (this.isDWPSDExtractManagerInitialized()) {
                for (i = 0; i < pendingEventQueue.length; i++) {
                    this.logExtractEvent(pendingEventQueue[i]);
                }
                pendingEventQueue = [];
            }
		},
        
        refreshPanel: function () {
            window.DWPSDExtractCallJsBridgingFunction('refreshPanel', {});
        },
        
        setPrefToShowUploadDialogOnReload: function (show) {
            window.DWPSDExtractCallJsBridgingFunction('setPrefToShowUploadDialogOnReload', {canShow: show});
        },
        
        setWelcomeExpDismissed: function (dismissed) {
            window.DWPSDExtractCallJsBridgingFunction('setWelcomeExpDismissed', {isDismissed: dismissed});
        },

        extractReadyForInit: function () {
            if (window.DWPSDExtractCallJsBridgingFunction) {
                window.DWPSDExtractCallJsBridgingFunction('extractReadyForInit', {});
            }
        },
        
        copyText: function (text) {
            window.DWPSDExtractCallJsBridgingFunction('copyText', {'text': text});
        },
        
        getClipboardText: function (callback) {
            window.DWPSDExtractCallJsBridgingFunction('getClipboardText', {'callback': callback});
        },
        
        startDrag: function (flavor, layerids, layerName) {
            // To incorporate layercomps as well
            
            if (this.canEnableDownloadAssets(layerids)) {
                window.DWPSDExtractCallJsBridgingFunction('startDrag', {'flavor': flavor, 'layerids': layerids, 'extensionID': 'DWPSDExtract', 'layerName': layerName});
            }
        },
        
        copyCSS: function (cssString, vendorPrefixesString) {
            // If css contains gradient add gradient value separately
            var gradientString = '',
                gradientProperty = '',
                gradientValue = '',
                gradientItemsArray,
                gradientVendorString = '';
            
            if (vendorPrefixesString) {
                gradientVendorString = vendorPrefixesString;
            }
            
            cssString.split('\n').forEach(function (cssItem) {
                if (cssItem.indexOf('gradient') !== -1) {
                    gradientString = cssItem;
                    gradientItemsArray = gradientString.split(':');
                    gradientProperty = gradientItemsArray[0];
                    gradientValue = gradientItemsArray[1].split(';')[0];
                }
            });
            window.DWPSDExtractCallJsBridgingFunction('copyCSS', {'cssString': cssString,
                                                                  'gradientString': gradientString,
                                                                  'gradientProperty': gradientProperty,
                                                                  'gradientValue': gradientValue,
                                                                  'gradientVendorString': gradientVendorString});
        },
        
        pathExists: function (filepath, callback) {
            var argsObj = {};
            argsObj.path = filepath;
            argsObj.callback = callback;
            if (window.DWPSDExtractCallJsBridgingFunction) {
                window.DWPSDExtractCallJsBridgingFunction('pathExists', argsObj);
            }
        },
        
        writeBase64: function (filepath, contents, accessToken, callback) {
            var argsObj = {};
            argsObj.path = filepath;
            argsObj.contents = contents;
            argsObj.accessToken = accessToken;
            argsObj.callback = callback;
            window.DWPSDExtractCallJsBridgingFunction('writeBase64', argsObj);
        },
        
        writeString: function (filepath, contents, callback) {
            var argsObj = {};
            argsObj.path = filepath;
            argsObj.contents = contents;
            argsObj.callback = callback;
            window.DWPSDExtractCallJsBridgingFunction('writeString', argsObj);
        },
        
        isExportableAsSVG: function (layerModel) {
            var exportableAsSVG = true;
            
            if ((layerModel.get("type") !== "contentLayer") && (layerModel.get("type") !== "textLayer")) {
                exportableAsSVG = false;
            }

            return exportableAsSVG;
        },
        
        extractFileNameWithoutExt: function (fileName) {
            return fileName.substr(0, fileName.lastIndexOf('.')) || fileName;
        },
        
        extractFileNameFromPath: function (filePath) {
            return filePath.replace(/^.*[\\\/]/, '');
        },
        
        extractFileExt: function (fileName) {
            return fileName.substr(fileName.lastIndexOf('.') + 1);
        },
		
        normalizeFileName: function (name) {
            name = name.replace(/(\/|\\|:|\*|\?|'|"|<|>|\||\,|^\.\.\.)/g, "_");
            return name;
        },
        
		validatePathForExtractAssetDownload: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('ValidatePathForExtractAssetDownload', argsObj);
            }
        },
        
        getFilePathsForMultipleAssetsDownload: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('getFilePathsForMultipleAssetsDownload', argsObj);
            }
        },
        
        deleteFile: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('deleteFile', argsObj);
            }
        },
        
        getImageDownloadLocation: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('getImageDownloadLocation', argsObj);
            }
        },
        
        browseForFile: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('browseForFile', argsObj);
            }
        },
        
        hideWelcomePageOnUpload: function (argsObj) {
            window.DWPSDExtractCallJsBridgingFunction('hideWelcomePageOnUpload', argsObj);
        },

        showWelcomePageIfNeeded: function (argsObj) {
            window.DWPSDExtractCallJsBridgingFunction('showWelcomePageIfNeeded', argsObj);
        },

        clickInExtractPanel: function (argsObj) {
            window.DWPSDExtractCallJsBridgingFunction('clickInExtractPanel', argsObj);
        },
        
        setOWLBoolUsePersistentDrawer: function (argsObj) {
            window.DWPSDExtractCallJsBridgingFunction('setOWLBoolUsePersistentDrawer', argsObj);
        },
        
        getOWLBoolUsePersistentDrawer: function (argsObj) {
            window.DWPSDExtractCallJsBridgingFunction('getOWLBoolUsePersistentDrawer', argsObj);
        },
        
        browseForFolder: function (argsObj) {
            if (argsObj.callback) {
                window.DWPSDExtractCallJsBridgingFunction('browseForFolder', argsObj);
            }
        },
        
        displayExtractPrefs: function () {
            window.DWPSDExtractCallJsBridgingFunction('displayExtractPrefs');
        },
        
        // Get the layer models array corresponding to the layer ids
        findLayerModelfromID: function (layerIDs) {
            // The result array of layerModels, corressponding to layerIDs.
            var layerModels = [];
            
            if (!layerIDs || layerIDs.length === 0) { return []; }
            
            // recursively find the model corresponding to the searchId
            function searchLayerCollection(layerCollection, searchId) {
                var i = 0;
                var layerModel = null;
                if (!layerCollection) { return null; }
                for (i = 0; i < layerCollection.length; ++i) {
                    layerModel = layerCollection.at(i);
                    if (layerModel.get('layerId') === searchId) {
                        return layerModel;
                    }
                    // recurse..
                    var m = searchLayerCollection(layerModel.get('layerCollection'), searchId);
                    if (m !== null) { return m; }
                    
                }
                return null;
            }

            var psdModel = SelectionController.getPSDModel();
            if (!psdModel) {
                console.error('psdmodel null');
                return layerModels;
            }
            layerIDs.forEach(function (val, idx, a) {
                var result = searchLayerCollection(psdModel.get('layerCollection'), val);
                layerModels.push(result);
            });
            
            return layerModels;
        },
        
        toDataURL: function (filePath, layerIds, type, options) {
            var self = this;
            if (!layerIds) { layerIds = "[]"; }
            layerIds = JSON.parse(layerIds);
            var layerModel = null;
            if (layerIds.length) {
                layerModel = this.findLayerModelfromID(layerIds);
            } else {
                layerModel = SelectionController.getSelectedLayers();
            }
            if (layerModel.length === 0) {
                return;
            }
            
            var layerType = layerModel[0].attributes.properties.layerType,
                isGroup = ((layerType === Constants.Type.LAYER_GROUP) || (layerType === Constants.Type.LAYER_ARTBOARD)),
                format = FILE_EXT_TO_FORMAT_MAP[type],
                canvasFormat =  FILE_EXT_TO_CANVAS_MAP[type],
                psdModel = SelectionController.getPSDModel(),
                deferred = new $.Deferred();
            
            if (options && options.fileformat) {
                options.fileformat = FILE_EXT_TO_FORMAT_MAP[options.fileformat];
                format = options.fileformat;
            }

            function toCanvasFallback() {
                deferred.resolve(self.get("canvas").toDataURL("image/" + canvasFormat));
            }
            
            var errorHandlers = {
                ontimeout: function () {
                    deferred.reject('timeout');
                },
                onerror: function (responseStatus) {
                    deferred.reject('error', responseStatus);
                }
            };

            // Error handling if SVG can't be derived
            if (type === "svg" && !this.isExportableAsSVG(layerModel[0])) {
                deferred.reject(Constants.Errors.SVG_NOT_AVAILABLE);
            } else if (format) {
                // Attempt service call to extract asset
                serverAPI.getDerivedAsset(layerModel, format, psdModel, filePath, options, errorHandlers).then(deferred.resolve, function (err) {

                    if (err === Constants.Errors.UNKNOWN_FILE_WRITE_ERROR) {
                        deferred.reject(Constants.UNKNOWN_FILE_WRITE_ERROR, err);
                    } else if ((!options || !options.isBatchExport) && canvasFormat && !isGroup) { // Service call failed
                        // fallback to canvas for non-groups
                        toCanvasFallback();
                    } else {
                        // reject with service call error
                        deferred.reject(Constants.Errors.SERVICE_ERROR, err);
                    }
                });
            } else if ((!options || !options.isBatchExport) && canvasFormat && !isGroup) {
                toCanvasFallback();
            } else {
                // Unsupported file format
                deferred.reject(Constants.Errors.FILE_FORMAT_ERROR, type);
            }

            return deferred.promise();
        },

        // Reload the PSD
        reloadPSD: function () {
            //Finding the route and then navigating to it so as to reload the PSD.
            if (!graphite.serverAPI.isPreviewLoading()) {
                var existingFragment = Backbone.history.fragment;
                Backbone.history.fragment = null;
                Backbone.history.navigate(existingFragment, true);
            }
        },
        
        downloadPSDExtractAsset: function (filepath, layerIds, fileFormat, imageEncodingQuality, extractInfoType, nonEncodedPath) {
            
            // Determine the type of file that needs to 
            // be downloaded.
            
            if (this.canEnableDownloadAssets(layerIds)) {
                var imageFormat = "png";

                if (fileFormat && fileFormat.length > 0) {
                    imageFormat = fileFormat;
                } else if (filepath.indexOf(".png") !== -1) {
                    imageFormat = "png";
                } else if (filepath.indexOf(".jpg") !== -1) {
                    imageFormat = "jpg";
                } else if (filepath.indexOf(".jpeg") !== -1) {
                    imageFormat = "jpeg";
                } else if (filepath.indexOf(".svg") !== -1) {
                    imageFormat = "svg";
                }

                var imageOptions = {};
                imageOptions.fileformat   = imageFormat;
                imageOptions.imageQuality = imageEncodingQuality;

                var thePromise = this.toDataURL(filepath, layerIds, imageFormat, imageOptions);

                var successFunc = function (msg) {
                    // Send a message to Spider Monkey flagging a success.
                    var argsObj = {'filepath': filepath, 'infotype': extractInfoType, 'nonEncodedPath': nonEncodedPath};
                    window.DWPSDExtractCallJsBridgingFunction('backgroundAssetExtractComplete', argsObj);
                };

                var failureFunc = function (msg) {
                    // Send message to Spider monkey indicating failure.
                    var argsObj = {'filepath': filepath};
                    window.DWPSDExtractCallJsBridgingFunction('backgroundAssetExtractError', argsObj);
                };

                thePromise.then(successFunc, failureFunc);
            } else {
                var argsObj = {'filepath': filepath};
                window.DWPSDExtractCallJsBridgingFunction('backgroundAssetExtractError', argsObj);
            }
        },
        
        fetchImageServiceAPIVersion: function (api, successCallback, errorCallback) {
            var url = window.graphite.environment.EXTRACT_SERVICE.HOST + '/' + api + '/version?api_key=DwExtract1';
            $.ajax({
                url:        url,
                async:      true,
                cache:		false,
                contentType: 'application/json',
                dataType:   'json',
                success:    function (versionData, status) {
                    if (successCallback) {
                        successCallback(versionData);
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    if (errorCallback) {
                        errorCallback(xhr);
                    }
                } //To_Do: Check with Extract team if this API has any failure scenario.
            });
        },
        
        setAuthStatusCode: function (statusCode, isType1User) {
            window.graphite.events.trigger("authstatus-change", statusCode, isType1User);
            this.logPendingExtractEvents();
        },
        
        getSelectedCSSFromPopup: function (includeWebkitGrad, includeMozGrad, includeOGrad, shouldFormatCode) {
            var finalCSSString = '';
            var popupView = DWPopUpManager.getCSSPopupView();
            if (popupView) {
                finalCSSString = popupView.getGradientVendorPrefixesStr(includeWebkitGrad, includeMozGrad, includeOGrad, shouldFormatCode);
            }
            return finalCSSString;
        },
        
        openInBrowser: function (url) {
            window.DWPSDExtractCallJsBridgingFunction('openInBrowser', {url: url});
        },
        
        getFormattedDateTime: function (date) {
            var timeFormat = date.getHours() + ":" + (date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes());
            var dateFormat = (date.getMonth() + 1) + "/" + date.getDate() + "/" + date.getFullYear();
            if (window.dwData && window.dwData.shortDateFormat) {
                if (window.dwData.shortDateFormat[0] === 'd' || window.dwData.shortDateFormat[0] === 'D') {
                    // user OS preference wants the date before the month.
                    dateFormat =  date.getDate() + "/" + (date.getMonth() + 1) + "/" + date.getFullYear();
                }
            }
            
            return dateFormat + " " + timeFormat;
        },
		
        isAnyDocumentOpened: function (argObj) {
            window.DWPSDExtractCallJsBridgingFunction('isAnyDocumentOpened', argObj);
		},
            
        generateUUID: function () {
            var d = new Date().getTime();
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c === 'x' ? r : (r & 0x7 | 0x8)).toString(16);
            });
        },
    
        generateDwExtractClientRequestId: function(){
            return this.XReqIdRoot + this.generateUUID();
        }
        
    };

    return DWPSDExtractManager;
});
