
/*	
 Copyright 2018 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file contains all the logic to identify the framework and set up appropriate variables
*/
/*global document, dw, DW_NDD_CONSTANTS*/

var pathSeparator = "/";
var imageFolder = "images" + pathSeparator;

function replaceLinksUtils(itemsArray, assetPath, configPath, docStrObj)
{
	var i;
	var path, toReplace, replaceWith;
	if (itemsArray && assetPath && configPath && docStrObj && docStrObj.docStr) {
		for (i = 0; i < itemsArray.length; i++) {
			path = itemsArray[i];
			toReplace = configPath + path;
			replaceWith = assetPath + path;

			if (path.indexOf(imageFolder) !== -1) {
				while (docStrObj.docStr.indexOf(toReplace) !== -1) {
					docStrObj.docStr = docStrObj.docStr.replace(toReplace, replaceWith);
				}
			} else {
				docStrObj.docStr = docStrObj.docStr.replace(toReplace, replaceWith);
			}
		}
	}
}

function replaceLinksWithValidPaths(docStrObj, folderName)
{
	var dom = dw.getDocumentDOM();
	if(!dom)
		return;

	var tempObject = dom.getLinksAndTempAssetPath(true);
    if (tempObject) {

	    var configPath;
	    var appConfigPath = dw.getConfigurationPath();
	    var userConfigPath = dw.getUserConfigurationPath();
	    
	    if (!appConfigPath || !userConfigPath || !folderName) {
	        return;
	    }
	    
	    userConfigPath += folderName;
	    if (DWfile.exists(userConfigPath, false)) {
	        configPath = userConfigPath;
	        /* This change is to facilitate soft updation of Tprebuilt Layout like templates */
	    } else {
	        configPath = appConfigPath + pathSeparator + folderName;
	    }
	    
	    // replace all spaces in path by '%20'
	    configPath = configPath.replace(/ /g, "%20");
		
		var urlsToReplaceArr = tempObject.tempItemsArray;
	    var tempAssetPath = tempObject.tempAssetPath;
		var existingItemsArray = tempObject.existingItemsArray;
		var existingAssetPath = tempObject.existingAssetPath;
		
		replaceLinksUtils(urlsToReplaceArr, tempAssetPath, configPath, docStrObj);
		replaceLinksUtils(existingItemsArray, existingAssetPath, configPath, docStrObj);
	}
	return;
}