/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// Increase the number the current user selected the given workflow
//
function incWorkflowAttempts(/*[String]*/ inWorkflowID)
{
	var error = false;
	var data = null;

	try
	{
		data = getNumWorkflowAttempts(inWorkflowID);
		var support = new OnboardingSupport();
		var userUID = support.currentUserUID;
		var key = 'Onboarding_' + userUID.hashCode() + '_' + inWorkflowID;

		app.localPreferences.setNumberValue(key, (data + 1));
	}
	catch(exc)
	{
		error = true;
		data = '"' + exc.toString() + '"';
	}

	return createResultJSON(error, data);
}

//////////////////////////////////////////////////////////////////////////////
//
// Return the number the current user selected the given workflow
//
function getWorkflowAttempts(/*[String]*/ inWorkflowID)
{
	var error = false;
	var data = null;

	var support = new OnboardingSupport();
	var userUID = support.currentUserUID;
	var key = 'Onboarding_' + userUID.hashCode() + '_' + inWorkflowID;

	try
	{
		data = app.localPreferences.getNumberValue(key);
	}
	catch(exc)
	{
		error = true;
		data = '"' + exc.toString() + '"';
	}
	
	return createResultJSON(error, data);
}

function getNumWorkflowAttempts(/*[String]*/ inWorkflowID)
{
	try
	{
		var support = new OnboardingSupport();
		var userUID = support.currentUserUID;
		var key = 'Onboarding_' + userUID.hashCode() + '_' + inWorkflowID;
		var num = 0;

		num = app.localPreferences.getNumberValue(key);
	}
	catch(exc)
	{
	}

	return num;
}

//////////////////////////////////////////////////////////////////////////////
//
// Log the action
//
function WorkflowActionData(inAction,
							inWorkflowID,
							inWorkflowName,
							inWorkflowSessionID,
							inWorkflowDuration,
							inWorkflowAttempts,
							inNumSteps)
{
	this.WorkflowStatus 	= inAction;
	this.WorkflowID			= inWorkflowID;
	this.WorkflowName 		= inWorkflowName;
	this.WorkflowSessionID 	= inWorkflowSessionID;
	this.WorkflowDurationMS = inWorkflowDuration;
	this.WorkflowAttempts 	= inWorkflowAttempts;
	this.WorkflowStepsTotal = inNumSteps;
}

function WorkflowStepActionData(inAction,
								inWorkflowID,
								inWorkflowName,
								inWorkflowSessionID,
								inInteractivity,
								inStepNumber,
								inStepRetries,
								inStepDuration,
								inWorkflowDuration,
								inWorkflowAttempts,
								inNumSteps)
{
	this.WorkflowStatus 			= inAction;
	this.WorkflowID 				= inWorkflowID;
	this.WorkflowName 				= inWorkflowName;
	this.WorkflowSessionID 			= inWorkflowSessionID;
	this.WorkflowAttempts 			= inWorkflowAttempts;
	this.WorkflowStepsTotal 		= inNumSteps;
	this.WorkflowStepInteractivity 	= inInteractivity;
	this.WorkflowStep 				= inStepNumber;
	this.WorkflowStepDurationMS 	= inStepDuration;
	this.WorkflowStepRetries 		= inStepRetries;
	this.WorkflowDurationMS 		= inWorkflowDuration;
}

function logAction(/*[Boolean]*/ inIsWorkflowAction,
				   /*[String]*/ inAction,
				   /*[String]*/ inWorkflowID,
				   /*[String]*/ inWorkflowName,
				   /*[String]*/ inWorkflowSessionID,
				   /*[Number]*/ inWorkflowAttempts,
				   /*[Number]*/ inStepNumber,
				   /*[Number]*/ inStepRetries,
				   /*[String]*/ inInteractivity,
				   /*[Number]*/ inWorkflowDuration,
				   /*[Number]*/ inStepDuration,
				   /*[Number]*/ inNumSteps)
{
	var error = false;
	var resultData = null;

	try
	{
		var support = new OnboardingSupport();
	
		if (inIsWorkflowAction)
		{
			var data = new WorkflowActionData(inAction,
			                         		  inWorkflowID,
			                         		  inWorkflowName,
									 		  inWorkflowSessionID,
											  (isNaN(inWorkflowDuration) ? -1 : inWorkflowDuration),
											  (isNaN(inWorkflowAttempts) ? -1 : inWorkflowAttempts),
											  (isNaN(inNumSteps) ? -1 : inNumSteps));
			support.onWorkflowAction(data);
		}
		else
		{
			var data = new WorkflowStepActionData(inAction,
												  inWorkflowID,
												  inWorkflowName,
												  inWorkflowSessionID,
												  inInteractivity,
												  (isNaN(inStepNumber) ? -1 : inStepNumber),
												  (isNaN(inStepRetries) ? -1 : inStepRetries),
												  (isNaN(inStepDuration) ? -1 : inStepDuration),
												  (isNaN(inWorkflowDuration) ? -1 : inWorkflowDuration),
												  (isNaN(inWorkflowAttempts) ? -1 : inWorkflowAttempts),
												  (isNaN(inNumSteps) ? -1 : inNumSteps));
			support.onWorkflowStepAction(data);
		}
	}
	catch(exc)
	{
		error = true;
		resultData = '"' + exc.toString() + '"';
	}

	return createResultJSON(error, resultData);
}				   
